/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.MissingParameterException;
import de.qfs.lib.util.UnexpectedParameterException;
import de.qfs.lib.util.UnknownOptionException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;

public class ArgsParser {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.ArgsParser");
    private String propFile;
    private String property;
    private String propOption;
    private Hashtable<String, Option> options;
    private Vector<Option> wildcards;
    private Hashtable<String, Object> result;
    private boolean requiresNonOptions = true;
    private Arbitrator arbitrator;
    private ArrayList<String> nonFunctionalOptionsList = new ArrayList();
    private boolean simplifyArgs = false;
    private Pattern skipFromSimplification = null;

    public ArgsParser() {
        if (ArgsParser.logger.level >= 7) {
            logger.lvlBuild(7, "ArgsParser()", 191).log();
        }
        this.options = new Hashtable();
        this.wildcards = new Vector();
        this.wildcards.addElement(new Option("", '?', false, true));
    }

    public ArgsParser(String[] stringArray) throws IllegalArgumentException {
        if (ArgsParser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "ArgsParser(String[])", 212).addDetail("opts", stringArray)).log();
        }
        this.setOptions(stringArray);
    }

    public void setOptions(String[] stringArray) throws IllegalArgumentException {
        if (ArgsParser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setOptions(String[])", 262).addDetail("opts", stringArray)).log();
        }
        this.options = new Hashtable();
        this.wildcards = new Vector();
        this.addOptions(stringArray);
    }

    public void addOptions(String[] stringArray) throws IllegalArgumentException {
        this.addOptions(stringArray, false);
    }

    public void addOptions(String[] stringArray, boolean bl) throws IllegalArgumentException {
        if (ArgsParser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addOptions(String[],boolean)", 302).addDetail("opts", stringArray)).addDetail("nonFunctional", bl)).log();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() < 2) {
                throw new IllegalArgumentException("Illegal option " + stringArray[i] + " at index " + i);
            }
            boolean bl2 = stringArray[i].startsWith("m");
            boolean bl3 = stringArray[i].endsWith("*");
            char c = stringArray[i].charAt(bl2 ? 1 : 0);
            String string = stringArray[i].substring(bl2 ? 2 : 1, stringArray[i].length() - (bl3 ? 1 : 0));
            if (string.length() == 0 && !bl3) {
                throw new IllegalArgumentException("Illegal option " + stringArray[i] + " at index " + i);
            }
            switch (c) {
                case '+': 
                case '-': 
                case '=': 
                case '?': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Missing parameter identifier in option " + stringArray[i] + " at index " + i);
                }
            }
            Option option = new Option(string, c, bl2, bl3);
            if (bl3) {
                this.wildcards.addElement(option);
            } else {
                this.options.put(option.name, option);
            }
            if (!bl) continue;
            this.nonFunctionalOptionsList.add(string);
        }
    }

    public void setDefault(String string, String string2) throws UnknownOptionException, MissingParameterException, UnexpectedParameterException {
        if (this.result == null) {
            this.result = new Hashtable();
        }
        this.addResult(this.isAllowed(string), string, string2);
    }

    public final boolean isRequiresNonOptions() {
        return this.requiresNonOptions;
    }

    public final void setRequiresNonOptions(boolean bl) {
        if (ArgsParser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setRequiresNonOptions(boolean)", 400).addDetail("requiresNonOptions", bl)).log();
        }
        this.requiresNonOptions = bl;
    }

    public final Arbitrator getArbitrator() {
        return this.arbitrator;
    }

    public final void setArbitrator(Arbitrator arbitrator) {
        if (ArgsParser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setArbitrator(Arbitrator)", 427).addDetail("arbitrator", arbitrator)).log();
        }
        this.arbitrator = arbitrator;
    }

    public void setPropertyFile(String string) {
        if (ArgsParser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setPropertyFile(String)", 445).addDetail("name", string)).log();
        }
        this.propFile = string;
    }

    public final void setProperty(String string) {
        if (ArgsParser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setProperty(String)", 459).addDetail("property", string)).log();
        }
        this.property = string;
    }

    public final void setDefaultOption(String string) {
        if (ArgsParser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setDefaultOption(String)", 475).addDetail("option", string)).log();
        }
        this.propOption = string;
    }

    public void addNonFunctionalOptions(String[] stringArray) {
        if (stringArray != null) {
            this.addOptions(stringArray, true);
        }
    }

    public int parse(String[] stringArray) throws UnknownOptionException, MissingParameterException, UnexpectedParameterException {
        String string;
        int n;
        if (ArgsParser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "parse(String[])", 520).addDetail("args", stringArray)).log();
        }
        this.result = new Hashtable();
        for (n = 0; n < stringArray.length; ++n) {
            Object object;
            if (ArgsParser.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "parse(String[])", 527).add("args[i]", stringArray[n])).log();
            }
            if (stringArray[n] == null || !stringArray[n].startsWith("-")) break;
            if (stringArray[n].equals("--")) {
                ++n;
                break;
            }
            if (stringArray[n].indexOf("=") > 0) {
                int n2 = stringArray[n].indexOf("=");
                object = this.simplifyOptionName(stringArray[n].substring(1, n2));
                string = stringArray[n].substring(n2 + 1);
                this.addResult(this.isAllowed((String)object), (String)object, string);
                continue;
            }
            String string2 = this.simplifyOptionName(stringArray[n].substring(1));
            object = this.isAllowed(string2);
            if (object == null) {
                throw new UnknownOptionException("Unknown option " + string2, string2);
            }
            string = null;
            if (stringArray.length > n + 1 && ((Option)object).parameter != '-' && ((Option)object).parameter != '=' && stringArray[n + 1] != null && (stringArray[n + 1].length() == 0 || stringArray[n + 1].charAt(0) != '-')) {
                if (((Option)object).parameter == '+' || stringArray.length > n + 2 && stringArray[n + 2] != null && stringArray[n + 2].length() > 0 && stringArray[n + 2].charAt(0) == '-') {
                    string = stringArray[++n];
                } else if (!this.requiresNonOptions || stringArray.length != n + 1) {
                    int n3 = 0;
                    if (this.arbitrator != null) {
                        n3 = this.arbitrator.isParameter(stringArray, n);
                    }
                    if (n3 == 1) {
                        string = stringArray[++n];
                    } else if (n3 == 0) {
                        string = stringArray[++n];
                    }
                }
            }
            this.addResult((Option)object, string2, string);
        }
        Object object = this.propFile;
        if (this.property != null) {
            object = System.getProperties().getProperty(this.property);
        }
        if (this.propOption != null && this.result.containsKey(this.propOption)) {
            object = this.result.get(this.propOption);
        }
        if (object instanceof String) {
            this.addProperties((String)object);
        } else if (object instanceof String[]) {
            for (int i = 0; i < ((String[])object).length; ++i) {
                this.addProperties(((String[])object)[i]);
            }
        }
        if (ArgsParser.logger.level >= 10) {
            if (ArgsParser.logger.level >= 10) {
                ((LevelAwareLogBuilder)logger.lvlBuild(10, "parse(String[])", 605).add("Options follow:")).log();
            }
            Enumeration<String> enumeration = this.result.keys();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                Object object2 = this.result.get(string);
                if (object2 instanceof String) {
                    if (ArgsParser.logger.level < 10) continue;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(10, "parse(String[])", 611).add("key", string)).add("\"")).add(object2)).add("\"")).log();
                    continue;
                }
                StringBuffer stringBuffer = new StringBuffer("[");
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(((String[])object2)[i]);
                }
                stringBuffer.append("]");
                if (ArgsParser.logger.level < 10) continue;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(10, "parse(String[])", 621).add("key", string)).add("\"")).add(stringBuffer.toString())).add("\"")).log();
            }
        }
        return n;
    }

    private String simplifyOptionName(String string) {
        if (!this.simplifyArgs) {
            return string;
        }
        if (this.skipFromSimplification != null && this.skipFromSimplification.matcher(string).matches()) {
            return string;
        }
        return ArgsParser.simplifiedOptionName(string);
    }

    public static String simplifiedOptionName(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase().replaceAll("[\\-\\.:_]", "").trim();
    }

    public void addProperties(Properties properties) throws UnknownOptionException, MissingParameterException, UnexpectedParameterException {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Option option = this.isAllowed(string);
            if (option == null || !option.multiple && this.result.containsKey(string)) continue;
            String string2 = properties.getProperty(string);
            if (string2.length() == 0 && option.parameter == '-') {
                string2 = null;
            }
            this.addResult(option, string, string2);
        }
    }

    public Hashtable<String, Object> getOptions() {
        if (ArgsParser.logger.level >= 7) {
            logger.lvlBuild(7, "getOptions()", 698).log();
        }
        return this.result;
    }

    public String getString(String string, String string2) {
        if (this.result == null) {
            return string2;
        }
        Object object = this.result.get(string);
        return object instanceof String ? (String)object : string2;
    }

    public String[] getStrings(String string, String[] stringArray) {
        if (this.result == null) {
            return stringArray;
        }
        Object object = this.result.get(string);
        return object instanceof String[] ? (String[])object : stringArray;
    }

    public int getInt(String string, int n) {
        if (this.result == null) {
            return n;
        }
        Object object = this.result.get(string);
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public boolean getBoolean(String string, boolean bl) {
        if (this.result == null) {
            return bl;
        }
        Object object = this.result.get(string);
        if (object instanceof String) {
            return ((String)object).length() == 0 || Boolean.valueOf((String)object) != false;
        }
        return bl;
    }

    private Option isAllowed(String string) {
        Option option;
        if (ArgsParser.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "isAllowed(String)", 856).addDetail("name", string)).log();
        }
        if ((option = this.options.get(string)) != null) {
            return option;
        }
        if (this.simplifyArgs) {
            for (Option option2 : this.options.values()) {
                if (!this.simplifyOptionName(option2.name).equals(string)) continue;
                return option2;
            }
        }
        int n = -1;
        for (int i = 0; i < this.wildcards.size(); ++i) {
            Option option3 = this.wildcards.elementAt(i);
            if (option3.name.length() <= n || !string.startsWith(option3.name) && (!this.simplifyArgs || !string.startsWith(this.simplifyOptionName(option3.name)))) continue;
            option = option3;
            n = option3.name.length();
        }
        return option;
    }

    private void addResult(Option option, String string, String string2) throws UnknownOptionException, MissingParameterException, UnexpectedParameterException {
        String[] stringArray;
        if (ArgsParser.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addResult(Option,String,String)", 910).addDetail("opt", option)).addDetail("name", string)).addDetail("value", string2)).log();
        }
        if (option == null) {
            throw new UnknownOptionException("Unknown option " + string, string);
        }
        if (option.parameter == '-' && string2 != null) {
            throw new UnexpectedParameterException("Illegal parameter " + string2 + " for option " + string, string, string2);
        }
        if (option.parameter == '+' && string2 == null) {
            throw new MissingParameterException("Missing parameter for option " + string, string);
        }
        if (this.simplifyArgs && !option.name.equals(string)) {
            stringArray = this.simplifyOptionName(option.name);
            string = string == null || stringArray.equals(string) ? option.name : option.name + string.substring(stringArray.length());
        }
        if (this.nonFunctionalOptionsList.contains(string)) {
            System.err.println("Option '-" + string + "' has no function.");
            return;
        }
        if (string2 == null) {
            string2 = "";
        }
        if (option.multiple) {
            if (this.result.containsKey(string)) {
                String[] stringArray2 = (String[])this.result.get(string);
                stringArray = new String[stringArray2.length + 1];
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                stringArray[stringArray2.length] = string2;
            } else {
                stringArray = new String[]{string2};
            }
            this.result.put(string, stringArray);
        } else {
            this.result.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProperties(String string) throws UnknownOptionException, MissingParameterException, UnexpectedParameterException {
        InputStream inputStream = null;
        try {
            block19: {
                try {
                    inputStream = new FileInputStream(string);
                    if (ArgsParser.logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "addProperties(String)", 991).add("Reading properties from file ")).add(string)).log();
                    }
                }
                catch (IOException iOException) {
                    if (ArgsParser.logger.level >= 5) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(5, "addProperties(String)", 993).add("ex", iOException)).log();
                    }
                    try {
                        inputStream = new URL(string).openStream();
                        if (ArgsParser.logger.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "addProperties(String)", 997).add("Reading properties from URL ")).add(string)).log();
                        }
                    }
                    catch (IOException iOException2) {
                        if (ArgsParser.logger.level < 3) break block19;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "addProperties(String)", 999).add("ex2", iOException2)).log();
                    }
                }
            }
            if (inputStream != null) {
                try {
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    this.addProperties(properties);
                }
                catch (IOException iOException) {
                    if (ArgsParser.logger.level >= 1) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "addProperties(String)", 1009).add("ex", iOException)).log();
                    }
                }
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void setSkipFromSimplification(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("pattern is marked non-null but is null");
        }
        this.skipFromSimplification = Pattern.compile(string);
    }

    @Generated
    public ArrayList<String> getNonFunctionalOptionsList() {
        return this.nonFunctionalOptionsList;
    }

    @Generated
    public ArgsParser setNonFunctionalOptionsList(ArrayList<String> arrayList) {
        this.nonFunctionalOptionsList = arrayList;
        return this;
    }

    @Generated
    public boolean isSimplifyArgs() {
        return this.simplifyArgs;
    }

    @Generated
    public ArgsParser setSimplifyArgs(boolean bl) {
        this.simplifyArgs = bl;
        return this;
    }

    private static class Option {
        public String name;
        public char parameter;
        public boolean multiple;
        public boolean wildcard;

        public Option(String string, char c, boolean bl, boolean bl2) {
            this.name = string;
            this.parameter = c;
            this.multiple = bl;
            this.wildcard = bl2;
        }
    }

    public static interface Arbitrator {
        public int isParameter(String[] var1, int var2);
    }
}

