/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.Logger;
import de.qfs.lib.util.DaemonThread;
import de.qfs.lib.util.StreamEvent;
import de.qfs.lib.util.StreamListener;
import java.util.ArrayList;

public class BufferingStreamListener
implements StreamListener,
Runnable {
    private static final Logger logger = new Logger("de.qfs.lib.util.BufferingStreamListener");
    private StreamListener delegate;
    private int interval;
    private int total;
    private ArrayList buffer = new ArrayList();
    private Object source;
    private boolean cont = true;
    private long lastBlock;
    private boolean gotInput;

    public BufferingStreamListener(StreamListener streamListener, int n, int n2) {
        Object object;
        if (BufferingStreamListener.logger.level >= 7) {
            object = logger.build("BufferingStreamListener(StreamListener,int,int)");
            ((Logger.Builder)(BufferingStreamListener.logger.level < 8 ? object : ((Logger.Builder)object).add("delegate: ").add(streamListener).add(", interval: ").add(n).add(", total: ").add(n2))).log(7);
        }
        this.delegate = streamListener;
        this.interval = n;
        this.total = n2;
        object = new DaemonThread(this, "BufferingStreamListener");
        ((Thread)object).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newInput(StreamEvent streamEvent) {
        Object object;
        if (BufferingStreamListener.logger.level >= 7) {
            object = logger.build("newInput(StreamEvent)");
            ((Logger.Builder)(BufferingStreamListener.logger.level < 8 ? object : ((Logger.Builder)object).add("event: ").add(streamEvent))).log(7);
        }
        this.source = streamEvent.getSource();
        object = streamEvent.getData();
        BufferingStreamListener bufferingStreamListener = this;
        synchronized (bufferingStreamListener) {
            this.buffer.add(object);
            if (this.lastBlock == 0L) {
                this.lastBlock = System.currentTimeMillis();
            }
            this.gotInput = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inputClosed(StreamEvent streamEvent) {
        Object object;
        if (BufferingStreamListener.logger.level >= 7) {
            object = logger.build("inputClosed(StreamEvent)");
            ((Logger.Builder)(BufferingStreamListener.logger.level < 8 ? object : ((Logger.Builder)object).add("event: ").add(streamEvent))).log(7);
        }
        this.flush();
        this.delegate.inputClosed(streamEvent);
        object = this;
        synchronized (object) {
            this.cont = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (BufferingStreamListener.logger.level >= 7) {
            logger.log(7, "run()", "");
        }
        while (this.cont) {
            boolean bl;
            BufferingStreamListener bufferingStreamListener = this;
            synchronized (bufferingStreamListener) {
                try {
                    if (this.buffer.size() == 0) {
                        if (BufferingStreamListener.logger.level >= 9) {
                            logger.log(9, "run()", "Waiting indefinitely");
                        }
                        this.wait();
                    } else {
                        if (BufferingStreamListener.logger.level >= 9) {
                            logger.log(9, "run()", "Waiting for the interval");
                        }
                        this.wait(this.interval);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                boolean bl2 = bl = this.buffer.size() > 0 && (!this.cont || !this.gotInput || this.lastBlock != 0L && System.currentTimeMillis() - this.lastBlock >= (long)this.total);
                if (BufferingStreamListener.logger.level >= 9) {
                    logger.build("run()").add("mustFlush: ").add(bl).log(9);
                }
                if (bl) {
                    this.lastBlock = 0L;
                }
                this.gotInput = false;
            }
            if (!bl) continue;
            this.flush();
        }
        if (BufferingStreamListener.logger.level >= 9) {
            logger.log(9, "run()", "terminating");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        char[] cArray;
        if (BufferingStreamListener.logger.level >= 7) {
            logger.log(7, "flush()", "");
        }
        BufferingStreamListener bufferingStreamListener = this;
        synchronized (bufferingStreamListener) {
            int n;
            int n2 = 0;
            for (n = 0; n < this.buffer.size(); ++n) {
                n2 += ((char[])this.buffer.get(n)).length;
            }
            if (n2 == 0) {
                this.buffer.clear();
                return;
            }
            cArray = new char[n2];
            n = 0;
            for (int i = 0; i < this.buffer.size(); ++i) {
                char[] cArray2 = (char[])this.buffer.get(i);
                System.arraycopy(cArray2, 0, cArray, n, cArray2.length);
                n += cArray2.length;
            }
            this.buffer.clear();
            this.lastBlock = 0L;
            this.gotInput = false;
        }
        this.delegate.newInput(new StreamEvent(this.source, cArray));
    }
}

