/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.ClassEntry;
import de.qfs.lib.util.ExtensionFileFilter;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Reflector;
import de.qfs.lib.util.StreamInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import lombok.Generated;

public class DynamicClassLoader
extends ClassLoader {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.DynamicClassLoader");
    protected static Hashtable systemClasses = new Hashtable();
    protected static Hashtable loadedClasses = new Hashtable();
    protected static Hashtable files = new Hashtable();
    protected static final File fileNotFound = new File("file not found");
    protected static Vector classpath;
    protected static long initTime;
    protected static DynamicClassLoader primaryLoader;
    protected Hashtable classes = new Hashtable();

    public DynamicClassLoader() {
        if (DynamicClassLoader.logger.level >= 7) {
            logger.lvlBuild(7, "DynamicClassLoader()", 160).log();
        }
    }

    public static void initClasspath() {
        Object object;
        Object object2;
        if (DynamicClassLoader.logger.level >= 7) {
            logger.lvlBuild(7, "initClasspath()", 180).log();
        }
        files = new Hashtable();
        classpath = new Vector();
        String string = System.getProperty("java.class.path");
        if (string != null) {
            object2 = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = new File(((StringTokenizer)object2).nextToken());
                if (DynamicClassLoader.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "initClasspath()", 190).add("path", object)).log();
                }
                if (!((File)object).exists()) continue;
                if (((File)object).isDirectory()) {
                    classpath.addElement(object);
                    continue;
                }
                try {
                    classpath.addElement(new ZipFile((File)object));
                }
                catch (ZipException zipException) {
                    if (DynamicClassLoader.logger.level < 3) continue;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "initClasspath()", 199).add("path", object)).add("ex", zipException)).log();
                }
                catch (IOException iOException) {
                    if (DynamicClassLoader.logger.level < 3) continue;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "initClasspath()", 201).add("path", object)).add("ex", iOException)).log();
                }
            }
        }
        if ((object2 = System.getProperty("java.ext.dirs")) == null) {
            return;
        }
        object = new StringTokenizer((String)object2, File.pathSeparator);
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("", new String[]{".jar", ".zip"}, false, true);
        while (((StringTokenizer)object).hasMoreTokens()) {
            File file = new File(((StringTokenizer)object).nextToken());
            if (!file.isDirectory()) continue;
            String[] stringArray = file.list(extensionFileFilter);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    classpath.addElement(new ZipFile(new File(file, stringArray[i])));
                    continue;
                }
                catch (ZipException zipException) {
                    if (DynamicClassLoader.logger.level < 1) continue;
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "initClasspath()", 225).add("ex", zipException)).log();
                    continue;
                }
                catch (IOException iOException) {
                    if (DynamicClassLoader.logger.level < 1) continue;
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "initClasspath()", 227).add("ex", iOException)).log();
                }
            }
        }
    }

    public static Class loadDynamicClass(String string) throws ClassNotFoundException {
        ClassEntry classEntry;
        if (DynamicClassLoader.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "loadDynamicClass(String)", 247).addDetail("name", string)).log();
        }
        if ((classEntry = (ClassEntry)loadedClasses.get(string)) != null) {
            if (DynamicClassLoader.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "loadDynamicClass(String)", 253).add("Loaded classes cache hit")).log();
            }
            if (classEntry.file.lastModified() <= classEntry.timestamp) {
                return classEntry.clazz;
            }
            if (DynamicClassLoader.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "loadDynamicClass(String)", 257).add("Class file is new")).log();
            }
            return new DynamicClassLoader().loadClass(string);
        }
        return primaryLoader.loadClass(string);
    }

    public static ClassLoader loadJarIntoClassLoader(ClassLoader classLoader, String string) {
        if (DynamicClassLoader.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "loadJarIntoClassLoader(ClassLoader,String)", 282).addDetail("classLoader", classLoader)).addDetail("jarFile", string)).log();
        }
        if (Misc.emptyOrNull(string)) {
            return classLoader;
        }
        try {
            return DynamicClassLoader.loadJarIntoClassLoader(classLoader, new File(string).toURI().toURL());
        }
        catch (Throwable throwable) {
            if (DynamicClassLoader.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "loadJarIntoClassLoader(ClassLoader,String)", 290).add("ex", throwable)).log();
            }
            return classLoader;
        }
    }

    public static ClassLoader loadJarIntoClassLoader(ClassLoader classLoader, URL uRL) throws FileNotFoundException {
        if (DynamicClassLoader.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "loadJarIntoClassLoader(ClassLoader,URL)", 309).addDetail("classLoader", classLoader)).addDetail("jarURL", uRL)).log();
        }
        if (Misc.emptyOrNull(uRL)) {
            return classLoader;
        }
        return DynamicClassLoader.loadJarUrlsIntoClassLoader(classLoader, Misc.listOf(uRL));
    }

    public static ClassLoader loadJarIntoClassLoader(ClassLoader classLoader, List<String> list) {
        if (DynamicClassLoader.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "loadJarIntoClassLoader(ClassLoader,List<String>)", 331).addDetail("classLoader", classLoader)).addDetail("jarURLs", list)).log();
        }
        if (Misc.emptyOrNull(list)) {
            return classLoader;
        }
        return DynamicClassLoader.loadJarFilesIntoClassLoader(classLoader, list.stream().map(string -> new File((String)string)).collect(Collectors.toList()));
    }

    public static ClassLoader loadJarFilesIntoClassLoader(ClassLoader classLoader, List<File> list) {
        if (DynamicClassLoader.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "loadJarFilesIntoClassLoader(ClassLoader,List<File>)", 353).addDetail("classLoader", classLoader)).addDetail("jarURLs", list)).log();
        }
        if (Misc.emptyOrNull(list)) {
            return classLoader;
        }
        try {
            return DynamicClassLoader.loadJarUrlsIntoClassLoader(classLoader, list.stream().map(file -> {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    if (DynamicClassLoader.logger.level >= 1) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "loadJarFilesIntoClassLoader(ClassLoader,List<File>)", 363).add("e", malformedURLException)).log();
                    }
                    return null;
                }
            }).collect(Collectors.toList()));
        }
        catch (Exception exception) {
            if (DynamicClassLoader.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "loadJarFilesIntoClassLoader(ClassLoader,List<File>)", 368).add("ex", exception)).log();
            }
            return classLoader;
        }
    }

    public static ClassLoader loadJarUrlsIntoClassLoader(ClassLoader classLoader, List<URL> list) throws FileNotFoundException {
        List<URL> list2;
        Object object;
        if (DynamicClassLoader.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "loadJarUrlsIntoClassLoader(ClassLoader,List<URL>)", 388).addDetail("classLoader", classLoader)).addDetail("jarURLs", list)).log();
        }
        if (Misc.emptyOrNull(list)) {
            return classLoader;
        }
        if (classLoader instanceof URLClassLoader) {
            object = classLoader;
            list2 = Arrays.asList(((URLClassLoader)classLoader).getURLs());
        } else {
            Reflector.openModule("java.base", "jdk.internal.loader", DynamicClassLoader.class);
            object = Reflector.safeGet(classLoader, "ucp", true);
            list2 = null;
        }
        if (object == null && DynamicClassLoader.logger.level >= 1) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "loadJarUrlsIntoClassLoader(ClassLoader,List<URL>)", 407).add("Cannot load jar into classLoader - no url container found")).add("classLoader", classLoader)).add("jarURLs", list)).log();
        }
        for (URL uRL : list) {
            block11: {
                if (Misc.emptyOrNull(uRL) || list2 != null && list2.contains(uRL)) continue;
                try {
                    File file = new File(uRL.toURI());
                    if (!file.exists()) {
                        throw new FileNotFoundException("Jar " + file.getAbsolutePath() + " doesn't exist");
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (DynamicClassLoader.logger.level < 3) break block11;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "loadJarUrlsIntoClassLoader(ClassLoader,List<URL>)", 421).add("e", uRISyntaxException)).log();
                }
            }
            try {
                Reflector.call(object, "addURL", URL.class, (Object)uRL, true);
            }
            catch (Throwable throwable) {
                if (DynamicClassLoader.logger.level < 1) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "loadJarUrlsIntoClassLoader(ClassLoader,List<URL>)", 426).add("ex", throwable)).log();
            }
        }
        return classLoader;
    }

    public static Object getDynamicObject(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (DynamicClassLoader.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getDynamicObject(String)", 452).addDetail("classname", string)).log();
        }
        return DynamicClassLoader.loadDynamicClass(string).newInstance();
    }

    public static Object getDynamicObject(String string, Class[] classArray, Object[] objectArray) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (DynamicClassLoader.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getDynamicObject(String,Class[],Object[])", 486).addDetail("classname", string)).addDetail("types", classArray)).addDetail("arguments", objectArray)).log();
        }
        Class clazz = DynamicClassLoader.loadDynamicClass(string);
        return clazz.getConstructor(classArray).newInstance(objectArray);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        if (DynamicClassLoader.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "loadClass(String)", 517).addDetail("name", string)).log();
        }
        return this.loadClass(string, true);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        File file;
        if (DynamicClassLoader.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getResourceAsStream(String)", 534).addDetail("name", string)).log();
        }
        if ((file = (File)files.get(string)) != null) {
            if (DynamicClassLoader.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getResourceAsStream(String)", 539).add("Cache hit")).log();
            }
            if (file.equals(fileNotFound)) {
                return null;
            }
            try {
                return new FileInputStream(file);
            }
            catch (IOException iOException) {
                if (DynamicClassLoader.logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "getResourceAsStream(String)", 546).add("ex", iOException)).log();
                }
                return null;
            }
        }
        for (int i = 0; i < classpath.size(); ++i) {
            Object object;
            Object e = classpath.elementAt(i);
            if (e instanceof File) {
                if (DynamicClassLoader.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getResourceAsStream(String)", 555).add("Trying path ")).add(e)).log();
                }
                object = string;
                if (File.separatorChar != '/') {
                    object = string.replace('/', File.separator.charAt(0));
                }
                try {
                    file = new File(((File)e).getCanonicalPath() + File.separator + (String)object);
                    if (!file.exists()) {
                        if (DynamicClassLoader.logger.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getResourceAsStream(String)", 568).add("getResourceAsStream(String)", file.toString())).add("Not Found")).log();
                        }
                        continue;
                    }
                    files.put(string, file);
                    return new FileInputStream(file);
                }
                catch (IOException iOException) {
                    if (DynamicClassLoader.logger.level >= 1) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "getResourceAsStream(String)", 575).add("ex", iOException)).log();
                    }
                    return null;
                }
            }
            if (!(e instanceof ZipFile)) continue;
            if (DynamicClassLoader.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getResourceAsStream(String)", 579).add("Trying ZipFile ")).add(((ZipFile)e).getName())).log();
            }
            try {
                object = ((ZipFile)e).getEntry(string);
                if (object == null) {
                    if (DynamicClassLoader.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "getResourceAsStream(String)", 584).add("Not Found")).log();
                    }
                    continue;
                }
                files.put(string, e);
                return ((ZipFile)e).getInputStream((ZipEntry)object);
            }
            catch (ZipException zipException) {
                if (DynamicClassLoader.logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "getResourceAsStream(String)", 590).add("ex", zipException)).log();
                }
                return null;
            }
            catch (IOException iOException) {
                if (DynamicClassLoader.logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "getResourceAsStream(String)", 593).add("ex", iOException)).log();
                }
                return null;
            }
        }
        files.put(string, fileNotFound);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected synchronized Class loadClass(String var1_1, boolean var2_2) throws ClassNotFoundException {
        if (DynamicClassLoader.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(7, "loadClass(String,boolean)", 621).addDetail("name", var1_1)).addDetail("resolve", var2_2)).log();
        }
        if (DynamicClassLoader.isSystemClass(var1_1)) {
            if (DynamicClassLoader.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(9, "loadClass(String,boolean)", 626).add("System class ")).add(var1_1)).log();
            }
            return this.makeSystemClass(var1_1, var2_2);
        }
        var4_3 = null;
        var5_4 = null;
        var6_5 = null;
        var7_6 = (ClassEntry)this.classes.get(var1_1);
        if (var7_6 != null) {
            if (DynamicClassLoader.logger.level >= 9) {
                ((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(9, "loadClass(String,boolean)", 638).add("Private cache hit")).log();
            }
            if (var7_6.file.lastModified() > var7_6.timestamp && DynamicClassLoader.logger.level >= 5) {
                ((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(5, "loadClass(String,boolean)", 641).add("Warning: class file is more recent than returned class")).log();
            }
            return var7_6.clazz;
        }
        var8_7 = null;
        try {
            block57: {
                var7_6 = (ClassEntry)DynamicClassLoader.systemClasses.get(var1_1);
                if (var7_6 == null) break block57;
                if (DynamicClassLoader.logger.level >= 9) {
                    ((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(9, "loadClass(String,boolean)", 653).add("System cache hit")).log();
                }
                if (var7_6.file.lastModified() <= var7_6.timestamp) {
                    var9_8 = var7_6.clazz;
                    return var9_8;
                }
                DynamicClassLoader.systemClasses.remove(var1_1);
                this.classes.put(var1_1, var7_6);
                DynamicClassLoader.loadedClasses.put(var1_1, var7_6);
                if (DynamicClassLoader.logger.level >= 9) {
                    ((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(9, "loadClass(String,boolean)", 661).add("Class file is new")).log();
                }
                try {
                    if (var7_6.zip == null) {
                        var8_7 = new FileInputStream(var7_6.file);
                    } else {
                        var9_9 = var7_6.zip.getEntry(var1_1);
                        if (var9_9 == null) {
                            if (DynamicClassLoader.logger.level >= 9) {
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(9, "loadClass(String,boolean)", 668).add("Not Found in")).add(var7_6.zip.getName())).log();
                            }
                            throw new ClassNotFoundException(var1_1);
                        }
                        var8_7 = var7_6.zip.getInputStream((ZipEntry)var9_9);
                    }
                    ** GOTO lbl80
                }
                catch (IOException var9_10) {
                    if (DynamicClassLoader.logger.level >= 1) {
                        ((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(1, "loadClass(String,boolean)", 675).add("ex", var9_10)).log();
                    }
                    throw new ClassNotFoundException(var1_1);
                }
            }
            var9_9 = var1_1.replace('.', '/') + ".class";
            if (DynamicClassLoader.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(9, "loadClass(String,boolean)", 681).add("Converted name is ")).add((String)var9_9)).log();
            }
            if ((var8_7 = this.getResourceAsStream((String)var9_9)) == null) {
                if (DynamicClassLoader.logger.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(5, "loadClass(String,boolean)", 685).add("Null resource for ")).add((String)var9_9)).log();
                }
                throw new ClassNotFoundException(var1_1);
            }
            var4_3 = DynamicClassLoader.files.get(var9_9);
            if (var4_3 instanceof ZipFile) {
                var6_5 = var4_3;
                var5_4 = new File(var6_5.getName());
            } else {
                var5_4 = var4_3;
            }
            if (var5_4.lastModified() > DynamicClassLoader.initTime) ** GOTO lbl80
            if (DynamicClassLoader.logger.level >= 9) {
                ((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(9, "loadClass(String,boolean)", 696).add("Old class file - Try to use system class")).log();
            }
            try {
                var10_14 = this.makeSystemClass(var1_1, var2_2);
                if (var6_5 != null) {
                    DynamicClassLoader.systemClasses.put(var1_1, new ClassEntry(var10_14, var6_5));
                } else {
                    DynamicClassLoader.systemClasses.put(var1_1, new ClassEntry(var10_14, var5_4));
                }
                var11_17 = var10_14;
                return var11_17;
            }
            catch (ClassNotFoundException var10_15) {
                if (DynamicClassLoader.logger.level >= 9) {
                    ((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(9, "loadClass(String,boolean)", 706).add("ex", var10_15)).log();
                }
lbl80:
                // 6 sources

                try {
                    var3_19 = StreamInput.read(var8_7);
                    if (DynamicClassLoader.logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(9, "loadClass(String,boolean)", 713).add("class ")).add(var1_1)).add(" has ")).add(var3_19.length)).add(" bytes")).log();
                    }
                }
                catch (IOException var9_11) {
                    if (DynamicClassLoader.logger.level >= 1) {
                        ((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(1, "loadClass(String,boolean)", 716).add("ex", var9_11)).log();
                    }
                    throw new ClassNotFoundException(var1_1);
                }
            }
        }
        finally {
            block56: {
                if (var8_7 != null) {
                    try {
                        var8_7.close();
                    }
                    catch (IOException var10_13) {
                        if (DynamicClassLoader.logger.level < 3) break block56;
                        ((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(3, "loadClass(String,boolean)", 725).add("ex", var10_13)).log();
                    }
                }
            }
        }
        var9_9 = null;
        try {
            if (DynamicClassLoader.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(9, "loadClass(String,boolean)", 732).add("defining ")).add(var1_1)).log();
            }
            var9_9 = this.defineClass(var1_1, var3_19, 0, var3_19.length);
        }
        catch (Throwable var10_16) {
            if (DynamicClassLoader.logger.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(1, "loadClass(String,boolean)", 735).add("name", var1_1)).add("ex", var10_16)).log();
            }
            throw new ClassNotFoundException(var1_1);
        }
        if (var7_6 == null) {
            var7_6 = var6_5 != null ? new ClassEntry((Class)var9_9, var6_5) : new ClassEntry((Class)var9_9, var5_4);
            this.classes.put(var1_1, var7_6);
            DynamicClassLoader.loadedClasses.put(var1_1, var7_6);
        } else {
            var7_6.timestamp = var7_6.file.lastModified();
            var7_6.clazz = var9_9;
        }
        if (DynamicClassLoader.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(9, "loadClass(String,boolean)", 750).add(var1_1)).add(" defined")).log();
        }
        if (var2_2) {
            this.resolveClass((Class<?>)var9_9);
            if (DynamicClassLoader.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(9, "loadClass(String,boolean)", 753).add(var1_1)).add(" resolved")).log();
            }
        }
        if (DynamicClassLoader.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)DynamicClassLoader.logger.lvlBuild(9, "loadClass(String,boolean)", 755).add("finished, clazz: ")).add(var9_9)).add(" (")).add(var9_9.hashCode())).add(")")).log();
        }
        return var9_9;
    }

    protected static boolean isSystemClass(String string) {
        if (DynamicClassLoader.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "isSystemClass(String)", 770).addDetail("name", string)).log();
        }
        return string.startsWith("java.") || string.startsWith("javax.") || string.startsWith("org.omg.") || string.startsWith("com.sun.") || string.startsWith("sun.");
    }

    protected Class makeSystemClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        if (DynamicClassLoader.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "makeSystemClass(String,boolean)", 793).addDetail("name", string)).addDetail("resolve", bl)).log();
        }
        if ((clazz = this.findSystemClass(string)) == null) {
            if (DynamicClassLoader.logger.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "makeSystemClass(String,boolean)", 798).add("Cannot fing system class ")).add(string)).log();
            }
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    static {
        initTime = System.currentTimeMillis();
        primaryLoader = new DynamicClassLoader();
        DynamicClassLoader.initClasspath();
    }
}

