/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import java.io.Serializable;
import java.util.Hashtable;

public class Enum
implements Serializable,
Cloneable,
Comparable {
    static final long serialVersionUID = -8444370131512049067L;
    private static Hashtable registry = new Hashtable();
    private int value;
    private String name;

    public Enum(int n, String string) throws IllegalArgumentException {
        this.register(n);
        this.value = n;
        this.name = string;
    }

    public static Enum lookup(String string, int n) {
        return (Enum)registry.get(string + n);
    }

    public final int getValue() {
        return this.value;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.getTypeName() + "[" + this.name + "]";
    }

    public Object clone() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readResolve() {
        String string = this.getTypeName() + this.value;
        Hashtable hashtable = registry;
        synchronized (hashtable) {
            Object v = registry.get(string);
            if (v == null) {
                registry.put(string, this);
            }
            return v == null ? this : v;
        }
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public int compareTo(Object object) {
        return this.value - ((Enum)object).getValue();
    }

    public String getTypeName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(int n) throws IllegalArgumentException {
        String string = this.getTypeName() + n;
        Hashtable hashtable = registry;
        synchronized (hashtable) {
            if (registry.get(string) != null) {
                throw new IllegalArgumentException("Value " + n + " already defined for type " + this.getTypeName());
            }
            registry.put(string, this);
        }
    }
}

