/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static boolean deleteRecursively(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (FileUtils.deleteRecursively(file2)) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static void moveFile(File file, File file2) throws IOException {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
        if (file.isDirectory()) {
            throw new IOException("Source '" + file + "' is a directory");
        }
        if (file2.exists()) {
            throw new FileExistsException("Destination '" + file2 + "' already exists");
        }
        if (file2.isDirectory()) {
            throw new IOException("Destination '" + file2 + "' is a directory");
        }
        boolean bl = file.renameTo(file2);
        if (!bl) {
            FileUtils.copyFile(file, file2);
            if (!file.delete()) {
                throw new IOException("Failed to delete original file '" + file + "' after copy to '" + file2 + "'");
            }
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileUtils.copyFile(file, file2, true);
    }

    public static void copyFile(File file, File file2, boolean bl) throws IOException {
        FileUtils.checkFileRequirements(file, file2);
        if (file.isDirectory()) {
            throw new IOException("Source '" + file + "' exists but is a directory");
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            throw new IOException("Source '" + file + "' and destination '" + file2 + "' are the same");
        }
        File file3 = file2.getParentFile();
        if (file3 != null && !file3.mkdirs() && !file3.isDirectory()) {
            throw new IOException("Destination '" + file3 + "' directory cannot be created");
        }
        if (file2.exists() && !file2.canWrite()) {
            throw new IOException("Destination '" + file2 + "' exists but is read-only");
        }
        FileUtils.doCopyFile(file, file2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File file, File file2, boolean bl) throws IOException {
        long l;
        long l2;
        if (file2.exists() && file2.isDirectory()) {
            throw new IOException("Destination '" + file2 + "' exists but is a directory");
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        FileChannel fileChannel2 = null;
        try {
            long l3;
            long l4;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            fileChannel = fileInputStream.getChannel();
            fileChannel2 = fileOutputStream.getChannel();
            l2 = fileChannel.size();
            long l5 = 0L;
            for (l = 0L; l < l2 && (l4 = fileChannel2.transferFrom(fileChannel, l, l5 = (l3 = l2 - l) > 0x1E00000L ? 0x1E00000L : l3)) != 0L; l += l4) {
            }
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly(fileChannel2, fileOutputStream, fileChannel, fileInputStream);
            throw throwable;
        }
        FileUtils.closeQuietly(fileChannel2, fileOutputStream, fileChannel, fileInputStream);
        l2 = file.length();
        l = file2.length();
        if (l2 != l) {
            throw new IOException("Failed to copy full contents from '" + file + "' to '" + file2 + "' Expected length: " + l2 + " Actual: " + l);
        }
        if (bl) {
            file2.setLastModified(file.lastModified());
        }
    }

    private static void checkFileRequirements(File file, File file2) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        FileUtils.copyDirectory(file, file2, true);
    }

    public static void copyDirectory(File file, File file2, boolean bl) throws IOException {
        FileUtils.copyDirectory(file, file2, null, bl);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter) throws IOException {
        FileUtils.copyDirectory(file, file2, fileFilter, true);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter, boolean bl) throws IOException {
        FileUtils.checkFileRequirements(file, file2);
        if (!file.isDirectory()) {
            throw new IOException("Source '" + file + "' exists but is not a directory");
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            throw new IOException("Source '" + file + "' and destination '" + file2 + "' are the same");
        }
        ArrayList<String> arrayList = null;
        if (file2.getCanonicalPath().startsWith(file.getCanonicalPath())) {
            File[] fileArray;
            File[] fileArray2 = fileArray = fileFilter == null ? file.listFiles() : file.listFiles(fileFilter);
            if (fileArray != null && fileArray.length > 0) {
                arrayList = new ArrayList<String>(fileArray.length);
                File[] fileArray3 = fileArray;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File file3 = fileArray3[i];
                    File file4 = new File(file2, file3.getName());
                    arrayList.add(file4.getCanonicalPath());
                }
            }
        }
        FileUtils.doCopyDirectory(file, file2, fileFilter, bl, arrayList);
    }

    private static void doCopyDirectory(File file, File file2, FileFilter fileFilter, boolean bl, List<String> list) throws IOException {
        File[] fileArray;
        File[] fileArray2 = fileArray = fileFilter == null ? file.listFiles() : file.listFiles(fileFilter);
        if (fileArray == null) {
            throw new IOException("Failed to list contents of " + file);
        }
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                throw new IOException("Destination '" + file2 + "' exists but is not a directory");
            }
        } else if (!file2.mkdirs() && !file2.isDirectory()) {
            throw new IOException("Destination '" + file2 + "' directory cannot be created");
        }
        if (!file2.canWrite()) {
            throw new IOException("Destination '" + file2 + "' cannot be written to");
        }
        File[] fileArray3 = fileArray;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file3 = fileArray3[i];
            File file4 = new File(file2, file3.getName());
            if (list != null && list.contains(file3.getCanonicalPath())) continue;
            if (file3.isDirectory()) {
                FileUtils.doCopyDirectory(file3, file4, fileFilter, bl, list);
                continue;
            }
            FileUtils.doCopyFile(file3, file4, bl);
        }
        if (bl) {
            file2.setLastModified(file.lastModified());
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Closeable ... closeableArray) {
        if (closeableArray != null) {
            Closeable[] closeableArray2 = closeableArray;
            int n = closeableArray.length;
            for (int i = 0; i < n; ++i) {
                Closeable closeable = closeableArray2[i];
                FileUtils.closeQuietly(closeable);
            }
        }
    }

    public static class FileExistsException
    extends IOException {
        public FileExistsException(String string) {
            super(string);
        }
    }
}

