/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.FileEvent;
import de.qfs.lib.util.FileListener;
import de.qfs.lib.util.FileWatcherGroup;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import lombok.Generated;

public class FileWatcher {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.FileWatcher");
    private final FileWatcherGroup fileWatcherGroup;
    private WeakReference<Object> owner;
    private String attribute;
    private ArrayList listeners = new ArrayList();
    private boolean onDispatchThread;
    private boolean active = true;
    private File file;
    private boolean exists;
    private long modTime;
    private int fireDeleteDelay = 2;
    private int deleteCount = 0;

    public FileWatcher(File file) {
        this(file, FileWatcherGroup.getDefaultGroup());
    }

    public FileWatcher(File file, FileWatcherGroup fileWatcherGroup) {
        if (FileWatcher.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "FileWatcher(File,FileWatcherGroup)", 139).addDetail("file", file)).addDetail("group", fileWatcherGroup)).log();
        }
        this.file = file;
        this.exists = file.exists();
        if (this.exists) {
            this.modTime = file.lastModified();
        }
        this.fileWatcherGroup = fileWatcherGroup;
        this.fileWatcherGroup.addFileWatcher(this);
    }

    public Object getOwner() {
        return this.owner == null ? null : this.owner.get();
    }

    public void setOwner(Object object) {
        this.owner = new WeakReference<Object>(object);
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String string) {
        this.attribute = string;
    }

    public File getFile() {
        return this.file;
    }

    public long getModTime() {
        return this.modTime;
    }

    public void setModTime(long l) {
        this.modTime = l;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public final boolean isOnDispatchThread() {
        return this.onDispatchThread;
    }

    public final void setOnDispatchThread(boolean bl) {
        if (FileWatcher.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setOnDispatchThread(boolean)", 274).addDetail("onDispatchThread", bl)).log();
        }
        this.onDispatchThread = bl;
    }

    public final long getFireDeleteDelay() {
        return this.fireDeleteDelay;
    }

    public final void setFireDeleteDelay(int n) {
        if (FileWatcher.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setFireDeleteDelay(int)", 301).addDetail("periods", n)).log();
        }
        this.fireDeleteDelay = n;
    }

    public synchronized void addFileListener(FileListener fileListener) {
        if (FileWatcher.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addFileListener(FileListener)", 319).addDetail("listener", fileListener)).log();
        }
        this.listeners.remove(fileListener);
        this.listeners.add(fileListener);
    }

    public synchronized void removeFileListener(FileListener fileListener) {
        if (FileWatcher.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeFileListener(FileListener)", 334).addDetail("listener", fileListener)).log();
        }
        this.listeners.remove(fileListener);
    }

    public synchronized void removeAllFileListeners() {
        if (FileWatcher.logger.level >= 7) {
            logger.lvlBuild(7, "removeAllFileListeners()", 345).log();
        }
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFileCreated() {
        FileListener[] fileListenerArray;
        if (FileWatcher.logger.level >= 7) {
            logger.lvlBuild(7, "fireFileCreated()", 356).log();
        }
        final FileEvent fileEvent = new FileEvent(this);
        Object object = this;
        synchronized (object) {
            fileListenerArray = this.listeners.toArray(new FileListener[0]);
        }
        object = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < fileListenerArray.length; ++i) {
                    fileListenerArray[i].fileCreated(fileEvent);
                }
            }
        };
        if (this.onDispatchThread) {
            SwingUtilities.invokeLater((Runnable)object);
        } else {
            object.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFileDeleted() {
        FileListener[] fileListenerArray;
        if (FileWatcher.logger.level >= 7) {
            logger.lvlBuild(7, "fireFileDeleted()", 385).log();
        }
        final FileEvent fileEvent = new FileEvent(this);
        Object object = this;
        synchronized (object) {
            fileListenerArray = this.listeners.toArray(new FileListener[0]);
        }
        object = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < fileListenerArray.length; ++i) {
                    fileListenerArray[i].fileDeleted(fileEvent);
                }
            }
        };
        if (this.onDispatchThread) {
            SwingUtilities.invokeLater((Runnable)object);
        } else {
            object.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFileModified() {
        FileListener[] fileListenerArray;
        if (FileWatcher.logger.level >= 7) {
            logger.lvlBuild(7, "fireFileModified()", 414).log();
        }
        final FileEvent fileEvent = new FileEvent(this);
        Object object = this;
        synchronized (object) {
            fileListenerArray = this.listeners.toArray(new FileListener[0]);
        }
        object = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < fileListenerArray.length; ++i) {
                    fileListenerArray[i].fileModified(fileEvent);
                }
            }
        };
        if (this.onDispatchThread) {
            SwingUtilities.invokeLater((Runnable)object);
        } else {
            object.run();
        }
    }

    public void dispose() {
        if (FileWatcher.logger.level >= 7) {
            logger.lvlBuild(7, "dispose()", 446).dumpStack();
        }
        this.fileWatcherGroup.removeFileWatcher(this);
        this.owner = null;
    }

    public void checkFile() {
        if (FileWatcher.logger.level >= 7) {
            logger.lvlBuild(7, "checkFile()", 457).log();
        }
        if (!this.active) {
            return;
        }
        if (this.exists) {
            if (!this.file.exists()) {
                ++this.deleteCount;
                if (this.deleteCount > this.fireDeleteDelay) {
                    this.exists = false;
                    this.fireFileDeleted();
                }
            } else {
                this.deleteCount = 0;
                long l = this.file.lastModified();
                if (l > this.modTime) {
                    this.modTime = l;
                    this.fireFileModified();
                }
            }
        } else if (this.file.exists()) {
            this.deleteCount = 0;
            this.exists = true;
            this.modTime = this.file.lastModified();
            this.fireFileCreated();
        }
    }
}

