/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.Logger;
import de.qfs.lib.util.DaemonThread;
import de.qfs.lib.util.FileWatcher;
import java.util.WeakHashMap;

public class FileWatcherGroup {
    private static final Logger logger = new Logger("de.qfs.lib.util.FileWatcherGroup");
    private static FileWatcherGroup defaultFileWatcherGroup = new FileWatcherGroup();
    private final WeakHashMap<FileWatcher, Object> fileWatchers = new WeakHashMap();
    private FileWatcherThread watcherThread;
    private long interval = 500L;

    public FileWatcherGroup() {
    }

    public FileWatcherGroup(int n) {
        this.interval = n;
    }

    public static FileWatcherGroup getDefaultGroup() {
        return defaultFileWatcherGroup;
    }

    public final long getInterval() {
        return this.interval;
    }

    public final void setInterval(long l) {
        if (FileWatcherGroup.logger.level >= 7) {
            logger.log(7, "setInterval(long)", FileWatcherGroup.logger.level < 8 ? "" : "interval: " + l);
        }
        this.interval = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileWatcher(FileWatcher fileWatcher) {
        Object object;
        if (FileWatcherGroup.logger.level >= 7) {
            object = logger.build("addFileWatcher(FileWatcher)");
            ((Logger.Builder)(FileWatcherGroup.logger.level < 8 ? object : ((Logger.Builder)object).add("fileWatcher: ").add(fileWatcher))).log(7);
        }
        object = this;
        synchronized (object) {
            this.fileWatchers.put(fileWatcher, null);
            if (this.watcherThread == null) {
                this.watcherThread = new FileWatcherThread();
                this.watcherThread.start();
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileWatcher(FileWatcher fileWatcher) {
        Object object;
        if (FileWatcherGroup.logger.level >= 7) {
            object = logger.build("removeFileWatcher(FileWatcher)");
            ((Logger.Builder)(FileWatcherGroup.logger.level < 8 ? object : ((Logger.Builder)object).add("fileWatcher: ").add(fileWatcher))).log(7);
        }
        object = this;
        synchronized (object) {
            this.fileWatchers.remove(fileWatcher);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (FileWatcherGroup.logger.level >= 7) {
            logger.log(7, "dispose()", "");
        }
        FileWatcherGroup fileWatcherGroup = this;
        synchronized (fileWatcherGroup) {
            if (this.watcherThread != null) {
                this.watcherThread.terminate();
                this.watcherThread = null;
            }
        }
    }

    class FileWatcherThread
    extends DaemonThread {
        private boolean done;

        public FileWatcherThread() {
            super("FileWatcherThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (logger.level >= 7) {
                logger.log(7, "run()", "");
            }
            FileWatcherThread fileWatcherThread = this;
            synchronized (fileWatcherThread) {
                while (!this.done) {
                    FileWatcherGroup fileWatcherGroup = FileWatcherGroup.this;
                    synchronized (fileWatcherGroup) {
                        while (!this.done && FileWatcherGroup.this.fileWatchers.size() == 0) {
                            try {
                                FileWatcherGroup.this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (this.done) {
                            break;
                        }
                    }
                    this.checkFiles();
                    try {
                        if (logger.level >= 10) {
                            logger.log(10, "run()", "Sleeping " + FileWatcherGroup.this.interval + " ms");
                        }
                        this.wait(FileWatcherGroup.this.interval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (logger.level < 10) continue;
                    logger.log(10, "run()", "Wakeup - done: " + this.done);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            if (logger.level >= 7) {
                logger.log(7, "terminate()", "");
            }
            this.done = true;
            Object object = this;
            synchronized (object) {
                this.notifyAll();
            }
            object = FileWatcherGroup.this;
            synchronized (object) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkFiles() {
            FileWatcher[] fileWatcherArray;
            if (logger.level >= 7) {
                logger.log(7, "checkFiles()", "");
            }
            FileWatcherGroup fileWatcherGroup = FileWatcherGroup.this;
            synchronized (fileWatcherGroup) {
                fileWatcherArray = FileWatcherGroup.this.fileWatchers.keySet().toArray(new FileWatcher[0]);
            }
            for (int i = 0; i < fileWatcherArray.length; ++i) {
                fileWatcherArray[i].checkFile();
            }
        }
    }
}

