/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import lombok.Generated;

public abstract class Files {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.Files");
    private static final int BLOCKSIZE = 65536;

    public Files() {
        if (Files.logger.level >= 7) {
            logger.lvlBuild(7, "Files.Files()", 52).log();
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        Files.copyFile(file, file2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2, boolean bl) throws IOException {
        if (Files.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "copyFile(File,File,boolean)", 95).addDetail("source", file)).addDetail("dest", file2)).addDetail("append", bl)).log();
        }
        long l = file.length();
        if (Files.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "copyFile(File,File,boolean)", 99).add("length", l)).log();
        }
        if (l == 0L) {
            l = 65536L;
        }
        byte[] byArray = new byte[(int)Math.min(l, 65536L)];
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2, bl);
            try {
                while (true) {
                    int n = fileInputStream.read(byArray);
                    if (Files.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "copyFile(File,File,boolean)", 111).add("got", n)).log();
                    }
                    if (n < 0) {
                        break;
                    }
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            finally {
                block21: {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable) {
                        if (Files.logger.level < 9) break block21;
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "copyFile(File,File,boolean)", 121).add("t", throwable)).log();
                    }
                }
            }
        }
        finally {
            block22: {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {
                    if (Files.logger.level < 9) break block22;
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "copyFile(File,File,boolean)", 128).add("t", throwable)).log();
                }
            }
        }
    }

    public static boolean renameFile(File file, File file2) throws IOException {
        if (Files.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "renameFile(File,File)", 148).addDetail("source", file)).addDetail("dest", file2)).log();
        }
        if (!file.renameTo(file2)) {
            if (Files.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "renameFile(File,File)", 152).add("renameTo failed.")).log();
            }
            Files.copyFile(file, file2);
            boolean bl = file.delete();
            if (Files.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "renameFile(File,File)", 155).add("ret", bl)).log();
            }
            return bl;
        }
        if (Files.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "renameFile(File,File)", 158).add("source exists", file.exists())).log();
        }
        if (Files.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "renameFile(File,File)", 159).add("dest exists", file2.exists())).log();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File file) throws IOException {
        if (Files.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "loadProperties(File)", 176).addDetail("file", file)).log();
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            properties.load(fileInputStream);
        }
        finally {
            block9: {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {
                    if (Files.logger.level < 9) break block9;
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "loadProperties(File)", 187).add("t", throwable)).log();
                }
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties safeLoadProperties(File file) {
        Properties properties;
        block10: {
            if (Files.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "safeLoadProperties(File)", 204).addDetail("file", file)).log();
            }
            properties = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    properties.load(fileInputStream);
                }
                finally {
                    block11: {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable) {
                            if (Files.logger.level < 9) break block11;
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "safeLoadProperties(File)", 215).add("t", throwable)).log();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                if (Files.logger.level < 9) break block10;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "safeLoadProperties(File)", 219).add("ex", iOException)).log();
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(Properties properties, File file) throws IOException {
        if (Files.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "saveProperties(Properties,File)", 235).addDetail("props", properties)).addDetail("file", file)).log();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            properties.store(fileOutputStream, null);
        }
        finally {
            block9: {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {
                    if (Files.logger.level < 9) break block9;
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "saveProperties(Properties,File)", 245).add("t", throwable)).log();
                }
            }
        }
    }
}

