/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.FileLogWriter;
import de.qfs.lib.log.LevelFilter;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogFilter;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.RingFileLogWriter;
import de.qfs.lib.logrmi.RemoteLogWriter;
import de.qfs.lib.util.ArgsParser;
import de.qfs.lib.util.Environment;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class LogSetup {
    private static final Logger logger = new Logger("de.qfs.lib.util.LogSetup");
    protected static LogSetup instance = new LogSetup();
    public static final String[] OPTIONS = new String[]{"+log-*", "=logcreateregistry", "+logfile", "=logfileclose", "+logfilelevel", "+logfilemode", "+logfilenum", "+logfilesize", "+logflushlevel", "+logflushsize", "=loglocalonly", "+logoutputlevel", "+logport", "+logpostflush", "+logprequeuelevel", "=logqueuedrop", "=logqueueing", "+logqueuesize", "=logregistry", "?logserver"};
    public static final int DEFAULT_LOG_FILE_NUM = 5;
    private static boolean DEBUG = "true".equalsIgnoreCase(System.getenv("QFLIB_LOGSETUP_DEBUG"));
    protected LevelFilter fileFilter;
    protected LevelFilter remoteFilter;
    protected Properties sprops = new Properties();

    protected LogSetup() {
    }

    public static LogSetup instance() {
        return instance;
    }

    public static void globalSetupInitialLogging(final String string) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block2: {
                    Object object = LogSetup.globalGetInstance();
                    try {
                        object.getClass().getMethod("setupInitialLogging", String.class).invoke(object, string);
                    }
                    catch (Throwable throwable) {
                        if (!DEBUG) break block2;
                        throwable.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    public static void globalStopLogging() {
        block2: {
            Object object = LogSetup.globalGetInstance();
            try {
                object.getClass().getMethod("stopLogging", new Class[0]).invoke(object, new Object[0]);
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block2;
                throwable.printStackTrace();
            }
        }
    }

    public void addOptions(ArgsParser argsParser) {
        argsParser.addOptions(OPTIONS);
        argsParser.setSkipFromSimplification("log-.*");
    }

    public synchronized void setupInitialLogging(String string) {
        String string2;
        Object object;
        Object object2;
        Object object3;
        if (DEBUG) {
            System.err.println("setupInitialLogging - now: " + System.currentTimeMillis());
            System.err.println("this: " + this);
            System.err.println("protectionDomain: " + this.getClass().getProtectionDomain());
            Thread.dumpStack();
        }
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        Properties properties3 = System.getProperties();
        if (properties3 != null) {
            object3 = properties3.keySet().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                String string3 = (String)object2;
                if (!string3.startsWith("qflib.log")) continue;
                object = properties3.getProperty(string3);
                if (DEBUG) {
                    System.err.println("setupInitialLogging - sysprop " + string3 + "=" + (String)object);
                }
                if (string3.startsWith("qflib.log-")) {
                    properties.setProperty("log-" + string3.substring(10), (String)object);
                    continue;
                }
                properties2.setProperty(string3, (String)object);
            }
        }
        if ((object3 = new Environment().getEnvironment()) != null) {
            for (Object string22 : ((Properties)object3).keySet()) {
                Object string5;
                object = (String)string22;
                if (((String)object).equals("QFLIB_LOGLEVELS")) {
                    for (String string3 : string5 = ((Properties)object3).getProperty((String)object).split(",")) {
                        String[] stringArray = string3.split("=");
                        if (stringArray.length != 2) continue;
                        properties.setProperty("log-" + stringArray[0], stringArray[1]);
                    }
                    continue;
                }
                if (!((String)object).startsWith("QFLIB_LOG")) continue;
                string5 = ((String)object).toLowerCase().replace("_", ".");
                String string4 = ((Properties)object3).getProperty((String)object);
                if (DEBUG) {
                    System.err.println("setupInitialLogging - env " + (String)string5 + "=" + string4);
                }
                properties2.setProperty((String)string5, string4);
            }
        }
        if (DEBUG) {
            System.err.println("setupInitialLogging - lprops: " + properties);
            System.err.println("setupInitialLogging - props: " + properties2);
        }
        if (properties2.containsKey("qflib.logqueueing")) {
            Log.setQueueing(Boolean.valueOf(properties2.getProperty("qflib.logqueueing")));
        }
        try {
            Log.setOutputLevel(Integer.parseInt(properties2.getProperty("qflib.logoutputlevel")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Log.setPreQueueLevel(Integer.parseInt(properties2.getProperty("qflib.logprequeuelevel")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = properties2.getProperty("qflib.logfile");
        if (DEBUG) {
            System.err.println("setupInitialLogging - logfile: " + (String)object2);
        }
        if (object2 != null) {
            int n;
            int n2;
            int n3 = -1;
            try {
                n2 = Integer.parseInt(properties2.getProperty("qflib.logfilesize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = "append";
            if (properties2.containsKey("qflib.logfilemode")) {
                object = properties2.getProperty("qflib.logfilemode");
            }
            boolean bl = !"false".equalsIgnoreCase(properties2.getProperty("qflib.logfileclose"));
            int n4 = 5;
            try {
                n = Integer.parseInt(properties2.getProperty("qflib.logfilenum"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n5 = -1;
            try {
                n5 = Integer.parseInt(properties2.getProperty("qflib.logfilelevel"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.maybeLogToFile(string, (String)object2, n2, (String)object, bl, n, n5);
        }
        if ((string2 = properties2.getProperty("qflib.logserver")) != null) {
            this.maybeLogRemote(string2, string);
        }
        object = properties2.keys();
        while (object.hasMoreElements()) {
            String string5 = (String)object.nextElement();
            if (string5.startsWith("qflib.log-")) {
                properties.put(string5.substring(6), properties2.get(string5));
                continue;
            }
            if (!string5.startsWith("qflib.")) continue;
            this.sprops.put(string5.substring(6), properties2.get(string5));
        }
        Logger.setLogLevels(properties);
    }

    public synchronized void setupLogging(String string, ArgsParser argsParser) {
        String string2;
        if (DEBUG) {
            System.err.println("setupLogging - now: " + System.currentTimeMillis());
            System.err.println("this: " + this);
            System.err.println("protectionDomain: " + this.getClass().getProtectionDomain());
            Thread.dumpStack();
        }
        try {
            argsParser.addProperties(this.sprops);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (DEBUG) {
            System.err.println("setupLogging - opts: " + argsParser.getOptions());
        }
        Logger.setLogLevels(argsParser.getOptions());
        Log.setOutputLevel(argsParser.getInt("logoutputlevel", Log.getOutputLevel()));
        Log.setPreQueueLevel(argsParser.getInt("logprequeuelevel", Log.getPreQueueLevel()));
        Log.setFlushBufferSize(argsParser.getInt("logflushsize", Log.getFlushBufferSize()));
        Log.setFlushTriggerLevel(argsParser.getInt("logflushlevel", Log.getFlushTriggerLevel()));
        Log.setPostFlushSize(argsParser.getInt("logpostflush", Log.getPostFlushSize()));
        String string3 = argsParser.getString("logfile", null);
        if (DEBUG) {
            System.err.println("setupLogging - logfile: " + string3);
        }
        if (string3 != null) {
            int n = argsParser.getInt("logfilesize", -1);
            String string4 = argsParser.getString("logfilemode", "append");
            boolean bl = argsParser.getBoolean("logfileclose", true);
            int n2 = argsParser.getInt("logfilenum", 5);
            int n3 = argsParser.getInt("logfilelevel", -1);
            this.maybeLogToFile(string, string3, n, string4, bl, n2, n3);
        }
        if ("".equals(string2 = argsParser.getString("logserver", null))) {
            string2 = "qflog";
        }
        if (string2 != null) {
            this.maybeLogRemote(string2, string);
        }
        this.startLogThread(argsParser.getInt("logqueuesize", Log.getQueueSize()), argsParser.getBoolean("logqueueing", Log.isQueueing()), argsParser.getBoolean("logqueuedrop", Log.isDropOnOverflow()));
    }

    public synchronized void stopLogging() {
        Log.setQueueing(false);
        if (this.fileFilter != null) {
            this.fileFilter.getLogWriter().close();
            Log.removeFilter(this.fileFilter);
            this.fileFilter = null;
        }
        if (this.remoteFilter != null) {
            this.remoteFilter.getLogWriter().close();
            Log.removeFilter(this.remoteFilter);
            this.remoteFilter = null;
        }
    }

    public LevelFilter getFileFilter() {
        return this.fileFilter;
    }

    public LevelFilter getRemoteFilter() {
        return this.remoteFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object globalGetInstance() {
        try {
            Map map;
            Class<?> clazz = Class.forName("de.qfs.apps.qftest.instrument.InstanceMap");
            Map map2 = map = (Map)clazz.getMethod("getMap", new Class[0]).invoke(null, new Object[0]);
            synchronized (map2) {
                Object object = map.get("de.qfs.lib.util.LogSetup.instance");
                if (object == null) {
                    object = LogSetup.instance();
                    map.put("de.qfs.lib.util.LogSetup.instance", object);
                }
                return object;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return LogSetup.instance();
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                throwable.printStackTrace();
            }
            return LogSetup.instance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeLogToFile(String string, String string2, int n, String string3, boolean bl, int n2, int n3) {
        Properties properties;
        block19: {
            Properties properties2 = properties = System.getProperties();
            synchronized (properties2) {
                if ("true".equalsIgnoreCase(properties.getProperty("qflib.logfile.created"))) {
                    if (DEBUG) {
                        System.err.println("logfile already created");
                    }
                    return;
                }
                properties.setProperty("qflib.logfile.created", "true");
            }
            if (n < 0) {
                int n4 = 1;
                if ("create".equalsIgnoreCase(string3)) {
                    n4 = 0;
                } else if ("unique".equalsIgnoreCase(string3)) {
                    n4 = 2;
                }
                try {
                    this.fileFilter = FileLogWriter.logToFile(string, string2, n4, bl);
                }
                catch (IOException iOException) {
                    if (DEBUG) {
                        iOException.printStackTrace();
                    }
                    if (LogSetup.logger.level >= 3) {
                        logger.log(3, "maybeLogToFile(String,String,int,String,boolean,int)", iOException);
                    }
                    break block19;
                }
            }
            try {
                this.fileFilter = RingFileLogWriter.logToFile(string, string2, n, n2);
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    iOException.printStackTrace();
                }
                if (LogSetup.logger.level < 3) break block19;
                logger.log(3, "maybeLogToFile(String,String,int,String,boolean,int)", iOException);
            }
        }
        if (this.fileFilter == null) {
            properties.remove("qflib.logfile.created");
        } else if (n3 >= 0) {
            this.fileFilter.setLevel(n3);
            this.fileFilter.setFilterMode(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeLogRemote(final String string, final String string2) {
        Properties properties;
        Properties properties2 = properties = System.getProperties();
        synchronized (properties2) {
            String string3 = properties.getProperty("qflib.logserver.connected");
            if (DEBUG) {
                System.err.println("maybeLogRemote - cprop: " + string3);
            }
            if ("true".equalsIgnoreCase(string3)) {
                if (DEBUG) {
                    System.err.println("maybeLogRemote - logserver already connected");
                }
                return;
            }
            if (DEBUG) {
                System.err.println("maybeLogRemote - setting cprop");
            }
            properties.setProperty("qflib.logserver.connected", "true");
        }
        long l = 1500L;
        try {
            l = Long.parseLong(System.getenv("LOGSETUP_DELAY_REMOTE"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (DEBUG) {
            System.err.println("maybeLogRemote - delayRemote: " + l);
        }
        if (l > 0L) {
            final BufferingLogFilter bufferingLogFilter = new BufferingLogFilter();
            Log.addFilter(bufferingLogFilter);
            final long l2 = l;
            Thread thread = new Thread("delay log remote"){

                @Override
                public void run() {
                    try {
                        if (DEBUG) {
                            System.err.println("maybeLogRemote - now: " + System.currentTimeMillis());
                            System.err.println("maybeLogRemote - delaying");
                        }
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (DEBUG) {
                        System.err.println("maybeLogRemote - now: " + System.currentTimeMillis());
                        System.err.println("maybeLogRemote - wakeup");
                    }
                    LogSetup.this.logRemote(string, string2, bufferingLogFilter);
                }
            };
            thread.setDaemon(true);
            thread.start();
        } else {
            this.logRemote(string, string2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logRemote(String string, String string2, BufferingLogFilter bufferingLogFilter) {
        Properties properties = System.getProperties();
        try {
            this.remoteFilter = RemoteLogWriter.logRemote(string, string2);
            if (bufferingLogFilter != null) {
                LogEntry[] logEntryArray = bufferingLogFilter.flush();
                if (DEBUG) {
                    System.err.println("logRemote - now: " + System.currentTimeMillis());
                    System.err.println("logRemote - got " + logEntryArray.length + " entries");
                }
                this.remoteFilter.filter(logEntryArray);
                Log.removeFilter(bufferingLogFilter);
                logEntryArray = bufferingLogFilter.flush();
                bufferingLogFilter = null;
                if (DEBUG) {
                    System.err.println("logRemote - now: " + System.currentTimeMillis());
                    System.err.println("logRemote - got " + logEntryArray.length + " additional entries");
                }
                this.remoteFilter.filter(logEntryArray);
            }
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                System.err.println("logRemote - cannot connect to logserver");
                throwable.printStackTrace();
            }
            if (LogSetup.logger.level >= 5) {
                logger.log(5, "maybeLogRemote(String,String)", throwable);
            }
            Properties properties2 = properties;
            synchronized (properties2) {
                if (DEBUG) {
                    System.err.println("logRemote - remove cprop");
                }
                properties.remove("qflib.logserver.connected");
                properties.notifyAll();
            }
        }
        finally {
            if (bufferingLogFilter != null) {
                Log.removeFilter(bufferingLogFilter);
            }
        }
    }

    private void startLogThread(int n, boolean bl, boolean bl2) {
        block2: {
            try {
                Log.startLogThread();
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block2;
                throwable.printStackTrace();
            }
        }
        Log.setQueueSize(n);
        Log.setQueueing(bl);
        Log.setDropOnOverflow(bl2);
    }

    public static class BufferingLogFilter
    implements LogFilter {
        private LinkedList<LogEntry> buffer = new LinkedList();

        @Override
        public synchronized boolean filter(LogEntry logEntry) {
            this.buffer.add(logEntry);
            return true;
        }

        @Override
        public synchronized LogEntry[] filter(LogEntry[] logEntryArray) {
            for (LogEntry logEntry : logEntryArray) {
                this.buffer.add(logEntry);
            }
            return logEntryArray;
        }

        public synchronized LogEntry[] flush() {
            LogEntry[] logEntryArray = this.buffer.toArray(new LogEntry[0]);
            this.buffer.clear();
            return logEntryArray;
        }
    }
}

