/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.Logger;
import de.qfs.lib.util.MRUCacheEvent;
import de.qfs.lib.util.MRUCacheListener;
import de.qfs.lib.util.MultiMap;
import java.util.Vector;

public class MRUCache {
    private static final Logger logger = new Logger("de.qfs.lib.util.MRUCache");
    private static Object uniqueKey = new Object();
    private MultiMap cache;
    private Vector mruList;
    private Vector keys;
    private int mruSize;
    private Vector listeners = new Vector();

    public MRUCache(int n) {
        if (MRUCache.logger.level >= 7) {
            logger.log(7, "MRUCache(int)", MRUCache.logger.level < 8 ? "" : "size: " + n);
        }
        this.mruSize = n;
        this.cache = new MultiMap(n);
        this.mruList = new Vector(n);
        this.keys = new Vector(n);
    }

    public synchronized Object get() {
        return this.get(uniqueKey);
    }

    public synchronized Object get(Object object) {
        Object object2;
        if (MRUCache.logger.level >= 7) {
            logger.log(7, "get(Object)", MRUCache.logger.level < 8 ? "" : "key: " + object);
        }
        if ((object2 = this.cache.get(object)) != null) {
            this.cache.remove(object, object2);
            int n = this.mruList.indexOf(object2);
            if (n < 0) {
                if (MRUCache.logger.level >= 3) {
                    logger.log(3, "get(Object)", "OOPS, object not on mruList");
                }
            } else {
                this.keys.removeElementAt(n);
                this.mruList.removeElementAt(n);
            }
        }
        return object2;
    }

    public synchronized void put(Object object) {
        this.put(uniqueKey, object);
    }

    public synchronized void put(Object object, Object object2) {
        Object e;
        int n;
        if (MRUCache.logger.level >= 7) {
            logger.log(7, "put(Object,Object)", MRUCache.logger.level < 8 ? "" : "key: " + object + ", resource: " + object2);
        }
        if ((n = this.mruList.indexOf(object2)) >= 0) {
            if (MRUCache.logger.level >= 3) {
                logger.dumpStack(3, "put(Object,Object)", "Object already in MRUCache: " + object2);
            }
            e = this.keys.elementAt(n);
            this.cache.remove(e, object2);
            this.keys.removeElementAt(n);
            this.mruList.removeElementAt(n);
        }
        if (MRUCache.logger.level >= 9) {
            logger.log(9, "put(Object,Object)", "storing " + object2 + "(hash: " + object2.hashCode() + ") in reverseMap");
        }
        if (this.mruList.size() >= this.mruSize) {
            e = this.mruList.elementAt(this.mruList.size() - 1);
            this.mruList.removeElementAt(this.mruList.size() - 1);
            Object e2 = this.keys.elementAt(this.keys.size() - 1);
            this.keys.removeElementAt(this.keys.size() - 1);
            this.cache.remove(e2, e);
            this.fireResourceDropped(e2, e);
        }
        this.mruList.insertElementAt(object2, 0);
        this.keys.insertElementAt(object, 0);
        this.cache.put(object, object2);
    }

    public void remove(Object object) {
        int n;
        if (MRUCache.logger.level >= 7) {
            logger.log(7, "remove(Object)", MRUCache.logger.level < 8 ? "" : "resource: " + object);
        }
        if ((n = this.mruList.indexOf(object)) < 0) {
            if (MRUCache.logger.level >= 3) {
                logger.dumpStack(3, "remove(Object)", "Object not in MRUCache: " + object);
            }
            return;
        }
        Object e = this.keys.elementAt(n);
        this.cache.remove(e, object);
        this.keys.removeElementAt(n);
        this.mruList.removeElementAt(n);
        if (MRUCache.logger.level >= 9) {
            logger.log(9, "remove(Object)", "removing " + object + "(hash: " + object.hashCode() + ") from reverseMap");
        }
    }

    public boolean contains(Object object) {
        return this.mruList.contains(object);
    }

    public synchronized int getMaximumSize() {
        return this.mruSize;
    }

    public synchronized void setMaximumSize(int n) {
        this.mruSize = n;
        while (this.mruList.size() > this.mruSize) {
            Object e = this.mruList.elementAt(this.mruList.size() - 1);
            this.mruList.removeElementAt(this.mruList.size() - 1);
            Object e2 = this.keys.elementAt(this.keys.size() - 1);
            this.keys.removeElementAt(this.keys.size() - 1);
            this.cache.remove(e2, e);
            this.fireResourceDropped(e2, e);
        }
    }

    public synchronized int getCurrentSize() {
        return this.mruList.size();
    }

    public void clear() {
        if (MRUCache.logger.level >= 7) {
            logger.log(7, "clear()", "");
        }
        this.cache.clear();
        this.mruList.clear();
        this.keys.clear();
    }

    public synchronized void addMRUCacheListener(MRUCacheListener mRUCacheListener) {
        this.listeners.removeElement(mRUCacheListener);
        this.listeners.insertElementAt(mRUCacheListener, 0);
    }

    public synchronized void removeMRUCacheListener(MRUCacheListener mRUCacheListener) {
        this.listeners.removeElement(mRUCacheListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireResourceDropped(Object object, Object object2) {
        Vector vector;
        MRUCacheEvent mRUCacheEvent = new MRUCacheEvent(this, object, object2);
        MRUCache mRUCache = this;
        synchronized (mRUCache) {
            vector = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ((MRUCacheListener)vector.elementAt(i)).resourceDropped(mRUCacheEvent);
        }
    }
}

