/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.gui.SVGIcon;
import de.qfs.lib.gui.ThemeSupport;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.util.Misc;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import lombok.Generated;
import lombok.NonNull;

public class MapResourceBundle
extends ResourceBundle {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.MapResourceBundle");
    private static final String OS_NAME = Misc.getOsShortName();
    public static final Pattern SCALING_SUFFIX_PATTERN = Pattern.compile("(.+)@(\\d+(\\.\\d+)?)x");
    private Hashtable map = new Hashtable();
    private Hashtable icons = new Hashtable();
    private Set svgIconMutexes = new ConcurrentSkipListSet();
    private Class resolver = null;

    public MapResourceBundle() {
        if (MapResourceBundle.logger.level >= 7) {
            logger.lvlBuild(7, "MapResourceBundle()", 143).log();
        }
    }

    public MapResourceBundle(ResourceBundle resourceBundle) {
        if (MapResourceBundle.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "MapResourceBundle(ResourceBundle)", 153).addDetail("rb", resourceBundle)).log();
        }
        this.addResources(resourceBundle);
    }

    public void addResources(ResourceBundle resourceBundle) {
        if (MapResourceBundle.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addResources(ResourceBundle)", 168).addDetail("bundle", resourceBundle)).log();
        }
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.map.put(string, resourceBundle.getObject(string));
        }
    }

    public void clear() {
        if (MapResourceBundle.logger.level >= 7) {
            logger.lvlBuild(7, "clear()", 182).log();
        }
        this.map.clear();
    }

    public void addResources(Properties properties) {
        if (MapResourceBundle.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addResources(Properties)", 196).addDetail("properties", properties)).log();
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.map.put(string, properties.get(string));
        }
    }

    public void addResource(String string, Object object) {
        this.map.put(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchProperties(String string, Locale locale, Class clazz, String string2) throws MissingResourceException {
        if (MapResourceBundle.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fetchProperties(String,Locale,Class,String)", 237).addDetail("basename", string)).addDetail("locale", locale)).addDetail("resolve", clazz)).addDetail("encoding", string2)).log();
        }
        try {
            boolean bl;
            block50: {
                InputStream inputStream;
                String string3;
                boolean bl2;
                block48: {
                    block46: {
                        bl = false;
                        bl2 = clazz.getClassLoader() != null;
                        String string4 = string3 = string.startsWith("/") ? string.substring(1) : string;
                        if (MapResourceBundle.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "fetchProperties(String,Locale,Class,String)", 245).add("clBase", string3)).log();
                        }
                        if (MapResourceBundle.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "fetchProperties(String,Locale,Class,String)", 246).add("ccl", Thread.currentThread().getContextClassLoader())).log();
                        }
                        inputStream = null;
                        if (bl2) {
                            inputStream = clazz.getClassLoader().getResourceAsStream(string3 + ".properties");
                        }
                        if (inputStream == null) {
                            inputStream = clazz.getResourceAsStream(string + ".properties");
                        }
                        if (inputStream != null) {
                            try {
                                try {
                                    this.addResources(new PropertyResourceBundle(new InputStreamReader(inputStream, string2)));
                                    bl = true;
                                }
                                finally {
                                    block47: {
                                        try {
                                            inputStream.close();
                                        }
                                        catch (Throwable throwable) {
                                            if (MapResourceBundle.logger.level < 9) break block47;
                                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "fetchProperties(String,Locale,Class,String)", 271).add("t", throwable)).log();
                                        }
                                    }
                                }
                            }
                            catch (IOException iOException) {
                                if (MapResourceBundle.logger.level < 1) break block46;
                                ((LevelAwareLogBuilder)logger.lvlBuild(1, "fetchProperties(String,Locale,Class,String)", 275).add("ex", iOException)).log();
                            }
                        }
                    }
                    inputStream = null;
                    if (bl2) {
                        inputStream = clazz.getClassLoader().getResourceAsStream(string3 + "_" + locale.getLanguage() + ".properties");
                    }
                    if (inputStream == null) {
                        inputStream = clazz.getResourceAsStream(string + "_" + locale.getLanguage() + ".properties");
                    }
                    if (inputStream != null) {
                        try {
                            try {
                                this.addResources(new PropertyResourceBundle(new InputStreamReader(inputStream, string2)));
                                bl = true;
                            }
                            finally {
                                block49: {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable) {
                                        if (MapResourceBundle.logger.level < 9) break block49;
                                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "fetchProperties(String,Locale,Class,String)", 307).add("t", throwable)).log();
                                    }
                                }
                            }
                        }
                        catch (IOException iOException) {
                            if (MapResourceBundle.logger.level < 1) break block48;
                            ((LevelAwareLogBuilder)logger.lvlBuild(1, "fetchProperties(String,Locale,Class,String)", 311).add("ex", iOException)).log();
                        }
                    }
                }
                inputStream = null;
                if (bl2) {
                    inputStream = clazz.getClassLoader().getResourceAsStream(string3 + "_" + locale.getLanguage() + "_" + locale.getCountry() + ".properties");
                }
                if (inputStream == null) {
                    inputStream = clazz.getResourceAsStream(string + "_" + locale.getLanguage() + "_" + locale.getCountry() + ".properties");
                }
                if (inputStream != null) {
                    try {
                        try {
                            this.addResources(new PropertyResourceBundle(new InputStreamReader(inputStream, string2)));
                            bl = true;
                        }
                        finally {
                            block51: {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable) {
                                    if (MapResourceBundle.logger.level < 9) break block51;
                                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "fetchProperties(String,Locale,Class,String)", 347).add("t", throwable)).log();
                                }
                            }
                        }
                    }
                    catch (IOException iOException) {
                        if (MapResourceBundle.logger.level < 1) break block50;
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "fetchProperties(String,Locale,Class,String)", 351).add("ex", iOException)).log();
                    }
                }
            }
            if (!bl) {
                throw new MissingResourceException("Can't find resource for " + string + " locale " + locale, string, locale.toString());
            }
        }
        catch (MissingResourceException missingResourceException) {
            throw missingResourceException;
        }
        catch (NullPointerException nullPointerException) {
            if (MapResourceBundle.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "fetchProperties(String,Locale,Class,String)", 365).add("ex", nullPointerException)).log();
            }
        }
        catch (Throwable throwable) {
            if (MapResourceBundle.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "fetchProperties(String,Locale,Class,String)", 368).add("ex", throwable)).log();
            }
            throw new MissingResourceException("Can't find resource for " + string + " locale " + locale, string, locale.toString());
        }
    }

    public void fetchProperties(String string, Locale locale, Class clazz) throws MissingResourceException {
        if (MapResourceBundle.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fetchProperties(String,Locale,Class)", 392).addDetail("basename", string)).addDetail("locale", locale)).addDetail("resolve", clazz)).log();
        }
        this.fetchProperties(string, locale, clazz, "UTF-8");
    }

    public void fetchProperties(String string, Class clazz) throws MissingResourceException {
        this.fetchProperties(string, Locale.getDefault(), clazz);
    }

    public Enumeration getKeys() {
        if (MapResourceBundle.logger.level >= 7) {
            logger.lvlBuild(7, "getKeys()", 434).log();
        }
        return this.map.keys();
    }

    @Override
    public Object handleGetObject(String string) throws MissingResourceException {
        if (MapResourceBundle.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "handleGetObject(String)", 452).addDetail("key", string)).log();
        }
        if (this.map.containsKey(string)) {
            return this.map.get(string);
        }
        throw new MissingResourceException("Missing resource: " + string, "de.qfs.lib.util.MapResourceBundle", string);
    }

    public String getString(String string, String string2) {
        if (MapResourceBundle.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getString(String,String)", 477).addDetail("key", string)).addDetail("def", string2)).log();
        }
        if (string == null) {
            return string2;
        }
        if (this.map.containsKey(string)) {
            return (String)this.map.get(string);
        }
        if (MapResourceBundle.logger.level >= 5) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "getString(String,String)", 483).add("Warning - unknown resource: ")).add(string)).log();
        }
        return string2;
    }

    public String getExtendedString(String string, @Nullable String string2, String string3) {
        if (MapResourceBundle.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getExtendedString(String,String,String)", 502).addDetail("key", string)).addDetail("ext", string2)).addDetail("def", string3)).log();
        }
        String string4 = string + "." + OS_NAME;
        if (string2 != null) {
            string4 = string4 + "." + string2;
            string = string + "." + string2;
        }
        if (this.map.containsKey(string4)) {
            return (String)this.map.get(string4);
        }
        if (this.map.containsKey(string)) {
            return (String)this.map.get(string);
        }
        if (MapResourceBundle.logger.level >= 5) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "getExtendedString(String,String,String)", 515).add("Warning - unknown resource: ")).add(string)).log();
        }
        return string3;
    }

    public int getInteger(String string, int n) {
        if (MapResourceBundle.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getInteger(String,int)", 536).addDetail("key", string)).addDetail("def", n)).log();
        }
        if (this.map.containsKey(string)) {
            try {
                return Integer.parseInt((String)this.map.get(string));
            }
            catch (NumberFormatException numberFormatException) {
                if (MapResourceBundle.logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "getInteger(String,int)", 542).add("ex", numberFormatException)).log();
                }
                return n;
            }
        }
        if (MapResourceBundle.logger.level >= 5) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "getInteger(String,int)", 546).add("Warning - unknown resource: ")).add(string)).log();
        }
        return n;
    }

    public int getInt(String string, int n) {
        if (MapResourceBundle.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getInt(String,int)", 564).addDetail("key", string)).addDetail("def", n)).log();
        }
        if (this.map.containsKey(string)) {
            try {
                return Integer.parseInt((String)this.map.get(string));
            }
            catch (NumberFormatException numberFormatException) {
                if (MapResourceBundle.logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "getInt(String,int)", 570).add("ex", numberFormatException)).log();
                }
                return n;
            }
        }
        if (MapResourceBundle.logger.level >= 5) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "getInt(String,int)", 574).add("Warning - unknown resource: ")).add(string)).log();
        }
        return n;
    }

    public boolean getBoolean(String string, boolean bl) {
        if (MapResourceBundle.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getBoolean(String,boolean)", 591).addDetail("key", string)).addDetail("def", bl)).log();
        }
        if (this.map.containsKey(string)) {
            return Boolean.valueOf((String)this.map.get(string));
        }
        if (MapResourceBundle.logger.level >= 5) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "getBoolean(String,boolean)", 596).add("Warning - unknown resource: ")).add(string)).log();
        }
        return bl;
    }

    public void setResolvingClass(Class clazz) {
        if (MapResourceBundle.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setResolvingClass(Class)", 610).addDetail("clazz", clazz)).log();
        }
        this.resolver = clazz;
    }

    public Icon getIcon(String string, Icon icon) {
        Object object;
        double d;
        String string2;
        block28: {
            if (MapResourceBundle.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getIcon(String,Icon)", 629).addDetail("key", string)).addDetail("def", icon)).log();
            }
            if (MapResourceBundle.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getIcon(String,Icon)", 631).addDetail("key", string)).addDetail("def", icon)).dumpStack();
            }
            if (this.icons.containsKey(string)) {
                if (MapResourceBundle.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getIcon(String,Icon)", 633).add("Cache hit")).log();
                }
                return (Icon)this.icons.get(string);
            }
            string2 = string;
            d = 1.0;
            if (!this.map.containsKey(string)) {
                try {
                    object = SCALING_SUFFIX_PATTERN.matcher(string);
                    if (((Matcher)object).matches()) {
                        d = Double.parseDouble(((Matcher)object).group(2));
                        string = ((Matcher)object).group(1);
                        if (d == 1.25 && this.map.containsKey(string + "@1.25x")) {
                            string = string + "@1.25x";
                            d = 1.0;
                        } else if (d == 1.25 && string.contains(".dark") && this.map.containsKey(string.replace(".dark", ".dark@1.25x"))) {
                            string = string.replace(".dark", ".dark@1.25x");
                            d = 1.0;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (MapResourceBundle.logger.level < 3) break block28;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "getIcon(String,Icon)", 655).add("ex", throwable)).log();
                }
            }
        }
        if (this.map.containsKey(string)) {
            object = (String)this.map.get(string);
        } else {
            if (string != null && string.indexOf(58) > -1 && !string.startsWith("file:")) {
                if (MapResourceBundle.logger.level >= 1) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "getIcon(String,Icon)", 666).add("Illegal icon specifier")).add(string)).log();
                }
                return icon;
            }
            object = string;
        }
        if (object != null) {
            Object object2;
            boolean bl;
            if (MapResourceBundle.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getIcon(String,Icon)", 674).add("Icon name: ")).add((String)object)).log();
            }
            URL uRL = null;
            boolean bl2 = ((String)object).endsWith(".svg");
            boolean bl3 = bl = !bl2;
            if (bl && (object2 = this.retinaIconName((String)object)) != null) {
                uRL = this.getResource((String)object2);
            }
            if (uRL == null) {
                bl = false;
                uRL = this.getResource((String)object);
            }
            if (uRL == null && bl2 && ((Matcher)(object2 = Pattern.compile("(.+)@(\\d+(\\.\\d+)?)x.svg").matcher((CharSequence)object))).matches()) {
                d *= Double.parseDouble(((Matcher)object2).group(2));
                uRL = this.getResource(((Matcher)object2).group(1) + ".svg");
            }
            if (uRL == null) {
                if (MapResourceBundle.logger.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "getIcon(String,Icon)", 699).add("Cannot get URL for ")).add((String)object)).log();
                }
                return icon;
            }
            if (uRL.toString().endsWith(".svg")) {
                object2 = new SVGIcon(uRL, false, d, false);
            } else {
                if (MapResourceBundle.logger.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "getIcon(String,Icon)", 709).add("Old-style Icon: ")).add(uRL)).log();
                }
                object2 = new ImageIcon(uRL);
                BufferedImage bufferedImage = new BufferedImage(object2.getIconWidth(), object2.getIconHeight(), 2);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.drawImage(((ImageIcon)object2).getImage(), 0, 0, null);
                graphics.dispose();
                Object object3 = object2 = bl ? new RetinaIcon(bufferedImage) : new ImageIcon(bufferedImage);
            }
            if (object2 == null) {
                if (MapResourceBundle.logger.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "getIcon(String,Icon)", 724).add("Warning - could not read icon: ")).add(uRL)).log();
                }
                return icon;
            }
            this.icons.put(string2, object2);
            return object2;
        }
        if (MapResourceBundle.logger.level >= 5) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "getIcon(String,Icon)", 730).add("Warning - unknown resource: ")).add(string)).log();
        }
        return icon;
    }

    public Icon getThemedIcon(String string, Icon icon, boolean bl) {
        double d;
        String string2;
        if (MapResourceBundle.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getThemedIcon(String,Icon,boolean)", 749).addDetail("key", string)).addDetail("def", icon)).addDetail("scaleForFontSize", bl)).log();
        }
        if ((string2 = ThemeSupport.getThemeSuffix()) != null) {
            string = string + string2;
        }
        if (bl && (d = ThemeSupport.getFontScale()) != 1.0) {
            string = string + "@" + d + "x";
        }
        return this.getIcon(string, icon);
    }

    @Nullable
    private String retinaIconName(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("iconName is marked non-null but is null");
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return string.substring(0, n) + "@2x" + string.substring(n);
    }

    @Nullable
    private URL getResource(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("resourceName is marked non-null but is null");
        }
        if (string.startsWith("file:")) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                if (MapResourceBundle.logger.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "getResource(String)", 794).add("Could not read file resource: ")).add(malformedURLException)).log();
                }
                return null;
            }
        }
        URL uRL = this.resolver != null ? this.resolver.getResource(string) : ClassLoader.getSystemResource(string);
        if (MapResourceBundle.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getResource(String)", 802).add("resource: ")).add(uRL)).log();
        }
        return uRL;
    }

    @Nullable
    public InputStream getResourceStream(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("key is marked non-null but is null");
        }
        String string2 = (String)this.map.get(string);
        URL uRL = this.getResource(string2);
        if (uRL == null) {
            return null;
        }
        try {
            return uRL.openStream();
        }
        catch (Exception exception) {
            if (MapResourceBundle.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "getResourceStream(String)", 818).add("ex", exception)).log();
            }
            return null;
        }
    }

    public void addOptions(Option[] optionArray) {
        if (MapResourceBundle.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addOptions(Option[])", 825).addDetail("options", optionArray)).log();
        }
        for (int i = 0; i < optionArray.length; ++i) {
            Option option = optionArray[i];
            if (option != null && option.getValue() != null) {
                this.addResource(option.getName(), option.getValue());
                continue;
            }
            if (MapResourceBundle.logger.level < 9) continue;
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "addOptions(Option[])", 833).add("An error occurred while adding options to resources")).log();
        }
    }

    public void setIcon(String string, Icon icon) {
        if (MapResourceBundle.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setIcon(String,Icon)", 897).addDetail("key", string)).addDetail("icon", icon)).log();
        }
        this.icons.put(string, icon);
    }

    private static final class RetinaIcon
    extends ImageIcon {
        public RetinaIcon(Image image) {
            super(image);
        }

        @Override
        public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
            ImageObserver imageObserver = this.getImageObserver();
            if (imageObserver == null) {
                imageObserver = component;
            }
            Image image = this.getImage();
            int n3 = image.getWidth(imageObserver);
            int n4 = image.getHeight(imageObserver);
            Graphics2D graphics2D = (Graphics2D)graphics.create(n, n2, n3, n4);
            graphics2D.scale(0.5, 0.5);
            graphics2D.drawImage(image, 0, 0, imageObserver);
            graphics2D.scale(1.0, 1.0);
            graphics2D.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.getImage().getWidth(null) / 2;
        }

        @Override
        public int getIconHeight() {
            return this.getImage().getHeight(null) / 2;
        }
    }
}

