/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import java.text.DecimalFormatSymbols;
import java.text.Normalizer;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;

public class NaturalComparator
implements Comparator<String> {
    private Pattern alphaNumChunkPattern;
    @NonNull
    String stripEndingString = "";

    public NaturalComparator() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.getDefault());
        char c = decimalFormatSymbols.getDecimalSeparator();
        this.alphaNumChunkPattern = Pattern.compile("(\\d+\\" + c + "\\d+)|(\\d+)|(\\D+)");
    }

    public NaturalComparator(@NonNull String string) {
        this();
        if (string == null) {
            throw new IllegalArgumentException("stripEndingString is marked non-null but is null");
        }
        this.stripEndingString = string;
    }

    @Override
    public int compare(String string, String string2) {
        return this.compareNaturally(string, string2, this.stripEndingString);
    }

    public int compareNaturally(String string, String string2, @NonNull String string3) {
        if (string3 == null) {
            throw new IllegalArgumentException("stripEndingString is marked non-null but is null");
        }
        if (!string3.isEmpty()) {
            if (string.endsWith(string3)) {
                string = string.replace(string3, "");
            }
            if (string2.endsWith(string3)) {
                string2 = string2.replace(string3, "");
            }
        }
        int n = 0;
        Matcher matcher = this.alphaNumChunkPattern.matcher(string);
        Matcher matcher2 = this.alphaNumChunkPattern.matcher(string2);
        String string4 = null;
        String string5 = null;
        while (matcher.find() && matcher2.find() && n == 0) {
            block8: {
                Object object;
                string4 = matcher.group();
                string5 = matcher2.group();
                try {
                    Double d = Double.valueOf(string4);
                    object = Double.valueOf(string5);
                    n = d.compareTo((Double)object);
                }
                catch (NumberFormatException numberFormatException) {
                    object = Normalizer.normalize(string4, Normalizer.Form.NFD);
                    String string6 = Normalizer.normalize(string5, Normalizer.Form.NFD);
                    n = ((String)object).compareToIgnoreCase(string6);
                    if (n != 0) break block8;
                    n = ((String)object).compareTo(string6);
                }
            }
            if (n != 0) continue;
            if (matcher.hitEnd() && !matcher2.hitEnd()) {
                n = -1;
                continue;
            }
            if (matcher.hitEnd() || !matcher2.hitEnd()) continue;
            n = 1;
        }
        return n;
    }

    @NonNull
    @Generated
    public String getStripEndingString() {
        return this.stripEndingString;
    }

    @Generated
    public NaturalComparator setStripEndingString(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("stripEndingString is marked non-null but is null");
        }
        this.stripEndingString = string;
        return this;
    }
}

