/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.util.DaemonThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NumberedDaemonThreadFactory
implements ThreadFactory {
    private final String name;
    private final ThreadGroup group;
    private final AtomicInteger counter;
    private final int priorityDelta;

    public NumberedDaemonThreadFactory(String string) {
        this(string, 0);
    }

    public NumberedDaemonThreadFactory(String string, int n) {
        this.name = string;
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.counter = new AtomicInteger();
        this.priorityDelta = n;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        DaemonThread daemonThread = new DaemonThread(this.group, runnable, this.name + "-" + this.counter.incrementAndGet());
        int n = 5 + this.priorityDelta;
        if (daemonThread.getPriority() != n) {
            daemonThread.setPriority(5);
        }
        return daemonThread;
    }
}

