/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Observable;
import de.qfs.lib.util.Observer;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import lombok.Generated;

public class Observed
implements Observable {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.Observed");
    private Observable owner;
    boolean changed;
    private Map<Observer, Object> observers;

    protected Observed() {
        if (Observed.logger.level >= 7) {
            logger.lvlBuild(7, "Observed()", 79).log();
        }
    }

    public Observed(Observable observable) {
        if (Observed.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "Observed(Observable)", 93).addDetail("owner", observable)).log();
        }
        this.owner = observable;
    }

    @Override
    public synchronized void addObserver(Observer observer) {
        if (Observed.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addObserver(Observer)", 112).addDetail("observer", observer)).log();
        }
        if (this.observers == null) {
            this.observers = this.createNewMap();
        }
        this.observers.put(observer, null);
    }

    protected Map<Observer, Object> createNewMap() {
        return new WeakHashMap<Observer, Object>();
    }

    @Override
    public synchronized void deleteObserver(Observer observer) {
        if (Observed.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "deleteObserver(Observer)", 138).addDetail("observer", observer)).log();
        }
        if (this.observers != null) {
            this.observers.remove(observer);
        }
    }

    @Override
    public synchronized void deleteObservers() {
        if (Observed.logger.level >= 7) {
            logger.lvlBuild(7, "deleteObservers()", 152).log();
        }
        this.observers = null;
    }

    @Override
    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyObservers(Object object) {
        TreeSet<Observer> treeSet;
        if (Observed.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "notifyObservers(Object)", 194).addDetail("arg", object)).log();
        }
        Observed observed = this;
        synchronized (observed) {
            if (!this.changed) {
                if (Observed.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "notifyObservers(Object)", 199).add("Not changed")).log();
                }
                return;
            }
            if (this.observers == null) {
                if (Observed.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "notifyObservers(Object)", 203).add("No Observers")).log();
                }
                return;
            }
            treeSet = this.getObservers();
            if (treeSet == null) {
                return;
            }
        }
        for (Observer observer : treeSet) {
            observer.update(this.owner == null ? this : this.owner, object);
        }
    }

    @Nullable
    public synchronized TreeSet<Observer> getObservers() {
        if (Observed.logger.level >= 7) {
            logger.lvlBuild(7, "getObservers()", 219).log();
        }
        return new TreeSet<Observer>(this.observers.keySet());
    }

    @Override
    public synchronized void setChanged() {
        if (Observed.logger.level >= 7) {
            logger.lvlBuild(7, "setChanged()", 232).log();
        }
        this.changed = true;
    }

    @Override
    public synchronized void clearChanged() {
        if (Observed.logger.level >= 7) {
            logger.lvlBuild(7, "clearChanged()", 248).log();
        }
        this.changed = false;
    }

    @Override
    public synchronized boolean hasChanged() {
        return this.changed;
    }
}

