/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.DaemonThread;
import de.qfs.lib.util.StreamEvent;
import de.qfs.lib.util.StreamListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import lombok.Generated;
import lombok.NonNull;

public class ReaderMultiplexer
extends DaemonThread {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.ReaderMultiplexer");
    private static int count;
    private boolean cont;
    private Reader reader;
    @NonNull
    protected Object source = this;
    @NonNull
    protected final Queue<StreamListener> listeners = new ConcurrentLinkedQueue<StreamListener>();

    public ReaderMultiplexer(Reader reader, Object object) {
        super("ReaderMultiplexer-" + count++);
        if (ReaderMultiplexer.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ReaderMultiplexer(Reader,Object)", 100).addDetail("reader", reader)).addDetail("source", object)).log();
        }
        this.reader = reader;
        this.setSource(object);
    }

    public final void setSource(Object object) {
        if (ReaderMultiplexer.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setSource(Object)", 119).addDetail("source", object)).log();
        }
        this.source = object == null ? this : object;
    }

    public final boolean isClosed() {
        return !this.cont;
    }

    @Override
    public void run() {
        block13: {
            if (ReaderMultiplexer.logger.level >= 7) {
                logger.lvlBuild(7, "run()", 150).log();
            }
            this.cont = true;
            char[] cArray = new char[8192];
            while (this.cont) {
                try {
                    int n = 0;
                    if (!this.cont) continue;
                    n = this.reader.read(cArray);
                    if (n == -1) {
                        if (ReaderMultiplexer.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "run()", 161).add("EOF")).log();
                        }
                        this.cont = false;
                        continue;
                    }
                    if (n <= 0) continue;
                    if (ReaderMultiplexer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "run()", 164).add("cnt", n)).log();
                    }
                    if (ReaderMultiplexer.logger.level >= 10) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(10, "run()", 165).add("data: ")).add(new String(cArray, 0, n))).log();
                    }
                    char[] cArray2 = new char[n];
                    System.arraycopy(cArray, 0, cArray2, 0, n);
                    this.fireNewInput(cArray2);
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (ReaderMultiplexer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "run()", 172).add("ex", interruptedIOException)).log();
                    }
                    this.cont = false;
                }
                catch (IOException iOException) {
                    if (ReaderMultiplexer.logger.level >= 3) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "run()", 175).add("ex", iOException)).log();
                    }
                    this.cont = false;
                }
            }
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                if (ReaderMultiplexer.logger.level < 9) break block13;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "run()", 182).add("ex", iOException)).log();
            }
        }
        this.fireInputClosed();
    }

    public void halt() {
        if (ReaderMultiplexer.logger.level >= 7) {
            logger.lvlBuild(7, "halt()", 196).log();
        }
        this.cont = false;
        this.interrupt();
    }

    public synchronized void addStreamListener(StreamListener streamListener) {
        if (ReaderMultiplexer.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addStreamListener(StreamListener)", 216).addDetail("listener", streamListener)).dumpStack();
        }
        this.listeners.remove(streamListener);
        this.listeners.add(streamListener);
    }

    public synchronized void removeStreamListener(StreamListener streamListener) {
        if (ReaderMultiplexer.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeStreamListener(StreamListener)", 232).addDetail("listener", streamListener)).log();
        }
        this.listeners.remove(streamListener);
    }

    protected void fireNewInput(char[] cArray) {
        StreamEvent streamEvent = new StreamEvent(this.source, cArray);
        for (StreamListener streamListener : this.listeners) {
            streamListener.newInput(streamEvent);
        }
    }

    protected void fireInputClosed() {
        if (ReaderMultiplexer.logger.level >= 7) {
            logger.lvlBuild(7, "fireInputClosed()", 265).log();
        }
        StreamEvent streamEvent = new StreamEvent(this.source);
        for (StreamListener streamListener : this.listeners) {
            streamListener.inputClosed(streamEvent);
        }
    }

    @NonNull
    @Generated
    public Object getSource() {
        return this.source;
    }
}

