/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.Log;
import de.qfs.lib.log.Logger;
import de.qfs.lib.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class ResourceTracker {
    private static final Logger logger = new Logger("de.qfs.lib.util.ResourceTracker");
    private static WeakHashMap map = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Object object) {
        Object object2;
        if (ResourceTracker.logger.level >= 7) {
            object2 = logger.build("register(Object)");
            ((Logger.Builder)(ResourceTracker.logger.level < 8 ? object2 : ((Logger.Builder)object2).add("resource: ").add(object))).log(7);
        }
        if (object == null) {
            if (ResourceTracker.logger.level >= 1) {
                logger.log(1, "register(Object)", "Bad resource: null");
            }
            return;
        }
        object2 = null;
        try {
            throw new Exception("Resource registered: " + object);
        }
        catch (Throwable throwable) {
            object2 = Log.getStackTrace(throwable);
            WeakHashMap weakHashMap = map;
            synchronized (weakHashMap) {
                map.put(object, new Pair<Long, Object>(System.currentTimeMillis(), object2));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregister(Object object) {
        Object object2;
        if (ResourceTracker.logger.level >= 7) {
            object2 = logger.build("unregister(Object)");
            ((Logger.Builder)(ResourceTracker.logger.level < 8 ? object2 : ((Logger.Builder)object2).add("resource: ").add(object))).log(7);
        }
        object2 = map;
        synchronized (object2) {
            return map.remove(object) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getResources(Class clazz, boolean bl) {
        if (ResourceTracker.logger.level >= 7) {
            logger.log(7, "getResources()", "");
        }
        ArrayList arrayList = new ArrayList();
        WeakHashMap weakHashMap = map;
        synchronized (weakHashMap) {
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                if (clazz != null && !clazz.isAssignableFrom(entry.getKey().getClass())) continue;
                arrayList.add(new Pair(entry.getKey(), entry.getValue()));
            }
        }
        if (bl) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((Long)((Pair)((Pair)object).getSecond()).getFirst()).compareTo((Long)((Pair)((Pair)object2).getSecond()).getFirst());
                }
            });
        }
        return arrayList;
    }
}

