/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.Logger;

public class RingBuffer {
    private static final Logger logger = new Logger("de.qfs.lib.util.RingBuffer");
    private Object[] buf;
    private int size;
    private int head;
    private int tail;

    public RingBuffer(int n) {
        if (RingBuffer.logger.level >= 7) {
            logger.log(7, "RingBuffer(int)", RingBuffer.logger.level < 8 ? "" : "size: " + n);
        }
        this.size = n + 1;
        this.buf = new Object[this.size];
    }

    public synchronized void push(Object object) {
        if (RingBuffer.logger.level >= 7) {
            logger.log(7, "push(Object)", RingBuffer.logger.level < 8 ? "" : "object: " + object);
        }
        this.buf[this.head++] = object;
        if (this.head == this.size) {
            this.head = 0;
        }
        if (this.head == this.tail) {
            ++this.tail;
            if (this.tail == this.size) {
                this.tail = 0;
            }
        }
    }

    public synchronized Object pop() throws IllegalStateException {
        if (RingBuffer.logger.level >= 7) {
            logger.log(7, "pop()", "");
        }
        if (this.head == this.tail) {
            throw new IllegalStateException("The RingBuffer is empty");
        }
        Object object = this.buf[this.tail++];
        if (this.tail == this.size) {
            this.tail = 0;
        }
        return object;
    }

    public synchronized Object[] popAll() {
        if (RingBuffer.logger.level >= 7) {
            logger.log(7, "popAll()", "");
        }
        if (this.head == this.tail) {
            return null;
        }
        Object[] objectArray = new Object[this.size()];
        if (this.head > this.tail) {
            System.arraycopy(this.buf, this.tail, objectArray, 0, this.head - this.tail);
        } else {
            System.arraycopy(this.buf, this.tail, objectArray, 0, this.size - this.tail);
            System.arraycopy(this.buf, 0, objectArray, this.size - this.tail, this.head);
        }
        this.head = 0;
        this.tail = 0;
        return objectArray;
    }

    public synchronized int size() {
        int n = this.head - this.tail;
        return n < 0 ? n + this.size : n;
    }

    public synchronized int getMaxSize() {
        return this.size - 1;
    }

    public synchronized void setMaxSize(int n) {
        if (RingBuffer.logger.level >= 7) {
            logger.log(7, "setMaxSize(int)", RingBuffer.logger.level < 8 ? "" : "newsize: " + n);
        }
        if (n < 1) {
            throw new IllegalArgumentException("Illegal size for RingBuffer: " + n);
        }
        if (this.size == ++n) {
            return;
        }
        Object[] objectArray = this.buf;
        this.buf = new Object[n + 1];
        if (this.head != this.tail) {
            int n2 = this.size();
            if (n2 > n - 1) {
                this.tail += n2 - (n - 1);
                if (this.tail >= this.size) {
                    this.tail -= this.size;
                }
                n2 = n - 1;
            }
            if (this.head > this.tail) {
                System.arraycopy(objectArray, this.tail, this.buf, 0, n2);
            } else {
                System.arraycopy(objectArray, this.tail, this.buf, 0, this.size - this.tail);
                System.arraycopy(objectArray, 0, this.buf, this.size - this.tail, this.head);
            }
            this.head = n2;
        } else {
            this.head = 0;
        }
        this.tail = 0;
        this.size = n;
    }
}

