/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.util.DaemonThread;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class StablePipedOutputStream
extends PipedOutputStream {
    private byte[] buf;
    private boolean cont = true;
    private boolean finished = true;
    private IOException exception;

    public StablePipedOutputStream() {
        new DaemonThread(){

            @Override
            public void run() {
                StablePipedOutputStream.this.run();
            }
        }.start();
    }

    public StablePipedOutputStream(PipedInputStream pipedInputStream) throws IOException {
        super(pipedInputStream);
        new DaemonThread(){

            @Override
            public void run() {
                StablePipedOutputStream.this.run();
            }
        }.start();
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        while (this.buf != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.buf = new byte[n2];
        System.arraycopy(byArray, n, this.buf, 0, n2);
        this.finished = false;
        this.notifyAll();
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.buf = null;
        IOException iOException = null;
        if (this.exception != null) {
            iOException = (IOException)this.exception.fillInStackTrace();
            this.exception = null;
        }
        this.notifyAll();
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public synchronized void write(int n) throws IOException {
        while (this.buf != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.buf = new byte[]{(byte)n};
        this.finished = false;
        this.notifyAll();
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.buf = null;
        IOException iOException = null;
        if (this.exception != null) {
            iOException = (IOException)this.exception.fillInStackTrace();
            this.exception = null;
        }
        this.notifyAll();
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.cont = false;
        Thread.currentThread().interrupt();
        super.close();
    }

    private synchronized void run() {
        while (this.cont) {
            while (this.finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                super.write(this.buf, 0, this.buf.length);
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
            this.finished = true;
            this.notifyAll();
        }
    }
}

