/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.StreamEvent;
import de.qfs.lib.util.StreamListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;
import lombok.Generated;

public class StreamListeningInputStream
extends InputStream
implements StreamListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.StreamListeningInputStream");
    char[] current = null;
    int currentIndex = 0;
    final Queue<char[]> buffer = new LinkedList<char[]>();
    boolean inputClosed = false;
    boolean discarded = false;
    Object inputMonitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newInput(StreamEvent streamEvent) {
        if (this.discarded) {
            return;
        }
        char[] cArray = streamEvent.getData();
        if (cArray == null) {
            return;
        }
        this.buffer.add(cArray);
        Object object = this.inputMonitor;
        synchronized (object) {
            this.inputMonitor.notifyAll();
        }
    }

    @Override
    public void inputClosed(StreamEvent streamEvent) {
        this.inputClosed = true;
        this.newInput(streamEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        char[] cArray = null;
        while ((cArray = this.getCurrent()) == null) {
            if (this.inputClosed || this.discarded) {
                return -1;
            }
            Object object = this.inputMonitor;
            synchronized (object) {
                block8: {
                    try {
                        this.inputMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (StreamListeningInputStream.logger.level < 3) break block8;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "read()", 87).add("e", interruptedException)).log();
                    }
                }
            }
        }
        char c = cArray[this.currentIndex];
        ++this.currentIndex;
        if (this.currentIndex >= cArray.length) {
            this.current = null;
        }
        return c;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (n + n2 > byArray.length || n < 0 || n2 < 0) {
            throw new IndexOutOfBoundsException("off: " + n + " length: " + n2 + " targetLength: " + byArray.length);
        }
        char[] cArray = null;
        while ((cArray = this.getCurrent()) == null) {
            if (this.inputClosed || this.discarded) {
                return -1;
            }
            Object object = this.inputMonitor;
            synchronized (object) {
                block11: {
                    try {
                        this.inputMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (StreamListeningInputStream.logger.level < 3) break block11;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "read(byte[],int,int)", 122).add("e", interruptedException)).log();
                    }
                }
            }
        }
        int n3 = Math.min(n2, cArray.length - this.currentIndex);
        for (int i = 0; i < n3; ++i) {
            byArray[i + n] = (byte)cArray[this.currentIndex];
            ++this.currentIndex;
        }
        if (this.currentIndex >= cArray.length) {
            this.current = null;
        }
        return n3;
    }

    @Override
    public int available() throws IOException {
        char[] cArray = this.getCurrent();
        if (cArray == null) {
            return 0;
        }
        return cArray.length - this.currentIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.discarded = true;
        this.currentIndex = 0;
        this.current = null;
        this.buffer.clear();
        Object object = this.inputMonitor;
        synchronized (object) {
            this.inputMonitor.notifyAll();
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private char[] getCurrent() {
        if (this.current != null) {
            return this.current;
        }
        this.current = this.buffer.poll();
        this.currentIndex = 0;
        return this.current;
    }
}

