/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.DaemonThread;
import de.qfs.lib.util.StreamEvent;
import de.qfs.lib.util.StreamListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import lombok.Generated;
import lombok.NonNull;

public class StreamMultiplexer
extends DaemonThread {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.StreamMultiplexer");
    private static int count;
    private boolean cont;
    private Reader reader;
    @NonNull
    protected Object source = this;
    @NonNull
    protected final Queue<StreamListener> listeners = new ConcurrentLinkedQueue<StreamListener>();

    public StreamMultiplexer(InputStream inputStream, Charset charset, Object object) {
        this(new InputStreamReader(inputStream, charset), object);
    }

    public StreamMultiplexer(Reader reader, Object object) {
        super("StreamMultiplexer-" + count++);
        if (StreamMultiplexer.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "StreamMultiplexer(Reader,Object)", 121).addDetail("reader", reader)).addDetail("source", object)).log();
        }
        this.reader = reader;
        this.setSource(object);
    }

    public final void setSource(Object object) {
        if (StreamMultiplexer.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setSource(Object)", 140).addDetail("source", object)).log();
        }
        this.source = object == null ? this : object;
    }

    public final boolean isClosed() {
        return !this.cont;
    }

    @Override
    public void run() {
        block13: {
            if (StreamMultiplexer.logger.level >= 7) {
                logger.lvlBuild(7, "run()", 173).log();
            }
            this.cont = true;
            char[] cArray = new char[1000];
            while (this.cont) {
                try {
                    int n = 0;
                    if (!this.cont) continue;
                    n = this.reader.read(cArray);
                    if (n == -1) {
                        if (StreamMultiplexer.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "run()", 184).add("EOF")).log();
                        }
                        this.cont = false;
                        continue;
                    }
                    if (n <= 0) continue;
                    if (StreamMultiplexer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "run()", 187).add("cnt", n)).log();
                    }
                    if (StreamMultiplexer.logger.level >= 10) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(10, "run()", 188).add("data: ")).add(new String(cArray, 0, n))).log();
                    }
                    char[] cArray2 = new char[n];
                    System.arraycopy(cArray, 0, cArray2, 0, n);
                    this.fireNewInput(cArray2);
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (StreamMultiplexer.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "run()", 195).add("ex", interruptedIOException)).log();
                    }
                    this.cont = false;
                }
                catch (IOException iOException) {
                    if (StreamMultiplexer.logger.level >= 3) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "run()", 198).add("ex", iOException)).log();
                    }
                    this.cont = false;
                }
            }
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                if (StreamMultiplexer.logger.level < 9) break block13;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "run()", 205).add("ex", iOException)).log();
            }
        }
        this.fireInputClosed();
    }

    public void halt() {
        if (StreamMultiplexer.logger.level >= 7) {
            logger.lvlBuild(7, "halt()", 219).log();
        }
        this.cont = false;
        this.interrupt();
    }

    public synchronized void addStreamListener(StreamListener streamListener) {
        if (StreamMultiplexer.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addStreamListener(StreamListener)", 239).addDetail("listener", streamListener)).dumpStack();
        }
        this.listeners.remove(streamListener);
        this.listeners.add(streamListener);
    }

    public synchronized void removeStreamListener(StreamListener streamListener) {
        if (StreamMultiplexer.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeStreamListener(StreamListener)", 255).addDetail("listener", streamListener)).log();
        }
        this.listeners.remove(streamListener);
    }

    protected void fireNewInput(char[] cArray) {
        StreamEvent streamEvent = new StreamEvent(this.source, cArray);
        for (StreamListener streamListener : this.listeners) {
            streamListener.newInput(streamEvent);
        }
    }

    protected void fireInputClosed() {
        if (StreamMultiplexer.logger.level >= 7) {
            logger.lvlBuild(7, "fireInputClosed()", 288).log();
        }
        StreamEvent streamEvent = new StreamEvent(this.source);
        for (StreamListener streamListener : this.listeners) {
            streamListener.inputClosed(streamEvent);
        }
    }

    @NonNull
    @Generated
    public Object getSource() {
        return this.source;
    }
}

