/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.Logger;
import de.qfs.lib.tree.IndexBasedTreeAdapter;

public class ThreadGroupTreeAdapter
extends IndexBasedTreeAdapter {
    private static final Logger logger = new Logger("de.qfs.lib.util.ThreadGroupTreeAdapter");
    private boolean includeThreads;

    public ThreadGroupTreeAdapter() {
        this(true);
    }

    public ThreadGroupTreeAdapter(boolean bl) {
        if (ThreadGroupTreeAdapter.logger.level >= 7) {
            logger.log(7, "ThreadGroupTreeAdapter(boolean)", ThreadGroupTreeAdapter.logger.level < 8 ? "" : "includeThreads: " + bl);
        }
        this.includeThreads = bl;
    }

    @Override
    public Object getParentNode(Object object) {
        if (ThreadGroupTreeAdapter.logger.level >= 7) {
            logger.log(7, "getParentNode(Object)", ThreadGroupTreeAdapter.logger.level < 8 ? "" : "child: " + object);
        }
        if (object instanceof ThreadGroup) {
            return ((ThreadGroup)object).getParent();
        }
        return ((Thread)object).getThreadGroup();
    }

    @Override
    public boolean isLeaf(Object object) {
        if (ThreadGroupTreeAdapter.logger.level >= 7) {
            logger.log(7, "isLeaf(Object)", ThreadGroupTreeAdapter.logger.level < 8 ? "" : "node: " + object);
        }
        return object instanceof Thread;
    }

    @Override
    public Object[] getChildren(Object object) {
        if (!(object instanceof ThreadGroup)) {
            if (ThreadGroupTreeAdapter.logger.level >= 9) {
                logger.log(9, "getChildren(Object)", "Not a ThreadGroup: " + object);
            }
            return new Object[0];
        }
        ThreadGroup threadGroup = (ThreadGroup)object;
        ThreadGroup[] threadGroupArray = new ThreadGroup[threadGroup.activeGroupCount() + 20];
        int n = threadGroup.enumerate(threadGroupArray);
        Thread[] threadArray = null;
        int n2 = 0;
        if (this.includeThreads) {
            threadArray = new Thread[threadGroup.activeCount() + 20];
            n2 = threadGroup.enumerate(threadArray);
        }
        if (ThreadGroupTreeAdapter.logger.level >= 7) {
            logger.log(7, "getChildren(Object)", ThreadGroupTreeAdapter.logger.level < 8 ? "" : "parent: " + object + ", groups: " + n + ", threads: " + n2);
        }
        Object[] objectArray = new Object[n + n2];
        if (n > 0) {
            System.arraycopy(threadGroupArray, 0, objectArray, 0, n);
        }
        if (n2 > 0) {
            System.arraycopy(threadArray, 0, objectArray, n, n2);
        }
        return objectArray;
    }

    @Override
    public int getChildCount(Object object) {
        if (!(object instanceof ThreadGroup)) {
            if (ThreadGroupTreeAdapter.logger.level >= 9) {
                logger.log(9, "getChildCount(Object)", "Not a ThreadGroup: " + object);
            }
            return 0;
        }
        ThreadGroup threadGroup = (ThreadGroup)object;
        ThreadGroup[] threadGroupArray = new ThreadGroup[threadGroup.activeGroupCount() + 20];
        int n = threadGroup.enumerate(threadGroupArray);
        if (!this.includeThreads) {
            if (ThreadGroupTreeAdapter.logger.level >= 7) {
                logger.log(7, "getChildCount(Object)", ThreadGroupTreeAdapter.logger.level < 8 ? "" : "parent: " + object + ", groups: " + n);
            }
            return n;
        }
        Thread[] threadArray = new Thread[threadGroup.activeCount() + 20];
        int n2 = threadGroup.enumerate(threadArray);
        if (ThreadGroupTreeAdapter.logger.level >= 7) {
            logger.log(7, "getChildCount(Object)", ThreadGroupTreeAdapter.logger.level < 8 ? "" : "parent: " + object + ", groups: " + n + ", threads: " + n2);
        }
        return n + n2;
    }

    @Override
    public Object getChildNode(Object object, int n) throws IndexOutOfBoundsException {
        if (!(object instanceof ThreadGroup)) {
            if (ThreadGroupTreeAdapter.logger.level >= 3) {
                logger.log(3, "getChildNode(Object,int)", "Not a ThreadGroup: " + object);
            }
            throw new IndexOutOfBoundsException("Not a ThreadGroup: " + object);
        }
        ThreadGroup threadGroup = (ThreadGroup)object;
        ThreadGroup[] threadGroupArray = new ThreadGroup[threadGroup.activeGroupCount() + 20];
        int n2 = threadGroup.enumerate(threadGroupArray);
        if (n >= 0 && n < n2) {
            if (ThreadGroupTreeAdapter.logger.level >= 7) {
                logger.log(7, "getChildNode(Object,int)", ThreadGroupTreeAdapter.logger.level < 8 ? "" : "parent: " + object + ", index: " + n + ", groups: " + n2 + ", ret: " + threadGroupArray[n]);
            }
            return threadGroupArray[n];
        }
        if (!this.includeThreads) {
            throw new IndexOutOfBoundsException("Bad index: " + n);
        }
        Thread[] threadArray = new Thread[threadGroup.activeCount() + 20];
        int n3 = threadGroup.enumerate(threadArray);
        if (n - n2 >= 0 && n - n2 < n3) {
            if (ThreadGroupTreeAdapter.logger.level >= 7) {
                logger.log(7, "getChildNode(Object,int)", ThreadGroupTreeAdapter.logger.level < 8 ? "" : "parent: " + object + ", index: " + n + ", groups: " + n2 + ", threads: " + n3 + ", ret: " + threadArray[n]);
            }
            return threadArray[n - n2];
        }
        if (ThreadGroupTreeAdapter.logger.level >= 7) {
            logger.log(7, "getChildNode(Object,int)", ThreadGroupTreeAdapter.logger.level < 8 ? "" : "parent: " + object + ", index: " + n + ", groups: " + n2 + ", threads: " + n3);
        }
        throw new IndexOutOfBoundsException("Bad index: " + n);
    }

    @Override
    public int getIndexOfChildNode(Object object, Object object2) {
        if (!(object instanceof ThreadGroup)) {
            if (ThreadGroupTreeAdapter.logger.level >= 3) {
                logger.log(3, "getIndexOfChildNode(Object,Object)", "Not a ThreadGroup: " + object);
            }
            return -1;
        }
        ThreadGroup threadGroup = (ThreadGroup)object;
        ThreadGroup[] threadGroupArray = new ThreadGroup[threadGroup.activeGroupCount() + 20];
        int n = threadGroup.enumerate(threadGroupArray);
        if (object2 instanceof ThreadGroup) {
            for (int i = 0; i < n; ++i) {
                if (threadGroupArray[i] != object2) continue;
                if (ThreadGroupTreeAdapter.logger.level >= 7) {
                    logger.log(7, "getIndexOfChildNode(Object,Object)", ThreadGroupTreeAdapter.logger.level < 8 ? "" : "parent: " + object + ", child: " + object2 + ", groups: " + n + ", ret: " + i);
                }
                return i;
            }
        }
        if (this.includeThreads) {
            Thread[] threadArray = new Thread[threadGroup.activeCount() + 20];
            int n2 = threadGroup.enumerate(threadArray);
            for (int i = 0; i < n2; ++i) {
                if (threadArray[i] != object2) continue;
                if (ThreadGroupTreeAdapter.logger.level >= 7) {
                    logger.log(7, "getIndexOfChildNode(Object,Object)", ThreadGroupTreeAdapter.logger.level < 8 ? "" : "parent: " + object + ", child: " + object2 + ", groups: " + n + ", threads: " + n2 + ",  ret: " + i);
                }
                return n + i;
            }
            if (ThreadGroupTreeAdapter.logger.level >= 7) {
                logger.log(7, "getIndexOfChildNode(Object,Object)", ThreadGroupTreeAdapter.logger.level < 8 ? "" : "parent: " + object + ", child: " + object2 + ", groups: " + n + ", threads: " + n2);
            }
        } else if (ThreadGroupTreeAdapter.logger.level >= 7) {
            logger.log(7, "getIndexOfChildNode(Object,Object)", ThreadGroupTreeAdapter.logger.level < 8 ? "" : "parent: " + object + ", child: " + object2 + ", groups: " + n);
        }
        return -1;
    }
}

