/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonSerializable;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

public class VersionNumber
implements Comparable<VersionNumber>,
JsonSerializable {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.VersionNumber");
    @NonNull
    final Integer major;
    @Nullable
    final Integer medium;
    @Nullable
    final Integer minor;
    @Nullable
    final Integer sub;
    @Nullable
    final Integer build;
    @Nullable
    String originalVersionString;

    @NonNull
    public static VersionNumber fromString(@Nullable String string) {
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "fromString(String)", 65).addDetail("versionString", string)).log();
        }
        return VersionNumber.fromString(string, "[._-]");
    }

    @NonNull
    public static VersionNumber fromString(@Nullable String string, @NonNull String string2) {
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fromString(String,String)", 72).addDetail("versionString", string)).addDetail("splitRegExp", string2)).log();
        }
        if (string2 == null) {
            throw new IllegalArgumentException("splitRegExp is marked non-null but is null");
        }
        if (string == null) {
            return new VersionNumber(0);
        }
        String[] stringArray = string.split(string2);
        Integer[] integerArray = new Integer[5];
        integerArray[0] = 0;
        for (int i = 0; i < stringArray.length && i < integerArray.length; ++i) {
            stringArray[i] = stringArray[i].replaceAll("[^0-9]", "");
            if (stringArray[i].length() <= 0) continue;
            try {
                integerArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (VersionNumber.logger.level < 9) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "fromString(String,String)", 86).add("ex", numberFormatException)).log();
            }
        }
        VersionNumber versionNumber = new VersionNumber(integerArray[0], integerArray[1], integerArray[2], integerArray[3], integerArray[4]);
        versionNumber.setOriginalVersionString(string);
        return versionNumber;
    }

    public VersionNumber(@NonNull Integer n) {
        this(n, null);
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "VersionNumber(Integer)", 98).addDetail("major", n)).log();
        }
        if (n == null) {
            throw new IllegalArgumentException("major is marked non-null but is null");
        }
    }

    public VersionNumber(@NonNull Integer n, @Nullable Integer n2) {
        this(n, n2, null);
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "VersionNumber(Integer,Integer)", 103).addDetail("major", n)).addDetail("medium", n2)).log();
        }
        if (n == null) {
            throw new IllegalArgumentException("major is marked non-null but is null");
        }
    }

    public VersionNumber(@NonNull Integer n, @Nullable Integer n2, @Nullable Integer n3) {
        this(n, n2, n3, null);
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "VersionNumber(Integer,Integer,Integer)", 108).addDetail("major", n)).addDetail("medium", n2)).addDetail("minor", n3)).log();
        }
        if (n == null) {
            throw new IllegalArgumentException("major is marked non-null but is null");
        }
    }

    public VersionNumber(@NonNull Integer n, @Nullable Integer n2, @Nullable Integer n3, @Nullable Integer n4) {
        this(n, n2, n3, n4, null);
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "VersionNumber(Integer,Integer,Integer,Integer)", 113).addDetail("major", n)).addDetail("medium", n2)).addDetail("minor", n3)).addDetail("sub", n4)).log();
        }
        if (n == null) {
            throw new IllegalArgumentException("major is marked non-null but is null");
        }
    }

    public String toString() {
        if (VersionNumber.logger.level >= 7) {
            logger.lvlBuild(7, "toString()", 122).log();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.major);
        if (this.medium == null) {
            return stringBuilder.toString();
        }
        stringBuilder.append(".").append(this.medium);
        if (this.minor == null) {
            return stringBuilder.toString();
        }
        stringBuilder.append(".").append(this.minor);
        if (this.sub == null) {
            return stringBuilder.toString();
        }
        stringBuilder.append(".").append(this.sub);
        if (this.build == null) {
            return stringBuilder.toString();
        }
        stringBuilder.append("_").append(this.build);
        return stringBuilder.toString();
    }

    @Override
    public JsonValue asJsonValue() {
        if (VersionNumber.logger.level >= 7) {
            logger.lvlBuild(7, "asJsonValue()", 144).log();
        }
        JsonObject jsonObject = new JsonObject();
        if (!Misc.emptyOrNull(this.originalVersionString)) {
            jsonObject.add("original", this.originalVersionString);
        }
        jsonObject.add("full", this.toString());
        jsonObject.add("major", this.major);
        if (this.medium == null) {
            return jsonObject;
        }
        jsonObject.add("medium", this.medium);
        if (this.minor == null) {
            return jsonObject;
        }
        jsonObject.add("minor", this.minor);
        if (this.sub == null) {
            return jsonObject;
        }
        jsonObject.add("sub", this.sub);
        if (this.build == null) {
            return jsonObject;
        }
        jsonObject.add("build", this.build);
        return jsonObject;
    }

    @Override
    public int compareTo(@Nullable VersionNumber versionNumber) {
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "compareTo(VersionNumber)", 172).addDetail("other", versionNumber)).log();
        }
        return this.compareTo(versionNumber, 5);
    }

    public int compareTo(@Nullable VersionNumber versionNumber, int n) {
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "compareTo(VersionNumber,int)", 183).addDetail("other", versionNumber)).addDetail("significantDigits", n)).log();
        }
        if (n <= 0) {
            return 0;
        }
        if (versionNumber == null) {
            return 1;
        }
        int n2 = this.compareTwo(this.major, versionNumber.major);
        if (n2 != 0 || n == 1) {
            return n2;
        }
        n2 = this.compareTwo(this.medium, versionNumber.medium);
        if (n2 != 0 || n == 2) {
            return n2;
        }
        n2 = this.compareTwo(this.minor, versionNumber.minor);
        if (n2 != 0 || n == 3) {
            return n2;
        }
        n2 = this.compareTwo(this.sub, versionNumber.sub);
        if (n2 != 0 || n == 4) {
            return n2;
        }
        n2 = this.compareTwo(this.build, versionNumber.build);
        return n2;
    }

    private int compareTwo(@Nullable Integer n, @Nullable Integer n2) {
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "compareTwo(Integer,Integer)", 208).addDetail("first", n)).addDetail("second", n2)).log();
        }
        if (n == null) {
            if (n2 == null) {
                return 0;
            }
            return -1;
        }
        if (n2 == null) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    public boolean isLowerThan(@Nullable VersionNumber versionNumber) {
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "isLowerThan(VersionNumber)", 224).addDetail("other", versionNumber)).log();
        }
        return this.isLowerThan(versionNumber, 5);
    }

    public boolean isLowerThan(@Nullable VersionNumber versionNumber, int n) {
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "isLowerThan(VersionNumber,int)", 234).addDetail("other", versionNumber)).addDetail("significantDigits", n)).log();
        }
        return this.compareTo(versionNumber, n) == -1;
    }

    public boolean isHigherThan(@Nullable VersionNumber versionNumber) {
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "isHigherThan(VersionNumber)", 241).addDetail("other", versionNumber)).log();
        }
        return this.isHigherThan(versionNumber, 5);
    }

    public boolean isHigherThan(@Nullable VersionNumber versionNumber, int n) {
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "isHigherThan(VersionNumber,int)", 251).addDetail("other", versionNumber)).addDetail("significantDigits", n)).log();
        }
        return this.compareTo(versionNumber, n) == 1;
    }

    public int getSignificantDigits() {
        if (VersionNumber.logger.level >= 7) {
            logger.lvlBuild(7, "getSignificantDigits()", 261).log();
        }
        if (this.medium == null) {
            return 1;
        }
        if (this.minor == null) {
            return 2;
        }
        if (this.sub == null) {
            return 3;
        }
        if (this.build == null) {
            return 4;
        }
        return 5;
    }

    @NonNull
    @Generated
    public Integer getMajor() {
        if (VersionNumber.logger.level >= 7) {
            logger.lvlBuild(7, "getMajor()", 54).log();
        }
        return this.major;
    }

    @Nullable
    @Generated
    public Integer getMedium() {
        if (VersionNumber.logger.level >= 7) {
            logger.lvlBuild(7, "getMedium()", 55).log();
        }
        return this.medium;
    }

    @Nullable
    @Generated
    public Integer getMinor() {
        if (VersionNumber.logger.level >= 7) {
            logger.lvlBuild(7, "getMinor()", 56).log();
        }
        return this.minor;
    }

    @Nullable
    @Generated
    public Integer getSub() {
        if (VersionNumber.logger.level >= 7) {
            logger.lvlBuild(7, "getSub()", 57).log();
        }
        return this.sub;
    }

    @Nullable
    @Generated
    public Integer getBuild() {
        if (VersionNumber.logger.level >= 7) {
            logger.lvlBuild(7, "getBuild()", 58).log();
        }
        return this.build;
    }

    @Nullable
    @Generated
    public String getOriginalVersionString() {
        if (VersionNumber.logger.level >= 7) {
            logger.lvlBuild(7, "getOriginalVersionString()", 59).log();
        }
        return this.originalVersionString;
    }

    @Generated
    public VersionNumber setOriginalVersionString(@Nullable String string) {
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setOriginalVersionString(String)", 47).addDetail("originalVersionString", string)).log();
        }
        this.originalVersionString = string;
        return this;
    }

    @Generated
    public boolean equals(Object object) {
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "equals(Object)", 47).addDetail("o", object)).log();
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof VersionNumber)) {
            return false;
        }
        VersionNumber versionNumber = (VersionNumber)object;
        if (!versionNumber.canEqual(this)) {
            return false;
        }
        Integer n = this.getMajor();
        Integer n2 = versionNumber.getMajor();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            return false;
        }
        Integer n3 = this.getMedium();
        Integer n4 = versionNumber.getMedium();
        if (n3 == null ? n4 != null : !((Object)n3).equals(n4)) {
            return false;
        }
        Integer n5 = this.getMinor();
        Integer n6 = versionNumber.getMinor();
        if (n5 == null ? n6 != null : !((Object)n5).equals(n6)) {
            return false;
        }
        Integer n7 = this.getSub();
        Integer n8 = versionNumber.getSub();
        if (n7 == null ? n8 != null : !((Object)n7).equals(n8)) {
            return false;
        }
        Integer n9 = this.getBuild();
        Integer n10 = versionNumber.getBuild();
        if (n9 == null ? n10 != null : !((Object)n9).equals(n10)) {
            return false;
        }
        String string = this.getOriginalVersionString();
        String string2 = versionNumber.getOriginalVersionString();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    @Generated
    protected boolean canEqual(Object object) {
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "canEqual(Object)", 47).addDetail("other", object)).log();
        }
        return object instanceof VersionNumber;
    }

    @Generated
    public int hashCode() {
        if (VersionNumber.logger.level >= 7) {
            logger.lvlBuild(7, "hashCode()", 47).log();
        }
        int n = 1;
        Integer n2 = this.getMajor();
        n = n * 59 + (n2 == null ? 43 : ((Object)n2).hashCode());
        Integer n3 = this.getMedium();
        n = n * 59 + (n3 == null ? 43 : ((Object)n3).hashCode());
        Integer n4 = this.getMinor();
        n = n * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        Integer n5 = this.getSub();
        n = n * 59 + (n5 == null ? 43 : ((Object)n5).hashCode());
        Integer n6 = this.getBuild();
        n = n * 59 + (n6 == null ? 43 : ((Object)n6).hashCode());
        String string = this.getOriginalVersionString();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        return n;
    }

    @Generated
    public VersionNumber(@NonNull Integer n, @Nullable Integer n2, @Nullable Integer n3, @Nullable Integer n4, @Nullable Integer n5) {
        if (VersionNumber.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "VersionNumber(Integer,Integer,Integer,Integer,Integer)", 48).addDetail("major", n)).addDetail("medium", n2)).addDetail("minor", n3)).addDetail("sub", n4)).addDetail("build", n5)).log();
        }
        if (n == null) {
            throw new IllegalArgumentException("major is marked non-null but is null");
        }
        this.major = n;
        this.medium = n2;
        this.minor = n3;
        this.sub = n4;
        this.build = n5;
    }
}

