/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import lombok.Generated;

public class WeakReferenceWithCleanup<T>
extends WeakReference<T> {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.WeakReferenceWithCleanup");
    private static ReferenceQueue<? extends Object> referenceQueue;
    @Nullable
    final Runnable cleanupTask;

    public WeakReferenceWithCleanup(T t, @Nullable Runnable runnable) {
        super(t, WeakReferenceWithCleanup.getReferenceQueue());
        if (WeakReferenceWithCleanup.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "WeakReferenceWithCleanup(T,Runnable)", 50).addDetail("referent", t)).addDetail("cleanupTask", runnable)).log();
        }
        this.cleanupTask = runnable;
    }

    private static synchronized ReferenceQueue<? extends Object> getReferenceQueue() {
        if (WeakReferenceWithCleanup.logger.level >= 7) {
            logger.lvlBuild(7, "getReferenceQueue()", 57).log();
        }
        if (referenceQueue == null) {
            referenceQueue = new ReferenceQueue();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    if (logger.level >= 7) {
                        logger.lvlBuild(7, "getReferenceQueue().Thread.run()", 64).log();
                    }
                    block4: while (true) {
                        try {
                            while (true) {
                                WeakReferenceWithCleanup weakReferenceWithCleanup = (WeakReferenceWithCleanup)referenceQueue.remove();
                                Runnable runnable = weakReferenceWithCleanup.cleanupTask;
                                if (runnable == null) continue;
                                try {
                                    runnable.run();
                                    continue block4;
                                }
                                catch (Throwable throwable) {
                                    if (logger.level < 1) continue;
                                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "getReferenceQueue().Thread.run()", 75).add("ex", throwable)).log();
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            if (logger.level < 5) continue;
                            ((LevelAwareLogBuilder)logger.lvlBuild(5, "getReferenceQueue().Thread.run()", 79).add("e", interruptedException)).log();
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.setName("WeakReference Cleanup Thread");
            thread.setDaemon(true);
            thread.start();
        }
        return referenceQueue;
    }
}

