/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.xml;

import de.qfs.lib.log.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeWalker {
    private static Logger logger = new Logger("de.qfs.lib.xml.NodeWalker");
    private Callback callback;

    public NodeWalker(Callback callback) throws IllegalArgumentException {
        if (NodeWalker.logger.level >= 7) {
            logger.log(7, "NodeWalker(Callback)", NodeWalker.logger.level < 8 ? "" : "callback: " + callback);
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback may not be null");
        }
        this.callback = callback;
    }

    public void walk(Node node) {
        if (this.callback.nodeEntered(node)) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.walk(nodeList.item(i));
            }
        }
        this.callback.nodeExited(node);
    }

    public static interface Callback {
        public boolean nodeEntered(Node var1);

        public void nodeExited(Node var1);
    }
}

