/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.xml;

import de.qfs.lib.log.Logger;
import de.qfs.lib.xml.NodeWalker;
import java.io.PrintWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class NodeWriter
implements NodeWalker.Callback {
    private static final Logger logger = new Logger("de.qfs.lib.xml.NodeWriter");
    protected String encoding;
    protected PrintWriter writer;

    public NodeWriter(PrintWriter printWriter) {
        if (NodeWriter.logger.level >= 7) {
            logger.log(7, "NodeWriter()", "");
        }
        this.writer = printWriter;
        this.encoding = "ISO-8859-1";
        this.reset();
    }

    public static String normalize(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\r': {
                    if (i >= n - 1 || string.charAt(i + 1) == '\n') continue block7;
                    if (bl) {
                        stringBuffer.append("&#");
                        stringBuffer.append(10);
                        stringBuffer.append(';');
                        continue block7;
                    }
                    stringBuffer.append('\n');
                    continue block7;
                }
                case '\t': 
                case '\n': 
                case '\"': {
                    if (bl) {
                        stringBuffer.append("&#");
                        stringBuffer.append((int)c);
                        stringBuffer.append(';');
                        continue block7;
                    }
                    stringBuffer.append(c);
                    continue block7;
                }
                default: {
                    if (c >= ' ' && c < '\u007f' || c >= '\u00a0' && c <= '\u00ff') {
                        stringBuffer.append(c);
                        continue block7;
                    }
                    if (' ' <= c && c <= '\ud7ff' || '\ue000' <= c && c <= '\ufffd') {
                        stringBuffer.append("&#");
                        stringBuffer.append((int)c);
                        stringBuffer.append(";");
                        continue block7;
                    }
                    if (i + 1 < n && c >= '\ud800' && c <= '\udbff') {
                        char c2 = string.charAt(i + 1);
                        if (c2 >= '\udc00' && c2 <= '\udfff') {
                            int n2 = (c - 55296) * 1024 + (c2 - 56320) + 65536;
                            stringBuffer.append("&#");
                            stringBuffer.append(n2);
                            stringBuffer.append(";");
                            ++i;
                            continue block7;
                        }
                        NodeWriter.addIllegalXMLCharToStringBuffer(stringBuffer, c);
                        continue block7;
                    }
                    NodeWriter.addIllegalXMLCharToStringBuffer(stringBuffer, c);
                }
            }
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    public static void addIllegalXMLCharToStringBuffer(StringBuffer stringBuffer, char c) {
        stringBuffer.append("\\");
        StringBuffer stringBuffer2 = new StringBuffer();
        while (c > '\u0000') {
            stringBuffer2.append((char)(c % 8 + 48));
            c = (char)(c / 8);
        }
        for (int i = 2; i >= 0; --i) {
            stringBuffer.append(i >= stringBuffer2.length() ? (char)'0' : stringBuffer2.charAt(i));
        }
    }

    public void reset() {
        if (NodeWriter.logger.level >= 7) {
            logger.log(7, "reset()", "");
        }
    }

    @Override
    public boolean nodeEntered(Node node) {
        switch (node.getNodeType()) {
            case 6: {
                return true;
            }
            case 4: {
                return this.CDATASectionEntered((CDATASection)node);
            }
            case 8: {
                return this.commentEntered((Comment)node);
            }
            case 9: {
                return this.documentEntered((Document)node);
            }
            case 1: {
                return this.elementEntered((Element)node);
            }
            case 5: {
                return this.entityReferenceEntered((EntityReference)node);
            }
            case 7: {
                return this.processingInstructionEntered((ProcessingInstruction)node);
            }
            case 3: {
                return this.textEntered((Text)node);
            }
        }
        return true;
    }

    @Override
    public void nodeExited(Node node) {
        switch (node.getNodeType()) {
            case 4: {
                this.CDATASectionExited((CDATASection)node);
                break;
            }
            case 8: {
                this.commentExited((Comment)node);
                break;
            }
            case 9: {
                this.documentExited((Document)node);
                break;
            }
            case 1: {
                this.elementExited((Element)node);
                break;
            }
            case 5: {
                this.entityReferenceExited((EntityReference)node);
                break;
            }
            case 7: {
                this.processingInstructionExited((ProcessingInstruction)node);
                break;
            }
            case 3: {
                this.textExited((Text)node);
            }
        }
    }

    protected boolean CDATASectionEntered(CDATASection cDATASection) {
        if (NodeWriter.logger.level >= 7) {
            logger.log(7, "CDATASectionEntered(CDATASection)", NodeWriter.logger.level < 8 ? "" : "node: " + cDATASection);
        }
        this.writer.print("<![CDATA[");
        this.writer.print(cDATASection.getNodeValue());
        this.writer.print("]]>");
        this.writer.flush();
        return true;
    }

    protected boolean commentEntered(Comment comment) {
        if (NodeWriter.logger.level >= 7) {
            logger.log(7, "commentEntered(Comment)", NodeWriter.logger.level < 8 ? "" : "node: " + comment);
        }
        this.writer.print("<!--");
        this.writer.print(comment.getNodeValue());
        this.writer.print("-->");
        this.writer.flush();
        return true;
    }

    protected boolean documentEntered(Document document) {
        if (NodeWriter.logger.level >= 7) {
            logger.log(7, "documentEntered(Document)", NodeWriter.logger.level < 8 ? "" : "node: " + document);
        }
        this.writer.println("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
        this.writer.flush();
        return true;
    }

    protected boolean elementEntered(Element element) {
        if (NodeWriter.logger.level >= 7) {
            logger.log(7, "elementEntered(Element)", NodeWriter.logger.level < 8 ? "" : "node: " + element);
        }
        this.writer.print('<');
        this.writer.print(element.getNodeName());
        this.printAttributes(element);
        this.writer.print('>');
        this.writer.flush();
        return true;
    }

    protected boolean entityReferenceEntered(EntityReference entityReference) {
        if (NodeWriter.logger.level >= 7) {
            logger.log(7, "entityReferenceEntered(EntityReference)", NodeWriter.logger.level < 8 ? "" : "node: " + entityReference);
        }
        this.writer.print('&');
        this.writer.print(entityReference.getNodeName());
        this.writer.print(';');
        this.writer.flush();
        return false;
    }

    protected boolean processingInstructionEntered(ProcessingInstruction processingInstruction) {
        if (NodeWriter.logger.level >= 7) {
            logger.log(7, "processingInstructionEntered(ProcessingInstruction)", "node: " + processingInstruction);
        }
        this.writer.print("<?");
        this.writer.print(processingInstruction.getNodeName());
        String string = processingInstruction.getNodeValue();
        if (string != null && string.length() > 0) {
            this.writer.print(' ');
            this.writer.print(string);
        }
        this.writer.print("?>");
        this.writer.flush();
        return true;
    }

    protected boolean textEntered(Text text) {
        if (NodeWriter.logger.level >= 7) {
            logger.log(7, "textEntered(Text)", NodeWriter.logger.level < 8 ? "" : "node: " + text);
        }
        this.writer.print(NodeWriter.normalize(text.getNodeValue(), false));
        this.writer.flush();
        return true;
    }

    protected void CDATASectionExited(CDATASection cDATASection) {
    }

    protected void commentExited(Comment comment) {
    }

    protected void documentExited(Document document) {
    }

    protected void elementExited(Element element) {
        if (NodeWriter.logger.level >= 7) {
            logger.log(7, "elementExited(Element)", NodeWriter.logger.level < 8 ? "" : "node: " + element);
        }
        this.writer.print("</");
        this.writer.print(element.getNodeName());
        this.writer.print('>');
        this.writer.flush();
    }

    protected void entityReferenceExited(EntityReference entityReference) {
    }

    protected void processingInstructionExited(ProcessingInstruction processingInstruction) {
    }

    protected void textExited(Text text) {
    }

    protected void printAttributes(Element element) {
        if (NodeWriter.logger.level >= 7) {
            logger.log(7, "printAttributes(Element)", NodeWriter.logger.level < 8 ? "" : "node: " + element);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!attr.getSpecified()) continue;
            this.writer.print(' ');
            this.writer.print(attr.getNodeName());
            this.writer.print("=\"");
            this.writer.print(NodeWriter.normalize(attr.getNodeValue(), true));
            this.writer.print('\"');
        }
    }
}

