/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.xml;

import de.qfs.lib.log.Logger;
import de.qfs.lib.xml.NodeWriter;
import java.io.PrintWriter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Text;

public class PrettyNodeWriter
extends NodeWriter {
    private static Logger logger = new Logger("de.qfs.lib.xml.PrettyNodeWriter");
    protected boolean fillText = false;
    protected boolean fillAttributes = false;
    protected int fillColumn = 78;
    protected int baseIndent = 2;
    protected boolean autoWhitespace = true;
    protected boolean sortAttributes = false;
    protected int tabSize = 8;
    protected int depth;
    protected int indent;
    protected int currentIndentation;
    protected boolean needBlank;
    protected boolean noBreak;
    protected String pendingToken;
    protected boolean pendingBlank;
    protected String leadingWhitespace;
    protected String trailingWhitespace;

    public PrettyNodeWriter(PrintWriter printWriter) {
        super(printWriter);
        if (PrettyNodeWriter.logger.level >= 7) {
            logger.log(7, "PrettyNodeWriter(Writer)", PrettyNodeWriter.logger.level < 8 ? "" : "writer: " + printWriter);
        }
        this.setAutoWhitespace(true);
        this.setBaseIndent(2);
        this.setSortAttributes(true);
        this.setFillAttributes(true);
        this.setFillText(false);
        this.setFillColumn(78);
    }

    public void reset(int n) {
        if (PrettyNodeWriter.logger.level >= 7) {
            logger.log(7, "reset()", "");
        }
        this.flush();
        this.depth = n;
        this.indent = this.baseIndent * n;
        this.currentIndentation = 0;
    }

    public void flush() {
        if (this.pendingToken != null) {
            this.printFilled(null);
        }
        this.writer.flush();
    }

    public final boolean isFillText() {
        return this.fillText;
    }

    public final void setFillText(boolean bl) {
        this.fillText = bl;
    }

    public final boolean isFillAttributes() {
        return this.fillAttributes;
    }

    public final void setFillAttributes(boolean bl) {
        this.fillAttributes = bl;
    }

    public final int getFillColumn() {
        return this.fillColumn;
    }

    public final void setFillColumn(int n) {
        this.fillColumn = n;
    }

    public final int getBaseIndent() {
        return this.baseIndent;
    }

    public final void setBaseIndent(int n) {
        this.baseIndent = n;
    }

    public final boolean isAutoWhitespace() {
        return this.autoWhitespace;
    }

    public final void setAutoWhitespace(boolean bl) {
        this.autoWhitespace = bl;
    }

    public final boolean isSortAttributes() {
        return this.sortAttributes;
    }

    public final void setSortAttributes(boolean bl) {
        this.sortAttributes = bl;
    }

    @Override
    protected boolean commentEntered(Comment comment) {
        if (PrettyNodeWriter.logger.level >= 7) {
            logger.log(7, "commentEntered(Comment)", PrettyNodeWriter.logger.level < 8 ? "" : "node: " + comment);
        }
        if (this.autoWhitespace) {
            this.flush();
            this.newLine();
        }
        this.writer.print("<!-- ");
        this.writer.print(comment.getNodeValue());
        this.writer.print(" -->");
        if (!this.autoWhitespace && this.depth == 0) {
            this.newLine();
        }
        this.writer.flush();
        return true;
    }

    @Override
    protected boolean elementEntered(Element element) {
        if (PrettyNodeWriter.logger.level >= 7) {
            logger.log(7, "elementEntered(Element)", PrettyNodeWriter.logger.level < 8 ? "" : "node: " + element);
        }
        if (this.autoWhitespace && this.depth != 0) {
            if (element.getPreviousSibling() == null || element.getPreviousSibling().getNodeType() != 3) {
                this.flush();
                this.newLine();
            }
        } else {
            this.needBlank = false;
        }
        this.printFilled("<" + element.getNodeName());
        int n = this.indent;
        if (this.autoWhitespace) {
            this.indent += element.getNodeName().length() + 2;
        }
        this.printAttributes(element);
        this.noBreak = true;
        this.needBlank = false;
        if (element.hasChildNodes()) {
            this.printFilled(">");
            if (this.autoWhitespace) {
                this.flush();
            }
            ++this.depth;
            this.indent = this.depth * this.baseIndent;
        } else {
            this.printFilled("/>");
            if (this.autoWhitespace) {
                this.flush();
            }
            this.indent = n;
        }
        this.writer.flush();
        return true;
    }

    @Override
    protected boolean entityReferenceEntered(EntityReference entityReference) {
        if (PrettyNodeWriter.logger.level >= 7) {
            logger.log(7, "entityReferenceEntered(EntityReference)", PrettyNodeWriter.logger.level < 8 ? "" : "node: " + entityReference);
        }
        this.printFilled("&" + entityReference.getNodeName() + ";");
        this.writer.flush();
        return false;
    }

    @Override
    protected boolean textEntered(Text text) {
        if (PrettyNodeWriter.logger.level >= 7) {
            logger.log(7, "textEntered(Text)", PrettyNodeWriter.logger.level < 8 ? "" : "node: " + text);
        }
        String string = text.getNodeValue();
        if (this.autoWhitespace && this.fillText && this.isWhitespace(string)) {
            return true;
        }
        if (this.fillText) {
            string = this.stripWhitespace(string);
            if (this.autoWhitespace) {
                if (!this.fillText) {
                    this.flush();
                } else if (this.fillText && text.getPreviousSibling() == null) {
                    this.newLine();
                } else {
                    this.needBlank = this.leadingWhitespace.length() > 0;
                }
            } else {
                this.printCounting(this.leadingWhitespace);
                this.needBlank = false;
                this.noBreak = this.leadingWhitespace.length() == 0;
            }
            boolean bl = false;
            boolean bl2 = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r", !this.autoWhitespace);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("\n")) {
                    if (bl) {
                        this.flush();
                        this.newLine();
                    }
                    bl = true;
                    continue;
                }
                if (string2.equals(" ") || string2.equals("\t")) {
                    bl2 = true;
                    continue;
                }
                if (!this.fillText && (bl || bl2)) {
                    this.printCounting(" ");
                }
                bl = false;
                bl2 = false;
                this.printFilled(PrettyNodeWriter.normalize(string2, false));
            }
            if (this.autoWhitespace) {
                this.needBlank = this.trailingWhitespace.length() > 0;
            } else {
                this.printCounting(this.trailingWhitespace);
                this.noBreak = this.trailingWhitespace.length() == 0;
                this.needBlank = false;
            }
        } else {
            if (this.autoWhitespace) {
                this.flush();
            }
            this.writer.print(PrettyNodeWriter.normalize(string, false));
            this.currentIndentation = -1;
        }
        this.writer.flush();
        return true;
    }

    @Override
    protected void elementExited(Element element) {
        if (PrettyNodeWriter.logger.level >= 7) {
            logger.log(7, "elementExited(Element)", PrettyNodeWriter.logger.level < 8 ? "" : "node: " + element);
        }
        if (!element.hasChildNodes()) {
            return;
        }
        if (this.autoWhitespace && (element.getLastChild().getNodeType() != 3 || this.fillText)) {
            this.flush();
        }
        --this.depth;
        this.indent = Math.max(0, this.depth * this.baseIndent);
        if (this.autoWhitespace) {
            if (element.getLastChild().getNodeType() != 3 || this.fillText) {
                this.newLine();
            } else {
                this.needBlank = false;
            }
        }
        this.printFilled("</" + element.getNodeName() + ">");
        if (this.depth == 0) {
            this.flush();
            this.newLine();
        }
        this.writer.flush();
    }

    @Override
    protected void printAttributes(Element element) {
        int n;
        NamedNodeMap namedNodeMap;
        int n2;
        if (PrettyNodeWriter.logger.level >= 7) {
            logger.log(7, "printAttributes(Element)", PrettyNodeWriter.logger.level < 8 ? "" : "node: " + element);
        }
        if ((n2 = (namedNodeMap = element.getAttributes()).getLength()) == 0) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < n2; ++n) {
            Attr attr = (Attr)namedNodeMap.item(n);
            if (!attr.getSpecified()) continue;
            arrayList.add(attr.getNodeName() + "=\"" + PrettyNodeWriter.normalize(attr.getNodeValue(), true) + "\"");
        }
        if (arrayList.size() == 0) {
            return;
        }
        if (this.sortAttributes) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    return Collator.getInstance().compare((String)object, (String)object2);
                }
            });
        }
        if (!this.fillAttributes) {
            this.flush();
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (this.fillAttributes) {
                this.printFilled((String)arrayList.get(n));
                continue;
            }
            this.writer.print(" ");
            this.writer.print((String)arrayList.get(n));
            this.currentIndentation = -1;
        }
    }

    protected void newLine() {
        this.writer.print('\n');
        for (int i = 0; i < this.indent; ++i) {
            this.writer.print(' ');
        }
        this.currentIndentation = this.indent;
        this.needBlank = false;
    }

    protected void printFilled(String string) {
        if (this.pendingToken == null) {
            this.pendingToken = string;
            this.pendingBlank = this.needBlank && !this.noBreak;
            this.needBlank = true;
            this.noBreak = false;
            return;
        }
        if (string != null && (this.noBreak || !this.needBlank)) {
            this.pendingToken = this.pendingToken + (this.needBlank ? " " : "") + string;
            this.needBlank = true;
            this.noBreak = false;
            return;
        }
        int n = this.pendingToken.length();
        if (this.currentIndentation > this.indent && n + this.currentIndentation + (this.pendingBlank ? 1 : 0) > this.fillColumn) {
            this.newLine();
        } else if (this.pendingBlank) {
            this.writer.print(' ');
            ++this.currentIndentation;
        }
        this.writer.print(this.pendingToken);
        if (this.currentIndentation >= 0) {
            this.currentIndentation += n;
        }
        this.needBlank = true;
        this.noBreak = false;
        this.pendingToken = string;
        this.pendingBlank = true;
    }

    protected void printCounting(String string) {
        int n = string.length();
        if (n > 0) {
            this.flush();
        }
        for (int i = 0; i < n; ++i) {
            int n2 = string.charAt(i);
            if (n2 == 13) {
                if (i >= n - 1 || string.charAt(i + 1) == '\n') continue;
                n2 = 10;
            }
            this.currentIndentation = n2 == 10 ? 0 : (n2 == 9 ? this.tabSize + (this.currentIndentation - this.currentIndentation % this.tabSize) : ++this.currentIndentation);
            this.writer.print((char)n2);
        }
    }

    private boolean isWhitespace(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private String stripWhitespace(String string) {
        int n;
        int n2;
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && Character.isWhitespace(string.charAt(n2)); ++n2) {
        }
        for (n = n3 - 1; n >= n2 && Character.isWhitespace(string.charAt(n)); --n) {
        }
        this.leadingWhitespace = string.substring(0, n2);
        this.trailingWhitespace = string.substring(n + 1, n3);
        return string.substring(n2, n + 1);
    }
}

