/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.xml;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Files;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.VersionNumber;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.Normalizer;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import lombok.Generated;

public class XSLTUtilities {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.xml.XSLTUtilities");
    private static final boolean DEBUG = false;
    private List splitFiles = new ArrayList();
    private Map splitIds = new HashMap();
    private String mainFile = "TOP";
    private String lastIndex = null;
    private boolean lastSub = false;
    private String split = "";
    private Set<String> availableModules = new HashSet<String>();
    private Set<String> availableSuperModules = new HashSet<String>();
    private Properties properties = new Properties();
    boolean propsPreprocessed = false;
    private boolean logImageCopy = false;
    private final Map<String, String> createdSlugs = Misc.mapOf(new Object[0]);

    public XSLTUtilities() {
        if (XSLTUtilities.logger.level >= 7) {
            logger.lvlBuild(7, "XSLTUtilities()", 110).log();
        }
        this.logImageCopy = Misc.toBoolean(System.getenv("QFS_MANUAL_LOG_IMAGE_COPY"));
    }

    public String time(String string) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "time(String)", 130).addDetail("format", string)).log();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        String string2 = simpleDateFormat.format(new Date());
        if (XSLTUtilities.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "time(String)", 137).add("ret", string2)).log();
        }
        return string2;
    }

    public String parsetime(String string, String string2, String string3, String string4, String string5) {
        ParsePosition parsePosition;
        SimpleDateFormat simpleDateFormat;
        Date date;
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "parsetime(String,String,String,String,String)", 154).addDetail("text", string)).addDetail("inFormat", string2)).addDetail("inLanguage", string3)).addDetail("outFormat", string4)).addDetail("outLanguage", string5)).log();
        }
        if ((date = (simpleDateFormat = new SimpleDateFormat(string2, new Locale(string3))).parse(string, parsePosition = new ParsePosition(0))) != null) {
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string4, new Locale(string5));
            String string6 = simpleDateFormat2.format(date);
            if (XSLTUtilities.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "parsetime(String,String,String,String,String)", 173).add("result", string6)).log();
            }
            return string6;
        }
        return "";
    }

    public String fileSize(String string, Double d) {
        File file;
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fileSize(String,Double)", 191).addDetail("filename", string)).addDetail("base", d)).log();
        }
        if (!(file = new File(string)).exists()) {
            if (XSLTUtilities.logger.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "fileSize(String,Double)", 202).add("XSLTUtilities.fileSize - Error: No such file ")).add(string)).log();
            }
            return "0";
        }
        long l = file.length();
        long l2 = d.longValue();
        String string2 = "" + (l + l2 - 1L) / l2;
        if (XSLTUtilities.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "fileSize(String,Double)", 212).add("ret", string2)).log();
        }
        return string2;
    }

    public String addSplitFile(String string) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addSplitFile(String)", 220).addDetail("type", string)).log();
        }
        return string;
    }

    public String pushSplitFile(String string) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "pushSplitFile(String)", 231).addDetail("type", string)).log();
        }
        this.splitFiles.add(string + ".html");
        String string2 = (String)this.splitFiles.get(this.splitFiles.size() - 1);
        if (XSLTUtilities.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "pushSplitFile(String)", 238).add("ret", string2)).log();
        }
        return string2;
    }

    public String popSplitFile() {
        if (XSLTUtilities.logger.level >= 7) {
            logger.lvlBuild(7, "popSplitFile()", 245).log();
        }
        String string = (String)this.splitFiles.remove(this.splitFiles.size() - 1);
        if (XSLTUtilities.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "popSplitFile()", 251).add("ret", string)).log();
        }
        return string;
    }

    public String addId(String string) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addId(String)", 258).addDetail("id", string)).log();
        }
        if (string.length() > 0 && !this.splitFiles.isEmpty()) {
            String string2 = (String)this.splitFiles.get(this.splitFiles.size() - 1) + '#' + string;
            if (XSLTUtilities.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "addId(String)", 265).add("store", string2)).log();
            }
            this.splitIds.put(string, string2);
        }
        return string;
    }

    public String getSplitId(String string) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getSplitId(String)", 277).addDetail("id", string)).log();
        }
        if (string.length() == 0 || string.charAt(0) != '#') {
            return string;
        }
        String string2 = (String)this.splitIds.get(string.substring(1));
        if (XSLTUtilities.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getSplitId(String)", 287).add("ret", string2)).log();
        }
        if (string2 == null) {
            string2 = this.splitFiles.isEmpty() ? string : this.mainFile + string;
            if (XSLTUtilities.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getSplitId(String)", 294).add("ret", string2)).log();
            }
            return string2;
        }
        return string2;
    }

    public String getSplitIdInLanguage(String string, String string2) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getSplitIdInLanguage(String,String)", 308).addDetail("id", string)).addDetail("language", string2)).log();
        }
        if (string.isEmpty() || string.charAt(0) != '#') {
            return "../" + string2 + "/" + string;
        }
        String string3 = (String)this.splitIds.get(string.substring(1));
        if (XSLTUtilities.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getSplitIdInLanguage(String,String)", 315).add("ret", string3)).log();
        }
        if (string3 == null) {
            string3 = this.mainFile + string;
        }
        return "../" + string2 + "/" + string3;
    }

    public String nextIndex(String string, boolean bl) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "nextIndex(String,boolean)", 325).addDetail("index", string)).addDetail("isSub", bl)).log();
        }
        if (string.equals(this.lastIndex) && bl == this.lastSub) {
            return "false";
        }
        String string2 = "true";
        if (this.lastIndex != null) {
            char c = this.lastIndex.charAt(0);
            char c2 = string.charAt(0);
            boolean bl2 = Character.isLetter(c);
            boolean bl3 = Character.isLetter(c2);
            boolean bl4 = Character.isDigit(c);
            boolean bl5 = Character.isDigit(c2);
            if (!bl2) {
                if (!bl4) {
                    if (bl5 || bl3) {
                        string2 = "sep";
                    }
                } else if (!bl5 || c2 != c) {
                    string2 = "sep";
                }
            } else if (!bl3 || Character.toLowerCase(c) != Character.toLowerCase(c2)) {
                string2 = "sep";
            }
        }
        this.lastIndex = string;
        this.lastSub = bl;
        return string2;
    }

    public final String getSplit() {
        if (XSLTUtilities.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getSplit()", 381).add("split", this.split)).log();
        }
        return this.split;
    }

    public final boolean setSplit(String string) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setSplit(String)", 393).addDetail("split", string)).log();
        }
        if (!string.equals(this.split)) {
            this.createdSlugs.clear();
        }
        this.split = string;
        return true;
    }

    public final String trimForAttribute(String string) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "trimForAttribute(String)", 410).addDetail("string", string)).log();
        }
        return string.trim().split("[\\r\\n]+", 2)[0].trim();
    }

    public final boolean addAvailableModules(String string2) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addAvailableModules(String)", 425).addDetail("modules", string2)).log();
        }
        String[] stringArray = string2.toUpperCase().split(":");
        Arrays.stream(Misc.fastSplit(stringArray[0], ',')).map(String::trim).filter(string -> !string.isEmpty()).forEach(this.availableModules::add);
        if (stringArray.length > 1) {
            Arrays.stream(Misc.fastSplit(stringArray[1], ',')).map(String::trim).filter(string -> !string.isEmpty()).forEach(this.availableSuperModules::add);
        }
        return true;
    }

    public final boolean isModuleAvailable(String string) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "isModuleAvailable(String)", 442).addDetail("modules", string)).log();
        }
        if (this.availableModules.isEmpty()) {
            return true;
        }
        String[] stringArray = Misc.fastSplit(string.toUpperCase(), ',');
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            String string2 = stringArray[i];
            String[] stringArray2 = Misc.fastSplit(string2, '+');
            int n3 = stringArray2.length;
            if (n2 >= n3) continue;
            String string3 = stringArray2[n2];
            if (!this.availableModules.contains(string3 = string3.trim()) && !this.availableSuperModules.contains(string3)) continue;
            return true;
        }
        return Misc.emptyOrNull(string);
    }

    public final boolean addProperties(String string, String string2) throws IOException {
        File file;
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addProperties(String,String)", 461).addDetail("baseDir", string)).addDetail("filename", string2)).log();
        }
        if (!(file = new File(string, string2)).exists()) {
            System.err.println("WARNING: " + file + " not found.");
            return false;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.properties.load(fileInputStream);
            System.out.println("Loaded " + file);
            this.propsPreprocessed = false;
        }
        return true;
    }

    private void preprocessProperties() {
        if (XSLTUtilities.logger.level >= 7) {
            logger.lvlBuild(7, "preprocessProperties()", 479).log();
        }
        if (this.propsPreprocessed) {
            return;
        }
        this.inheritOptionModules();
        this.propsPreprocessed = true;
    }

    private void inheritOptionModules() {
        if (XSLTUtilities.logger.level >= 7) {
            logger.lvlBuild(7, "inheritOptionModules()", 490).log();
        }
        boolean bl = false;
        for (String string : this.properties.stringPropertyNames()) {
            String string2;
            String string3;
            Object object;
            if (!string.startsWith("option.group.") || !string.endsWith(".modules")) continue;
            String string4 = string.substring(0, string.length() - ".modules".length());
            String string5 = this.properties.getProperty(string);
            String string6 = this.properties.getProperty(string4 + ".members");
            if (string6 != null && !string6.isEmpty()) {
                object = new StringTokenizer(string6, " ");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string3 = ((StringTokenizer)object).nextToken();
                    string2 = "option." + string3 + ".modules";
                    if (this.properties.getProperty(string2) != null) continue;
                    this.properties.setProperty(string2, string5);
                    bl = true;
                }
            }
            if ((string6 = this.properties.getProperty(string4 + ".children")) != null && !string6.isEmpty()) {
                object = new StringTokenizer(string6, " ");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string3 = ((StringTokenizer)object).nextToken();
                    string2 = string4 + "." + string3 + ".modules";
                    if (this.properties.getProperty(string2) != null) continue;
                    this.properties.setProperty(string2, string5);
                    bl = true;
                }
            }
            if ((string6 = this.properties.getProperty(string4 + ".group")) == null || this.properties.getProperty((String)(object = "option.group." + string6 + ".modules")) != null) continue;
            this.properties.setProperty((String)object, string5);
            bl = true;
        }
        if (bl) {
            this.inheritOptionModules();
        }
    }

    public String getProperty(String string) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getProperty(String)", 553).addDetail("key", string)).log();
        }
        this.preprocessProperties();
        return this.properties.getProperty(string, "");
    }

    public boolean copyImage(String string, String string2, String string3) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "copyImage(String,String,String)", 560).addDetail("lang", string)).addDetail("targetDir", string2)).addDetail("filename", string3)).log();
        }
        File file = new File("..", string3.replace("images/", "images/" + string + "/"));
        File file2 = new File(string2, string3);
        try {
            file2.getParentFile().mkdirs();
            if (this.logImageCopy) {
                System.out.println("Copying " + file + " to " + file2);
            }
            Files.copyFile(file, file2);
            return true;
        }
        catch (Exception exception) {
            System.err.println("ERROR: copying image " + string3 + ": " + exception);
            return false;
        }
    }

    public String getImageDimensions(String string, String string2) {
        Dimension dimension;
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getImageDimensions(String,String)", 581).addDetail("targetDir", string)).addDetail("filename", string2)).log();
        }
        if ((dimension = string2.toLowerCase().endsWith(".svg") ? XSLTUtilities.getSvgDimensions(string2) : XSLTUtilities.getPngDimensions(string, string2)) == null) {
            return "";
        }
        return String.format("%.0fx%.0f", dimension.getWidth(), dimension.getHeight());
    }

    private static Dimension getPngDimensions(String string, String string2) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getPngDimensions(String,String)", 596).addDetail("targetDir", string)).addDetail("filename", string2)).log();
        }
        File file = new File(string, string2);
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            return new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        catch (Exception exception) {
            System.err.println("ERROR: reading image " + string2 + ": " + exception);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Dimension getSvgDimensions(String string) {
        block21: {
            if (XSLTUtilities.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "getSvgDimensions(String)", 608).addDetail("filename", string)).log();
            }
            Pattern pattern = Pattern.compile("<svg[^>]*width=\"([0-9.]+)\"[^>]*height=\"([0-9.]+)\"");
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                Throwable throwable = null;
                while (true) {
                    String string2 = bufferedReader.readLine();
                    if (string2 == null) break block21;
                    Matcher matcher = pattern.matcher(string2);
                    if (!matcher.find()) continue;
                    try {
                        double d = Double.parseDouble(matcher.group(1));
                        double d2 = Double.parseDouble(matcher.group(2));
                        Dimension dimension = new Dimension((int)d, (int)d2);
                        return dimension;
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            System.err.println("Error parsing width or height from SVG: " + numberFormatException.getMessage());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
                finally {
                    if (bufferedReader != null) {
                        if (throwable != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            bufferedReader.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println("Error reading SVG file: " + iOException.getMessage());
            }
        }
        return null;
    }

    public int compareVersion(String string, String string2) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "compareVersion(String,String)", 633).addDetail("versionString1", string)).addDetail("versionString2", string2)).log();
        }
        VersionNumber versionNumber = VersionNumber.fromString(string);
        VersionNumber versionNumber2 = VersionNumber.fromString(string2);
        return versionNumber.compareTo(versionNumber2);
    }

    public String generateSlug(String string, String string2) {
        if (XSLTUtilities.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "generateSlug(String,String)", 644).addDetail("rawText", string)).addDetail("nodeId", string2)).log();
        }
        int n = 1000;
        String string3 = "_";
        String string4 = Normalizer.normalize(string, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        String string5 = string4.replaceAll("[^a-zA-Z0-9]", string3);
        if ((string5 = string5.replaceAll(string3 + "{2,}", string3)).length() > n) {
            string5 = string5.substring(0, n);
        }
        string5 = string5.replaceAll("^" + string3 + "|" + string3 + "$", "");
        if (!this.createdSlugs.getOrDefault(string5 = string5.toLowerCase(), string2).equals(string2)) {
            System.err.println("WARNING: Auto-generated id slug is not unique: '" + string5 + "'. Fallback slug: '" + string2 + "' in split '" + this.split + "'");
            return string2;
        }
        this.createdSlugs.put(string5, string2);
        return string5;
    }
}

