/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.loader;

import dev.langchain4j.data.document.BlankDocumentException;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentLoader;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.loader.DocumentParserLoader;
import dev.langchain4j.data.document.parser.TextDocumentParser;
import dev.langchain4j.data.document.source.ClassPathSource;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathDocumentLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathDocumentLoader.class);
    private static final DocumentParser DEFAULT_DOCUMENT_PARSER = Utils.getOrDefault(DocumentParserLoader.loadDocumentParser(), TextDocumentParser::new);

    private ClassPathDocumentLoader() {
    }

    public static Document loadDocument(String pathOnClasspath) {
        return ClassPathDocumentLoader.loadDocument(pathOnClasspath, ClassPathDocumentLoader.getDefaultClassloader());
    }

    public static Document loadDocument(String pathOnClasspath, ClassLoader classLoader) {
        return ClassPathDocumentLoader.loadDocument(pathOnClasspath, DEFAULT_DOCUMENT_PARSER);
    }

    public static Document loadDocument(String pathOnClasspath, DocumentParser documentParser) {
        return ClassPathDocumentLoader.loadDocument(pathOnClasspath, documentParser, ClassPathDocumentLoader.getDefaultClassloader());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Document loadDocument(String pathOnClasspath, DocumentParser documentParser, ClassLoader classLoader) {
        Document document;
        ClassPathSource classPathSource = ClassPathSource.from(pathOnClasspath, classLoader);
        URI uri = classPathSource.url().toURI();
        if (!classPathSource.isInsideArchive()) return ClassPathDocumentLoader.loadDocument(classPathSource, Path.of(uri), documentParser);
        FileSystem fs = FileSystems.newFileSystem(uri, Map.of("create", "true"));
        try {
            document = ClassPathDocumentLoader.loadDocument(classPathSource, fs.getPath(pathOnClasspath, new String[0]), documentParser);
            if (fs == null) return document;
        }
        catch (Throwable throwable) {
            try {
                if (fs == null) throw throwable;
                try {
                    fs.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        fs.close();
        return document;
    }

    private static Document loadDocument(ClassPathSource classPathSource, Path path, DocumentParser documentParser) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw Exceptions.illegalArgument("'%s' is not a file", path);
        }
        return DocumentLoader.load(classPathSource, documentParser);
    }

    public static List<Document> loadDocuments(String directoryOnClasspath) {
        return ClassPathDocumentLoader.loadDocuments(directoryOnClasspath, ClassPathDocumentLoader.getDefaultClassloader());
    }

    public static List<Document> loadDocuments(String directoryOnClasspath, ClassLoader classLoader) {
        return ClassPathDocumentLoader.loadDocuments(directoryOnClasspath, DEFAULT_DOCUMENT_PARSER, classLoader);
    }

    public static List<Document> loadDocuments(String directoryOnClasspath, DocumentParser documentParser) {
        return ClassPathDocumentLoader.loadDocuments(directoryOnClasspath, documentParser, ClassPathDocumentLoader.getDefaultClassloader());
    }

    public static List<Document> loadDocuments(String directoryOnClasspath, DocumentParser documentParser, ClassLoader classLoader) {
        return ClassPathDocumentLoader.loadDocuments(directoryOnClasspath, path -> true, documentParser, classLoader);
    }

    public static List<Document> loadDocuments(String directoryOnClasspath, PathMatcher pathMatcher) {
        return ClassPathDocumentLoader.loadDocuments(directoryOnClasspath, pathMatcher, ClassPathDocumentLoader.getDefaultClassloader());
    }

    public static List<Document> loadDocuments(String directoryOnClasspath, PathMatcher pathMatcher, ClassLoader classLoader) {
        return ClassPathDocumentLoader.loadDocuments(directoryOnClasspath, pathMatcher, DEFAULT_DOCUMENT_PARSER, classLoader);
    }

    public static List<Document> loadDocuments(String directoryOnClasspath, PathMatcher pathMatcher, DocumentParser documentParser) {
        return ClassPathDocumentLoader.loadDocuments(directoryOnClasspath, pathMatcher, documentParser, ClassPathDocumentLoader.getDefaultClassloader());
    }

    public static List<Document> loadDocuments(String directoryOnClasspath, PathMatcher pathMatcher, DocumentParser documentParser, ClassLoader classLoader) {
        return ClassPathDocumentLoader.loadDocuments(directoryOnClasspath, pathMatcher, documentParser, classLoader, ClassPathDocumentLoader::getFilesInDirectory);
    }

    private static ClassLoader getDefaultClassloader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Document> loadDocuments(String directoryOnClasspath, PathMatcher pathMatcher, DocumentParser documentParser, ClassLoader classLoader, Function<Path, Stream<Path>> pathStreamFunction) {
        List<Document> list;
        ClassPathSource classPathSource = ClassPathSource.from(directoryOnClasspath, classLoader);
        URI uri = classPathSource.url().toURI();
        if (!classPathSource.isInsideArchive()) return ClassPathDocumentLoader.loadDocuments(classPathSource, directoryOnClasspath, Path.of(uri), pathMatcher, documentParser, pathStreamFunction);
        FileSystem fs = FileSystems.newFileSystem(uri, Map.of("create", "true"));
        try {
            list = ClassPathDocumentLoader.loadDocuments(classPathSource, directoryOnClasspath, fs.getPath(directoryOnClasspath, new String[0]), pathMatcher, documentParser, pathStreamFunction);
            if (fs == null) return list;
        }
        catch (Throwable throwable) {
            try {
                if (fs == null) throw throwable;
                try {
                    fs.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        fs.close();
        return list;
    }

    private static List<Document> loadDocuments(ClassPathSource rootDirectoryClassPathSource, String directoryOnClasspath, Path path, PathMatcher pathMatcher, DocumentParser documentParser, Function<Path, Stream<Path>> pathStreamFunction) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw Exceptions.illegalArgument("'%s' is not a directory", path);
        }
        try (Stream<Path> pathStream = pathStreamFunction.apply(path);){
            List<Document> list = ClassPathDocumentLoader.loadDocuments(pathStream, rootDirectoryClassPathSource, directoryOnClasspath, path, pathMatcher, documentParser);
            return list;
        }
    }

    private static List<Document> loadDocuments(Stream<Path> pathStream, ClassPathSource rootDirectoryClassPathSource, String directoryOnClasspath, Path pathMatcherRoot, PathMatcher pathMatcher, DocumentParser documentParser) {
        return pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> pathMatcher.matches(Path.of(pathMatcherRoot.relativize((Path)p).toString().replace('/', File.separatorChar), new String[0]))).map(p -> {
            try {
                String relativePath = ClassPathDocumentLoader.getRelativePath(directoryOnClasspath, rootDirectoryClassPathSource, p);
                return ClassPathDocumentLoader.loadDocument(ClassPathSource.from(relativePath, rootDirectoryClassPathSource.classLoader()), p, documentParser);
            }
            catch (BlankDocumentException ignored) {
                return null;
            }
            catch (Exception e) {
                String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                LOG.warn("Failed to load '{}': {}", p, (Object)message);
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    private static String getRelativePath(String directoryOnClasspath, ClassPathSource rootDirectoryClassPathSource, Path subPath) {
        if (rootDirectoryClassPathSource.isInsideArchive()) {
            return subPath.toString();
        }
        try {
            boolean isClasspathRoot;
            Path rootClasspathPath = Path.of(rootDirectoryClassPathSource.url().toURI());
            boolean bl = isClasspathRoot = ".".equals(directoryOnClasspath) || "/".equals(directoryOnClasspath);
            if (!isClasspathRoot) {
                String withoutLeadingAndTrailingSpaces = directoryOnClasspath.strip().replaceAll("^/+", "").replaceAll("/+$", "");
                long numDirs = withoutLeadingAndTrailingSpaces.chars().filter(c -> c == 47).count() + 1L;
                rootClasspathPath = IntStream.range(0, (int)numDirs).mapToObj(index -> "..").reduce(rootClasspathPath, Path::resolve, (a, b) -> b).normalize();
            }
            Path relativeClasspathPath = rootClasspathPath.relativize(subPath);
            return relativeClasspathPath.toString().replace(File.separatorChar, '/');
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Document> loadDocumentsRecursively(String directoryOnClasspath) {
        return ClassPathDocumentLoader.loadDocumentsRecursively(directoryOnClasspath, ClassPathDocumentLoader.getDefaultClassloader());
    }

    public static List<Document> loadDocumentsRecursively(String directoryOnClasspath, ClassLoader classLoader) {
        return ClassPathDocumentLoader.loadDocumentsRecursively(directoryOnClasspath, DEFAULT_DOCUMENT_PARSER, classLoader);
    }

    public static List<Document> loadDocumentsRecursively(String directoryOnClasspath, DocumentParser documentParser) {
        return ClassPathDocumentLoader.loadDocumentsRecursively(directoryOnClasspath, documentParser, ClassPathDocumentLoader.getDefaultClassloader());
    }

    public static List<Document> loadDocumentsRecursively(String directoryOnClasspath, DocumentParser documentParser, ClassLoader classLoader) {
        return ClassPathDocumentLoader.loadDocumentsRecursively(directoryOnClasspath, path -> true, documentParser, classLoader);
    }

    public static List<Document> loadDocumentsRecursively(String directoryOnClasspath, PathMatcher pathMatcher) {
        return ClassPathDocumentLoader.loadDocumentsRecursively(directoryOnClasspath, pathMatcher, ClassPathDocumentLoader.getDefaultClassloader());
    }

    public static List<Document> loadDocumentsRecursively(String directoryOnClasspath, PathMatcher pathMatcher, ClassLoader classLoader) {
        return ClassPathDocumentLoader.loadDocumentsRecursively(directoryOnClasspath, pathMatcher, DEFAULT_DOCUMENT_PARSER, classLoader);
    }

    public static List<Document> loadDocumentsRecursively(String directoryOnClasspath, PathMatcher pathMatcher, DocumentParser documentParser) {
        return ClassPathDocumentLoader.loadDocumentsRecursively(directoryOnClasspath, pathMatcher, documentParser, ClassPathDocumentLoader.getDefaultClassloader());
    }

    public static List<Document> loadDocumentsRecursively(String directoryOnClasspath, PathMatcher pathMatcher, DocumentParser documentParser, ClassLoader classLoader) {
        return ClassPathDocumentLoader.loadDocuments(directoryOnClasspath, pathMatcher, documentParser, classLoader, ClassPathDocumentLoader::getFilesInDirectoryRecursively);
    }

    private static Stream<Path> getFilesInDirectory(Path directoryPath) {
        try {
            return Files.list(directoryPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Stream<Path> getFilesInDirectoryRecursively(Path directoryPath) {
        try {
            return Files.walk(directoryPath, new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

