/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.HttpClientBuilderLoader;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.log.LoggingHttpClient;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.internal.ExceptionMapper;
import dev.langchain4j.internal.InternalStreamingChatResponseHandlerUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.CompleteToolCall;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.googleai.GeminiCountTokensRequest;
import dev.langchain4j.model.googleai.GeminiCountTokensResponse;
import dev.langchain4j.model.googleai.GeminiGenerateContentRequest;
import dev.langchain4j.model.googleai.GeminiGenerateContentResponse;
import dev.langchain4j.model.googleai.GeminiStreamingResponseBuilder;
import dev.langchain4j.model.googleai.GoogleAiBatchEmbeddingRequest;
import dev.langchain4j.model.googleai.GoogleAiBatchEmbeddingResponse;
import dev.langchain4j.model.googleai.GoogleAiEmbeddingRequest;
import dev.langchain4j.model.googleai.GoogleAiEmbeddingResponse;
import dev.langchain4j.model.googleai.Json;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.Nullable;

class GeminiService {
    private static final String GEMINI_AI_ENDPOINT = "https://generativelanguage.googleapis.com/v1beta";
    private static final String API_KEY_HEADER_NAME = "x-goog-api-key";
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(15L);
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(60L);
    private final HttpClient httpClient;
    private final String baseUrl;
    private final String apiKey;

    GeminiService(@Nullable HttpClientBuilder httpClientBuilder, String apiKey, String baseUrl, boolean logRequestsAndResponses, Duration timeout) {
        this.apiKey = ValidationUtils.ensureNotBlank(apiKey, "apiKey");
        this.baseUrl = Utils.getOrDefault(baseUrl, GEMINI_AI_ENDPOINT);
        HttpClientBuilder builder = Utils.getOrDefault(httpClientBuilder, HttpClientBuilderLoader::loadHttpClientBuilder);
        HttpClient httpClient = builder.connectTimeout(Utils.firstNotNull("connectTimeout", timeout, builder.connectTimeout(), DEFAULT_CONNECT_TIMEOUT)).readTimeout(Utils.firstNotNull("readTimeout", timeout, builder.readTimeout(), DEFAULT_READ_TIMEOUT)).build();
        this.httpClient = logRequestsAndResponses ? new LoggingHttpClient(httpClient, true, true) : httpClient;
    }

    GeminiGenerateContentResponse generateContent(String modelName, GeminiGenerateContentRequest request) {
        String url = String.format("%s/models/%s:generateContent", this.baseUrl, modelName);
        return this.sendRequest(url, this.apiKey, request, GeminiGenerateContentResponse.class);
    }

    GeminiCountTokensResponse countTokens(String modelName, GeminiCountTokensRequest request) {
        String url = String.format("%s/models/%s:countTokens", this.baseUrl, modelName);
        return this.sendRequest(url, this.apiKey, request, GeminiCountTokensResponse.class);
    }

    GoogleAiEmbeddingResponse embed(String modelName, GoogleAiEmbeddingRequest request) {
        String url = String.format("%s/models/%s:embedContent", this.baseUrl, modelName);
        return this.sendRequest(url, this.apiKey, request, GoogleAiEmbeddingResponse.class);
    }

    GoogleAiBatchEmbeddingResponse batchEmbed(String modelName, GoogleAiBatchEmbeddingRequest request) {
        String url = String.format("%s/models/%s:batchEmbedContents", this.baseUrl, modelName);
        return this.sendRequest(url, this.apiKey, request, GoogleAiBatchEmbeddingResponse.class);
    }

    void generateContentStream(String modelName, GeminiGenerateContentRequest request, boolean includeCodeExecutionOutput, Boolean returnThinking, StreamingChatResponseHandler handler) {
        String url = String.format("%s/models/%s:streamGenerateContent?alt=sse", this.baseUrl, modelName);
        this.streamRequest(url, this.apiKey, request, includeCodeExecutionOutput, returnThinking, handler);
    }

    private <T> T sendRequest(String url, String apiKey, Object requestBody, Class<T> responseType) {
        String jsonBody = Json.toJson(requestBody);
        HttpRequest request = this.buildHttpRequest(url, apiKey, jsonBody);
        SuccessfulHttpResponse response = this.httpClient.execute(request);
        return Json.fromJson(response.body(), responseType);
    }

    private void streamRequest(String url, String apiKey, Object requestBody, boolean includeCodeExecutionOutput, final Boolean returnThinking, final StreamingChatResponseHandler handler) {
        String jsonBody = Json.toJson(requestBody);
        HttpRequest httpRequest = this.buildHttpRequest(url, apiKey, jsonBody);
        final GeminiStreamingResponseBuilder responseBuilder = new GeminiStreamingResponseBuilder(includeCodeExecutionOutput, returnThinking);
        this.httpClient.execute(httpRequest, new ServerSentEventListener(){
            AtomicInteger toolIndex = new AtomicInteger(0);

            @Override
            public void onEvent(ServerSentEvent event) {
                GeminiGenerateContentResponse response = Json.fromJson(event.data(), GeminiGenerateContentResponse.class);
                GeminiStreamingResponseBuilder.TextAndTools textAndTools = responseBuilder.append(response);
                textAndTools.maybeText().ifPresent(text -> InternalStreamingChatResponseHandlerUtils.onPartialResponse(handler, text));
                textAndTools.maybeThought().ifPresent(thought -> {
                    if (Boolean.TRUE.equals(returnThinking)) {
                        InternalStreamingChatResponseHandlerUtils.onPartialThinking(handler, thought);
                    } else if (returnThinking == null) {
                        InternalStreamingChatResponseHandlerUtils.onPartialResponse(handler, thought);
                    }
                });
                for (ToolExecutionRequest tool : textAndTools.tools()) {
                    CompleteToolCall completeToolCall = new CompleteToolCall(this.toolIndex.get(), tool);
                    InternalStreamingChatResponseHandlerUtils.onCompleteToolCall(handler, completeToolCall);
                    this.toolIndex.incrementAndGet();
                }
            }

            @Override
            public void onClose() {
                ChatResponse completeResponse = responseBuilder.build();
                InternalStreamingChatResponseHandlerUtils.onCompleteResponse(handler, completeResponse);
            }

            @Override
            public void onError(Throwable error) {
                RuntimeException mappedError = ExceptionMapper.DEFAULT.mapException(error);
                InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError(mappedError));
            }
        });
    }

    private HttpRequest buildHttpRequest(String url, String apiKey, String jsonBody) {
        return HttpRequest.builder().method(HttpMethod.POST).url(url).addHeader("Content-Type", "application/json").addHeader("User-Agent", "LangChain4j").addHeader(API_KEY_HEADER_NAME, apiKey).body(jsonBody).build();
    }
}

