/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.guardrail.InputGuardrail;
import dev.langchain4j.guardrail.OutputGuardrail;
import dev.langchain4j.guardrail.config.InputGuardrailsConfig;
import dev.langchain4j.guardrail.config.OutputGuardrailsConfig;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.moderation.Moderation;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.rag.DefaultRetrievalAugmentor;
import dev.langchain4j.rag.RetrievalAugmentor;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.DefaultAiServices;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.ModerationException;
import dev.langchain4j.service.tool.ToolExecutor;
import dev.langchain4j.service.tool.ToolProvider;
import dev.langchain4j.spi.ServiceHelper;
import dev.langchain4j.spi.services.AiServicesFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public abstract class AiServices<T> {
    protected final AiServiceContext context;
    private boolean contentRetrieverSet = false;
    private boolean retrievalAugmentorSet = false;

    protected AiServices(AiServiceContext context) {
        this.context = context;
    }

    public static <T> T create(Class<T> aiService, ChatModel chatModel) {
        return AiServices.builder(aiService).chatModel(chatModel).build();
    }

    public static <T> T create(Class<T> aiService, StreamingChatModel streamingChatModel) {
        return AiServices.builder(aiService).streamingChatModel(streamingChatModel).build();
    }

    public static <T> AiServices<T> builder(Class<T> aiService) {
        AiServiceContext context = new AiServiceContext(aiService);
        return AiServices.builder(context);
    }

    @Internal
    public static <T> AiServices<T> builder(AiServiceContext context) {
        Iterator<AiServicesFactory> iterator = ServiceHelper.loadFactories(AiServicesFactory.class).iterator();
        if (iterator.hasNext()) {
            AiServicesFactory factory = iterator.next();
            return factory.create(context);
        }
        return new DefaultAiServices(context);
    }

    public AiServices<T> chatModel(ChatModel chatModel) {
        this.context.chatModel = chatModel;
        return this;
    }

    public AiServices<T> streamingChatModel(StreamingChatModel streamingChatModel) {
        this.context.streamingChatModel = streamingChatModel;
        return this;
    }

    public AiServices<T> systemMessageProvider(Function<Object, String> systemMessageProvider) {
        this.context.systemMessageProvider = systemMessageProvider.andThen(Optional::ofNullable);
        return this;
    }

    public AiServices<T> chatMemory(ChatMemory chatMemory) {
        this.context.initChatMemories(chatMemory);
        return this;
    }

    public AiServices<T> chatMemoryProvider(ChatMemoryProvider chatMemoryProvider) {
        this.context.initChatMemories(chatMemoryProvider);
        return this;
    }

    public AiServices<T> chatRequestTransformer(UnaryOperator<ChatRequest> chatRequestTransformer) {
        this.context.chatRequestTransformer = (req, memId) -> (ChatRequest)chatRequestTransformer.apply((ChatRequest)req);
        return this;
    }

    public AiServices<T> chatRequestTransformer(BiFunction<ChatRequest, Object, ChatRequest> chatRequestTransformer) {
        this.context.chatRequestTransformer = chatRequestTransformer;
        return this;
    }

    public AiServices<T> moderationModel(ModerationModel moderationModel) {
        this.context.moderationModel = moderationModel;
        return this;
    }

    public AiServices<T> tools(Object ... objectsWithTools) {
        return this.tools(Arrays.asList(objectsWithTools));
    }

    public AiServices<T> tools(Collection<Object> objectsWithTools) {
        this.context.toolService.tools(objectsWithTools);
        return this;
    }

    public AiServices<T> toolProvider(ToolProvider toolProvider) {
        this.context.toolService.toolProvider(toolProvider);
        return this;
    }

    public AiServices<T> tools(Map<ToolSpecification, ToolExecutor> tools) {
        this.context.toolService.tools(tools);
        return this;
    }

    public AiServices<T> maxSequentialToolsInvocations(int maxSequentialToolsInvocations) {
        this.context.toolService.maxSequentialToolsInvocations(maxSequentialToolsInvocations);
        return this;
    }

    public AiServices<T> hallucinatedToolNameStrategy(Function<ToolExecutionRequest, ToolExecutionResultMessage> hallucinatedToolNameStrategy) {
        this.context.toolService.hallucinatedToolNameStrategy(hallucinatedToolNameStrategy);
        return this;
    }

    public AiServices<T> contentRetriever(ContentRetriever contentRetriever) {
        if (this.retrievalAugmentorSet) {
            throw IllegalConfigurationException.illegalConfiguration("Only one out of [retriever, contentRetriever, retrievalAugmentor] can be set");
        }
        this.contentRetrieverSet = true;
        this.context.retrievalAugmentor = DefaultRetrievalAugmentor.builder().contentRetriever(ValidationUtils.ensureNotNull(contentRetriever, "contentRetriever")).build();
        return this;
    }

    public AiServices<T> retrievalAugmentor(RetrievalAugmentor retrievalAugmentor) {
        if (this.contentRetrieverSet) {
            throw IllegalConfigurationException.illegalConfiguration("Only one out of [retriever, contentRetriever, retrievalAugmentor] can be set");
        }
        this.retrievalAugmentorSet = true;
        this.context.retrievalAugmentor = ValidationUtils.ensureNotNull(retrievalAugmentor, "retrievalAugmentor");
        return this;
    }

    public AiServices<T> inputGuardrailsConfig(InputGuardrailsConfig inputGuardrailsConfig) {
        this.context.guardrailServiceBuilder.inputGuardrailsConfig(inputGuardrailsConfig);
        return this;
    }

    public AiServices<T> outputGuardrailsConfig(OutputGuardrailsConfig outputGuardrailsConfig) {
        this.context.guardrailServiceBuilder.outputGuardrailsConfig(outputGuardrailsConfig);
        return this;
    }

    public <I extends InputGuardrail> AiServices<T> inputGuardrailClasses(List<Class<? extends I>> guardrailClasses) {
        this.context.guardrailServiceBuilder.inputGuardrailClasses(guardrailClasses);
        return this;
    }

    public <I extends InputGuardrail> AiServices<T> inputGuardrailClasses(Class<? extends I> ... guardrailClasses) {
        this.context.guardrailServiceBuilder.inputGuardrailClasses(guardrailClasses);
        return this;
    }

    public <I extends InputGuardrail> AiServices<T> inputGuardrails(List<I> guardrails) {
        this.context.guardrailServiceBuilder.inputGuardrails(guardrails);
        return this;
    }

    public <I extends InputGuardrail> AiServices<T> inputGuardrails(I ... guardrails) {
        this.context.guardrailServiceBuilder.inputGuardrails((InputGuardrail[])guardrails);
        return this;
    }

    public <O extends OutputGuardrail> AiServices<T> outputGuardrailClasses(List<Class<? extends O>> guardrailClasses) {
        this.context.guardrailServiceBuilder.outputGuardrailClasses(guardrailClasses);
        return this;
    }

    public <O extends OutputGuardrail> AiServices<T> outputGuardrailClasses(Class<? extends O> ... guardrailClasses) {
        this.context.guardrailServiceBuilder.outputGuardrailClasses(guardrailClasses);
        return this;
    }

    public <O extends OutputGuardrail> AiServices<T> outputGuardrails(List<O> guardrails) {
        this.context.guardrailServiceBuilder.outputGuardrails(guardrails);
        return this;
    }

    public <O extends OutputGuardrail> AiServices<T> outputGuardrails(O ... guardrails) {
        this.context.guardrailServiceBuilder.outputGuardrails((OutputGuardrail[])guardrails);
        return this;
    }

    public abstract T build();

    protected void performBasicValidation() {
        if (this.context.chatModel == null && this.context.streamingChatModel == null) {
            throw IllegalConfigurationException.illegalConfiguration("Please specify either chatModel or streamingChatModel");
        }
    }

    public static List<ChatMessage> removeToolMessages(List<ChatMessage> messages) {
        return messages.stream().filter(it -> !(it instanceof ToolExecutionResultMessage)).filter(it -> !(it instanceof AiMessage) || !((AiMessage)it).hasToolExecutionRequests()).collect(Collectors.toList());
    }

    public static void verifyModerationIfNeeded(Future<Moderation> moderationFuture) {
        if (moderationFuture != null) {
            try {
                Moderation moderation = moderationFuture.get();
                if (moderation.flagged()) {
                    throw new ModerationException(String.format("Text \"%s\" violates content policy", moderation.flaggedText()), moderation);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

