/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.influxdb.client.domain.ArrayExpression;
import com.influxdb.client.domain.BinaryExpression;
import com.influxdb.client.domain.BooleanLiteral;
import com.influxdb.client.domain.ConditionalExpression;
import com.influxdb.client.domain.DateTimeLiteral;
import com.influxdb.client.domain.DictExpression;
import com.influxdb.client.domain.DurationLiteral;
import com.influxdb.client.domain.Expression;
import com.influxdb.client.domain.FloatLiteral;
import com.influxdb.client.domain.FunctionExpression;
import com.influxdb.client.domain.Identifier;
import com.influxdb.client.domain.IndexExpression;
import com.influxdb.client.domain.IntegerLiteral;
import com.influxdb.client.domain.LogicalExpression;
import com.influxdb.client.domain.MemberExpression;
import com.influxdb.client.domain.ObjectExpression;
import com.influxdb.client.domain.ParenExpression;
import com.influxdb.client.domain.PipeExpression;
import com.influxdb.client.domain.PipeLiteral;
import com.influxdb.client.domain.RegexpLiteral;
import com.influxdb.client.domain.StringLiteral;
import com.influxdb.client.domain.UnaryExpression;
import com.influxdb.client.domain.UnsignedIntegerLiteral;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class CallExpression
extends Expression {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_CALLEE = "callee";
    @SerializedName(value="callee")
    @JsonAdapter(value=CallExpressionCalleeAdapter.class)
    private Expression callee = null;
    public static final String SERIALIZED_NAME_ARGUMENTS = "arguments";
    @SerializedName(value="arguments")
    @JsonAdapter(value=CallExpressionArgumentsAdapter.class)
    private List<Expression> arguments = new ArrayList<Expression>();

    public CallExpression type(String type) {
        this.type = type;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public CallExpression callee(Expression callee) {
        this.callee = callee;
        return this;
    }

    public Expression getCallee() {
        return this.callee;
    }

    public void setCallee(Expression callee) {
        this.callee = callee;
    }

    public CallExpression arguments(List<Expression> arguments) {
        this.arguments = arguments;
        return this;
    }

    public CallExpression addArgumentsItem(Expression argumentsItem) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<Expression>();
        }
        this.arguments.add(argumentsItem);
        return this;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<Expression> arguments) {
        this.arguments = arguments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallExpression callExpression = (CallExpression)o;
        return Objects.equals(this.type, callExpression.type) && Objects.equals(this.callee, callExpression.callee) && Objects.equals(this.arguments, callExpression.arguments) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.callee, this.arguments, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CallExpression {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    callee: ").append(this.toIndentedString(this.callee)).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class CallExpressionCalleeAdapter
    implements JsonDeserializer<Object>,
    JsonSerializer<Object> {
        @Override
        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            List<String> discriminator = Arrays.asList(CallExpression.SERIALIZED_NAME_TYPE);
            JsonObject jsonObject = json.getAsJsonObject();
            String[] types = (String[])discriminator.stream().map(jsonObject::get).filter(Objects::nonNull).map(JsonElement::getAsString).toArray(String[]::new);
            return this.deserialize(types, jsonObject, context);
        }

        @Override
        public JsonElement serialize(Object object, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(object);
        }

        private Object deserialize(String[] types, JsonElement json, JsonDeserializationContext context) {
            if (Arrays.equals(new String[]{"ArrayExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)ArrayExpression.class));
            }
            if (Arrays.equals(new String[]{"DictExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)DictExpression.class));
            }
            if (Arrays.equals(new String[]{"FunctionExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)FunctionExpression.class));
            }
            if (Arrays.equals(new String[]{"BinaryExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)BinaryExpression.class));
            }
            if (Arrays.equals(new String[]{"CallExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)CallExpression.class));
            }
            if (Arrays.equals(new String[]{"ConditionalExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)ConditionalExpression.class));
            }
            if (Arrays.equals(new String[]{"LogicalExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)LogicalExpression.class));
            }
            if (Arrays.equals(new String[]{"MemberExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)MemberExpression.class));
            }
            if (Arrays.equals(new String[]{"IndexExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)IndexExpression.class));
            }
            if (Arrays.equals(new String[]{"ObjectExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)ObjectExpression.class));
            }
            if (Arrays.equals(new String[]{"ParenExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)ParenExpression.class));
            }
            if (Arrays.equals(new String[]{"PipeExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)PipeExpression.class));
            }
            if (Arrays.equals(new String[]{"UnaryExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)UnaryExpression.class));
            }
            if (Arrays.equals(new String[]{"BooleanLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)BooleanLiteral.class));
            }
            if (Arrays.equals(new String[]{"DateTimeLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)DateTimeLiteral.class));
            }
            if (Arrays.equals(new String[]{"DurationLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)DurationLiteral.class));
            }
            if (Arrays.equals(new String[]{"FloatLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)FloatLiteral.class));
            }
            if (Arrays.equals(new String[]{"IntegerLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)IntegerLiteral.class));
            }
            if (Arrays.equals(new String[]{"PipeLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)PipeLiteral.class));
            }
            if (Arrays.equals(new String[]{"RegexpLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)RegexpLiteral.class));
            }
            if (Arrays.equals(new String[]{"StringLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)StringLiteral.class));
            }
            if (Arrays.equals(new String[]{"UnsignedIntegerLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)UnsignedIntegerLiteral.class));
            }
            if (Arrays.equals(new String[]{"Identifier"}, types)) {
                return context.deserialize(json, (Type)((Object)Identifier.class));
            }
            return context.deserialize(json, (Type)((Object)Object.class));
        }
    }

    public static class CallExpressionArgumentsAdapter
    implements JsonDeserializer<Object>,
    JsonSerializer<Object> {
        @Override
        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            List<String> discriminator = Arrays.asList(CallExpression.SERIALIZED_NAME_TYPE);
            ArrayList<Object> results = new ArrayList<Object>();
            for (JsonElement arrayItem : json.getAsJsonArray()) {
                JsonObject jsonObject = arrayItem.getAsJsonObject();
                String[] types = (String[])discriminator.stream().map(jsonObject::get).filter(Objects::nonNull).map(JsonElement::getAsString).toArray(String[]::new);
                results.add(this.deserialize(types, jsonObject, context));
            }
            return results;
        }

        @Override
        public JsonElement serialize(Object object, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(object);
        }

        private Object deserialize(String[] types, JsonElement json, JsonDeserializationContext context) {
            if (Arrays.equals(new String[]{"ArrayExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)ArrayExpression.class));
            }
            if (Arrays.equals(new String[]{"DictExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)DictExpression.class));
            }
            if (Arrays.equals(new String[]{"FunctionExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)FunctionExpression.class));
            }
            if (Arrays.equals(new String[]{"BinaryExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)BinaryExpression.class));
            }
            if (Arrays.equals(new String[]{"CallExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)CallExpression.class));
            }
            if (Arrays.equals(new String[]{"ConditionalExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)ConditionalExpression.class));
            }
            if (Arrays.equals(new String[]{"LogicalExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)LogicalExpression.class));
            }
            if (Arrays.equals(new String[]{"MemberExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)MemberExpression.class));
            }
            if (Arrays.equals(new String[]{"IndexExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)IndexExpression.class));
            }
            if (Arrays.equals(new String[]{"ObjectExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)ObjectExpression.class));
            }
            if (Arrays.equals(new String[]{"ParenExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)ParenExpression.class));
            }
            if (Arrays.equals(new String[]{"PipeExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)PipeExpression.class));
            }
            if (Arrays.equals(new String[]{"UnaryExpression"}, types)) {
                return context.deserialize(json, (Type)((Object)UnaryExpression.class));
            }
            if (Arrays.equals(new String[]{"BooleanLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)BooleanLiteral.class));
            }
            if (Arrays.equals(new String[]{"DateTimeLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)DateTimeLiteral.class));
            }
            if (Arrays.equals(new String[]{"DurationLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)DurationLiteral.class));
            }
            if (Arrays.equals(new String[]{"FloatLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)FloatLiteral.class));
            }
            if (Arrays.equals(new String[]{"IntegerLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)IntegerLiteral.class));
            }
            if (Arrays.equals(new String[]{"PipeLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)PipeLiteral.class));
            }
            if (Arrays.equals(new String[]{"RegexpLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)RegexpLiteral.class));
            }
            if (Arrays.equals(new String[]{"StringLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)StringLiteral.class));
            }
            if (Arrays.equals(new String[]{"UnsignedIntegerLiteral"}, types)) {
                return context.deserialize(json, (Type)((Object)UnsignedIntegerLiteral.class));
            }
            if (Arrays.equals(new String[]{"Identifier"}, types)) {
                return context.deserialize(json, (Type)((Object)Identifier.class));
            }
            return context.deserialize(json, (Type)((Object)Object.class));
        }
    }
}

