/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.influxdb.client.domain.ConstantVariableProperties;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.MapVariableProperties;
import com.influxdb.client.domain.QueryVariableProperties;
import com.influxdb.client.domain.VariableLinks;
import com.influxdb.client.domain.VariableProperties;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Variable {
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private VariableLinks links = null;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ORG_I_D = "orgID";
    @SerializedName(value="orgID")
    private String orgID;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_SELECTED = "selected";
    @SerializedName(value="selected")
    private List<String> selected = new ArrayList<String>();
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    private List<Label> labels = new ArrayList<Label>();
    public static final String SERIALIZED_NAME_ARGUMENTS = "arguments";
    @SerializedName(value="arguments")
    @JsonAdapter(value=VariableArgumentsAdapter.class)
    private VariableProperties arguments = null;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt;

    public Variable links(VariableLinks links) {
        this.links = links;
        return this;
    }

    public VariableLinks getLinks() {
        return this.links;
    }

    public void setLinks(VariableLinks links) {
        this.links = links;
    }

    public String getId() {
        return this.id;
    }

    public Variable orgID(String orgID) {
        this.orgID = orgID;
        return this;
    }

    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    public Variable name(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Variable description(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Variable selected(List<String> selected) {
        this.selected = selected;
        return this;
    }

    public Variable addSelectedItem(String selectedItem) {
        if (this.selected == null) {
            this.selected = new ArrayList<String>();
        }
        this.selected.add(selectedItem);
        return this;
    }

    public List<String> getSelected() {
        return this.selected;
    }

    public void setSelected(List<String> selected) {
        this.selected = selected;
    }

    public Variable labels(List<Label> labels) {
        this.labels = labels;
        return this;
    }

    public Variable addLabelsItem(Label labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<Label>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public Variable arguments(VariableProperties arguments) {
        this.arguments = arguments;
        return this;
    }

    public VariableProperties getArguments() {
        return this.arguments;
    }

    public void setArguments(VariableProperties arguments) {
        this.arguments = arguments;
    }

    public Variable createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Variable updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variable variable = (Variable)o;
        return Objects.equals(this.links, variable.links) && Objects.equals(this.id, variable.id) && Objects.equals(this.orgID, variable.orgID) && Objects.equals(this.name, variable.name) && Objects.equals(this.description, variable.description) && Objects.equals(this.selected, variable.selected) && Objects.equals(this.labels, variable.labels) && Objects.equals(this.arguments, variable.arguments) && Objects.equals(this.createdAt, variable.createdAt) && Objects.equals(this.updatedAt, variable.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.id, this.orgID, this.name, this.description, this.selected, this.labels, this.arguments, this.createdAt, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Variable {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    orgID: ").append(this.toIndentedString(this.orgID)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    selected: ").append(this.toIndentedString(this.selected)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class VariableArgumentsAdapter
    implements JsonDeserializer<Object>,
    JsonSerializer<Object> {
        @Override
        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            List<String> discriminator = Arrays.asList("type");
            JsonObject jsonObject = json.getAsJsonObject();
            String[] types = (String[])discriminator.stream().map(jsonObject::get).filter(Objects::nonNull).map(JsonElement::getAsString).toArray(String[]::new);
            return this.deserialize(types, jsonObject, context);
        }

        @Override
        public JsonElement serialize(Object object, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(object);
        }

        private Object deserialize(String[] types, JsonElement json, JsonDeserializationContext context) {
            if (Arrays.equals(new String[]{"query"}, types)) {
                return context.deserialize(json, (Type)((Object)QueryVariableProperties.class));
            }
            if (Arrays.equals(new String[]{"constant"}, types)) {
                return context.deserialize(json, (Type)((Object)ConstantVariableProperties.class));
            }
            if (Arrays.equals(new String[]{"map"}, types)) {
                return context.deserialize(json, (Type)((Object)MapVariableProperties.class));
            }
            return context.deserialize(json, (Type)((Object)Object.class));
        }
    }
}

