/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.client.DashboardsApi;
import com.influxdb.client.domain.AddResourceMemberRequestBody;
import com.influxdb.client.domain.Cell;
import com.influxdb.client.domain.CellUpdate;
import com.influxdb.client.domain.CreateCell;
import com.influxdb.client.domain.CreateDashboardRequest;
import com.influxdb.client.domain.Dashboard;
import com.influxdb.client.domain.Dashboards;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.Organization;
import com.influxdb.client.domain.PatchDashboardRequest;
import com.influxdb.client.domain.ResourceMember;
import com.influxdb.client.domain.ResourceMembers;
import com.influxdb.client.domain.ResourceOwner;
import com.influxdb.client.domain.ResourceOwners;
import com.influxdb.client.domain.User;
import com.influxdb.client.domain.View;
import com.influxdb.client.service.DashboardsService;
import com.influxdb.internal.AbstractRestClient;
import com.influxdb.utils.Arguments;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import retrofit2.Call;

final class DashboardsApiImpl
extends AbstractRestClient
implements DashboardsApi {
    private final DashboardsService service;

    DashboardsApiImpl(@Nonnull DashboardsService service) {
        Arguments.checkNotNull(service, "service");
        this.service = service;
    }

    @Override
    public Dashboard createDashboard(@Nonnull String name, @Nullable String description, @Nonnull String orgID) {
        Arguments.checkNonEmpty(name, "name");
        Arguments.checkNonEmpty(description, "description");
        Arguments.checkNonEmpty(orgID, "orgID");
        return this.createDashboard(new CreateDashboardRequest().name(name).description(description).orgID(orgID));
    }

    @Override
    @Nonnull
    public Dashboard createDashboard(@Nonnull CreateDashboardRequest createDashboardRequest) {
        Arguments.checkNotNull(createDashboardRequest, "createDashboardRequest");
        Call<Dashboard> call = this.service.postDashboards(createDashboardRequest, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public Dashboard updateDashboard(@Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(dashboard, "Dashboard");
        PatchDashboardRequest request = new PatchDashboardRequest().name(dashboard.getName()).description(dashboard.getDescription());
        Call<Dashboard> call = this.service.patchDashboardsID(dashboard.getId(), null, request);
        return this.execute(call);
    }

    @Override
    public void deleteDashboard(@Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(dashboard, "dashboard");
        this.deleteDashboard(dashboard.getId());
    }

    @Override
    public void deleteDashboard(@Nonnull String dashboardID) {
        Arguments.checkNotNull(dashboardID, "dashboardID");
        Call<Void> call = this.service.deleteDashboardsID(dashboardID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Dashboard findDashboardByID(@Nonnull String dashboardID) {
        Arguments.checkNotNull(dashboardID, "dashboardID");
        Call<Dashboard> call = this.service.getDashboardsID(dashboardID, null, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public List<Dashboard> findDashboards() {
        return this.findDashboardsByOrgName(null);
    }

    @Override
    @Nonnull
    public List<Dashboard> findDashboardsByOrganization(@Nonnull Organization organization) {
        return this.findDashboardsByOrgName(organization.getName());
    }

    @Override
    @Nonnull
    public List<Dashboard> findDashboardsByOrgName(@Nullable String orgName) {
        Call<Dashboards> call = this.service.getDashboards(null, null, null, null, null, null, null, null, orgName);
        return this.execute(call).getDashboards();
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(dashboard, "dashboard");
        return this.getMembers(dashboard.getId());
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull String dashboardID) {
        Arguments.checkNotNull(dashboardID, "dashboardID");
        Call<ResourceMembers> call = this.service.getDashboardsIDMembers(dashboardID, null);
        return this.execute(call).getUsers();
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull User member, @Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(member, "member");
        Arguments.checkNotNull(dashboard, "dashboard");
        return this.addMember(member.getId(), dashboard.getId());
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull String memberID, @Nonnull String dashboardID) {
        Arguments.checkNotNull(memberID, "memberID");
        Arguments.checkNotNull(dashboardID, "dashboardID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody().id(memberID);
        Call<ResourceMember> call = this.service.postDashboardsIDMembers(dashboardID, user, null);
        return this.execute(call);
    }

    @Override
    public void deleteMember(@Nonnull User member, @Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(member, "member");
        Arguments.checkNotNull(dashboard, "dashboard");
        this.deleteMember(member.getId(), dashboard.getId());
    }

    @Override
    public void deleteMember(@Nonnull String memberID, @Nonnull String dashboardID) {
        Arguments.checkNotNull(memberID, "memberID");
        Arguments.checkNotNull(dashboardID, "dashboardID");
        Call<Void> call = this.service.deleteDashboardsIDMembersID(memberID, dashboardID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(dashboard, "dashboard");
        return this.getOwners(dashboard.getId());
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull String dashboardID) {
        Arguments.checkNotNull(dashboardID, "dashboardID");
        Call<ResourceOwners> call = this.service.getDashboardsIDOwners(dashboardID, null);
        return this.execute(call).getUsers();
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull User owner, @Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(owner, "owner");
        Arguments.checkNotNull(dashboard, "dashboard");
        return this.addOwner(owner.getId(), dashboard.getId());
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull String ownerID, @Nonnull String dashboardID) {
        Arguments.checkNotNull(ownerID, "ownerID");
        Arguments.checkNotNull(dashboardID, "dashboardID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody().id(ownerID);
        Call<ResourceOwner> call = this.service.postDashboardsIDOwners(dashboardID, user, null);
        return this.execute(call);
    }

    @Override
    public void deleteOwner(@Nonnull User owner, @Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(owner, "owner");
        Arguments.checkNotNull(dashboard, "dashboard");
        this.deleteOwner(owner.getId(), dashboard.getId());
    }

    @Override
    public void deleteOwner(@Nonnull String ownerID, @Nonnull String dashboardID) {
        Arguments.checkNotNull(ownerID, "ownerID");
        Arguments.checkNotNull(dashboardID, "dashboardID");
        Call<Void> call = this.service.deleteDashboardsIDOwnersID(ownerID, dashboardID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(dashboard, "dashboard");
        return this.getLabels(dashboard.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String dashboardID) {
        Arguments.checkNotNull(dashboardID, "dashboardID");
        Call<LabelsResponse> call = this.service.getDashboardsIDLabels(dashboardID, null);
        return this.execute(call).getLabels();
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull Label label, @Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(dashboard, "dashboard");
        return this.addLabel(label.getId(), dashboard.getId());
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull String labelID, @Nonnull String dashboardID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(dashboardID, "dashboardID");
        LabelMapping labelMapping = new LabelMapping().labelID(labelID);
        Call<LabelResponse> call = this.service.postDashboardsIDLabels(dashboardID, labelMapping, null);
        return this.execute(call);
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(dashboard, "dashboard");
        this.deleteLabel(label.getId(), dashboard.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String dashboardID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(dashboardID, "dashboardID");
        Call<Void> call = this.service.deleteDashboardsIDLabelsID(dashboardID, labelID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Cell addCell(@Nonnull CreateCell createCell, @Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(createCell, "createCell");
        Arguments.checkNotNull(dashboard, "dashboard");
        return this.addCell(createCell, dashboard.getId());
    }

    @Override
    @Nonnull
    public Cell addCell(@Nonnull CreateCell createCell, @Nonnull String dashboardID) {
        Arguments.checkNotNull(createCell, "createCell");
        Arguments.checkNonEmpty(dashboardID, "dashboardID");
        Call<Cell> call = this.service.postDashboardsIDCells(dashboardID, createCell, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public Dashboard replaceCells(@Nonnull List<Cell> cells, @Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(cells, "cells");
        Arguments.checkNotNull(dashboard, "dashboard");
        return this.replaceCells(cells, dashboard.getId());
    }

    @Override
    @Nonnull
    public Dashboard replaceCells(@Nonnull List<Cell> cells, @Nonnull String dashboardID) {
        Arguments.checkNotNull(cells, "cells");
        Arguments.checkNonEmpty(dashboardID, "dashboardID");
        Call<Dashboard> call = this.service.putDashboardsIDCells(dashboardID, cells, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public Cell updateCell(@Nonnull CellUpdate cellUpdate, @Nonnull String cellID, @Nonnull String dashboardID) {
        Arguments.checkNotNull(cellUpdate, "cellUpdate");
        Arguments.checkNonEmpty(cellID, "cellID");
        Arguments.checkNonEmpty(dashboardID, "dashboardID");
        Call<Cell> call = this.service.patchDashboardsIDCellsID(dashboardID, cellID, cellUpdate, null);
        return this.execute(call);
    }

    @Override
    public void deleteCell(@Nonnull Cell cell, @Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(cell, "cell");
        Arguments.checkNotNull(dashboard, "dashboard");
        this.deleteCell(cell.getId(), dashboard.getId());
    }

    @Override
    public void deleteCell(@Nonnull String cellID, @Nonnull String dashboardID) {
        Arguments.checkNonEmpty(cellID, "cellID");
        Arguments.checkNonEmpty(dashboardID, "dashboardID");
        Call<Void> call = this.service.deleteDashboardsIDCellsID(dashboardID, cellID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public View addCellView(@Nonnull View view, @Nonnull Cell cell, @Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(view, "view");
        Arguments.checkNotNull(cell, "cell");
        Arguments.checkNotNull(dashboard, "dashboard");
        return this.addCellView(view, cell.getId(), dashboard.getId());
    }

    @Override
    @Nonnull
    public View addCellView(@Nonnull View view, @Nonnull String cellID, @Nonnull String dashboardID) {
        Arguments.checkNotNull(view, "view");
        Arguments.checkNonEmpty(cellID, "cellID");
        Arguments.checkNonEmpty(dashboardID, "dashboardID");
        return this.updateCellView(view, cellID, dashboardID);
    }

    @Override
    @Nonnull
    public View updateCellView(@Nonnull View view, @Nonnull Cell cell, @Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(view, "view");
        Arguments.checkNotNull(cell, "cell");
        Arguments.checkNotNull(dashboard, "dashboard");
        return this.updateCellView(view, cell.getId(), dashboard.getId());
    }

    @Override
    @Nonnull
    public View updateCellView(@Nonnull View view, @Nonnull String cellID, @Nonnull String dashboardID) {
        Arguments.checkNotNull(view, "view");
        Arguments.checkNonEmpty(cellID, "cellID");
        Arguments.checkNonEmpty(dashboardID, "dashboardID");
        Call<View> call = this.service.patchDashboardsIDCellsIDView(dashboardID, cellID, view, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public View getCellView(@Nonnull Cell cell, @Nonnull Dashboard dashboard) {
        Arguments.checkNotNull(cell, "cell");
        Arguments.checkNotNull(dashboard, "dashboard");
        return this.getCellView(cell.getId(), dashboard.getId());
    }

    @Override
    @Nonnull
    public View getCellView(@Nonnull String cellID, @Nonnull String dashboardID) {
        Arguments.checkNonEmpty(cellID, "cellID");
        Arguments.checkNonEmpty(dashboardID, "dashboardID");
        Call<View> call = this.service.getDashboardsIDCellsIDView(dashboardID, cellID, null);
        return this.execute(call);
    }
}

