/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.exceptions;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kotlin.Pair;
import okhttp3.ResponseBody;
import retrofit2.HttpException;
import retrofit2.Response;

public class InfluxException
extends RuntimeException {
    private static final Logger LOG = Logger.getLogger(InfluxException.class.getName());
    private static final String HTTP_STATUS_CODE_MESSAGE = "HTTP status code: %d; Message: %s";
    private final Response<?> response;
    private final String message;
    private Map<String, Object> errorBody = new HashMap<String, Object>();

    public InfluxException(@Nullable String message) {
        this.response = null;
        this.message = message;
    }

    public InfluxException(@Nullable Throwable cause) {
        super(cause);
        this.response = cause instanceof HttpException ? ((HttpException)cause).response() : null;
        this.message = this.messageFromResponse();
    }

    public InfluxException(@Nullable Response<?> cause) {
        this.response = cause;
        this.message = this.messageFromResponse();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public int reference() {
        String reference = null;
        if (this.response != null) {
            reference = this.response.headers().get("X-Influx-Reference");
        }
        if (reference != null) {
            return Integer.valueOf(reference);
        }
        return 0;
    }

    public int status() {
        if (this.response != null) {
            return this.response.code();
        }
        return 0;
    }

    @Nonnull
    public Map<String, String> headers() {
        if (this.response != null) {
            return StreamSupport.stream(this.response.headers().spliterator(), false).collect(Collectors.toMap(Pair::component1, Pair::component2, (oldValue, newValue) -> newValue, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
        }
        return Collections.emptyMap();
    }

    @Nonnull
    public Map<String, Object> errorBody() {
        return this.errorBody;
    }

    @Nullable
    private String messageFromResponse() {
        Throwable cause;
        if (this.response != null) {
            int code = this.response.code();
            try {
                String json;
                ResponseBody body = this.response.errorBody();
                if (body != null && !(json = body.source().readUtf8()).isEmpty()) {
                    this.errorBody = (Map)new Gson().fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
                    if (this.errorBody.containsKey("message")) {
                        return String.format(HTTP_STATUS_CODE_MESSAGE, code, this.errorBody.get("message").toString());
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.FINEST, "Can't parse msg from response {}", this.response);
            }
            String value = Stream.of("X-Platform-Error-Code", "X-Influx-Error", "X-InfluxDb-Error").map(name -> this.response.headers().get((String)name)).filter(message -> message != null && !message.isEmpty()).findFirst().orElse(null);
            if (value != null) {
                return String.format(HTTP_STATUS_CODE_MESSAGE, code, value);
            }
        }
        if ((cause = this.getCause()) != null) {
            return cause.getMessage();
        }
        return null;
    }
}

