/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.core;

import io.reactivex.rxjava3.annotations.BackpressureKind;
import io.reactivex.rxjava3.annotations.BackpressureSupport;
import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.annotations.SchedulerSupport;
import io.reactivex.rxjava3.core.CompletableConverter;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableOnSubscribe;
import io.reactivex.rxjava3.core.CompletableOperator;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.CompletableTransformer;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Notification;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.BiPredicate;
import io.reactivex.rxjava3.functions.BooleanSupplier;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.fuseable.FuseToFlowable;
import io.reactivex.rxjava3.internal.fuseable.FuseToMaybe;
import io.reactivex.rxjava3.internal.fuseable.FuseToObservable;
import io.reactivex.rxjava3.internal.jdk8.CompletableFromCompletionStage;
import io.reactivex.rxjava3.internal.jdk8.CompletionStageConsumer;
import io.reactivex.rxjava3.internal.observers.BlockingDisposableMultiObserver;
import io.reactivex.rxjava3.internal.observers.BlockingMultiObserver;
import io.reactivex.rxjava3.internal.observers.CallbackCompletableObserver;
import io.reactivex.rxjava3.internal.observers.DisposableAutoReleaseMultiObserver;
import io.reactivex.rxjava3.internal.observers.EmptyCompletableObserver;
import io.reactivex.rxjava3.internal.observers.FutureMultiObserver;
import io.reactivex.rxjava3.internal.observers.SafeCompletableObserver;
import io.reactivex.rxjava3.internal.operators.completable.CompletableAmb;
import io.reactivex.rxjava3.internal.operators.completable.CompletableAndThenCompletable;
import io.reactivex.rxjava3.internal.operators.completable.CompletableCache;
import io.reactivex.rxjava3.internal.operators.completable.CompletableConcat;
import io.reactivex.rxjava3.internal.operators.completable.CompletableConcatArray;
import io.reactivex.rxjava3.internal.operators.completable.CompletableConcatIterable;
import io.reactivex.rxjava3.internal.operators.completable.CompletableCreate;
import io.reactivex.rxjava3.internal.operators.completable.CompletableDefer;
import io.reactivex.rxjava3.internal.operators.completable.CompletableDelay;
import io.reactivex.rxjava3.internal.operators.completable.CompletableDetach;
import io.reactivex.rxjava3.internal.operators.completable.CompletableDisposeOn;
import io.reactivex.rxjava3.internal.operators.completable.CompletableDoFinally;
import io.reactivex.rxjava3.internal.operators.completable.CompletableDoOnEvent;
import io.reactivex.rxjava3.internal.operators.completable.CompletableEmpty;
import io.reactivex.rxjava3.internal.operators.completable.CompletableError;
import io.reactivex.rxjava3.internal.operators.completable.CompletableErrorSupplier;
import io.reactivex.rxjava3.internal.operators.completable.CompletableFromAction;
import io.reactivex.rxjava3.internal.operators.completable.CompletableFromCallable;
import io.reactivex.rxjava3.internal.operators.completable.CompletableFromObservable;
import io.reactivex.rxjava3.internal.operators.completable.CompletableFromPublisher;
import io.reactivex.rxjava3.internal.operators.completable.CompletableFromRunnable;
import io.reactivex.rxjava3.internal.operators.completable.CompletableFromSingle;
import io.reactivex.rxjava3.internal.operators.completable.CompletableFromSupplier;
import io.reactivex.rxjava3.internal.operators.completable.CompletableFromUnsafeSource;
import io.reactivex.rxjava3.internal.operators.completable.CompletableHide;
import io.reactivex.rxjava3.internal.operators.completable.CompletableLift;
import io.reactivex.rxjava3.internal.operators.completable.CompletableMaterialize;
import io.reactivex.rxjava3.internal.operators.completable.CompletableMerge;
import io.reactivex.rxjava3.internal.operators.completable.CompletableMergeArray;
import io.reactivex.rxjava3.internal.operators.completable.CompletableMergeArrayDelayError;
import io.reactivex.rxjava3.internal.operators.completable.CompletableMergeDelayErrorIterable;
import io.reactivex.rxjava3.internal.operators.completable.CompletableMergeIterable;
import io.reactivex.rxjava3.internal.operators.completable.CompletableNever;
import io.reactivex.rxjava3.internal.operators.completable.CompletableObserveOn;
import io.reactivex.rxjava3.internal.operators.completable.CompletableOnErrorComplete;
import io.reactivex.rxjava3.internal.operators.completable.CompletableOnErrorReturn;
import io.reactivex.rxjava3.internal.operators.completable.CompletablePeek;
import io.reactivex.rxjava3.internal.operators.completable.CompletableResumeNext;
import io.reactivex.rxjava3.internal.operators.completable.CompletableSubscribeOn;
import io.reactivex.rxjava3.internal.operators.completable.CompletableTakeUntilCompletable;
import io.reactivex.rxjava3.internal.operators.completable.CompletableTimeout;
import io.reactivex.rxjava3.internal.operators.completable.CompletableTimer;
import io.reactivex.rxjava3.internal.operators.completable.CompletableToFlowable;
import io.reactivex.rxjava3.internal.operators.completable.CompletableToObservable;
import io.reactivex.rxjava3.internal.operators.completable.CompletableToSingle;
import io.reactivex.rxjava3.internal.operators.completable.CompletableUsing;
import io.reactivex.rxjava3.internal.operators.maybe.MaybeDelayWithCompletable;
import io.reactivex.rxjava3.internal.operators.maybe.MaybeFromCompletable;
import io.reactivex.rxjava3.internal.operators.maybe.MaybeIgnoreElementCompletable;
import io.reactivex.rxjava3.internal.operators.mixed.CompletableAndThenObservable;
import io.reactivex.rxjava3.internal.operators.mixed.CompletableAndThenPublisher;
import io.reactivex.rxjava3.internal.operators.mixed.FlowableSwitchMapCompletablePublisher;
import io.reactivex.rxjava3.internal.operators.single.SingleDelayWithCompletable;
import io.reactivex.rxjava3.observers.TestObserver;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;

public abstract class Completable
implements CompletableSource {
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static Completable ambArray(CompletableSource ... sources) {
        Objects.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Completable.complete();
        }
        if (sources.length == 1) {
            return Completable.wrap(sources[0]);
        }
        return RxJavaPlugins.onAssembly(new CompletableAmb(sources, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable amb(@NonNull @NonNull Iterable<@NonNull ? extends CompletableSource> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new CompletableAmb(null, sources));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable complete() {
        return RxJavaPlugins.onAssembly(CompletableEmpty.INSTANCE);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static Completable concatArray(CompletableSource ... sources) {
        Objects.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Completable.complete();
        }
        if (sources.length == 1) {
            return Completable.wrap(sources[0]);
        }
        return RxJavaPlugins.onAssembly(new CompletableConcatArray(sources));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static Completable concatArrayDelayError(CompletableSource ... sources) {
        return Flowable.fromArray(sources).concatMapCompletableDelayError(Functions.identity(), true, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable concat(@NonNull @NonNull Iterable<@NonNull ? extends CompletableSource> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new CompletableConcatIterable(sources));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static Completable concat(@NonNull @NonNull Publisher<@NonNull ? extends CompletableSource> sources) {
        return Completable.concat(sources, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static Completable concat(@NonNull @NonNull Publisher<@NonNull ? extends CompletableSource> sources, int prefetch) {
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new CompletableConcat(sources, prefetch));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable concatDelayError(@NonNull @NonNull Iterable<@NonNull ? extends CompletableSource> sources) {
        return Flowable.fromIterable(sources).concatMapCompletableDelayError(Functions.identity());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static Completable concatDelayError(@NonNull @NonNull Publisher<@NonNull ? extends CompletableSource> sources) {
        return Completable.concatDelayError(sources, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static Completable concatDelayError(@NonNull @NonNull Publisher<@NonNull ? extends CompletableSource> sources, int prefetch) {
        return Flowable.fromPublisher(sources).concatMapCompletableDelayError(Functions.identity(), true, prefetch);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable create(@NonNull CompletableOnSubscribe source2) {
        Objects.requireNonNull(source2, "source is null");
        return RxJavaPlugins.onAssembly(new CompletableCreate(source2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Single<Boolean> sequenceEqual(@NonNull CompletableSource source1, @NonNull CompletableSource source2) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        return Completable.mergeArrayDelayError(source1, source2).andThen(Single.just(true));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable unsafeCreate(@NonNull CompletableSource onSubscribe) {
        Objects.requireNonNull(onSubscribe, "onSubscribe is null");
        if (onSubscribe instanceof Completable) {
            throw new IllegalArgumentException("Use of unsafeCreate(Completable)!");
        }
        return RxJavaPlugins.onAssembly(new CompletableFromUnsafeSource(onSubscribe));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable defer(@NonNull @NonNull Supplier<? extends @NonNull CompletableSource> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new CompletableDefer(supplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable error(@NonNull @NonNull Supplier<? extends @NonNull Throwable> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new CompletableErrorSupplier(supplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable error(@NonNull Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable is null");
        return RxJavaPlugins.onAssembly(new CompletableError(throwable));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable fromAction(@NonNull Action action) {
        Objects.requireNonNull(action, "action is null");
        return RxJavaPlugins.onAssembly(new CompletableFromAction(action));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable fromCallable(@NonNull Callable<?> callable) {
        Objects.requireNonNull(callable, "callable is null");
        return RxJavaPlugins.onAssembly(new CompletableFromCallable(callable));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable fromFuture(@NonNull Future<?> future) {
        Objects.requireNonNull(future, "future is null");
        return Completable.fromAction(Functions.futureAction(future));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Completable fromMaybe(@NonNull MaybeSource<T> maybe) {
        Objects.requireNonNull(maybe, "maybe is null");
        return RxJavaPlugins.onAssembly(new MaybeIgnoreElementCompletable<T>(maybe));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable fromRunnable(@NonNull Runnable run) {
        Objects.requireNonNull(run, "run is null");
        return RxJavaPlugins.onAssembly(new CompletableFromRunnable(run));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Completable fromObservable(@NonNull ObservableSource<T> observable2) {
        Objects.requireNonNull(observable2, "observable is null");
        return RxJavaPlugins.onAssembly(new CompletableFromObservable<T>(observable2));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Completable fromPublisher(@NonNull Publisher<T> publisher) {
        Objects.requireNonNull(publisher, "publisher is null");
        return RxJavaPlugins.onAssembly(new CompletableFromPublisher<T>(publisher));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Completable fromSingle(@NonNull SingleSource<T> single) {
        Objects.requireNonNull(single, "single is null");
        return RxJavaPlugins.onAssembly(new CompletableFromSingle<T>(single));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable fromSupplier(@NonNull Supplier<?> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new CompletableFromSupplier(supplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static Completable mergeArray(CompletableSource ... sources) {
        Objects.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Completable.complete();
        }
        if (sources.length == 1) {
            return Completable.wrap(sources[0]);
        }
        return RxJavaPlugins.onAssembly(new CompletableMergeArray(sources));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable merge(@NonNull @NonNull Iterable<@NonNull ? extends CompletableSource> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new CompletableMergeIterable(sources));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @NonNull
    public static Completable merge(@NonNull @NonNull Publisher<@NonNull ? extends CompletableSource> sources) {
        return Completable.merge0(sources, Integer.MAX_VALUE, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static Completable merge(@NonNull @NonNull Publisher<@NonNull ? extends CompletableSource> sources, int maxConcurrency) {
        return Completable.merge0(sources, maxConcurrency, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    private static Completable merge0(@NonNull @NonNull Publisher<@NonNull ? extends CompletableSource> sources, int maxConcurrency, boolean delayErrors) {
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        return RxJavaPlugins.onAssembly(new CompletableMerge(sources, maxConcurrency, delayErrors));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static Completable mergeArrayDelayError(CompletableSource ... sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new CompletableMergeArrayDelayError(sources));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable mergeDelayError(@NonNull @NonNull Iterable<@NonNull ? extends CompletableSource> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new CompletableMergeDelayErrorIterable(sources));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @NonNull
    public static Completable mergeDelayError(@NonNull @NonNull Publisher<@NonNull ? extends CompletableSource> sources) {
        return Completable.merge0(sources, Integer.MAX_VALUE, true);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static Completable mergeDelayError(@NonNull @NonNull Publisher<@NonNull ? extends CompletableSource> sources, int maxConcurrency) {
        return Completable.merge0(sources, maxConcurrency, true);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable never() {
        return RxJavaPlugins.onAssembly(CompletableNever.INSTANCE);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public static Completable timer(long delay, @NonNull TimeUnit unit) {
        return Completable.timer(delay, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public static Completable timer(long delay, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new CompletableTimer(delay, unit, scheduler));
    }

    private static NullPointerException toNpe(Throwable ex) {
        NullPointerException npe = new NullPointerException("Actually not, but can't pass out an exception otherwise...");
        npe.initCause(ex);
        return npe;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @NonNull
    public static Completable switchOnNext(@NonNull @NonNull Publisher<@NonNull ? extends CompletableSource> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new FlowableSwitchMapCompletablePublisher<CompletableSource>(sources, Functions.identity(), false));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @NonNull
    public static Completable switchOnNextDelayError(@NonNull @NonNull Publisher<@NonNull ? extends CompletableSource> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new FlowableSwitchMapCompletablePublisher<CompletableSource>(sources, Functions.identity(), true));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <R> Completable using(@NonNull Supplier<R> resourceSupplier, @NonNull Function<? super R, ? extends CompletableSource> sourceSupplier, @NonNull Consumer<? super R> resourceCleanup) {
        return Completable.using(resourceSupplier, sourceSupplier, resourceCleanup, true);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <R> Completable using(@NonNull Supplier<R> resourceSupplier, @NonNull Function<? super R, ? extends CompletableSource> sourceSupplier, @NonNull Consumer<? super R> resourceCleanup, boolean eager) {
        Objects.requireNonNull(resourceSupplier, "resourceSupplier is null");
        Objects.requireNonNull(sourceSupplier, "sourceSupplier is null");
        Objects.requireNonNull(resourceCleanup, "resourceCleanup is null");
        return RxJavaPlugins.onAssembly(new CompletableUsing<R>(resourceSupplier, sourceSupplier, resourceCleanup, eager));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable wrap(@NonNull CompletableSource source2) {
        Objects.requireNonNull(source2, "source is null");
        if (source2 instanceof Completable) {
            return RxJavaPlugins.onAssembly((Completable)source2);
        }
        return RxJavaPlugins.onAssembly(new CompletableFromUnsafeSource(source2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable ambWith(@NonNull CompletableSource other) {
        Objects.requireNonNull(other, "other is null");
        return Completable.ambArray(this, other);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <T> Observable<T> andThen(@NonNull ObservableSource<T> next) {
        Objects.requireNonNull(next, "next is null");
        return RxJavaPlugins.onAssembly(new CompletableAndThenObservable<T>(this, next));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <T> Flowable<T> andThen(@NonNull Publisher<T> next) {
        Objects.requireNonNull(next, "next is null");
        return RxJavaPlugins.onAssembly(new CompletableAndThenPublisher<T>(this, next));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <T> Single<T> andThen(@NonNull SingleSource<T> next) {
        Objects.requireNonNull(next, "next is null");
        return RxJavaPlugins.onAssembly(new SingleDelayWithCompletable<T>(next, this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <T> Maybe<T> andThen(@NonNull MaybeSource<T> next) {
        Objects.requireNonNull(next, "next is null");
        return RxJavaPlugins.onAssembly(new MaybeDelayWithCompletable<T>(next, this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable andThen(@NonNull CompletableSource next) {
        Objects.requireNonNull(next, "next is null");
        return RxJavaPlugins.onAssembly(new CompletableAndThenCompletable(this, next));
    }

    @SchedulerSupport(value="none")
    public final void blockingAwait() {
        BlockingMultiObserver observer = new BlockingMultiObserver();
        this.subscribe(observer);
        observer.blockingGet();
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final boolean blockingAwait(long timeout2, @NonNull TimeUnit unit) {
        Objects.requireNonNull(unit, "unit is null");
        BlockingMultiObserver observer = new BlockingMultiObserver();
        this.subscribe(observer);
        return observer.blockingAwait(timeout2, unit);
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe() {
        this.blockingSubscribe(Functions.EMPTY_ACTION, Functions.ERROR_CONSUMER);
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull Action onComplete) {
        this.blockingSubscribe(onComplete, Functions.ERROR_CONSUMER);
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull Action onComplete, @NonNull Consumer<? super Throwable> onError) {
        Objects.requireNonNull(onComplete, "onComplete is null");
        Objects.requireNonNull(onError, "onError is null");
        BlockingMultiObserver observer = new BlockingMultiObserver();
        this.subscribe(observer);
        observer.blockingConsume(Functions.emptyConsumer(), onError, onComplete);
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull CompletableObserver observer) {
        Objects.requireNonNull(observer, "observer is null");
        BlockingDisposableMultiObserver blockingObserver = new BlockingDisposableMultiObserver();
        observer.onSubscribe(blockingObserver);
        this.subscribe(blockingObserver);
        blockingObserver.blockingConsume(observer);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable cache() {
        return RxJavaPlugins.onAssembly(new CompletableCache(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable compose(@NonNull CompletableTransformer transformer) {
        return Completable.wrap(Objects.requireNonNull(transformer, "transformer is null").apply(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable concatWith(@NonNull CompletableSource other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new CompletableAndThenCompletable(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Completable delay(long time, @NonNull TimeUnit unit) {
        return this.delay(time, unit, Schedulers.computation(), false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Completable delay(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.delay(time, unit, scheduler, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Completable delay(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean delayError) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new CompletableDelay(this, time, unit, scheduler, delayError));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Completable delaySubscription(long time, @NonNull TimeUnit unit) {
        return this.delaySubscription(time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Completable delaySubscription(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return Completable.timer(time, unit, scheduler).andThen(this);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable doOnComplete(@NonNull Action onComplete) {
        return this.doOnLifecycle(Functions.emptyConsumer(), Functions.emptyConsumer(), onComplete, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable doOnDispose(@NonNull Action onDispose) {
        return this.doOnLifecycle(Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, onDispose);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable doOnError(@NonNull Consumer<? super Throwable> onError) {
        return this.doOnLifecycle(Functions.emptyConsumer(), onError, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable doOnEvent(@NonNull Consumer<@Nullable ? super Throwable> onEvent) {
        Objects.requireNonNull(onEvent, "onEvent is null");
        return RxJavaPlugins.onAssembly(new CompletableDoOnEvent(this, onEvent));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable doOnLifecycle(@NonNull Consumer<? super Disposable> onSubscribe, @NonNull Action onDispose) {
        return this.doOnLifecycle(onSubscribe, Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, onDispose);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    private Completable doOnLifecycle(Consumer<? super Disposable> onSubscribe, Consumer<? super Throwable> onError, Action onComplete, Action onTerminate, Action onAfterTerminate, Action onDispose) {
        Objects.requireNonNull(onSubscribe, "onSubscribe is null");
        Objects.requireNonNull(onError, "onError is null");
        Objects.requireNonNull(onComplete, "onComplete is null");
        Objects.requireNonNull(onTerminate, "onTerminate is null");
        Objects.requireNonNull(onAfterTerminate, "onAfterTerminate is null");
        Objects.requireNonNull(onDispose, "onDispose is null");
        return RxJavaPlugins.onAssembly(new CompletablePeek(this, onSubscribe, onError, onComplete, onTerminate, onAfterTerminate, onDispose));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable doOnSubscribe(@NonNull Consumer<? super Disposable> onSubscribe) {
        return this.doOnLifecycle(onSubscribe, Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable doOnTerminate(@NonNull Action onTerminate) {
        return this.doOnLifecycle(Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.EMPTY_ACTION, onTerminate, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable doAfterTerminate(@NonNull Action onAfterTerminate) {
        return this.doOnLifecycle(Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, onAfterTerminate, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable doFinally(@NonNull Action onFinally) {
        Objects.requireNonNull(onFinally, "onFinally is null");
        return RxJavaPlugins.onAssembly(new CompletableDoFinally(this, onFinally));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable lift(@NonNull CompletableOperator onLift) {
        Objects.requireNonNull(onLift, "onLift is null");
        return RxJavaPlugins.onAssembly(new CompletableLift(this, onLift));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <T> Single<Notification<T>> materialize() {
        return RxJavaPlugins.onAssembly(new CompletableMaterialize(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable mergeWith(@NonNull CompletableSource other) {
        Objects.requireNonNull(other, "other is null");
        return Completable.mergeArray(this, other);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Completable observeOn(@NonNull Scheduler scheduler) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new CompletableObserveOn(this, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable onErrorComplete() {
        return this.onErrorComplete(Functions.alwaysTrue());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable onErrorComplete(@NonNull Predicate<? super Throwable> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new CompletableOnErrorComplete(this, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable onErrorResumeNext(@NonNull Function<? super Throwable, ? extends CompletableSource> fallbackSupplier) {
        Objects.requireNonNull(fallbackSupplier, "fallbackSupplier is null");
        return RxJavaPlugins.onAssembly(new CompletableResumeNext(this, fallbackSupplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable onErrorResumeWith(@NonNull CompletableSource fallback) {
        Objects.requireNonNull(fallback, "fallback is null");
        return this.onErrorResumeNext(Functions.justFunction(fallback));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <T> Maybe<T> onErrorReturn(@NonNull Function<? super Throwable, ? extends T> itemSupplier) {
        Objects.requireNonNull(itemSupplier, "itemSupplier is null");
        return RxJavaPlugins.onAssembly(new CompletableOnErrorReturn<T>(this, itemSupplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <T> Maybe<T> onErrorReturnItem(@NonNull T item) {
        Objects.requireNonNull(item, "item is null");
        return this.onErrorReturn(Functions.justFunction(item));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable onTerminateDetach() {
        return RxJavaPlugins.onAssembly(new CompletableDetach(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable repeat() {
        return Completable.fromPublisher(this.toFlowable().repeat());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable repeat(long times) {
        return Completable.fromPublisher(this.toFlowable().repeat(times));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable repeatUntil(@NonNull BooleanSupplier stop) {
        return Completable.fromPublisher(this.toFlowable().repeatUntil(stop));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable repeatWhen(@NonNull @NonNull Function<? super Flowable<Object>, @NonNull ? extends Publisher<@NonNull ?>> handler) {
        return Completable.fromPublisher(this.toFlowable().repeatWhen(handler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable retry() {
        return Completable.fromPublisher(this.toFlowable().retry());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable retry(@NonNull BiPredicate<? super Integer, ? super Throwable> predicate) {
        return Completable.fromPublisher(this.toFlowable().retry(predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable retry(long times) {
        return Completable.fromPublisher(this.toFlowable().retry(times));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable retry(long times, @NonNull Predicate<? super Throwable> predicate) {
        return Completable.fromPublisher(this.toFlowable().retry(times, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable retry(@NonNull Predicate<? super Throwable> predicate) {
        return Completable.fromPublisher(this.toFlowable().retry(predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable retryUntil(@NonNull BooleanSupplier stop) {
        Objects.requireNonNull(stop, "stop is null");
        return this.retry(Long.MAX_VALUE, Functions.predicateReverseFor(stop));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable retryWhen(@NonNull @NonNull Function<? super Flowable<Throwable>, @NonNull ? extends Publisher<@NonNull ?>> handler) {
        return Completable.fromPublisher(this.toFlowable().retryWhen(handler));
    }

    @SchedulerSupport(value="none")
    public final void safeSubscribe(@NonNull CompletableObserver observer) {
        Objects.requireNonNull(observer, "observer is null");
        this.subscribe(new SafeCompletableObserver(observer));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable startWith(@NonNull CompletableSource other) {
        Objects.requireNonNull(other, "other is null");
        return Completable.concatArray(other, this);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public final <T> Flowable<T> startWith(@NonNull SingleSource<T> other) {
        Objects.requireNonNull(other, "other is null");
        return Flowable.concat(Single.wrap(other).toFlowable(), this.toFlowable());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public final <T> Flowable<T> startWith(@NonNull MaybeSource<T> other) {
        Objects.requireNonNull(other, "other is null");
        return Flowable.concat(Maybe.wrap(other).toFlowable(), this.toFlowable());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <T> Observable<T> startWith(@NonNull ObservableSource<T> other) {
        Objects.requireNonNull(other, "other is null");
        return Observable.wrap(other).concatWith(this.toObservable());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <T> Flowable<T> startWith(@NonNull Publisher<T> other) {
        Objects.requireNonNull(other, "other is null");
        return this.toFlowable().startWith(other);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable hide() {
        return RxJavaPlugins.onAssembly(new CompletableHide(this));
    }

    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe() {
        EmptyCompletableObserver observer = new EmptyCompletableObserver();
        this.subscribe(observer);
        return observer;
    }

    @Override
    @SchedulerSupport(value="none")
    public final void subscribe(@NonNull CompletableObserver observer) {
        Objects.requireNonNull(observer, "observer is null");
        try {
            observer = RxJavaPlugins.onSubscribe(this, observer);
            Objects.requireNonNull(observer, "The RxJavaPlugins.onSubscribe hook returned a null CompletableObserver. Please check the handler provided to RxJavaPlugins.setOnCompletableSubscribe for invalid null returns. Further reading: https://github.com/ReactiveX/RxJava/wiki/Plugins");
            this.subscribeActual(observer);
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            RxJavaPlugins.onError(ex);
            throw Completable.toNpe(ex);
        }
    }

    protected abstract void subscribeActual(@NonNull CompletableObserver var1);

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <E extends CompletableObserver> E subscribeWith(E observer) {
        this.subscribe(observer);
        return observer;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe(@NonNull Action onComplete, @NonNull Consumer<? super Throwable> onError) {
        Objects.requireNonNull(onError, "onError is null");
        Objects.requireNonNull(onComplete, "onComplete is null");
        CallbackCompletableObserver observer = new CallbackCompletableObserver(onError, onComplete);
        this.subscribe(observer);
        return observer;
    }

    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe(@NonNull Action onComplete, @NonNull Consumer<? super Throwable> onError, @NonNull DisposableContainer container) {
        Objects.requireNonNull(onComplete, "onComplete is null");
        Objects.requireNonNull(onError, "onError is null");
        Objects.requireNonNull(container, "container is null");
        DisposableAutoReleaseMultiObserver observer = new DisposableAutoReleaseMultiObserver(container, Functions.emptyConsumer(), onError, onComplete);
        container.add(observer);
        this.subscribe(observer);
        return observer;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe(@NonNull Action onComplete) {
        return this.subscribe(onComplete, Functions.ON_ERROR_MISSING);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Completable subscribeOn(@NonNull Scheduler scheduler) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new CompletableSubscribeOn(this, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable takeUntil(@NonNull CompletableSource other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new CompletableTakeUntilCompletable(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Completable timeout(long timeout2, @NonNull TimeUnit unit) {
        return this.timeout0(timeout2, unit, Schedulers.computation(), null);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Completable timeout(long timeout2, @NonNull TimeUnit unit, @NonNull CompletableSource fallback) {
        Objects.requireNonNull(fallback, "fallback is null");
        return this.timeout0(timeout2, unit, Schedulers.computation(), fallback);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Completable timeout(long timeout2, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.timeout0(timeout2, unit, scheduler, null);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Completable timeout(long timeout2, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, @NonNull CompletableSource fallback) {
        Objects.requireNonNull(fallback, "fallback is null");
        return this.timeout0(timeout2, unit, scheduler, fallback);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    private Completable timeout0(long timeout2, TimeUnit unit, Scheduler scheduler, CompletableSource fallback) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new CompletableTimeout(this, timeout2, unit, scheduler, fallback));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <R> R to(@NonNull CompletableConverter<? extends R> converter) {
        return Objects.requireNonNull(converter, "converter is null").apply(this);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <T> Flowable<T> toFlowable() {
        if (this instanceof FuseToFlowable) {
            return ((FuseToFlowable)((Object)this)).fuseToFlowable();
        }
        return RxJavaPlugins.onAssembly(new CompletableToFlowable(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Future<Void> toFuture() {
        return this.subscribeWith(new FutureMultiObserver());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <T> Maybe<T> toMaybe() {
        if (this instanceof FuseToMaybe) {
            return ((FuseToMaybe)((Object)this)).fuseToMaybe();
        }
        return RxJavaPlugins.onAssembly(new MaybeFromCompletable(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <T> Observable<T> toObservable() {
        if (this instanceof FuseToObservable) {
            return ((FuseToObservable)((Object)this)).fuseToObservable();
        }
        return RxJavaPlugins.onAssembly(new CompletableToObservable(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <T> Single<T> toSingle(@NonNull Supplier<? extends T> completionValueSupplier) {
        Objects.requireNonNull(completionValueSupplier, "completionValueSupplier is null");
        return RxJavaPlugins.onAssembly(new CompletableToSingle<Object>(this, completionValueSupplier, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <T> Single<T> toSingleDefault(T completionValue) {
        Objects.requireNonNull(completionValue, "completionValue is null");
        return RxJavaPlugins.onAssembly(new CompletableToSingle<T>(this, null, completionValue));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Completable unsubscribeOn(@NonNull Scheduler scheduler) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new CompletableDisposeOn(this, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final TestObserver<Void> test() {
        TestObserver<Void> to = new TestObserver<Void>();
        this.subscribe(to);
        return to;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final TestObserver<Void> test(boolean dispose) {
        TestObserver<Void> to = new TestObserver<Void>();
        if (dispose) {
            to.dispose();
        }
        this.subscribe(to);
        return to;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Completable fromCompletionStage(@NonNull CompletionStage<?> stage) {
        Objects.requireNonNull(stage, "stage is null");
        return RxJavaPlugins.onAssembly(new CompletableFromCompletionStage(stage));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <T> CompletionStage<T> toCompletionStage(T defaultItem) {
        return this.subscribeWith(new CompletionStageConsumer<T>(true, defaultItem));
    }
}

