/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableThrottleLatest<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean emitLast;
    final Consumer<? super T> onDropped;

    public FlowableThrottleLatest(Flowable<T> source2, long timeout2, TimeUnit unit, Scheduler scheduler, boolean emitLast, Consumer<? super T> onDropped) {
        super(source2);
        this.timeout = timeout2;
        this.unit = unit;
        this.scheduler = scheduler;
        this.emitLast = emitLast;
        this.onDropped = onDropped;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new ThrottleLatestSubscriber<T>(s, this.timeout, this.unit, this.scheduler.createWorker(), this.emitLast, this.onDropped));
    }

    static final class ThrottleLatestSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -8296689127439125014L;
        final Subscriber<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final boolean emitLast;
        final AtomicReference<T> latest;
        final AtomicLong requested;
        final Consumer<? super T> onDropped;
        Subscription upstream;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;
        volatile boolean timerFired;
        long emitted;
        boolean timerRunning;

        ThrottleLatestSubscriber(Subscriber<? super T> downstream, long timeout2, TimeUnit unit, Scheduler.Worker worker, boolean emitLast, Consumer<? super T> onDropped) {
            this.downstream = downstream;
            this.timeout = timeout2;
            this.unit = unit;
            this.worker = worker;
            this.emitLast = emitLast;
            this.latest = new AtomicReference();
            this.requested = new AtomicLong();
            this.onDropped = onDropped;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            T old = this.latest.getAndSet(t);
            if (this.onDropped != null && old != null) {
                try {
                    this.onDropped.accept(old);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.upstream.cancel();
                    this.error = ex;
                    this.done = true;
                }
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.worker.dispose();
            if (this.getAndIncrement() == 0) {
                this.clear();
            }
        }

        void clear() {
            if (this.onDropped != null) {
                Object v = this.latest.getAndSet(null);
                if (v != null) {
                    try {
                        this.onDropped.accept(v);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        RxJavaPlugins.onError(ex);
                    }
                }
            } else {
                this.latest.lazySet(null);
            }
        }

        @Override
        public void run() {
            this.timerFired = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            AtomicReference<T> latest = this.latest;
            AtomicLong requested = this.requested;
            Subscriber<T> downstream = this.downstream;
            while (true) {
                long e;
                boolean empty;
                T v;
                if (this.cancelled) {
                    this.clear();
                    return;
                }
                boolean d = this.done;
                Throwable error = this.error;
                if (d && error != null) {
                    if (this.onDropped != null) {
                        v = latest.getAndSet(null);
                        if (v != null) {
                            try {
                                this.onDropped.accept(v);
                            }
                            catch (Throwable ex) {
                                Exceptions.throwIfFatal(ex);
                                error = new CompositeException(error, ex);
                            }
                        }
                    } else {
                        latest.lazySet(null);
                    }
                    downstream.onError(error);
                    this.worker.dispose();
                    return;
                }
                v = latest.get();
                boolean bl = empty = v == null;
                if (d) {
                    if (!empty) {
                        v = latest.getAndSet(null);
                        if (this.emitLast) {
                            e = this.emitted;
                            if (e != requested.get()) {
                                this.emitted = e + 1L;
                                downstream.onNext(v);
                                downstream.onComplete();
                            } else {
                                this.tryDropAndSignalMBE(v);
                            }
                        } else {
                            if (this.onDropped != null) {
                                try {
                                    this.onDropped.accept(v);
                                }
                                catch (Throwable ex) {
                                    Exceptions.throwIfFatal(ex);
                                    downstream.onError(ex);
                                    this.worker.dispose();
                                    return;
                                }
                            }
                            downstream.onComplete();
                        }
                    } else {
                        downstream.onComplete();
                    }
                    this.worker.dispose();
                    return;
                }
                if (empty) {
                    if (this.timerFired) {
                        this.timerRunning = false;
                        this.timerFired = false;
                    }
                } else if (!this.timerRunning || this.timerFired) {
                    v = latest.getAndSet(null);
                    e = this.emitted;
                    if (e == requested.get()) {
                        this.upstream.cancel();
                        this.tryDropAndSignalMBE(v);
                        this.worker.dispose();
                        return;
                    }
                    downstream.onNext(v);
                    this.emitted = e + 1L;
                    this.timerFired = false;
                    this.timerRunning = true;
                    this.worker.schedule(this, this.timeout, this.unit);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void tryDropAndSignalMBE(T valueToDrop) {
            RuntimeException errorToSignal = MissingBackpressureException.createDefault();
            if (this.onDropped != null) {
                try {
                    this.onDropped.accept(valueToDrop);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    errorToSignal = new CompositeException(errorToSignal, ex);
                }
            }
            this.downstream.onError(errorToSignal);
        }
    }
}

