/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public final class SingleEquals<T>
extends Single<Boolean> {
    final SingleSource<? extends T> first;
    final SingleSource<? extends T> second;

    public SingleEquals(SingleSource<? extends T> first, SingleSource<? extends T> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super Boolean> observer) {
        AtomicInteger count = new AtomicInteger();
        Object[] values2 = new Object[]{null, null};
        CompositeDisposable set = new CompositeDisposable();
        observer.onSubscribe(set);
        this.first.subscribe(new InnerObserver(0, set, values2, observer, count));
        this.second.subscribe(new InnerObserver(1, set, values2, observer, count));
    }

    static class InnerObserver<T>
    implements SingleObserver<T> {
        final int index;
        final CompositeDisposable set;
        final Object[] values;
        final SingleObserver<? super Boolean> downstream;
        final AtomicInteger count;

        InnerObserver(int index, CompositeDisposable set, Object[] values2, SingleObserver<? super Boolean> observer, AtomicInteger count) {
            this.index = index;
            this.set = set;
            this.values = values2;
            this.downstream = observer;
            this.count = count;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.set.add(d);
        }

        @Override
        public void onSuccess(T value) {
            this.values[this.index] = value;
            if (this.count.incrementAndGet() == 2) {
                this.downstream.onSuccess((Boolean)Objects.equals(this.values[0], this.values[1]));
            }
        }

        @Override
        public void onError(Throwable e) {
            int state = this.count.getAndSet(-1);
            if (state == 0 || state == 1) {
                this.set.dispose();
                this.downstream.onError(e);
            } else {
                RxJavaPlugins.onError(e);
            }
        }
    }
}

