/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.observers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.VolatileSizeArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class BaseTestConsumer<T, U extends BaseTestConsumer<T, U>> {
    protected final CountDownLatch done;
    protected final List<T> values = new VolatileSizeArrayList();
    protected final List<Throwable> errors = new VolatileSizeArrayList<Throwable>();
    protected long completions;
    protected Thread lastThread;
    protected boolean checkSubscriptionOnce;
    protected CharSequence tag;
    protected boolean timeout;

    public BaseTestConsumer() {
        this.done = new CountDownLatch(1);
    }

    @NonNull
    public final List<T> values() {
        return this.values;
    }

    @NonNull
    protected final AssertionError fail(@NonNull String message) {
        CharSequence tag;
        StringBuilder b = new StringBuilder(64 + message.length());
        b.append(message);
        b.append(" (").append("latch = ").append(this.done.getCount()).append(", ").append("values = ").append(this.values.size()).append(", ").append("errors = ").append(this.errors.size()).append(", ").append("completions = ").append(this.completions);
        if (this.timeout) {
            b.append(", timeout!");
        }
        if (this.isDisposed()) {
            b.append(", disposed!");
        }
        if ((tag = this.tag) != null) {
            b.append(", tag = ").append(tag);
        }
        b.append(')');
        AssertionError ae = new AssertionError((Object)b.toString());
        if (!this.errors.isEmpty()) {
            if (this.errors.size() == 1) {
                ((Throwable)((Object)ae)).initCause(this.errors.get(0));
            } else {
                CompositeException ce = new CompositeException(this.errors);
                ((Throwable)((Object)ae)).initCause(ce);
            }
        }
        return ae;
    }

    @NonNull
    public final U await() throws InterruptedException {
        if (this.done.getCount() == 0L) {
            return (U)this;
        }
        this.done.await();
        return (U)this;
    }

    public final boolean await(long time, @NonNull TimeUnit unit) throws InterruptedException {
        boolean d = this.done.getCount() == 0L || this.done.await(time, unit);
        this.timeout = !d;
        return d;
    }

    @NonNull
    public final U assertComplete() {
        long c = this.completions;
        if (c == 0L) {
            throw this.fail("Not completed");
        }
        if (c > 1L) {
            throw this.fail("Multiple completions: " + c);
        }
        return (U)this;
    }

    @NonNull
    public final U assertNotComplete() {
        long c = this.completions;
        if (c == 1L) {
            throw this.fail("Completed!");
        }
        if (c > 1L) {
            throw this.fail("Multiple completions: " + c);
        }
        return (U)this;
    }

    @NonNull
    public final U assertNoErrors() {
        int s = this.errors.size();
        if (s != 0) {
            throw this.fail("Error(s) present: " + this.errors);
        }
        return (U)this;
    }

    @NonNull
    public final U assertError(@NonNull Throwable error) {
        return this.assertError(Functions.equalsWith(error), true);
    }

    @NonNull
    public final U assertError(@NonNull Class<? extends Throwable> errorClass) {
        return this.assertError(Functions.isInstanceOf(errorClass), true);
    }

    @NonNull
    public final U assertError(@NonNull Predicate<Throwable> errorPredicate) {
        return this.assertError(errorPredicate, false);
    }

    @NonNull
    private U assertError(@NonNull Predicate<Throwable> errorPredicate, boolean exact) {
        int s = this.errors.size();
        if (s == 0) {
            throw this.fail("No errors");
        }
        boolean found = false;
        for (Throwable e : this.errors) {
            try {
                if (!errorPredicate.test(e)) continue;
                found = true;
                break;
            }
            catch (Throwable ex) {
                throw ExceptionHelper.wrapOrThrow(ex);
            }
        }
        if (found) {
            if (s != 1) {
                if (exact) {
                    throw this.fail("Error present but other errors as well");
                }
                throw this.fail("One error passed the predicate but other errors are present as well");
            }
        } else {
            if (exact) {
                throw this.fail("Error not present");
            }
            throw this.fail("No error(s) passed the predicate");
        }
        return (U)this;
    }

    @NonNull
    public final U assertValue(@NonNull T value) {
        int s = this.values.size();
        if (s != 1) {
            throw this.fail("\nexpected: " + BaseTestConsumer.valueAndClass(value) + "\ngot: " + this.values);
        }
        T v = this.values.get(0);
        if (!Objects.equals(value, v)) {
            throw this.fail("\nexpected: " + BaseTestConsumer.valueAndClass(value) + "\ngot: " + BaseTestConsumer.valueAndClass(v));
        }
        return (U)this;
    }

    @NonNull
    public final U assertValue(@NonNull Predicate<T> valuePredicate) {
        this.assertValueAt(0, valuePredicate);
        if (this.values.size() > 1) {
            throw this.fail("The first value passed the predicate but this consumer received more than one value");
        }
        return (U)this;
    }

    @NonNull
    public final U assertValueAt(int index, @NonNull T value) {
        int s = this.values.size();
        if (s == 0) {
            throw this.fail("No values");
        }
        if (index < 0 || index >= s) {
            throw this.fail("Index " + index + " is out of range [0, " + s + ")");
        }
        T v = this.values.get(index);
        if (!Objects.equals(value, v)) {
            throw this.fail("\nexpected: " + BaseTestConsumer.valueAndClass(value) + "\ngot: " + BaseTestConsumer.valueAndClass(v) + "; Value at position " + index + " differ");
        }
        return (U)this;
    }

    @NonNull
    public final U assertValueAt(int index, @NonNull Predicate<T> valuePredicate) {
        int s = this.values.size();
        if (s == 0) {
            throw this.fail("No values");
        }
        if (index < 0 || index >= s) {
            throw this.fail("Index " + index + " is out of range [0, " + s + ")");
        }
        boolean found = false;
        T v = this.values.get(index);
        try {
            if (valuePredicate.test(v)) {
                found = true;
            }
        }
        catch (Throwable ex) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        if (!found) {
            throw this.fail("Value " + BaseTestConsumer.valueAndClass(v) + " at position " + index + " did not pass the predicate");
        }
        return (U)this;
    }

    @NonNull
    public static String valueAndClass(@Nullable Object o) {
        if (o != null) {
            return o + " (class: " + o.getClass().getSimpleName() + ")";
        }
        return "null";
    }

    @NonNull
    public final U assertValueCount(int count) {
        int s = this.values.size();
        if (s != count) {
            throw this.fail("\nexpected: " + count + "\ngot: " + s + "; Value counts differ");
        }
        return (U)this;
    }

    @NonNull
    public final U assertNoValues() {
        return this.assertValueCount(0);
    }

    @SafeVarargs
    @NonNull
    public final U assertValues(T ... values2) {
        int s = this.values.size();
        if (s != values2.length) {
            throw this.fail("\nexpected: " + values2.length + " " + Arrays.toString(values2) + "\ngot: " + s + " " + this.values + "; Value count differs");
        }
        for (int i = 0; i < s; ++i) {
            T u = values2[i];
            T v = this.values.get(i);
            if (Objects.equals(u, v)) continue;
            throw this.fail("\nexpected: " + BaseTestConsumer.valueAndClass(u) + "\ngot: " + BaseTestConsumer.valueAndClass(v) + "; Value at position " + i + " differ");
        }
        return (U)this;
    }

    @SafeVarargs
    @NonNull
    public final U assertValuesOnly(T ... values2) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values2)).assertNoErrors()).assertNotComplete();
    }

    @NonNull
    public final U assertValueSequence(@NonNull Iterable<? extends T> sequence2) {
        boolean actualNext;
        boolean expectedNext;
        int i = 0;
        Iterator<T> actualIterator = this.values.iterator();
        Iterator<T> expectedIterator = sequence2.iterator();
        while (true) {
            T v;
            expectedNext = expectedIterator.hasNext();
            actualNext = actualIterator.hasNext();
            if (!actualNext || !expectedNext) break;
            T u = expectedIterator.next();
            if (!Objects.equals(u, v = actualIterator.next())) {
                throw this.fail("\nexpected: " + BaseTestConsumer.valueAndClass(u) + "\ngot: " + BaseTestConsumer.valueAndClass(v) + "; Value at position " + i + " differ");
            }
            ++i;
        }
        if (actualNext) {
            throw this.fail("More values received than expected (" + i + ")");
        }
        if (expectedNext) {
            throw this.fail("Fewer values received than expected (" + i + ")");
        }
        return (U)this;
    }

    @NonNull
    protected abstract U assertSubscribed();

    @SafeVarargs
    @NonNull
    public final U assertResult(T ... values2) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values2)).assertNoErrors()).assertComplete();
    }

    @SafeVarargs
    @NonNull
    public final U assertFailure(@NonNull Class<? extends Throwable> error, T ... values2) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values2)).assertError(error)).assertNotComplete();
    }

    @NonNull
    public final U awaitDone(long time, @NonNull TimeUnit unit) {
        try {
            if (!this.done.await(time, unit)) {
                this.timeout = true;
                this.dispose();
            }
        }
        catch (InterruptedException ex) {
            this.dispose();
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        return (U)this;
    }

    @NonNull
    public final U assertEmpty() {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertNoValues()).assertNoErrors()).assertNotComplete();
    }

    @NonNull
    public final U withTag(@Nullable CharSequence tag) {
        this.tag = tag;
        return (U)this;
    }

    @NonNull
    public final U awaitCount(int atLeast) {
        long start = System.currentTimeMillis();
        long timeoutMillis = 5000L;
        while (true) {
            if (System.currentTimeMillis() - start >= timeoutMillis) {
                this.timeout = true;
                break;
            }
            if (this.done.getCount() == 0L || this.values.size() >= atLeast) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
        return (U)this;
    }

    protected abstract boolean isDisposed();

    protected abstract void dispose();
}

