/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.rxjava3;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.core.Single;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava3.Result;
import retrofit2.adapter.rxjava3.RxJava3CallAdapter;

public final class RxJava3CallAdapterFactory
extends CallAdapter.Factory {
    @Nullable
    private final Scheduler scheduler;
    private final boolean isAsync;

    public static RxJava3CallAdapterFactory create() {
        return new RxJava3CallAdapterFactory(null, true);
    }

    public static RxJava3CallAdapterFactory createSynchronous() {
        return new RxJava3CallAdapterFactory(null, false);
    }

    public static RxJava3CallAdapterFactory createWithScheduler(Scheduler scheduler) {
        if (scheduler == null) {
            throw new NullPointerException("scheduler == null");
        }
        return new RxJava3CallAdapterFactory(scheduler, false);
    }

    private RxJava3CallAdapterFactory(@Nullable Scheduler scheduler, boolean isAsync) {
        this.scheduler = scheduler;
        this.isAsync = isAsync;
    }

    @Override
    @Nullable
    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        Type responseType;
        boolean isMaybe;
        Class<?> rawType = RxJava3CallAdapterFactory.getRawType(returnType);
        if (rawType == Completable.class) {
            return new RxJava3CallAdapter((Type)((Object)Void.class), this.scheduler, this.isAsync, false, true, false, false, false, true);
        }
        boolean isFlowable = rawType == Flowable.class;
        boolean isSingle = rawType == Single.class;
        boolean bl = isMaybe = rawType == Maybe.class;
        if (!(rawType == Observable.class || isFlowable || isSingle || isMaybe)) {
            return null;
        }
        boolean isResult = false;
        boolean isBody = false;
        if (!(returnType instanceof ParameterizedType)) {
            String name = isFlowable ? "Flowable" : (isSingle ? "Single" : (isMaybe ? "Maybe" : "Observable"));
            throw new IllegalStateException(name + " return type must be parameterized as " + name + "<Foo> or " + name + "<? extends Foo>");
        }
        Type observableType = RxJava3CallAdapterFactory.getParameterUpperBound(0, (ParameterizedType)returnType);
        Class<?> rawObservableType = RxJava3CallAdapterFactory.getRawType(observableType);
        if (rawObservableType == Response.class) {
            if (!(observableType instanceof ParameterizedType)) {
                throw new IllegalStateException("Response must be parameterized as Response<Foo> or Response<? extends Foo>");
            }
            responseType = RxJava3CallAdapterFactory.getParameterUpperBound(0, (ParameterizedType)observableType);
        } else if (rawObservableType == Result.class) {
            if (!(observableType instanceof ParameterizedType)) {
                throw new IllegalStateException("Result must be parameterized as Result<Foo> or Result<? extends Foo>");
            }
            responseType = RxJava3CallAdapterFactory.getParameterUpperBound(0, (ParameterizedType)observableType);
            isResult = true;
        } else {
            responseType = observableType;
            isBody = true;
        }
        return new RxJava3CallAdapter(responseType, this.scheduler, this.isAsync, isResult, isBody, isFlowable, isSingle, isMaybe, false);
    }
}

