/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.AbstractCSSRuleImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.MediaListImpl;
import com.steadystate.css.format.CSSFormat;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.util.LangUtils;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSImportRuleImpl
extends AbstractCSSRuleImpl
implements CSSImportRule {
    private static final long serialVersionUID = 7807829682009179339L;
    private String href_;
    private MediaList media_;

    public void setHref(String href) {
        this.href_ = href;
    }

    public void setMedia(MediaList media) {
        this.media_ = media;
    }

    public CSSImportRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, String href, MediaList media) {
        super(parentStyleSheet, parentRule);
        this.href_ = href;
        this.media_ = media;
    }

    public CSSImportRuleImpl() {
    }

    @Override
    public short getType() {
        return 3;
    }

    @Override
    public String getCssText(CSSFormat format) {
        MediaList ml;
        StringBuilder sb = new StringBuilder();
        sb.append("@import");
        String href = this.getHref();
        if (null != href) {
            sb.append(" url(").append(href).append(")");
        }
        if (null != (ml = this.getMedia()) && ml.getLength() > 0) {
            sb.append(" ").append(((MediaListImpl)this.getMedia()).getMediaText(format));
        }
        sb.append(";");
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        CSSStyleSheetImpl parentStyleSheet = this.getParentStyleSheetImpl();
        if (parentStyleSheet != null && parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 3) {
                throw new DOMExceptionImpl(13, 6);
            }
            this.href_ = ((CSSImportRuleImpl)r).href_;
            this.media_ = ((CSSImportRuleImpl)r).media_;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public String getHref() {
        return this.href_;
    }

    @Override
    public MediaList getMedia() {
        return this.media_;
    }

    @Override
    public CSSStyleSheet getStyleSheet() {
        return null;
    }

    public String toString() {
        return this.getCssText(null);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSImportRule)) {
            return false;
        }
        CSSImportRule cir = (CSSImportRule)obj;
        return super.equals(obj) && LangUtils.equals(this.getHref(), cir.getHref()) && LangUtils.equals(this.getMedia(), cir.getMedia());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = LangUtils.hashCode(hash, this.href_);
        hash = LangUtils.hashCode(hash, this.media_);
        return hash;
    }
}

