/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared;

import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.JavaInfo;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.RunContext;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.apps.qftest.shared.variables.VariableData;
import de.qfs.lib.gui.Message;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.StringOption;
import de.qfs.lib.util.ArgsParser;
import de.qfs.lib.util.DaemonThread;
import de.qfs.lib.util.Environment;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.ProcessManager;
import de.qfs.lib.util.Reflector;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.text.View;

public abstract class Util {
    private static final QFLogger f = new QFLogger("de.qfs.apps.qftest.shared.Util");
    public static final String PROP_MESSAGE_NOCOMPACT = "qftest.sut.messages.nocompact";
    public static final String PROP_MESSAGE_REPORT = "qftest.sut.messages.report";
    public static final String PROP_MESSAGE = "qftest.sut.messages";
    public static final String PROP_WARNING = "qftest.sut.warnings";
    public static final String PROP_WARNING_REPORT = "qftest.sut.warnings.report";
    public static final String PROP_ERROR = "qftest.sut.errors";
    public static final String DASH_LINE = "--------------------------------------------------------------------------------\n";
    private static final int g = 1000;
    private static DateFormat h = new SimpleDateFormat("HH:mm:ss.SSS");
    private static Pattern i = Pattern.compile("(?s)(?m)^\\s*@(\\S+)\\s*");
    private static Pattern j = Pattern.compile("(\\S+)\\s*");
    private static final String[] k = new String[]{"jython", "groovy", "javascript"};
    static final long a = System.currentTimeMillis();
    static final long b = System.nanoTime();
    private static WeakHashMap l = new WeakHashMap();
    private static final AtomicReference m = new AtomicReference();
    private static final AtomicReference n = new AtomicReference();
    private static final AtomicReference o = new AtomicReference();
    private static final AtomicReference p = new AtomicReference();
    private static final AtomicReference q = new AtomicReference();
    private static final AtomicReference r = new AtomicReference();
    static final String c = "log";
    static final String d = "qftest.log";
    static final String e = "[default]";
    private static String s = Globals.PRE42_USER_CFG_DIR + File.separator + "log";
    private static JLabel t;

    public Util() {
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "Util.Util()", 100).log();
        }
    }

    public static String getPluginDir() {
        String string;
        String string2;
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "getPluginDir()", 239).log();
        }
        if ((string2 = Globals.getGlobalString("qftestplugindir", string = System.getenv("QFTEST_PLUGINDIR"))) == null) {
            string2 = "";
        }
        return string2;
    }

    @Nullable
    public static JavaInfo getJavaInfo(@Nullable String string) {
        block18: {
            if (Util.f.level >= 7) {
                ((LevelAwareLogBuilder)f.lvlBuild(7, "getJavaInfo(String)", 262).addDetail("binary", string)).log();
            }
            if (Util.f.level >= 7) {
                ((LevelAwareLogBuilder)f.lvlBuild(7, "getJavaInfo(String)", 264).addDetail("binary", string)).log();
            }
            if (Misc.emptyOrNull((String)string)) {
                return null;
            }
            try {
                String string2;
                try {
                    string2 = new File(Misc.getFilenameOfClass(JavaInfo.class)).getCanonicalPath();
                }
                catch (Exception exception) {
                    if (Util.f.level >= 9) {
                        ((LevelAwareLogBuilder)f.lvlBuild(9, "getJavaInfo(String)", 273).add("e", (Object)exception)).log();
                    }
                    string2 = System.getProperty("java.class.path");
                }
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "getJavaInfo(String)", 277).add("classpath", string2)).log();
                }
                ProcessManager processManager = new ProcessManager("java", new String[]{string, "-classpath", string2, JavaInfo.class.getCanonicalName()});
                Environment environment = new Environment();
                environment.unsetEnv("JAVA_TOOL_OPTIONS");
                environment.unsetEnv("_JAVA_OPTIONS");
                processManager.setEnvironment(environment);
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "getJavaInfo(String)", 285).add("env", (Object)environment)).log();
                }
                processManager.setCollect(true, true);
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "getJavaInfo(String)", 287).add("Starting process")).log();
                }
                processManager.startProcess();
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "getJavaInfo(String)", 289).add("Waiting for process")).log();
                }
                boolean bl = processManager.waitFor(5000L);
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "getJavaInfo(String)", 291).add("processDidTerminate", bl)).log();
                }
                int n2 = 1;
                if (bl) {
                    n2 = processManager.getExitCode();
                } else {
                    processManager.terminateProcess(1);
                }
                String string3 = processManager.getProcessOutputString();
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "getJavaInfo(String)", 299).add("exitCode", n2)).log();
                }
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "getJavaInfo(String)", 300).add("output", string3)).log();
                }
                if (n2 == 0 && string3 != null) {
                    return JavaInfo.fromString(string3);
                }
            }
            catch (Throwable throwable) {
                if (Util.f.level < 3) break block18;
                ((LevelAwareLogBuilder)f.lvlBuild(3, "getJavaInfo(String)", 307).add("ex", (Object)throwable)).log();
            }
        }
        return null;
    }

    @Deprecated
    public static String[] getJavaVersionAndArch(String string) {
        JavaInfo javaInfo;
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getJavaVersionAndArch(String)", 327).addDetail("bin", string)).log();
        }
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getJavaVersionAndArch(String)", 329).addDetail("bin", string)).log();
        }
        if ((javaInfo = Util.getJavaInfo(string)) == null) {
            return null;
        }
        return javaInfo.toString().split("\n");
    }

    public static LinkedList findFilesWithEnding(String string, String string2, LinkedList linkedList) {
        File[] fileArray;
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "findFilesWithEnding(String,String,LinkedList<String>)", 349).addDetail("directoryName", string)).addDetail("ending", string2)).addDetail("files", (Object)linkedList)).log();
        }
        File file = new File(string);
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isFile() && file2.getAbsolutePath().matches(".*\\." + string2)) {
                linkedList.add(file2.getAbsolutePath());
                continue;
            }
            if (!file2.isDirectory()) continue;
            Util.findFilesWithEnding(file2.getAbsolutePath(), string2, linkedList);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File findOnPath(String string) {
        File file;
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "findOnPath(String)", 373).addDetail("executable", string)).log();
        }
        if ((file = new File(string)).isAbsolute()) {
            return file;
        }
        String string2 = System.getenv("PATH");
        if (string2 == null && !Misc.OS_IS_MAC_OS_X) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2 != null) {
            for (String string3 : string2.split(File.pathSeparator)) {
                arrayList.add(string3);
            }
        }
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "findOnPath(String)", 390).add("dirs", arrayList)).log();
        }
        if (Misc.OS_IS_MAC_OS_X) {
            Object object = null;
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            try {
                String string3;
                object = new FileInputStream("/etc/paths");
                inputStreamReader = new InputStreamReader((InputStream)object, "UTF-8");
                bufferedReader = new BufferedReader(inputStreamReader);
                string3 = bufferedReader.readLine();
                while (string3 != null) {
                    if (string3.length() > 0) {
                        arrayList.add(string3);
                    }
                    string3 = bufferedReader.readLine();
                }
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "findOnPath(String)", 407).add("dirs including /etc/paths: ", arrayList)).log();
                }
            }
            catch (IOException iOException) {
                if (Util.f.level >= 5) {
                    ((LevelAwareLogBuilder)f.lvlBuild(5, "findOnPath(String)", 409).add("ex", (Object)iOException)).log();
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (object != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return Util.findOnPath(string, arrayList.toArray(new String[0]));
    }

    public static File findOnPath(String string, String[] stringArray) {
        String[] stringArray2;
        File file;
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "findOnPath(String,String[])", 448).addDetail("executable", string)).addDetail("path", (Object)stringArray)).log();
        }
        if ((file = new File(string)).isAbsolute()) {
            return file;
        }
        if (Misc.OS_IS_WINDOWS) {
            String[] stringArray3 = new String[5];
            stringArray3[0] = "";
            stringArray3[1] = ".exe";
            stringArray3[2] = ".com";
            stringArray3[3] = ".bat";
            stringArray2 = stringArray3;
            stringArray3[4] = ".cmd";
        } else {
            String[] stringArray4 = new String[1];
            stringArray2 = stringArray4;
            stringArray4[0] = "";
        }
        String[] stringArray5 = stringArray2;
        for (String string2 : stringArray) {
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "findOnPath(String,String[])", 459).add("dir", string2)).log();
            }
            for (String string3 : stringArray5) {
                file = new File(string2, string + string3);
                if (!file.canExecute()) continue;
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "findOnPath(String,String[])", 465).add("Found executable: ", (Object)file)).log();
                }
                return file;
            }
        }
        return null;
    }

    public static boolean fileStartsWith(File file, char[] cArray) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "fileStartsWith(File,char[])", 475).addDetail("file", (Object)file)).addDetail("sequence", (Object)cArray)).log();
        }
        if (file == null) {
            throw new IllegalArgumentException("file is marked non-null but is null");
        }
        if (cArray == null) {
            throw new IllegalArgumentException("sequence is marked non-null but is null");
        }
        return Util.fileStartsWith(file, cArray, Misc.UTF8_CHARSET);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean fileStartsWith(File file, char[] cArray, Charset charset) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "fileStartsWith(File,char[],Charset)", 482).addDetail("file", (Object)file)).addDetail("sequence", (Object)cArray)).addDetail("charset", (Object)charset)).log();
        }
        if (file == null) {
            throw new IllegalArgumentException("file is marked non-null but is null");
        }
        if (cArray == null) {
            throw new IllegalArgumentException("sequence is marked non-null but is null");
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));){
            int n2 = 0;
            int n3 = 0;
            while ((n2 = bufferedReader.read()) != -1) {
                if (n3 >= cArray.length) {
                    boolean bl = true;
                    return bl;
                }
                if ((char)n2 != cArray[n3]) {
                    boolean bl = false;
                    return bl;
                }
                ++n3;
            }
            return false;
        }
        catch (IOException iOException) {
            if (Util.f.level < 1) return false;
            ((LevelAwareLogBuilder)f.lvlBuild(1, "fileStartsWith(File,char[],Charset)", 496).add("e", (Object)iOException)).log();
        }
        return false;
    }

    public static void logSutMessage(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "logSutMessage(String)", 514).addDetail("message", string)).log();
        }
        Util.logSutMessage(string, false, false, false);
    }

    public static void logSutMessage(String string, boolean bl, boolean bl2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "logSutMessage(String,boolean,boolean)", 529).addDetail("message", string)).addDetail("addTimestamp", bl)).addDetail("nocompact", bl2)).log();
        }
        Util.logSutMessage(string, bl, bl2, false);
    }

    public static void logSutMessage(String string, boolean bl, boolean bl2, boolean bl3) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "logSutMessage(String,boolean,boolean,boolean)", 545).addDetail("message", string)).addDetail("addTimestamp", bl)).addDetail("nocompact", bl2)).addDetail("report", bl3)).log();
        }
        Util.logSutMessage(bl ? Util.timestamp() + " " + string : string, bl3 ? PROP_MESSAGE_REPORT : (bl2 ? PROP_MESSAGE_NOCOMPACT : PROP_MESSAGE));
    }

    public static void logSutMessage(int n2, String string, boolean bl, boolean bl2, boolean bl3) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "logSutMessage(int,String,boolean,boolean,boolean)", 566).addDetail("level", n2)).addDetail("message", string)).addDetail("addTimestamp", bl)).addDetail("nocompact", bl2)).addDetail("report", bl3)).log();
        }
        if (n2 == 2) {
            Util.logSutError(string, bl);
        } else if (n2 == 1) {
            Util.logSutWarning(string, bl, bl3);
        } else {
            Util.logSutMessage(string, bl, bl2, bl3);
        }
    }

    public static void logSutWarning(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "logSutWarning(String)", 586).addDetail("message", string)).log();
        }
        Util.logSutWarning(string, false, true);
    }

    public static void logSutWarning(String string, boolean bl) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "logSutWarning(String,boolean)", 600).addDetail("message", string)).addDetail("addTimestamp", bl)).log();
        }
        Util.logSutWarning(string, bl, true);
    }

    public static void logSutWarning(String string, boolean bl, boolean bl2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "logSutWarning(String,boolean,boolean)", 615).addDetail("message", string)).addDetail("addTimestamp", bl)).addDetail("report", bl2)).log();
        }
        Util.logSutMessage(bl ? Util.timestamp() + " " + string : string, bl2 ? PROP_WARNING_REPORT : PROP_WARNING);
    }

    public static void logSutError(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "logSutError(String)", 629).addDetail("message", string)).log();
        }
        Util.logSutMessage(string, PROP_ERROR);
    }

    public static void logSutError(String string, boolean bl) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "logSutError(String,boolean)", 643).addDetail("message", string)).addDetail("addTimestamp", bl)).log();
        }
        Util.logSutMessage(bl ? Util.timestamp() + " " + string : string, PROP_ERROR);
    }

    public static void logSutMessage(int n2, String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "logSutMessage(int,String)", 656).addDetail("level", n2)).addDetail("message", string)).log();
        }
        Util.logSutMessage(string, false, false, false);
    }

    public static void reportTestException(Serializable serializable) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "reportTestException(Serializable)", 671).addDetail("exceptionData", (Object)serializable)).log();
        }
        if (RunContext.AsyncRunInfo.NOTIFIER.level >= 1) {
            RunContext.AsyncRunInfo.NOTIFIER.postNotification(1, "de.qfs.apps.qftest.shared.extensions.RunContext.AsyncRunInfo.Exception", null, new Object[]{"data", serializable});
        }
    }

    public static String safeToString(Object object, String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "safeToString(Object,String)", 688).addDetail("o", object)).addDetail("cl", string)).log();
        }
        if (object == null) {
            return null;
        }
        try {
            return object.toString();
        }
        catch (Throwable throwable) {
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "safeToString(Object,String)", 696).add("ex", (Object)throwable)).log();
            }
            return "Bad " + (string == null ? "object" : string) + " of class " + object.getClass().getName() + " with broken toString() method.";
        }
    }

    public static String formatMessage(String string, Object ... objectArray) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "formatMessage(String,Object[])", 715).addDetail("resource", string)).addDetail("parameters", (Object)objectArray)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("resource is marked non-null but is null");
        }
        if (Globals.getResources().getString(string + ".message", null) != null) {
            return Message.format((String)(string + ".message"), (Object[])objectArray);
        }
        return Message.format((String)string, (Object[])objectArray);
    }

    public static String stripDoctags(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "stripDoctags(String)", 739).addDetail("text", string)).log();
        }
        if (string == null) {
            return null;
        }
        Matcher matcher = i.matcher(string);
        if (matcher.find()) {
            return string.substring(0, matcher.start()).trim();
        }
        return string;
    }

    public static String stripDoctags(String string, String string2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "stripDoctags(String,String)", 763).addDetail("text", string)).addDetail("tag", string2)).log();
        }
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            if (Util.f.level >= 3) {
                ((LevelAwareLogBuilder)f.lvlBuild(3, "stripDoctags(String,String)", 771).add("Illegal null tag")).log();
            }
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        Matcher matcher = i.matcher(string);
        boolean bl = matcher.find();
        while (bl) {
            Matcher matcher2 = i.matcher(string);
            bl = matcher2.find(matcher.end());
            if (!string2.equals(matcher.group(1))) {
                matcher = matcher2;
                continue;
            }
            if (matcher.start(1) - 1 > n2) {
                stringBuffer.append(string.substring(n2, matcher.start(1) - 1));
            }
            n2 = bl ? matcher2.start(1) - 1 : string.length();
            matcher = matcher2;
        }
        if (n2 >= 0 && n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public static String getDoctag(String string, String string2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "getDoctag(String,String)", 809).addDetail("text", string)).addDetail("tag", string2)).log();
        }
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            if (Util.f.level >= 3) {
                ((LevelAwareLogBuilder)f.lvlBuild(3, "getDoctag(String,String)", 815).add("Illegal null tag")).log();
            }
            return null;
        }
        Matcher matcher = i.matcher(string);
        boolean bl = matcher.find();
        while (bl) {
            Matcher matcher2 = i.matcher(string);
            bl = matcher2.find(matcher.end());
            if (!string2.equals(matcher.group(1))) {
                matcher = matcher2;
                continue;
            }
            int n2 = matcher.end(1);
            if (bl) {
                return string.substring(n2 + 1, matcher2.start()).trim();
            }
            if (string.length() > n2) {
                return string.substring(n2 + 1).trim();
            }
            return "";
        }
        return null;
    }

    public static List getDoctags(String string, String string2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "getDoctags(String,String)", 851).addDetail("text", string)).addDetail("tag", string2)).log();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        if (string == null) {
            return linkedList;
        }
        if (string2 == null) {
            if (Util.f.level >= 3) {
                ((LevelAwareLogBuilder)f.lvlBuild(3, "getDoctags(String,String)", 858).add("Illegal null tag")).log();
            }
            return linkedList;
        }
        Matcher matcher = i.matcher(string);
        boolean bl = matcher.find();
        while (bl) {
            Matcher matcher2 = i.matcher(string);
            bl = matcher2.find(matcher.end());
            if (!string2.equals(matcher.group(1))) {
                matcher = matcher2;
                continue;
            }
            int n2 = matcher.end(1);
            String string3 = bl ? string.substring(n2 + 1, matcher2.start()).trim() : (string.length() > n2 ? string.substring(n2 + 1).trim() : "");
            linkedList.add(string3);
            matcher = matcher2;
        }
        return linkedList;
    }

    public static String[] getNamedDoctag(String string, String string2, String string3) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "getNamedDoctag(String,String,String)", 899).addDetail("text", string)).addDetail("tag", string2)).addDetail("name", string3)).log();
        }
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            if (Util.f.level >= 3) {
                ((LevelAwareLogBuilder)f.lvlBuild(3, "getNamedDoctag(String,String,String)", 905).add("Illegal null tag")).log();
            }
            return null;
        }
        Matcher matcher = i.matcher(string);
        boolean bl = matcher.find();
        while (bl) {
            Matcher matcher2 = i.matcher(string);
            bl = matcher2.find(matcher.end());
            if (!string2.equals(matcher.group(1))) {
                matcher = matcher2;
                continue;
            }
            int n2 = matcher.end(1);
            String string4 = bl ? string.substring(n2 + 1, matcher2.start()).trim() : (string.length() > n2 ? string.substring(n2 + 1).trim() : "");
            Matcher matcher3 = j.matcher(string4);
            if (!matcher3.lookingAt() || string3 != null && !string3.equals(matcher3.group(1))) {
                matcher = matcher2;
                continue;
            }
            return new String[]{matcher3.group(1), string4.substring(matcher3.end())};
        }
        return null;
    }

    public static List getNamedDoctags(String string, String string2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "getNamedDoctags(String,String)", 950).addDetail("text", string)).addDetail("tag", string2)).log();
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (string == null) {
            return arrayList;
        }
        if (string2 == null) {
            if (Util.f.level >= 3) {
                ((LevelAwareLogBuilder)f.lvlBuild(3, "getNamedDoctags(String,String)", 957).add("Illegal null tag")).log();
            }
            return arrayList;
        }
        Matcher matcher = i.matcher(string);
        boolean bl = matcher.find();
        while (bl) {
            Matcher matcher2 = i.matcher(string);
            bl = matcher2.find(matcher.end());
            if (!string2.equals(matcher.group(1))) {
                matcher = matcher2;
                continue;
            }
            int n2 = matcher.end(1);
            String string3 = bl ? string.substring(n2 + 1, matcher2.start()).trim() : (string.length() > n2 ? string.substring(n2 + 1).trim() : "");
            Matcher matcher3 = j.matcher(string3);
            if (!matcher3.lookingAt()) {
                matcher = matcher2;
                continue;
            }
            arrayList.add(new String[]{matcher3.group(1), string3.substring(matcher3.end())});
            matcher = matcher2;
        }
        return arrayList;
    }

    public static final boolean isInstance(Object object, String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "isInstance(Object,String)", 1006).addDetail("object", object)).addDetail("className", string)).log();
        }
        if (object == null) {
            return false;
        }
        return Util.isDerivedClass(object.getClass(), string);
    }

    public static final boolean isDerivedClass(Class clazz, String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "isDerivedClass(Class<?>,String)", 1027).addDetail("clazz", (Object)clazz)).addDetail("className", string)).log();
        }
        while (true) {
            Class<?>[] classArray;
            if (clazz.getName().equals(string)) {
                return true;
            }
            for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
                if (!clazz2.getName().equals(string)) continue;
                return true;
            }
            if (clazz == Object.class) break;
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperty(Object object, String string, Object object2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "setProperty(Object,String,Object)", 1058).addDetail("object", object)).addDetail("name", string)).addDetail("value", object2)).log();
        }
        WeakHashMap weakHashMap = l;
        synchronized (weakHashMap) {
            HashMap<String, Object> hashMap = (HashMap<String, Object>)l.get(object);
            if (hashMap == null) {
                if (object2 == null) {
                    return;
                }
                hashMap = new HashMap<String, Object>();
                l.put(object, hashMap);
            }
            if (object2 == null) {
                hashMap.remove(string);
                if (hashMap.isEmpty()) {
                    l.remove(object);
                }
            } else {
                hashMap.put(string, object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getProperty(Object object, String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "getProperty(Object,String)", 1091).addDetail("object", object)).addDetail("name", string)).log();
        }
        WeakHashMap weakHashMap = l;
        synchronized (weakHashMap) {
            Map map = (Map)l.get(object);
            if (map == null) {
                return null;
            }
            return map.get(string);
        }
    }

    public static String to7Bit(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "to7Bit(String)", 1114).addDetail("file", string)).log();
        }
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0080' && c2 != '*') {
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append('*');
            String string2 = Integer.toHexString(c2 & 0xFFFF);
            for (int i3 = 4 - string2.length(); i3 > 0; --i3) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String from7Bit(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "from7Bit(String)", 1149).addDetail("file", string)).log();
        }
        if (string == null) {
            return null;
        }
        if (string.indexOf("*") < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "from7Bit(String)", 1161).add("c", c2)).log();
            }
            if (c2 != '*') {
                stringBuffer.append(c2);
                continue;
            }
            if (i2 + 4 >= string.length()) {
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "from7Bit(String)", 1166).add("Illegal converted filename: ")).add(string)).log();
                }
                return stringBuffer.toString();
            }
            try {
                int n2 = Integer.parseInt(string.substring(i2 + 1, i2 + 5), 16);
                stringBuffer.append((char)n2);
                i2 += 4;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (Util.f.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(3, "from7Bit(String)", 1174).add("Illegal converted filename: ")).add(string)).log();
                }
                return stringBuffer.toString();
            }
        }
        return stringBuffer.toString();
    }

    public static ArrayList getTreeNodesAsList(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getTreeNodesAsList(String)", 1192).addDetail("thePath", string)).log();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 >= 0) {
            int n3 = Misc.unquotedIndexOf((String)string, (String)"/", (int)(n2 + 1));
            String string2 = n3 > n2 ? Misc.unquote((String)string.substring(n2 + 1, n3), (String)"\\#@&%/") : Misc.unquote((String)string.substring(n2 + 1), (String)"\\#@&%/");
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "getTreeNodesAsList(String)", 1207).add("index", string2)).log();
            }
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "getTreeNodesAsList(String)", 1208).add("pos", n2)).log();
            }
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "getTreeNodesAsList(String)", 1209).add("pos2", n3)).log();
            }
            n2 = n3;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean isPreviewFeatureEnabled(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "isPreviewFeatureEnabled(String)", 1225).addDetail("featureName", string)).log();
        }
        if (Misc.emptyOrNull((String)string)) {
            return false;
        }
        String string2 = Options.cached_OPT_ENABLED_PREVIEW_FEATURES;
        String string3 = Options.cached_OPT_ENABLED_PREVIEW_FEATURES_USER;
        String string4 = string2 + "," + string3;
        String[] stringArray = Misc.fastSplit((String)string4, (char)',');
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string5 = stringArray[i2].trim();
            if (!string.equalsIgnoreCase(string5)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList parseIntervals(String string, boolean bl) throws IllegalArgumentException {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "parseIntervals(String,boolean)", 1259).addDetail("intervals", string)).addDetail("allowNegative", bl)).log();
        }
        if (Misc.emptyOrNull((String)string)) {
            return null;
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        String[] stringArray = string.replaceAll("\\s", "").split(",");
        Pattern pattern = Pattern.compile("(-?[0-9]+)([-:](-?[0-9]+)?)?");
        for (String string2 : stringArray) {
            int n2;
            Matcher matcher;
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "parseIntervals(String,boolean)", 1269).add("part", string2)).log();
            }
            if (!(matcher = pattern.matcher(string2)).matches()) {
                throw new IllegalArgumentException("Invalid interval definition: " + string);
            }
            int n3 = Integer.parseInt(matcher.group(1));
            if (Misc.emptyOrNull((String)matcher.group(2))) {
                if (n3 < 0) {
                    if (bl) {
                        n2 = n3;
                    } else {
                        n2 = -n3;
                        n3 = -1;
                    }
                } else {
                    n2 = n3;
                }
            } else {
                n2 = Misc.emptyOrNull((String)matcher.group(3)) ? -1 : Integer.parseInt(matcher.group(3));
            }
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "parseIntervals(String,boolean)", 1294).add("from", n3)).log();
            }
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "parseIntervals(String,boolean)", 1295).add("to", n2)).log();
            }
            arrayList.add(new int[]{n3, n2});
        }
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "parseIntervals(String,boolean)", 1298).add("ret", arrayList)).log();
        }
        return arrayList.isEmpty() ? null : arrayList;
    }

    public static boolean matchesInterval(int n2, String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "matchesInterval(int,String)", 1305).addDetail("value", n2)).addDetail("intervalDefinition", string)).log();
        }
        try {
            ArrayList arrayList = Util.parseIntervals(string, false);
            if (arrayList == null) {
                return false;
            }
            for (int[] nArray : arrayList) {
                if (nArray[0] > n2 || nArray[1] >= 0 && nArray[1] < n2) continue;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            if (Util.f.level >= 5) {
                ((LevelAwareLogBuilder)f.lvlBuild(5, "matchesInterval(int,String)", 1320).add("ex", (Object)throwable)).log();
            }
            return false;
        }
    }

    @Nullable
    public static String maybeDecrypt(@Nullable String string, String string2) throws TestException {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "maybeDecrypt(String,String)", 1343).addDetail("pwd", string)).addDetail("salt", string2)).log();
        }
        if (string != null && string.startsWith("qftest:decrypt(") && string.endsWith(")")) {
            return Util.decryptPassword(string.substring(15, string.length() - 1), string2);
        }
        return string;
    }

    public static String decryptPassword(String string, String string2) throws TestException {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "decryptPassword(String,String)", 1366).addDetail("pwd", string)).addDetail("salt", string2)).log();
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(Misc.fromHex((String)Globals.getResources().getString("qftest.public.key", null)));
            if (!Misc.emptyOrNull((String)string2)) {
                messageDigest.update(string2.getBytes());
            }
            byte[] byArray = messageDigest.digest();
            Class<?> clazz = Class.forName("javax.crypto.spec.SecretKeySpec");
            Object object = Reflector.createInstance(clazz, (Class[])new Class[]{new byte[0].getClass(), Integer.TYPE, Integer.TYPE, String.class}, (Object[])new Object[]{byArray, 0, 16, "AES"});
            Class<?> clazz2 = Class.forName("javax.crypto.Cipher");
            Object object2 = Reflector.call(clazz2, (String)"getInstance", String.class, (Object)"AES/ECB/PKCS5Padding");
            Reflector.call((Object)object2, (String)"init", (Class[])new Class[]{Integer.TYPE, Key.class}, (Object[])new Object[]{Reflector.get(clazz2, (String)"DECRYPT_MODE"), object});
            byte[] byArray2 = Misc.fromHex((String)string);
            byte[] byArray3 = (byte[])Reflector.call((Object)object2, (String)"doFinal", new byte[0].getClass(), (Object)byArray2);
            return new String(byArray3);
        }
        catch (Exception exception) {
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "decryptPassword(String,String)", 1395).add("ex", (Object)exception)).log();
            }
            throw new TestException("Decryption failed.", "decryptFailed", exception);
        }
    }

    public static String encryptPassword(String string, String string2) throws TestException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(Misc.fromHex((String)Globals.getResources().getString("qftest.public.key", null)));
            if (!Misc.emptyOrNull((String)string2)) {
                messageDigest.update(string2.getBytes());
            }
            byte[] byArray = messageDigest.digest();
            Class<?> clazz = Class.forName("javax.crypto.spec.SecretKeySpec");
            Object object = Reflector.createInstance(clazz, (Class[])new Class[]{new byte[0].getClass(), Integer.TYPE, Integer.TYPE, String.class}, (Object[])new Object[]{byArray, 0, 16, "AES"});
            Class<?> clazz2 = Class.forName("javax.crypto.Cipher");
            Object object2 = Reflector.call(clazz2, (String)"getInstance", String.class, (Object)"AES/ECB/PKCS5Padding");
            Reflector.call((Object)object2, (String)"init", (Class[])new Class[]{Integer.TYPE, Key.class}, (Object[])new Object[]{Reflector.get(clazz2, (String)"ENCRYPT_MODE"), object});
            byte[] byArray2 = (byte[])Reflector.call((Object)object2, (String)"doFinal", new byte[0].getClass(), (Object)string.getBytes());
            String string3 = Misc.toHex((byte[])byArray2);
            return string3;
        }
        catch (Exception exception) {
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "encryptPassword(String,String)", 1444).add("ex", (Object)exception)).log();
            }
            throw new TestException("Decryption failed.", "decryptFailed", exception);
        }
    }

    public static void setTimestampFormat(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "setTimestampFormat(String)", 1460).addDetail("format", string)).log();
        }
        h = new SimpleDateFormat(string);
    }

    public static boolean regexpMatches(String string, String string2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "regexpMatches(String,String)", 1476).addDetail("regexp", string)).addDetail("value", string2)).log();
        }
        if (Misc.emptyOrNull((String)string)) {
            return Misc.emptyOrNull((String)string2);
        }
        if (string2 == null) {
            string2 = "";
        }
        try {
            boolean bl = string2.matches(string);
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "regexpMatches(String,String)", 1485).add("ret", bl)).log();
            }
            return bl;
        }
        catch (Error error) {
            if (Util.f.level >= 1) {
                ((LevelAwareLogBuilder)f.lvlBuild(1, "regexpMatches(String,String)", 1488).add("ex", (Object)error)).log();
            }
            boolean bl = string.contains("(.|\\n)");
            String string3 = Message.format((String)((bl ? "errorFromRegexpOld" : "errorFromRegexp") + ".message"), (Object[])new String[]{string, error.getMessage() == null ? error.toString() : error.getMessage()});
            throw new RuntimeException(string3, error);
        }
    }

    public static boolean regexpFind(String string, String string2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "regexpFind(String,String)", 1507).addDetail("regexp", string)).addDetail("value", string2)).log();
        }
        if (Misc.emptyOrNull((String)string)) {
            return Misc.emptyOrNull((String)string2);
        }
        if (string2 == null) {
            string2 = "";
        }
        try {
            boolean bl = Pattern.compile(string).matcher(string2).find();
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "regexpFind(String,String)", 1516).add("ret", bl)).log();
            }
            return bl;
        }
        catch (Error error) {
            boolean bl;
            if (Util.f.level >= 1) {
                ((LevelAwareLogBuilder)f.lvlBuild(1, "regexpFind(String,String)", 1519).add("ex", (Object)error)).log();
            }
            String string3 = Message.format((String)((bl = string.contains("(.|\\n)")) ? "errorFromRegexpOld" : "errorFromRegexp"), (Object[])new String[]{string, error.getMessage()});
            throw new RuntimeException(string3, error);
        }
    }

    public static boolean stringOrRegexpMatches(String string, boolean bl, String string2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "stringOrRegexpMatches(String,boolean,String)", 1539).addDetail("stringOrRegexp", string)).addDetail("isRegexp", bl)).addDetail("value", string2)).log();
        }
        return bl ? Util.regexpMatches(string, string2) : Misc.equalOrEmpty((String)string, (String)string2);
    }

    public static String globToRegexp(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "globToRegexp(String)", 1557).addDetail("glob", string)).log();
        }
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
        if (string.startsWith("/")) {
            stringBuffer.append('/');
        }
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (string.startsWith("**/")) {
            stringBuffer.append("(.*/)?");
            string = string.substring(3);
        }
        int n2 = string.length();
        boolean bl = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '*') {
                if (bl) {
                    stringBuffer.append(".*");
                    bl = false;
                    continue;
                }
                bl = true;
                continue;
            }
            if (bl) {
                stringBuffer.append("[^/]*");
                bl = false;
            }
            if (c2 == '.') {
                stringBuffer.append('\\');
            } else if (c2 == '\\') {
                c2 = '/';
            }
            stringBuffer.append(c2);
        }
        if (bl) {
            stringBuffer.append("[^/]*");
        }
        String string2 = stringBuffer.toString();
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "globToRegexp(String)", 1604).add("ret", string2)).log();
        }
        return string2;
    }

    public static Object[] parseStringToHashMap(String string, String string2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "parseStringToHashMap(String,String)", 1626).addDetail("params", string)).addDetail("splitter", string2)).log();
        }
        int n2 = 0;
        String[] stringArray = string.split(string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[] stringArray2 = stringArray[i2].split("=");
            try {
                if (!hashMap.containsKey(stringArray2[0].trim()) && !stringArray2[0].trim().equals("")) {
                    hashMap.put(stringArray2[0].trim(), stringArray2[1].trim());
                    continue;
                }
                if (stringArray2[0].trim().equals("") && stringArray2[1].trim().equals("")) {
                    n2 = -2;
                    hashMap = null;
                    break;
                }
                n2 = -1;
                hashMap.clear();
                hashMap.put(stringArray2[0].trim(), null);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                try {
                    if (!hashMap.containsKey(stringArray2[0].trim()) && !stringArray2[0].trim().equals("")) {
                        hashMap.put(stringArray2[0].trim(), null);
                        continue;
                    }
                    if (stringArray2[0].trim().equals("")) {
                        n2 = -2;
                        hashMap = null;
                        break;
                    }
                    n2 = -1;
                    hashMap.clear();
                    hashMap.put(stringArray2[0].trim(), null);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                    n2 = -2;
                    hashMap = null;
                }
            }
            break;
        }
        return new Object[]{hashMap, n2};
    }

    public static Object[] verifyParamExistence(HashMap hashMap, HashMap hashMap2) {
        Object object3;
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "verifyParamExistence(HashMap<String, ? extends Object>,HashMap<String, ? extends Object>)", 1703).addDetail("input", (Object)hashMap)).addDetail("expected", (Object)hashMap2)).log();
        }
        int n2 = 0;
        Object object2 = null;
        Set set = hashMap.keySet();
        for (Object object3 : set) {
            if (hashMap2.containsKey(object3)) continue;
            n2 = -2;
            object2 = object3;
            break;
        }
        object3 = hashMap2.keySet();
        Iterator iterator = object3.iterator();
        while (iterator.hasNext() && n2 == 0) {
            String string = (String)iterator.next();
            if (hashMap.containsKey(string)) continue;
            n2 = -1;
            object2 = string;
            break;
        }
        return new Object[]{object2, n2};
    }

    public static boolean verifyParam(Object object, int n2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "verifyParam(Object,int)", 1750).addDetail("param", object)).addDetail("expected", n2)).log();
        }
        boolean bl = false;
        switch (n2) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                bl = object != null && !object.equals("");
                break;
            }
            case 2: {
                try {
                    Double.parseDouble(object.toString());
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException nullPointerException) {}
                break;
            }
            case 3: {
                try {
                    Integer.parseInt(object.toString());
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException nullPointerException) {}
                break;
            }
            case 4: {
                try {
                    bl = (double)Integer.parseInt(object.toString()) == Math.pow(2.0, (int)(Math.log(Integer.parseInt(object.toString())) / Math.log(2.0)));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException nullPointerException) {}
                break;
            }
            case 5: {
                try {
                    bl = object.toString().toLowerCase().equals("true") || object.toString().toLowerCase().equals("false");
                }
                catch (NullPointerException nullPointerException) {}
                break;
            }
        }
        return bl;
    }

    public static Map createKeyValueMap(Object ... objectArray) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "createKeyValueMap(Object[])", 1818).addDetail("keysAndValues", (Object)objectArray)).log();
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            String string = "" + objectArray[i2];
            linkedHashMap.put(string, i2 < n2 - 1 ? objectArray[i2 + 1] : null);
        }
        return linkedHashMap;
    }

    public static Window getWindowForComponent(Component component) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getWindowForComponent(Component)", 1841).addDetail("parentComponent", (Object)component)).log();
        }
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return Util.getWindowForComponent(component.getParent());
    }

    public static String getIdentifierText(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getIdentifierText(String)", 1862).addDetail("text", string)).log();
        }
        if (!Misc.emptyOrNull((String)string)) {
            return Misc.safeTrim((String)Misc.lineSepToLineFeed((String)Util.replaceNBSP(string)));
        }
        return string;
    }

    public static String getFlatIdentifierText(String string) {
        String string2;
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getFlatIdentifierText(String)", 1881).addDetail("text", string)).log();
        }
        if (!Misc.emptyOrNull((String)(string2 = Util.getIdentifierText(string)))) {
            return string2.replace('\n', ' ');
        }
        return string2;
    }

    public static String getCleanElementText(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getCleanElementText(String)", 1903).addDetail("text", string)).log();
        }
        if (!Misc.emptyOrNull((String)string)) {
            return Misc.lineSepToLineFeed((String)Util.replaceNBSP(string));
        }
        return string;
    }

    public static String replaceNBSP(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "replaceNBSP(String)", 1921).addDetail("text", string)).log();
        }
        if (string == null) {
            return null;
        }
        char[] cArray = new char[string.length()];
        int n2 = 0;
        for (char c2 : string.toCharArray()) {
            if (c2 == '\u00a0' || c2 == '\u00a0') {
                cArray[n2++] = 32;
                continue;
            }
            if (c2 == '\u00ad' || c2 == '\u200b') continue;
            cArray[n2++] = c2;
        }
        return new String(cArray, 0, n2);
    }

    public static boolean domainsEqual(String string, String string2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "domainsEqual(String,String)", 1955).addDetail("host1", string)).addDetail("host2", string2)).log();
        }
        if (Misc.equalOrEmpty((String)string, (String)string2)) {
            return true;
        }
        if (Misc.emptyOrNull((String)string) || Misc.emptyOrNull((String)string2)) {
            return false;
        }
        string = string.split(":")[0];
        string2 = string2.split(":")[0];
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "domainsEqual(String,String)", 1965).add("host1 no port: ", string)).add(", host2 no port: ", string2)).log();
        }
        if (string.matches("[0-9\\.]+") && string2.matches("[0-9\\.]+")) {
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "domainsEqual(String,String)", 1967).add("Two domains")).log();
            }
            return true;
        }
        int n2 = string.indexOf(".");
        if (n2 > 0) {
            string = string.substring(n2 + 1);
        }
        if ((n2 = string2.indexOf(".")) > 0) {
            string2 = string2.substring(n2 + 1);
        }
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "domainsEqual(String,String)", 1978).add("host1 stripped: ", string)).add(", host2 stripped: ", string2)).log();
        }
        return string.equals(string2);
    }

    public static String getHTMLTextOfJComponent(JComponent jComponent) {
        View view;
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getHTMLTextOfJComponent(JComponent)", 1993).addDetail("label", (Object)jComponent)).log();
        }
        if ((view = (View)jComponent.getClientProperty("html")) != null) {
            return Util.a(view);
        }
        return null;
    }

    public static String reduceHTMLText(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "reduceHTMLText(String)", 2013).addDetail("text", string)).log();
        }
        if (string == null) {
            return null;
        }
        if (!string.toLowerCase().startsWith("<html>")) {
            return string;
        }
        String[] stringArray = new String[1];
        SwingUtil.invokeAndWait(() -> {
            if (t == null) {
                t = new JLabel();
            }
            t.setText(string);
            stringArray[0] = Util.getHTMLTextOfJComponent(t);
        });
        return stringArray[0];
    }

    public static String simpleHtmlToText(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "simpleHtmlToText(String)", 2045).addDetail("html", string)).log();
        }
        if (Misc.emptyOrNull((String)string)) {
            return "";
        }
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = null;
        for (char c2 : cArray) {
            if (bl) {
                if (c2 != '>') continue;
                bl = false;
                continue;
            }
            if (c2 == '<' || c2 == '&') {
                if (bl2) {
                    stringBuilder.append('&').append((CharSequence)stringBuilder2);
                    bl2 = false;
                }
                if (c2 == '<') {
                    bl = true;
                    continue;
                }
                bl2 = true;
                stringBuilder2 = new StringBuilder();
                continue;
            }
            if (bl2) {
                if (c2 == ';') {
                    String string2;
                    bl2 = false;
                    switch (string2 = stringBuilder2.toString()) {
                        case "nbsp": {
                            stringBuilder.append(' ');
                            break;
                        }
                        case "lt": {
                            stringBuilder.append('<');
                            break;
                        }
                        case "gt": {
                            stringBuilder.append('>');
                            break;
                        }
                        case "amp": {
                            stringBuilder.append('&');
                            break;
                        }
                        default: {
                            stringBuilder.append('&').append(string2).append(';');
                            break;
                        }
                    }
                    continue;
                }
                stringBuilder2.append(c2);
                continue;
            }
            stringBuilder.append(c2);
        }
        if (bl2) {
            stringBuilder.append('&').append((CharSequence)stringBuilder2);
        }
        String string3 = stringBuilder.toString();
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "simpleHtmlToText(String)", 2109).add("html", string)).add("retval", string3)).log();
        }
        return string3;
    }

    public static void openModule(Class clazz, Object object) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "openModule(Class<?>,Object)", 2126).addDetail("targetClass", (Object)clazz)).addDetail("caller", object)).log();
        }
    }

    public static void openModule(Class clazz, String string, Class clazz2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "openModule(Class<?>,String,Class<?>)", 2143).addDetail("targetClass", (Object)clazz)).addDetail("packageName", string)).addDetail("callingClass", (Object)clazz2)).log();
        }
    }

    public static Object getSutMessageMonitor() {
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "getSutMessageMonitor()", 2159).log();
        }
        return "qftest.sut.message.monitor";
    }

    public static void logSutMessage(final String string, final String string2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "logSutMessage(String,String)", 2173).addDetail("message", string)).addDetail("property", string2)).log();
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                if (f.level >= 7) {
                    f.lvlBuild(7, "logSutMessage(String,String).PrivilegedAction<Object>.run()", 2179).log();
                }
                Object object = Util.getSutMessageMonitor();
                synchronized (object) {
                    String string3 = (String)System.getProperties().remove(string2);
                    if (string3 == null) {
                        System.getProperties().put(string2, string);
                    } else {
                        ArrayList arrayList = Util.splitMessages(string3);
                        while (arrayList.size() >= 1000) {
                            arrayList.remove(0);
                        }
                        arrayList.add(string);
                        System.getProperties().put(string2, Util.b(arrayList));
                    }
                }
                return null;
            }
        });
    }

    private static String b(ArrayList arrayList) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "joinMessages(ArrayList<String>)", 2210).addDetail("messages", (Object)arrayList)).log();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            if (i2 > 0) {
                stringBuffer.append("\n\n\n");
            }
            stringBuffer.append((String)arrayList.get(i2));
        }
        return stringBuffer.toString();
    }

    public static ArrayList splitMessages(String string) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "splitMessages(String)", 2233).addDetail("messages", string)).log();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(Misc.lineSepToLineFeed((String)string), "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("\n".equals(string2)) {
                if (n2 > 1) {
                    if (stringBuffer.length() > 0) {
                        arrayList.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                    }
                    n2 = 0;
                    continue;
                }
                ++n2;
                continue;
            }
            if (n2 > 0 && stringBuffer.length() > 0) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    stringBuffer.append("\n");
                }
            }
            stringBuffer.append(string2);
            n2 = 0;
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    public static String timestamp(Date date) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "timestamp(Date)", 2277).addDetail("date", (Object)date)).log();
        }
        if (date == null) {
            throw new IllegalArgumentException("date is marked non-null but is null");
        }
        return h.format(date);
    }

    public static String timestamp() {
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "timestamp()", 2290).log();
        }
        return Util.timestamp(new Date());
    }

    public static String formatDuration(long l2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "formatDuration(long)", 2305).addDetail("duration", l2)).log();
        }
        long l3 = l2 % 1000L;
        String string = "ms";
        StringBuffer stringBuffer = new StringBuffer();
        if ((l2 /= 1000L) > 0L) {
            string = "s";
            long l4 = l2 % 60L;
            if ((l2 /= 60L) > 0L) {
                string = "min";
                long l5 = l2 % 60L;
                if ((l2 /= 60L) > 0L) {
                    string = "h";
                    long l6 = l2 % 24L;
                    if ((l2 /= 24L) > 0L) {
                        stringBuffer.append(l2);
                        stringBuffer.append(" d  ");
                    }
                    stringBuffer.append(l6);
                    stringBuffer.append(':');
                    if (l5 < 10L) {
                        stringBuffer.append("0");
                    }
                }
                stringBuffer.append(l5);
                stringBuffer.append(':');
                if (l4 < 10L) {
                    stringBuffer.append("0");
                }
            }
            stringBuffer.append(l4);
            stringBuffer.append('.');
            if (l3 < 100L) {
                stringBuffer.append('0');
                if (l3 < 10L) {
                    stringBuffer.append('0');
                }
            }
        }
        stringBuffer.append(l3);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static String a(View view) {
        block8: {
            if (Util.f.level >= 7) {
                ((LevelAwareLogBuilder)f.lvlBuild(7, "getHTMLTextOfSwingView(View)", 2365).addDetail("view", (Object)view)).log();
            }
            try {
                String string = Misc.lineSepToLineFeed((String)view.getDocument().getText(0, view.getDocument().getLength()));
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "getHTMLTextOfSwingView(View)", 2371).add("tmp", string)).log();
                }
                if (string != null) {
                    int n2;
                    int n3;
                    for (n3 = 0; n3 < string.length() && string.charAt(n3) == '\n'; ++n3) {
                    }
                    for (n2 = string.length() - 1; n2 >= n3 && string.charAt(n2) == '\n'; --n2) {
                    }
                    String string2 = string.substring(n3, n2 + 1);
                    if (Util.f.level >= 9) {
                        ((LevelAwareLogBuilder)f.lvlBuild(9, "getHTMLTextOfSwingView(View)", 2382).add("result", string2)).log();
                    }
                    return string2;
                }
            }
            catch (Exception exception) {
                if (Util.f.level < 3) break block8;
                ((LevelAwareLogBuilder)f.lvlBuild(3, "getHTMLTextOfSwingView(View)", 2387).add("ex", (Object)exception)).log();
            }
        }
        return null;
    }

    public static String getSessionInformation(int n2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getSessionInformation(int)", 2405).addDetail("pid", n2)).log();
        }
        if (!Options.getBoolean(Options.OPT_LOG_DISABLE_SESSION_QUERY, false)) {
            int n3;
            Object object;
            Object object2;
            String string = Util.query(new String[]{"session"});
            StringBuilder stringBuilder = new StringBuilder();
            try {
                object2 = string.split("\n");
                for (int i2 = 1; i2 < ((String[])object2).length; ++i2) {
                    object = object2[i2].replaceFirst(" ", "").split("\\s+");
                    stringBuilder.append(object[0]);
                    for (n3 = 1; n3 < ((Object)object).length; ++n3) {
                        stringBuilder.append(" | ");
                        stringBuilder.append((String)object[n3]);
                    }
                    stringBuilder.append("\n  ");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object2 = Util.query(new String[]{"process", String.valueOf(n2)});
            StringBuilder stringBuilder2 = new StringBuilder();
            try {
                object = ((String)object2).split("\n")[1].replace(">", "").split("\\s+");
                stringBuilder2.append((String)object[0]);
                for (n3 = 1; n3 < ((Object)object).length; ++n3) {
                    stringBuilder2.append(" | ");
                    stringBuilder2.append((String)object[n3]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Sessions:\n  ");
            ((StringBuilder)object).append((CharSequence)stringBuilder);
            ((StringBuilder)object).append("\nSUT Process:\n  ");
            ((StringBuilder)object).append((CharSequence)stringBuilder2);
            return ((StringBuilder)object).toString();
        }
        return "No information collected.";
    }

    public static String getShortFileName(String string) {
        block9: {
            if (Util.f.level >= 7) {
                ((LevelAwareLogBuilder)f.lvlBuild(7, "getShortFileName(String)", 2461).addDetail("filename", string)).log();
            }
            String[] stringArray = new String[]{"cmd", "/c", "for %i in (\"" + string + "\") do @echo %~si"};
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "getShortFileName(String)", 2466).add("cmdArray", (Object)stringArray)).log();
            }
            try {
                String string2 = ProcessManager.runProcess((String[])stringArray, (int)10000);
                if (Util.f.level >= 5) {
                    ((LevelAwareLogBuilder)f.lvlBuild(5, "getShortFileName(String)", 2469).add("procs", string2)).log();
                }
                if (Misc.emptyOrNull((String)string2)) {
                    if (Util.f.level >= 3) {
                        ((LevelAwareLogBuilder)f.lvlBuild(3, "getShortFileName(String)", 2471).add("command did not return anything")).log();
                    }
                } else {
                    String[] stringArray2 = Misc.splitLines((String)string2);
                    if (stringArray2.length > 0) {
                        return stringArray2[stringArray2.length - 1].trim();
                    }
                }
            }
            catch (ProcessManager.RunProcessException runProcessException) {
                if (Util.f.level < 1) break block9;
                ((LevelAwareLogBuilder)f.lvlBuild(1, "getShortFileName(String)", 2480).add("ex", (Object)runProcessException)).log();
            }
        }
        return string;
    }

    public static String query(String[] stringArray) {
        block14: {
            if (Util.f.level >= 7) {
                ((LevelAwareLogBuilder)f.lvlBuild(7, "query(String[])", 2494).addDetail("cmd", (Object)stringArray)).log();
            }
            String[] stringArray2 = null;
            String string = System.getenv("windir");
            File file = new File(string + "/System32/query.exe");
            stringArray2 = file.exists() ? new String[]{"cmd", "/c", string + "/System32/query.exe"} : new String[]{"cmd", "/c", string + "/Sysnative/query.exe"};
            String[] stringArray3 = new String[stringArray2.length + stringArray.length];
            System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
            System.arraycopy(stringArray, 0, stringArray3, stringArray2.length, stringArray.length);
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "query(String[])", 2514).add("query", (Object)stringArray3)).log();
            }
            try {
                ProcessManager processManager = new ProcessManager("query", stringArray3);
                processManager.setCollect(true, false);
                processManager.startProcess();
                if (!processManager.waitFor(10000L)) {
                    if (Util.f.level >= 3) {
                        ((LevelAwareLogBuilder)f.lvlBuild(3, "query(String[])", 2521).add("command did not terminate")).log();
                    }
                    return null;
                }
                int n2 = processManager.getExitCode();
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "query(String[])", 2525).add("exitCode", n2)).log();
                }
                String string2 = processManager.getProcessOutputString();
                if (Util.f.level >= 5) {
                    ((LevelAwareLogBuilder)f.lvlBuild(5, "query(String[])", 2531).add("procs", string2)).log();
                }
                if (Misc.emptyOrNull((String)string2)) {
                    if (Util.f.level >= 3) {
                        ((LevelAwareLogBuilder)f.lvlBuild(3, "query(String[])", 2533).add("command did not return anything")).log();
                    }
                    return null;
                }
                return string2;
            }
            catch (IOException iOException) {
                if (Util.f.level >= 1) {
                    ((LevelAwareLogBuilder)f.lvlBuild(1, "query(String[])", 2540).add("ex", (Object)iOException)).log();
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (Util.f.level >= 1) {
                    ((LevelAwareLogBuilder)f.lvlBuild(1, "query(String[])", 2543).add("ex", (Object)numberFormatException)).log();
                }
            }
            catch (Exception exception) {
                if (Util.f.level < 1) break block14;
                ((LevelAwareLogBuilder)f.lvlBuild(1, "query(String[])", 2546).add("ex", (Object)exception)).log();
            }
        }
        return null;
    }

    public static List getTopicDirs(@Nullable String string, LocationPreference locationPreference) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "getTopicDirs(String,LocationPreference)", 2563).addDetail("topic", string)).addDetail("locationPreference", (Object)locationPreference)).log();
        }
        return Util.getTopicDirs(string, locationPreference, true);
    }

    public static List getTopicDirs(@Nullable String string, LocationPreference locationPreference, boolean bl) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "getTopicDirs(String,LocationPreference,boolean)", 2579).addDetail("topic", string)).addDetail("locationPreference", (Object)locationPreference)).addDetail("includeQftestDirs", bl)).log();
        }
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        Util.a(Util.getUserConfigDir(), string, linkedList);
        String string2 = Util.getSystemConfigDir();
        String string3 = Globals.getGlobalString("qftestdir", null);
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "getTopicDirs(String,LocationPreference,boolean)", 2588).add("sysConfigDir", string2)).add("qftestdir", string3)).log();
        }
        if (bl || string3 == null || !string3.equals(string2)) {
            Util.a(string2, string, linkedList2);
        }
        if (bl) {
            String string4 = Globals.getGlobalString("qftestversiondir", null);
            Util.a(string4, string, linkedList2);
        }
        switch (locationPreference) {
            case ONLY_USER_DIR: {
                return linkedList;
            }
            case ONLY_SYSTEM_DIR: {
                return linkedList2;
            }
            case PREFER_SYSTEM_DIR: {
                linkedList2.addAll(linkedList);
                return linkedList2;
            }
        }
        linkedList.addAll(linkedList2);
        return linkedList;
    }

    private static boolean a(@Nullable File file, @Nullable String string, List list) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "addTopicDirToList(File,String,List<String>)", 2613).addDetail("parentDir", (Object)file)).addDetail("topic", string)).addDetail("list", (Object)list)).log();
        }
        if (list == null) {
            throw new IllegalArgumentException("list is marked non-null but is null");
        }
        if (file != null && file.isDirectory()) {
            if (string == null) {
                list.add(Misc.getBestPath((File)file));
                return true;
            }
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                list.add(Misc.getBestPath((File)file2));
                return true;
            }
        }
        return false;
    }

    private static void a(@Nullable String string, @Nullable String string2, List list) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "addTopicDirToList(String,String,List<String>)", 2634).addDetail("parentDir", string)).addDetail("topic", string2)).addDetail("list", (Object)list)).log();
        }
        if (list == null) {
            throw new IllegalArgumentException("list is marked non-null but is null");
        }
        if (string != null) {
            Util.a(new File(string), string2, list);
        }
    }

    @Nullable
    public static String getTopicDir(@Nullable String string, boolean bl, LocationPreference locationPreference) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "getTopicDir(String,boolean,LocationPreference)", 2655).addDetail("topic", string)).addDetail("writeable", bl)).addDetail("locationPreference", (Object)locationPreference)).log();
        }
        boolean bl2 = !bl || Native.instance().writeToQFTestDirAllowed();
        for (String string2 : Util.getTopicDirs(string, locationPreference, bl2)) {
            if (string2 == null || bl && !new File(string2).canWrite()) continue;
            return string2;
        }
        return null;
    }

    private static String b() {
        block18: {
            Iterator iterator;
            if (Util.f.level >= 7) {
                f.lvlBuild(7, "determineUserConfigDirectory()", 2670).log();
            }
            LinkedList<Object> linkedList = new LinkedList<Object>();
            LinkedList<Object> linkedList2 = new LinkedList<Object>();
            String string = Globals.getGlobalString("qftestuserdir", null);
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "determineUserConfigDirectory()", 2681).add("overrideUserDir", string)).log();
            }
            if (string != null) {
                iterator = new File(string);
                linkedList.add(iterator);
                linkedList2.add(iterator);
            } else {
                Object object;
                iterator = System.getProperty("qftest.userconfigdir");
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "determineUserConfigDirectory()", 2689).add("configDirProperty", (String)((Object)iterator))).log();
                }
                if (iterator != null) {
                    object = new File((String)((Object)iterator));
                    if (((File)object).isDirectory()) {
                        linkedList.add(object);
                        linkedList2.add(object);
                    }
                } else {
                    object = Globals.getGlobalString("qftestdir", null);
                    File file = new File((String)object, "userdir");
                    if (Util.f.level >= 9) {
                        ((LevelAwareLogBuilder)f.lvlBuild(9, "determineUserConfigDirectory()", 2701).add("userDirInRoot", (Object)file)).log();
                    }
                    linkedList.add(file);
                    File file2 = Native.instance().getApplicationSupportDirectory();
                    linkedList.add(file2);
                    linkedList2.add(file2);
                    File file3 = new File(Globals.PRE42_USER_CFG_DIR);
                    linkedList.add(file3);
                    linkedList2.add(file3);
                }
            }
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "determineUserConfigDirectory()", 2716).add("createOrder", linkedList2)).add("existingOrder", linkedList)).log();
            }
            for (Object object : linkedList) {
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "determineUserConfigDirectory()", 2720).add("trying folder ")).add(object)).log();
                }
                if (object == null || !((File)object).exists()) continue;
                return Misc.getBestPath(object);
            }
            boolean bl = Util.isRunningInteractively();
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "determineUserConfigDirectory()", 2728).add("interactive", bl)).log();
            }
            if (bl) {
                try {
                    for (File file : linkedList2) {
                        if (Util.f.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "determineUserConfigDirectory()", 2732).add("trying to create folder ")).add((Object)file)).log();
                        }
                        if (file == null || !file.mkdirs()) continue;
                        return Misc.getBestPath((File)file);
                    }
                }
                catch (Exception exception) {
                    if (Util.f.level < 1) break block18;
                    ((LevelAwareLogBuilder)f.lvlBuild(1, "determineUserConfigDirectory()", 2738).add("ex", (Object)exception)).log();
                }
            }
        }
        return Globals.PRE42_USER_CFG_DIR;
    }

    private static String c() {
        boolean bl;
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "determineSystemConfigDirectory()", 2750).log();
        }
        String string = Globals.getGlobalString("qftestsystemdir", null);
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "determineSystemConfigDirectory()", 2754).add("overrideSystemDir", string)).log();
        }
        if (string != null) {
            return string;
        }
        String string2 = System.getProperty("qftest.systemconfigdir");
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "determineSystemConfigDirectory()", 2761).add("systemDirProperty", string2)).log();
        }
        if (string2 != null) {
            return string2;
        }
        String string3 = Globals.getGlobalString("qftestdir", null);
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "determineSystemConfigDirectory()", 2768).add("baseDir", string3)).log();
        }
        boolean bl2 = bl = Misc.OS_IS_WINDOWS && Native.instance().isCompliantInstallation();
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "determineSystemConfigDirectory()", 2774).add("isWindowsCompliantInstall", bl)).log();
        }
        if (!Misc.OS_IS_WINDOWS || bl) {
            File file = Native.instance().getSystemApplicationSupportDirectory(false);
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "determineSystemConfigDirectory()", 2777).add("systemAppSupportDir", (Object)file)).log();
            }
            if (file != null && file.isDirectory()) {
                return Misc.getBestPath((File)file);
            }
            if (!Native.instance().writeToQFTestDirAllowed()) {
                return Util.getUserConfigDir();
            }
        }
        return string3;
    }

    private static String d() {
        File file;
        block12: {
            if (Util.f.level >= 7) {
                f.lvlBuild(7, "determineCacheDirectory()", 2794).log();
            }
            if ((file = Native.instance().getCacheDirectory()) == null) {
                String string = Util.getTopicDir("Cache", true, LocationPreference.PREFER_USER_DIR);
                if (string != null) {
                    file = new File(string);
                } else {
                    try {
                        file = Files.createTempDirectory("qftest.cache", new FileAttribute[0]).toFile();
                    }
                    catch (IOException iOException) {
                        if (Util.f.level >= 5) {
                            ((LevelAwareLogBuilder)f.lvlBuild(5, "determineCacheDirectory()", 2805).add("Could not create temp directory.")).log();
                        }
                        file = new File(".");
                    }
                }
            }
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "determineCacheDirectory()", 2810).add("cacheDirectory", (Object)file)).log();
            }
            if (!file.exists()) {
                try {
                    if (!file.mkdirs() && Util.f.level >= 3) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(3, "determineCacheDirectory()", 2815).add("Could not create cache directory ")).add((Object)file)).log();
                    }
                }
                catch (Exception exception) {
                    if (Util.f.level < 3) break block12;
                    ((LevelAwareLogBuilder)f.lvlBuild(3, "determineCacheDirectory()", 2818).add("Could not create cache directory " + file, (Object)exception)).log();
                }
            }
        }
        return Misc.getBestPath((File)file);
    }

    public static void syncDirectoriesWithArguments(ArgsParser argsParser) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "syncDirectoriesWithArguments(ArgsParser)", 2827).addDetail("parser", (Object)argsParser)).log();
        }
        if (argsParser == null) {
            throw new IllegalArgumentException("parser is marked non-null but is null");
        }
        String string = argsParser.getString("userdir", null);
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "syncDirectoriesWithArguments(ArgsParser)", 2830).add("userDir", string)).log();
        }
        if (string != null) {
            string = Misc.getBestPath((String)string);
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "syncDirectoriesWithArguments(ArgsParser)", 2833).add("userDir", string)).log();
            }
        }
        String string2 = argsParser.getString("systemdir", null);
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "syncDirectoriesWithArguments(ArgsParser)", 2836).add("systemDir", string2)).log();
        }
        if (string2 != null) {
            string2 = Misc.getBestPath((String)string2);
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "syncDirectoriesWithArguments(ArgsParser)", 2839).add("systemDir", string2)).log();
            }
        }
        Globals.addGlobal((Option)new StringOption("qftestuserdir", string));
        Globals.addGlobal((Option)new StringOption("qftestsystemdir", string2));
        Util.a(argsParser);
        Util.b(argsParser);
    }

    static void a(ArgsParser argsParser) {
        String string;
        String string2;
        boolean bl;
        File file;
        String string3;
        Hashtable hashtable;
        block24: {
            if (Util.f.level >= 7) {
                ((LevelAwareLogBuilder)f.lvlBuild(7, "syncLogDirectoryWithArguments(ArgsParser)", 2865).addDetail("ap", (Object)argsParser)).log();
            }
            if (argsParser == null) {
                throw new IllegalArgumentException("ap is marked non-null but is null");
            }
            hashtable = argsParser.getOptions();
            string3 = null;
            file = null;
            bl = Util.isRunningInSUT();
            try {
                string2 = argsParser.getString("logfile", null);
                string = argsParser.getString("logdir", null);
                File file2 = Util.e();
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "syncLogDirectoryWithArguments(ArgsParser)", 2876).add("logfilePath", string2)).add("logdirPath", string)).add("defaultLogDir", (Object)file2)).log();
                }
                File file3 = null;
                if (!Misc.emptyOrNull((String)string2)) {
                    boolean bl2;
                    string2 = e.equals(string2) ? d : string2.replace(e, file2.getAbsolutePath());
                    boolean bl3 = bl2 = string2.contains(File.separator) || string2.contains("/");
                    if (bl2) {
                        file = new File(string2);
                        if (file.isDirectory()) {
                            file3 = file;
                            file = null;
                        } else {
                            string3 = file.getName();
                            file3 = file.getParentFile();
                        }
                    } else {
                        string3 = string2;
                    }
                }
                if (!Misc.emptyOrNull((String)string)) {
                    string = string.replace(e, file2.getAbsolutePath());
                    file3 = new File(string);
                }
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "syncLogDirectoryWithArguments(ArgsParser)", 2903).add("newLogDir", (Object)file3)).log();
                }
                if (file3 == null && !bl) {
                    file3 = file2;
                }
                if (file3 != null && !file3.exists() && !file3.mkdirs() && Util.f.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(3, "syncLogDirectoryWithArguments(ArgsParser)", 2911).add("Could not create logdir: ")).add((Object)file3)).log();
                }
                if (file3 != null) {
                    s = Misc.getBestPath((File)file3);
                }
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "syncLogDirectoryWithArguments(ArgsParser)", 2918).add("Util.logDir", s)).log();
                }
            }
            catch (Exception exception) {
                if (Util.f.level < 1) break block24;
                ((LevelAwareLogBuilder)f.lvlBuild(1, "syncLogDirectoryWithArguments(ArgsParser)", 2920).add("ex", (Object)exception)).log();
            }
        }
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "syncLogDirectoryWithArguments(ArgsParser)", 2922).add("logFileName", string3)).add("explicitLogFile", file)).log();
        }
        string2 = null;
        string = Util.getLogDir();
        if (file == null) {
            if (Misc.emptyOrNull(string3) && !bl) {
                string3 = d;
            }
            if (!Misc.emptyOrNull(string3)) {
                string2 = Misc.getBestPath((File)new File(Util.getLogDir(), string3));
            }
        } else {
            string2 = Misc.getBestPath(file);
        }
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "syncLogDirectoryWithArguments(ArgsParser)", 2938).add("logfilePath", string2)).log();
        }
        if (string2 != null) {
            hashtable.put("logfile", string2);
        }
        if (argsParser.getBoolean("dbg", false)) {
            System.out.format("logdir: %s\nlogfile: %s\n", string, string2 == null ? "none" : string2);
        }
    }

    public static void extractZipToFolder(InputStream inputStream, File file) throws IOException {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "extractZipToFolder(InputStream,File)", 2959).addDetail("inputStream", (Object)inputStream)).addDetail("destinationFolder", (Object)file)).log();
        }
        Util.extractZipToFolder(inputStream, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZipToFolder(InputStream inputStream, File file, boolean bl) throws IOException {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "extractZipToFolder(InputStream,File,boolean)", 2971).addDetail("inputStream", (Object)inputStream)).addDetail("destinationFolder", (Object)file)).addDetail("flatExtract", bl)).log();
        }
        byte[] byArray = new byte[10240];
        try (ZipInputStream zipInputStream = null;){
            zipInputStream = new ZipInputStream(inputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "extractZipToFolder(InputStream,File,boolean)", 2981).add("zipEntry", (Object)zipEntry)).log();
            }
            while (zipEntry != null) {
                block17: {
                    String string = zipEntry.getName();
                    try {
                        File file2 = new File(file, string);
                        if (bl) {
                            file2 = new File(file, file2.getName());
                        }
                        if (Util.f.level >= 9) {
                            ((LevelAwareLogBuilder)f.lvlBuild(9, "extractZipToFolder(InputStream,File,boolean)", 2989).add("fileToCreate", (Object)file2)).log();
                        }
                        new File(file2.getParent()).mkdirs();
                        if (zipEntry.isDirectory()) break block17;
                        try (FileOutputStream fileOutputStream = null;){
                            int n2;
                            fileOutputStream = new FileOutputStream(file2);
                            while ((n2 = zipInputStream.read(byArray)) > 0) {
                                fileOutputStream.write(byArray, 0, n2);
                            }
                        }
                    }
                    finally {
                        zipInputStream.closeEntry();
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractFolder(File file, File file2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "extractFolder(File,File)", 3027).addDetail("file", (Object)file)).addDetail("destinationFolder", (Object)file2)).log();
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Util.extractZipToFolder(fileInputStream, file2);
        }
        catch (Exception exception) {
            if (Util.f.level >= 3) {
                ((LevelAwareLogBuilder)f.lvlBuild(3, "extractFolder(File,File)", 3034).add("e", (Object)exception)).log();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            block15: {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    if (Util.f.level < 9) break block15;
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "extractFolder(File,File)", 3042).add("e", (Object)iOException)).log();
                }
            }
        }
        return true;
    }

    static void b(ArgsParser argsParser) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "syncLanguageDirsWithArguments(ArgsParser)", 3051).addDetail("parser", (Object)argsParser)).log();
        }
        if (argsParser == null) {
            throw new IllegalArgumentException("parser is marked non-null but is null");
        }
        for (String string : k) {
            Object object;
            String string2;
            Object[] objectArray = argsParser.getStrings(string + "dir", null);
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "syncLanguageDirsWithArguments(ArgsParser)", 3054).add("dirs", (Object)objectArray)).log();
            }
            if (argsParser.getString(string + "dir", null) != null) {
                string2 = Misc.getBestPath((String)argsParser.getString(string + "dir", null));
            } else if (!Misc.emptyOrNull((Object[])objectArray)) {
                object = (String[])objectArray.clone();
                for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                    object[i2] = Misc.getBestPath((String)object[i2]);
                }
                string2 = Misc.join((Object[])object, (String)File.pathSeparator);
            } else {
                object = Util.getTopicDirs(string, LocationPreference.PREFER_USER_DIR, false);
                string2 = object.isEmpty() ? Misc.getBestPath((File)new File(Util.getSystemConfigDir(), string)) : (String)object.get(0);
            }
            Globals.addGlobal((Option)new StringOption(string + "dir", string2));
        }
    }

    private static File e() {
        String string;
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "getDefaultLogDir()", 3081).log();
        }
        if ((string = Util.getTopicDir(c, true, LocationPreference.PREFER_USER_DIR)) != null) {
            return new File(string);
        }
        String string2 = Util.getTopicDir(null, true, LocationPreference.PREFER_USER_DIR);
        return new File(string2, c);
    }

    @Nullable
    public static String getTopicDir(@Nullable String string, LocationPreference locationPreference) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "getTopicDir(String,LocationPreference)", 3103).addDetail("topic", string)).addDetail("locationPreference", (Object)locationPreference)).log();
        }
        return Util.getTopicDir(string, false, locationPreference);
    }

    @Nullable
    public static File getTopicFile(String string, @Nullable String string2, FileState fileState, LocationPreference locationPreference) {
        File file;
        File file2;
        boolean bl;
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "getTopicFile(String,String,FileState,LocationPreference)", 3121).addDetail("filename", string)).addDetail("topic", string2)).addDetail("fileState", (Object)fileState)).addDetail("locationPreference", (Object)locationPreference)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("filename is marked non-null but is null");
        }
        boolean bl2 = fileState == FileState.WRITABLE || fileState == FileState.CREATABLE;
        boolean bl3 = bl = !bl2 || Native.instance().writeToQFTestDirAllowed();
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "getTopicFile(String,String,FileState,LocationPreference)", 3125).add("requireWriteable", bl2)).add("includeQftestDirs", bl)).log();
        }
        List list = Util.getTopicDirs(string2, locationPreference, bl);
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "getTopicFile(String,String,FileState,LocationPreference)", 3128).add("topicDirs", (Object)list)).log();
        }
        for (String string3 : list) {
            file2 = new File(string3);
            if (string3 == null || !(file = new File(file2, string)).exists()) continue;
            if (fileState == FileState.EXISTS || fileState == FileState.UNDEFINED) {
                return file;
            }
            if (fileState == FileState.READABLE && file.canRead()) {
                return file;
            }
            if (!bl2 || !file.canWrite()) continue;
            return file;
        }
        for (String string3 : list) {
            file2 = new File(string3);
            if (string3 == null) continue;
            file = new File(file2, string);
            if (fileState == FileState.UNDEFINED) {
                return file;
            }
            if (fileState != FileState.CREATABLE || !file2.canWrite() || file.exists()) continue;
            return file;
        }
        return null;
    }

    public static void delayedRun(final Runnable runnable2, long l2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "delayedRun(Runnable,long)", 3171).addDetail("task", (Object)runnable2)).addDetail("delay", l2)).log();
        }
        if (l2 < 0L) {
            l2 = 0L;
        }
        final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(runnable -> new DaemonThread(runnable, "DelayedRun Executor Thread"));
        scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                block9: {
                    if (f.level >= 7) {
                        f.lvlBuild(7, "delayedRun(Runnable,long).Runnable.run()", 3182).log();
                    }
                    try {
                        try {
                            runnable2.run();
                        }
                        catch (Throwable throwable) {
                            if (f.level >= 1) {
                                ((LevelAwareLogBuilder)f.lvlBuild(1, "delayedRun(Runnable,long).Runnable.run()", 3188).add("ex", (Object)throwable)).log();
                            }
                        }
                        finally {
                            scheduledExecutorService.shutdownNow();
                        }
                    }
                    catch (Throwable throwable) {
                        if (f.level < 1) break block9;
                        ((LevelAwareLogBuilder)f.lvlBuild(1, "delayedRun(Runnable,long).Runnable.run()", 3193).add("ex", (Object)throwable)).log();
                    }
                }
            }
        }, l2, TimeUnit.MILLISECONDS);
    }

    public static String indent(@Nullable String string, int n2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "indent(String,int)", 3208).addDetail("input", string)).addDetail("n", n2)).log();
        }
        if (string == null) {
            return "";
        }
        String string2 = n2 == 0 ? "" : String.format("%" + n2 + "s", "");
        return string.replaceAll("(?m)^(.*)", string2 + "$1");
    }

    public static boolean isRunningInteractively() {
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "isRunningInteractively()", 3221).log();
        }
        return Globals.getGlobalBoolean("interactive", false);
    }

    public static boolean isRunningInSUT() {
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "isRunningInSUT()", 3232).log();
        }
        return Globals.getGlobalValue("clientstarter", null) != null;
    }

    public static Date nanoToDate(long l2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "nanoToDate(long)", 3246).addDetail("timestamp", l2)).log();
        }
        return new Date(a + (l2 - b) / 1000000L);
    }

    public static String formatNano(long l2) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "formatNano(long)", 3257).addDetail("timestamp", l2)).log();
        }
        long l3 = l2 - b;
        long l4 = l3 / 1000000L;
        long l5 = l3 - l4 * 1000000L;
        Date date = new Date(a + l4);
        return String.format("%s%06d", h.format(date), l5);
    }

    public static void suppressAwtConnect(String string) {
        if (System.getProperty("qftest.connector.dontsuppress") == null) {
            System.getProperties().put("qftest.connector.suppress", string);
        }
    }

    public static boolean invokeAndWaitForSwingHelper(Runnable runnable) {
        return Util.a(runnable, true);
    }

    public static void invokeRunnableForSwingHelper(Runnable runnable) {
        Util.a(runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean a(Runnable runnable, boolean bl) {
        String string = System.getProperty("qftest.connector.suppress");
        try {
            if (!Options.cached_OPT_CONNECT_HELPER_AWT_ENGINE) {
                if (Util.f.level >= 9) {
                    ((LevelAwareLogBuilder)f.lvlBuild(9, "invokeRunnableForSwingHelper(Runnable,boolean)", 3318).add("Suppressing AWT engine connection")).log();
                }
                System.setProperty("qftest.connector.suppress", "HelperStarting");
            }
            if (bl) {
                boolean bl2 = SwingUtil.invokeAndWait((Runnable)runnable);
                return bl2;
            }
            runnable.run();
            boolean bl3 = true;
            return bl3;
        }
        finally {
            if (string == null) {
                System.clearProperty("qftest.connector.suppress");
            } else {
                System.setProperty("qftest.connector.suppress", string);
            }
        }
    }

    public static String getQftestJava() {
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "getQftestJava()", 3342).log();
        }
        String string = System.getProperty("qftest.java");
        if (Util.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "getQftestJava()", 3345).add("jexe", string)).log();
        }
        if (string != null && new File(string).isAbsolute()) {
            return Misc.getBestPath((String)string);
        }
        String string2 = System.getProperty("java.home");
        if (string2 != null) {
            File file = new File(string2, "bin");
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "getQftestJava()", 3353).add("javaBinDir", (Object)file)).log();
            }
            File file2 = null;
            if (string != null && !(file2 = new File(file, string)).exists()) {
                file2 = null;
            }
            if (file2 == null) {
                file2 = new File(file, "java" + (Misc.OS_IS_WINDOWS ? "w.exe" : ""));
            }
            if (Util.f.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "getQftestJava()", 3364).add("javaBin", (Object)file2)).add("exists: ")).add(file2 != null && file2.exists())).log();
            }
            if (file2 != null && file2.exists()) {
                return Misc.getBestPath((File)file2);
            }
        }
        return Misc.OS_IS_WINDOWS ? "javaw" : "java";
    }

    public static boolean isInteractiveAndDesktopActionSupported(Desktop.Action action) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "isInteractiveAndDesktopActionSupported(Action)", 3382).addDetail("action", (Object)action)).log();
        }
        if (!Util.isRunningInteractively()) {
            return false;
        }
        return Misc.isDesktopActionSupported((Desktop.Action)action);
    }

    @Deprecated
    public static void main(String[] stringArray) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "main(String[])", 3401).addDetail("args", (Object)stringArray)).log();
        }
        JavaInfo.main(stringArray);
    }

    public static VariableData wrapInVariableData(Object object) {
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "wrapInVariableData(Object)", 3414).addDetail("object", object)).log();
        }
        if (object == null) {
            return null;
        }
        if (object instanceof VariableData) {
            return (VariableData)object;
        }
        VariableData variableData = VariableData.from(object);
        Object[][] objectArray = Options.cached_OPT_VARIABLE_NO_SERIALIZED_CLASSES;
        if (objectArray != null) {
            for (Object[] objectArray2 : objectArray) {
                if (Misc.emptyOrNull((Object[])objectArray2) || !Util.isInstance(object, (String)objectArray2[0])) continue;
                variableData.setSerializable(false);
                break;
            }
        }
        return variableData;
    }

    public static String getWebCompatiblePath(File file) {
        String string;
        if (Util.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getWebCompatiblePath(File)", 3438).addDetail("file", (Object)file)).log();
        }
        if (!(string = file.getAbsolutePath().replace(File.separatorChar, '/')).startsWith("/")) {
            string = "/" + string;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserConfigDir() {
        Object object;
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "getUserConfigDir()", 177).log();
        }
        if ((object = m.get()) == null) {
            AtomicReference atomicReference = m;
            synchronized (atomicReference) {
                object = m.get();
                if (object == null) {
                    String string = Util.b();
                    object = string == null ? m : string;
                    m.set(object);
                }
            }
        }
        return object == m ? null : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSystemConfigDir() {
        Object object;
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "getSystemConfigDir()", 178).log();
        }
        if ((object = n.get()) == null) {
            AtomicReference atomicReference = n;
            synchronized (atomicReference) {
                object = n.get();
                if (object == null) {
                    String string = Util.c();
                    object = string == null ? n : string;
                    n.set(object);
                }
            }
        }
        return object == n ? null : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCacheDir() {
        Object object;
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "getCacheDir()", 179).log();
        }
        if ((object = o.get()) == null) {
            AtomicReference atomicReference = o;
            synchronized (atomicReference) {
                object = o.get();
                if (object == null) {
                    String string = Util.d();
                    object = string == null ? o : string;
                    o.set(object);
                }
            }
        }
        return object == o ? null : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJythonDir() {
        Object object;
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "getJythonDir()", 181).log();
        }
        if ((object = p.get()) == null) {
            AtomicReference atomicReference = p;
            synchronized (atomicReference) {
                object = p.get();
                if (object == null) {
                    String string = Globals.getGlobalString("jythondir", null);
                    object = string == null ? p : string;
                    p.set(object);
                }
            }
        }
        return object == p ? null : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGroovyDir() {
        Object object;
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "getGroovyDir()", 182).log();
        }
        if ((object = q.get()) == null) {
            AtomicReference atomicReference = q;
            synchronized (atomicReference) {
                object = q.get();
                if (object == null) {
                    String string = Globals.getGlobalString("groovydir", null);
                    object = string == null ? q : string;
                    q.set(object);
                }
            }
        }
        return object == q ? null : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJavascriptDir() {
        Object object;
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "getJavascriptDir()", 183).log();
        }
        if ((object = r.get()) == null) {
            AtomicReference atomicReference = r;
            synchronized (atomicReference) {
                object = r.get();
                if (object == null) {
                    String string = Globals.getGlobalString("javascriptdir", null);
                    object = string == null ? r : string;
                    r.set(object);
                }
            }
        }
        return object == r ? null : object;
    }

    public static String getLogDir() {
        if (Util.f.level >= 7) {
            f.lvlBuild(7, "getLogDir()", 194).log();
        }
        return s;
    }

    public static enum LocationPreference {
        ONLY_USER_DIR,
        PREFER_USER_DIR,
        ONLY_SYSTEM_DIR,
        PREFER_SYSTEM_DIR;


        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private LocationPreference() {
            if (f.level >= 7) {
                f.lvlBuild(7, "LocationPreference.LocationPreference()", 218).log();
            }
        }
    }

    public static enum FileState {
        UNDEFINED,
        EXISTS,
        READABLE,
        WRITABLE,
        CREATABLE;


        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private FileState() {
            if (f.level >= 7) {
                f.lvlBuild(7, "FileState.FileState()", 205).log();
            }
        }
    }
}

