/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.ai;

import de.qfs.apps.qftest.shared.ai.c;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class AIModel
implements Serializable {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.ai.AIModel");

    public static ModelConfiguration getConfiguration(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        Optional<ModelConfiguration> optional = AIModel.getConfigurations().stream().filter(modelConfiguration -> string.equals(modelConfiguration.a)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new IllegalArgumentException("Provider not found in options: " + string);
    }

    public static List getConfigurations() {
        Object[][] objectArray = (Object[][])Misc.valueOrDefault((Object)Options.cached_OPT_LLM_PROVIDERS, (Object)new Object[0][]);
        List list = Options.cached_OPT_CUSTOM_LLM_PROVIDER_NAMES;
        ArrayList arrayList = new ArrayList();
        if (objectArray != null) {
            Arrays.stream(objectArray).map(AIModel::a).filter(modelConfiguration -> list == null || !list.contains(modelConfiguration.getDisplayName())).forEach(arrayList::add);
        }
        if (list != null) {
            list.stream().map(AIModel::a).forEach(arrayList::add);
        }
        return arrayList;
    }

    public static List getConfigurationNames(List list) {
        if (list == null) {
            throw new IllegalArgumentException("models is marked non-null but is null");
        }
        return list.stream().map(ModelConfiguration::getDisplayName).collect(Collectors.toList());
    }

    private static ModelConfiguration a(Object[] objectArray) {
        return new ModelConfiguration((String)objectArray[1], c.a((String)objectArray[0]), (String)objectArray[2], (String)objectArray[3], (String)objectArray[4]);
    }

    private static ModelConfiguration a(String string) {
        return new ModelConfiguration(string, c.e, null, null, null);
    }

    public static class AIExecutionResult
    implements Serializable {
        final Object a;
        final String b;

        public String toString() {
            return String.valueOf(this.a);
        }

        public AIExecutionResult(Object object, String string) {
            this.a = object;
            this.b = string;
        }

        public Object getContent() {
            return this.a;
        }

        public String getRawResponse() {
            return this.b;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AIExecutionResult)) {
                return false;
            }
            AIExecutionResult aIExecutionResult = (AIExecutionResult)object;
            if (!aIExecutionResult.a(this)) {
                return false;
            }
            Object object2 = this.getContent();
            Object object3 = aIExecutionResult.getContent();
            if (object2 == null ? object3 != null : !object2.equals(object3)) {
                return false;
            }
            String string = this.getRawResponse();
            String string2 = aIExecutionResult.getRawResponse();
            return !(string == null ? string2 != null : !string.equals(string2));
        }

        protected boolean a(Object object) {
            return object instanceof AIExecutionResult;
        }

        public int hashCode() {
            int n2 = 1;
            Object object = this.getContent();
            n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
            String string = this.getRawResponse();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            return n2;
        }
    }

    public static class RequestParameters
    implements Serializable {
        private Double a;
        private Double b;
        private Integer c;
        private Double d;
        private Double e;
        private Integer f;
        private List g;
        private Duration h;
        private boolean i = false;

        public Double getTemperature() {
            return this.a;
        }

        public Double getTopP() {
            return this.b;
        }

        public Integer getTopK() {
            return this.c;
        }

        public Double getFrequencyPenalty() {
            return this.d;
        }

        public Double getPresencePenalty() {
            return this.e;
        }

        public Integer getMaxOutputTokens() {
            return this.f;
        }

        public List getStopSequences() {
            return this.g;
        }

        public Duration getTimeout() {
            return this.h;
        }

        public boolean isDisableSSLVerification() {
            return this.i;
        }

        public RequestParameters setTemperature(Double d2) {
            this.a = d2;
            return this;
        }

        public RequestParameters setTopP(Double d2) {
            this.b = d2;
            return this;
        }

        public RequestParameters setTopK(Integer n2) {
            this.c = n2;
            return this;
        }

        public RequestParameters setFrequencyPenalty(Double d2) {
            this.d = d2;
            return this;
        }

        public RequestParameters setPresencePenalty(Double d2) {
            this.e = d2;
            return this;
        }

        public RequestParameters setMaxOutputTokens(Integer n2) {
            this.f = n2;
            return this;
        }

        public RequestParameters setStopSequences(List list) {
            this.g = list;
            return this;
        }

        public RequestParameters setTimeout(Duration duration) {
            this.h = duration;
            return this;
        }

        public RequestParameters setDisableSSLVerification(boolean bl) {
            this.i = bl;
            return this;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof RequestParameters)) {
                return false;
            }
            RequestParameters requestParameters = (RequestParameters)object;
            if (!requestParameters.a(this)) {
                return false;
            }
            if (this.isDisableSSLVerification() != requestParameters.isDisableSSLVerification()) {
                return false;
            }
            Double d2 = this.getTemperature();
            Double d3 = requestParameters.getTemperature();
            if (d2 == null ? d3 != null : !((Object)d2).equals(d3)) {
                return false;
            }
            Double d4 = this.getTopP();
            Double d5 = requestParameters.getTopP();
            if (d4 == null ? d5 != null : !((Object)d4).equals(d5)) {
                return false;
            }
            Integer n2 = this.getTopK();
            Integer n3 = requestParameters.getTopK();
            if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
                return false;
            }
            Double d6 = this.getFrequencyPenalty();
            Double d7 = requestParameters.getFrequencyPenalty();
            if (d6 == null ? d7 != null : !((Object)d6).equals(d7)) {
                return false;
            }
            Double d8 = this.getPresencePenalty();
            Double d9 = requestParameters.getPresencePenalty();
            if (d8 == null ? d9 != null : !((Object)d8).equals(d9)) {
                return false;
            }
            Integer n4 = this.getMaxOutputTokens();
            Integer n5 = requestParameters.getMaxOutputTokens();
            if (n4 == null ? n5 != null : !((Object)n4).equals(n5)) {
                return false;
            }
            List list = this.getStopSequences();
            List list2 = requestParameters.getStopSequences();
            if (list == null ? list2 != null : !((Object)list).equals(list2)) {
                return false;
            }
            Duration duration = this.getTimeout();
            Duration duration2 = requestParameters.getTimeout();
            return !(duration == null ? duration2 != null : !((Object)duration).equals(duration2));
        }

        protected boolean a(Object object) {
            return object instanceof RequestParameters;
        }

        public int hashCode() {
            int n2 = 1;
            n2 = n2 * 59 + (this.isDisableSSLVerification() ? 79 : 97);
            Double d2 = this.getTemperature();
            n2 = n2 * 59 + (d2 == null ? 43 : ((Object)d2).hashCode());
            Double d3 = this.getTopP();
            n2 = n2 * 59 + (d3 == null ? 43 : ((Object)d3).hashCode());
            Integer n3 = this.getTopK();
            n2 = n2 * 59 + (n3 == null ? 43 : ((Object)n3).hashCode());
            Double d4 = this.getFrequencyPenalty();
            n2 = n2 * 59 + (d4 == null ? 43 : ((Object)d4).hashCode());
            Double d5 = this.getPresencePenalty();
            n2 = n2 * 59 + (d5 == null ? 43 : ((Object)d5).hashCode());
            Integer n4 = this.getMaxOutputTokens();
            n2 = n2 * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
            List list = this.getStopSequences();
            n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
            Duration duration = this.getTimeout();
            n2 = n2 * 59 + (duration == null ? 43 : ((Object)duration).hashCode());
            return n2;
        }

        public String toString() {
            return "AIModel.RequestParameters(temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", topK=" + this.getTopK() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", presencePenalty=" + this.getPresencePenalty() + ", maxOutputTokens=" + this.getMaxOutputTokens() + ", stopSequences=" + this.getStopSequences() + ", timeout=" + this.getTimeout() + ", disableSSLVerification=" + this.isDisableSSLVerification() + ")";
        }
    }

    public static class ModelConfiguration
    implements Serializable {
        final String a;
        final c b;
        final String c;
        final String d;
        final String e;

        public ModelConfiguration(String string, c c2, String string2, String string3, String string4) {
            this.a = string;
            this.b = c2;
            this.c = string2;
            this.d = string3;
            this.e = string4;
        }

        public String getDisplayName() {
            return this.a;
        }

        public c getProvider() {
            return this.b;
        }

        public String getBaseUrl() {
            return this.c;
        }

        public String getApiKey() {
            return this.d;
        }

        public String getModelName() {
            return this.e;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ModelConfiguration)) {
                return false;
            }
            ModelConfiguration modelConfiguration = (ModelConfiguration)object;
            if (!modelConfiguration.a(this)) {
                return false;
            }
            String string = this.getDisplayName();
            String string2 = modelConfiguration.getDisplayName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            c c2 = this.getProvider();
            c c3 = modelConfiguration.getProvider();
            if (c2 == null ? c3 != null : !c2.equals(c3)) {
                return false;
            }
            String string3 = this.getBaseUrl();
            String string4 = modelConfiguration.getBaseUrl();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                return false;
            }
            String string5 = this.getApiKey();
            String string6 = modelConfiguration.getApiKey();
            if (string5 == null ? string6 != null : !string5.equals(string6)) {
                return false;
            }
            String string7 = this.getModelName();
            String string8 = modelConfiguration.getModelName();
            return !(string7 == null ? string8 != null : !string7.equals(string8));
        }

        protected boolean a(Object object) {
            return object instanceof ModelConfiguration;
        }

        public int hashCode() {
            int n2 = 1;
            String string = this.getDisplayName();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            c c2 = this.getProvider();
            n2 = n2 * 59 + (c2 == null ? 43 : c2.hashCode());
            String string2 = this.getBaseUrl();
            n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
            String string3 = this.getApiKey();
            n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
            String string4 = this.getModelName();
            n2 = n2 * 59 + (string4 == null ? 43 : string4.hashCode());
            return n2;
        }

        public String toString() {
            return "AIModel.ModelConfiguration(displayName=" + this.getDisplayName() + ", provider=" + this.getProvider() + ", baseUrl=" + this.getBaseUrl() + ", apiKey=" + this.getApiKey() + ", modelName=" + this.getModelName() + ")";
        }
    }
}

