/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.extensions;

import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.notifications.NotificationName;
import de.qfs.lib.notifications.Notifier;
import de.qfs.lib.option.BooleanOption;
import de.qfs.lib.option.ChoiceOption;
import de.qfs.lib.option.EnumOption;
import de.qfs.lib.option.FileOption;
import de.qfs.lib.option.IntegerOption;
import de.qfs.lib.option.LabelOption;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.StringArrayMapOption;
import de.qfs.lib.option.StringArrayOption;
import de.qfs.lib.option.StringListOption;
import de.qfs.lib.option.StringOption;
import de.qfs.lib.util.HighPriorityObserver;
import de.qfs.lib.util.Observable;
import de.qfs.lib.util.Observer;
import de.qfs.lib.util.Reflector;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;

public abstract class OptionsBase {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.extensions.OptionsBase");
    protected static final String QFS_SCRIPT_LAYER = "qfs:script";
    public static final String OPTION_LAYER_OVERRIDE = "qfs:override";
    private static final Map b = Collections.synchronizedMap(new LinkedHashMap());
    @Nullable
    protected static OptionsProvider optionsProvider;
    protected static final OptionContext USER;
    protected static final OptionContext LEGACY_USER;
    protected static final OptionContext SYSTEM;
    protected static final OptionContext LEGACY_SYSTEM;
    protected static final OptionContext RUNTIME;
    protected static final OptionContext KEYSTROKE;
    protected static final Map REVERSE_OPTION_MAP;
    protected static CacheUpdateObserver _BooleanOption_observer;
    protected static CacheUpdateObserver _IntOption_observer;
    protected static CacheUpdateObserver _EnumOption_observer;
    protected static CacheUpdateObserver _FileOption_observer;
    protected static CacheUpdateObserver _StringOption_observer;
    protected static CacheUpdateObserver _StringArrayOption_observer;
    protected static CacheUpdateObserver _StringListOption_observer;
    protected static CacheUpdateObserver _StringArrayMapOption_observer;
    protected static CacheUpdateObserver _RawOption_observer;

    public OptionsBase() {
        if (OptionsBase.a.level >= 7) {
            a.lvlBuild(7, "OptionsBase.OptionsBase()", 57).log();
        }
    }

    public static String register(OptionContext optionContext, Option option) {
        if (OptionsBase.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "register(OptionContext,Option)", 137).addDetail("context", (Object)optionContext)).addDetail("option", (Object)option)).log();
        }
        if (optionContext == null) {
            throw new IllegalArgumentException("context is marked non-null but is null");
        }
        if (option == null) {
            throw new IllegalArgumentException("option is marked non-null but is null");
        }
        String string = option.getName();
        if (b.putIfAbsent(string + "@" + (Object)((Object)optionContext), new ContextedOption(option, optionContext)) != null && OptionsBase.a.level >= 3) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "register(OptionContext,Option)", 140).add("Option '")).add(string)).add("' already registered. Is the name unique?")).log();
        }
        if (optionsProvider != null) {
            optionsProvider.addOption(option, optionContext);
        }
        return string;
    }

    public static String registerOptionWithLegacyContext(OptionContext optionContext, OptionContext optionContext2, Option option) {
        if (OptionsBase.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "registerOptionWithLegacyContext(OptionContext,OptionContext,Option)", 160).addDetail("context", (Object)optionContext)).addDetail("legacyContext", (Object)optionContext2)).addDetail("option", (Object)option)).log();
        }
        if (optionContext == null) {
            throw new IllegalArgumentException("context is marked non-null but is null");
        }
        if (optionContext2 == null) {
            throw new IllegalArgumentException("legacyContext is marked non-null but is null");
        }
        if (option == null) {
            throw new IllegalArgumentException("option is marked non-null but is null");
        }
        Option option2 = (Option)option.clone();
        OptionsBase.register(optionContext2, option2);
        OptionsBase.register(optionContext, option);
        return option.getName();
    }

    public static String listOptions() {
        if (OptionsBase.a.level >= 7) {
            a.lvlBuild(7, "listOptions()", 180).log();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ContextedOption contextedOption : b.values()) {
            stringBuilder.append(contextedOption.a.getName()).append("\t").append((Object)contextedOption.getContext()).append("\n");
        }
        return stringBuilder.toString();
    }

    public static void fixupOptionFromLegacyOptionSet(String string, OptionSet optionSet, OptionSet optionSet2) {
        if (OptionsBase.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "fixupOptionFromLegacyOptionSet(String,OptionSet,OptionSet)", 197).addDetail("optionName", string)).addDetail("currentOptionSet", (Object)optionSet)).addDetail("legacyOptionSet", (Object)optionSet2)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("optionName is marked non-null but is null");
        }
        if (optionSet == null) {
            throw new IllegalArgumentException("currentOptionSet is marked non-null but is null");
        }
        if (optionSet2 == null) {
            throw new IllegalArgumentException("legacyOptionSet is marked non-null but is null");
        }
        Option option = optionSet.getOption(string);
        Option option2 = optionSet2.getOption(string);
        if (option.getValue() == null) {
            Object object = option2.getValue();
            if (object == null) {
                object = option2.getDefaultValue();
            }
            option.setValue(object);
        }
        optionSet2.remove(string);
    }

    static void a(@Nullable OptionsProvider optionsProvider) {
        if (OptionsBase.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setOptionsProvider(OptionsProvider)", 220).addDetail("newOptionsProvider", (Object)optionsProvider)).log();
        }
        if (optionsProvider == OptionsBase.optionsProvider) {
            return;
        }
        OptionsBase.optionsProvider = optionsProvider;
        if (optionsProvider != null) {
            for (ContextedOption contextedOption : b.values()) {
                optionsProvider.addOption(contextedOption.a, contextedOption.b);
            }
        }
    }

    protected static void setCacheValue(String string, String string2, Object object) {
        block3: {
            if (OptionsBase.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "setCacheValue(String,String,Object)", 389).addDetail("optionName", string)).addDetail("suffix", string2)).addDetail("value", object)).log();
            }
            try {
                String string3 = "cached_" + (String)REVERSE_OPTION_MAP.get(string) + string2;
                Reflector.set(Options.class, (String)string3, (Object)object);
            }
            catch (Throwable throwable) {
                if (OptionsBase.a.level < 1) break block3;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(1, "setCacheValue(String,String,Object)", 394).add("Could not update cached ")).add(string2)).add(" for ")).add(string)).log();
            }
        }
    }

    protected static Option withCache(Option option, String string, boolean bl) {
        if (OptionsBase.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "withCache(Option,String,boolean)", 414).addDetail("option", (Object)option)).addDetail("optionConstantName", string)).addDetail("useRawValue", bl)).log();
        }
        if (option == null) {
            throw new IllegalArgumentException("option is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("optionConstantName is marked non-null but is null");
        }
        String string2 = option.getName();
        if (REVERSE_OPTION_MAP.putIfAbsent(string2, string) == null) {
            CacheUpdateObserver cacheUpdateObserver = bl ? _RawOption_observer : (option instanceof BooleanOption ? _BooleanOption_observer : (option instanceof ChoiceOption || option instanceof IntegerOption ? _IntOption_observer : (option instanceof EnumOption ? _EnumOption_observer : (option instanceof FileOption ? _FileOption_observer : (option instanceof StringArrayOption ? _StringArrayOption_observer : (option instanceof StringListOption ? _StringListOption_observer : (option instanceof StringArrayMapOption ? _StringArrayMapOption_observer : (option instanceof StringOption || option instanceof LabelOption ? _StringOption_observer : _RawOption_observer))))))));
            if (cacheUpdateObserver != null) {
                option.addObserver((Observer)cacheUpdateObserver);
            }
        } else if (OptionsBase.a.level >= 3) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "withCache(Option,String,boolean)", 448).add("Option '")).add(string2)).add("' was already used for ")).add((String)REVERSE_OPTION_MAP.get(string2))).add(". Not caching its value twice.")).log();
        }
        return option;
    }

    protected static void updateCachedValue(String string) {
        if (OptionsBase.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "updateCachedValue(String)", 457).addDetail("optionName", string)).log();
        }
        Option option = Options.getOption(string);
        TreeSet treeSet = option.getObservers();
        for (Observer observer : treeSet) {
            if (!(observer instanceof CacheUpdateObserver)) continue;
            ((CacheUpdateObserver)observer).update(string);
            return;
        }
    }

    static {
        USER = OptionContext.USER;
        LEGACY_USER = OptionContext.LEGACY_USER;
        SYSTEM = OptionContext.SYSTEM;
        LEGACY_SYSTEM = OptionContext.LEGACY_SYSTEM;
        RUNTIME = OptionContext.RUNTIME;
        KEYSTROKE = OptionContext.KEYSTROKE;
        REVERSE_OPTION_MAP = new HashMap();
        _BooleanOption_observer = string -> OptionsBase.setCacheValue(string, "", Options.getBoolean(string));
        _IntOption_observer = string -> OptionsBase.setCacheValue(string, "", Options.getInt(string));
        _EnumOption_observer = string -> OptionsBase.setCacheValue(string, "", Options.getEnum(string));
        _FileOption_observer = string -> {
            OptionsBase.setCacheValue(string, "", Options.getFile(string));
            OptionsBase.setCacheValue(string, "_type", Options.getFileType(string));
        };
        _StringOption_observer = string -> OptionsBase.setCacheValue(string, "", Options.getString(string));
        _StringArrayOption_observer = string -> {
            OptionsBase.setCacheValue(string, "", Options.getArray(string));
            OptionsBase.setCacheValue(string, "_as_string", Options.getString(string));
        };
        _StringListOption_observer = string -> {
            OptionsBase.setCacheValue(string, "", Options.getList(string));
            OptionsBase.setCacheValue(string, "_as_string", Options.getString(string));
        };
        _StringArrayMapOption_observer = string -> {
            OptionsBase.setCacheValue(string, "_keys", Options.getKeys(string));
            OptionsBase.setCacheValue(string, "_default_key_value", Options.getDefaultKeyValue(string));
        };
        _RawOption_observer = string -> OptionsBase.setCacheValue(string, "", Options.getOption(string).getValue());
    }

    protected static interface CacheUpdateObserver
    extends HighPriorityObserver {
        default public void update(Observable observable, Object object) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "CacheUpdateObserver.update(Observable,Object)", 401).addDetail("observable", (Object)observable)).addDetail("arg", object)).log();
            }
            this.update(((Option)observable).getName());
        }

        public void update(String var1);
    }

    public static class RemovedOption
    extends Option {
        final String a;

        public RemovedOption(String string, String string2, Object object) {
            super(string, object);
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "RemovedOption.RemovedOption(String,String,Object)", 326).addDetail("name", string)).addDetail("removeVersion", string2)).addDetail("constantValue", object)).log();
            }
            this.a = string2;
        }

        public RemovedOption(String string, String string2, Object object, boolean bl) {
            super(string, object, bl);
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "RemovedOption.RemovedOption(String,String,Object,boolean)", 331).addDetail("name", string)).addDetail("removeVersion", string2)).addDetail("constantValue", object)).addDetail("nullOK", bl)).log();
            }
            this.a = string2;
        }

        public void setValueFromString(String string) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "RemovedOption.setValueFromString(String)", 337).addDetail("val", string)).log();
            }
        }

        public Object getValueFromString(String string) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "RemovedOption.getValueFromString(String)", 343).addDetail("val", string)).log();
            }
            return string;
        }

        public void setValue(Object object) throws IllegalArgumentException {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "RemovedOption.setValue(Object)", 349).addDetail("value", object)).log();
            }
        }

        public Object getValue() {
            if (a.level >= 7) {
                a.lvlBuild(7, "RemovedOption.getValue()", 355).log();
            }
            return this.getDefaultValue();
        }

        public String getRemoveVersion() {
            if (a.level >= 7) {
                a.lvlBuild(7, "RemovedOption.getRemoveVersion()", 324).log();
            }
            return this.a;
        }
    }

    public static class OptionNotifications {
        public static final Notifier NOTIFIER = Notifier.instance((String)"de.qfs.apps.qftest.shared.extensions.OptionsBase.OptionNotifications");
        public static final int POST_LEVEL = 3;
        @NotificationName
        public static final String PERSIST_CHANGE = "de.qfs.apps.qftest.shared.extensions.OptionsBase.OptionNotifications.persistChange";

        public OptionNotifications() {
            if (a.level >= 7) {
                a.lvlBuild(7, "OptionNotifications.OptionNotifications()", 314).log();
            }
        }
    }

    public static abstract class OptionsProviderAdapter
    implements OptionsProvider {
        public OptionsProviderAdapter() {
            if (a.level >= 7) {
                a.lvlBuild(7, "OptionsProviderAdapter.OptionsProviderAdapter()", 268).log();
            }
        }

        @Override
        public abstract OptionSet getOptions();

        @Override
        public void addOption(Option option, OptionContext optionContext) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "OptionsProviderAdapter.addOption(Option,OptionContext)", 273).addDetail("option", (Object)option)).addDetail("context", (Object)optionContext)).log();
            }
            if (option == null) {
                throw new IllegalArgumentException("option is marked non-null but is null");
            }
            this.getOptions().add(option);
        }

        @Override
        public void setOption(String string, Object object) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "OptionsProviderAdapter.setOption(String,Object)", 278).addDetail("name", string)).addDetail("value", object)).log();
            }
            this.getOptions().setOption(string, object, "def");
        }

        @Override
        public void setOption(String string, Object object, String string2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "OptionsProviderAdapter.setOption(String,Object,String)", 283).addDetail("name", string)).addDetail("value", object)).addDetail("layer", string2)).log();
            }
            this.setOption(string, object);
        }

        @Override
        public void unsetOption(String string) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "OptionsProviderAdapter.unsetOption(String)", 288).addDetail("name", string)).log();
            }
            this.unsetOption(string, "def");
        }

        @Override
        public void unsetOption(String string, String string2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "OptionsProviderAdapter.unsetOption(String,String)", 293).addDetail("name", string)).addDetail("layer", string2)).log();
            }
            this.getOptions().unsetOption(string, string2);
        }

        @Override
        public void pushOption(String string, Object object) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "OptionsProviderAdapter.pushOption(String,Object)", 298).addDetail("name", string)).addDetail("value", object)).log();
            }
            this.getOptions().pushOption(string, object);
        }

        @Override
        public void popOption(String string) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "OptionsProviderAdapter.popOption(String)", 304).addDetail("name", string)).log();
            }
            this.getOptions().popOption(string);
        }
    }

    public static interface OptionsProvider {
        public OptionSet getOptions();

        public void addOption(Option var1, OptionContext var2);

        public void setOption(String var1, Object var2);

        public void setOption(String var1, Object var2, String var3);

        public void unsetOption(String var1);

        public void unsetOption(String var1, String var2);

        public void pushOption(String var1, Object var2);

        public void popOption(String var1);
    }

    private static class ContextedOption {
        final Option a;
        final OptionContext b;

        public ContextedOption(Option option, OptionContext optionContext) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "ContextedOption.ContextedOption(Option,OptionContext)", 238).addDetail("option", (Object)option)).addDetail("context", (Object)optionContext)).log();
            }
            if (option == null) {
                throw new IllegalArgumentException("option is marked non-null but is null");
            }
            if (optionContext == null) {
                throw new IllegalArgumentException("context is marked non-null but is null");
            }
            this.a = option;
            this.b = optionContext;
        }

        public Option getOption() {
            if (a.level >= 7) {
                a.lvlBuild(7, "ContextedOption.getOption()", 240).log();
            }
            return this.a;
        }

        public OptionContext getContext() {
            if (a.level >= 7) {
                a.lvlBuild(7, "ContextedOption.getContext()", 241).log();
            }
            return this.b;
        }

        public boolean equals(Object object) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "ContextedOption.equals(Object)", 238).addDetail("o", object)).log();
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof ContextedOption)) {
                return false;
            }
            ContextedOption contextedOption = (ContextedOption)object;
            if (!contextedOption.canEqual(this)) {
                return false;
            }
            Option option = this.getOption();
            Option option2 = contextedOption.getOption();
            if (option == null ? option2 != null : !option.equals(option2)) {
                return false;
            }
            OptionContext optionContext = this.getContext();
            OptionContext optionContext2 = contextedOption.getContext();
            return !(optionContext == null ? optionContext2 != null : !((Object)((Object)optionContext)).equals((Object)optionContext2));
        }

        protected boolean canEqual(Object object) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "ContextedOption.canEqual(Object)", 238).addDetail("other", object)).log();
            }
            return object instanceof ContextedOption;
        }

        public int hashCode() {
            if (a.level >= 7) {
                a.lvlBuild(7, "ContextedOption.hashCode()", 238).log();
            }
            int n2 = 1;
            Option option = this.getOption();
            n2 = n2 * 59 + (option == null ? 43 : option.hashCode());
            OptionContext optionContext = this.getContext();
            n2 = n2 * 59 + (optionContext == null ? 43 : ((Object)((Object)optionContext)).hashCode());
            return n2;
        }

        public String toString() {
            if (a.level >= 7) {
                a.lvlBuild(7, "ContextedOption.toString()", 238).log();
            }
            return "OptionsBase.ContextedOption(option=" + this.getOption() + ", context=" + (Object)((Object)this.getContext()) + ")";
        }
    }

    public static enum OptionLayerLabel {
        STARTUP("qfs:startup"),
        SUT("qfs:sut"),
        COMMANDLINE("qfs:commandline"),
        SCRIPT("qfs:script"),
        OVERRIDE("qfs:override");

        final String a;
        static final Map b;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private OptionLayerLabel() {
            void var3_2;
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "OptionLayerLabel.OptionLayerLabel(String)", 113).addDetail("internalLabel", (String)var3_2)).log();
            }
            this.a = var3_2;
        }

        public String toString() {
            if (a.level >= 7) {
                a.lvlBuild(7, "OptionLayerLabel.toString()", 118).log();
            }
            return this.a;
        }

        @Nullable
        public static OptionLayerLabel forString(String string) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "OptionLayerLabel.forString(String)", 123).addDetail("s", string)).log();
            }
            return (OptionLayerLabel)((Object)b.get(string));
        }

        static {
            b = new HashMap();
            for (OptionLayerLabel optionLayerLabel : OptionLayerLabel.values()) {
                b.put(optionLayerLabel.toString(), optionLayerLabel);
            }
        }
    }

    public static enum OptionContext {
        UNDEFINED,
        USER,
        LEGACY_USER,
        SYSTEM,
        LEGACY_SYSTEM,
        RUNTIME,
        KEYSTROKE,
        DEV,
        EXEMPLARS,
        ALTERNATIVE_EXEMPLARS;


        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private OptionContext() {
            if (a.level >= 7) {
                a.lvlBuild(7, "OptionContext.OptionContext()", 71).log();
            }
        }
    }
}

