/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.extensions.image;

import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.image.BaseImageHandler;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.extensions.image.NativeImageHandler;
import de.qfs.apps.qftest.shared.image.AWTImageHelper;
import de.qfs.apps.qftest.shared.image.BaseImageHelper;
import de.qfs.apps.qftest.shared.image.h;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.apps.qftest.shared.system.NativeRobot;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Observer;
import de.qfs.lib.util.Pair;
import de.qfs.lib.util.Reflector;
import de.qfs.lib.util.ThreadPool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.RepaintManager;

public class AWTImageHandler
extends BaseImageHandler {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.extensions.image.AWTImageHandler");
    private static AWTImageHandler b = new AWTImageHandler();
    private AWTImageHelper i = AWTImageHelper.instance();
    private static int j;
    private Robot k;
    private Pair[] l;
    private long m = 0L;
    private NativeImageHandler n;
    private Observer o = (observable, object) -> this.c();

    protected AWTImageHandler() {
        if (AWTImageHandler.a.level >= 7) {
            a.lvlBuild(7, "AWTImageHandler()", 125).log();
        }
        Options.getOption(Options.OPT_DEFAULT_SCREENSHOT_TECHNOLOGY).addObserver(this.o);
        this.c();
    }

    public static synchronized AWTImageHandler instance() {
        if (AWTImageHandler.a.level >= 7) {
            a.lvlBuild(7, "instance()", 143).log();
        }
        if (b == null) {
            b = new AWTImageHandler();
        }
        return b;
    }

    @Override
    public ImageRep grabScreenshot() {
        if (AWTImageHandler.a.level >= 7) {
            a.lvlBuild(7, "grabScreenshot()", 159).log();
        }
        if (this.n != null) {
            return this.n.grabScreenshot();
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
        return this.grabScreenshot(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageRep grabScreenshot(int n2, int n3, int n4, int n5) {
        int n6;
        if (AWTImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "grabScreenshot(int,int,int,int)", 174).addDetail("x", n2)).addDetail("y", n3)).addDetail("width", n4)).addDetail("height", n5)).log();
        }
        if (this.n != null) {
            return this.n.grabScreenshot(n2, n3, n4, n5);
        }
        Object object = this;
        synchronized (object) {
            n6 = j++;
        }
        object = new Rectangle(n2, n3, n4, n5);
        try {
            if (this.i.getThreadPool() == null) {
                this.i.setThreadPool(new ThreadPool(1, 1, 2));
            }
            Image image = (Image)this.i.getThreadPool().executeWatched(new ThreadPool.UnsafeRunnable((Rectangle)object){
                final /* synthetic */ Rectangle a;
                {
                    this.a = rectangle;
                }

                public Object run() throws Exception {
                    if (a.level >= 7) {
                        a.lvlBuild(7, "grabScreenshot(int,int,int,int).ThreadPool.UnsafeRunnable.run()", 192).log();
                    }
                    AWTImageHandler.this.b();
                    if (AWTImageHandler.this.k != null) {
                        return AWTImageHandler.this.k.createScreenCapture(this.a);
                    }
                    return null;
                }
            }, 20000L, (long)n6);
            return this.createImageRep("", image);
        }
        catch (Throwable throwable) {
            if (AWTImageHandler.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "grabScreenshot(int,int,int,int)", 203).add("ex", (Object)throwable)).log();
            }
            AWTImageHandler.maybeLogWarningInRunLogWithStackTrace(this.getClass(), "screenshotCreationFailure.message", throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageRep[] grabSpecifiedScreenshots(final Set set, final boolean bl) {
        int n2;
        if (AWTImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "grabSpecifiedScreenshots(Set<Integer>,boolean)", 215).addDetail("specifiedMonitors", (Object)set)).addDetail("asSingleImage", bl)).dumpStack();
        }
        if (this.n != null) {
            return this.n.grabSpecifiedScreenshots(set, bl);
        }
        AWTImageHandler aWTImageHandler = this;
        synchronized (aWTImageHandler) {
            n2 = j++;
        }
        try {
            if (this.i.getThreadPool() == null) {
                this.i.setThreadPool(new ThreadPool(1, 1, 2));
            }
            return (ImageRep[])this.i.getThreadPool().executeWatched(new ThreadPool.UnsafeRunnable(){

                public Object run() throws Exception {
                    return AWTImageHandler.super.grabSpecifiedScreenshots(set, bl);
                }
            }, 20000L, (long)n2);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        catch (Throwable throwable) {
            if (AWTImageHandler.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "grabSpecifiedScreenshots(Set<Integer>,boolean)", 240).add("ex", (Object)throwable)).log();
            }
            AWTImageHandler.maybeLogWarningInRunLogWithStackTrace(this.getClass(), "screenshotCreationFailure.message", throwable);
            return null;
        }
    }

    @Override
    public int getMonitorCount() {
        if (AWTImageHandler.a.level >= 7) {
            a.lvlBuild(7, "getMonitorCount()", 250).log();
        }
        if (this.n != null) {
            return this.n.getMonitorCount();
        }
        return this.getNumberOfScreens();
    }

    @Override
    public ImageRep grabImage(Object object) {
        Component component;
        if (AWTImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "grabImage(Object)", 262).addDetail("com", object)).log();
        }
        if ((component = (Component)object) instanceof Window) {
            return this.grabWindowImage((Window)component);
        }
        return this.grabImageOfComponent(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageRep grabImage(Object object, int n2, int n3, int n4, int n5) {
        if (AWTImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "grabImage(Object,int,int,int,int)", 276).addDetail("com", object)).addDetail("x", n2)).addDetail("y", n3)).addDetail("width", n4)).addDetail("height", n5)).log();
        }
        Component component = (Component)object;
        Component component2 = this.i.isBrokenGrabImage() ? component : AWTImageHandler.a(component, new Point(0, 0));
        boolean bl = RepaintManager.currentManager(component).isDoubleBufferingEnabled();
        try {
            if (this.a(object)) {
                Container container;
                Cloneable cloneable;
                Rectangle2D rectangle2D;
                JPanel jPanel = (JPanel)object;
                try {
                    rectangle2D = (Rectangle2D)Reflector.call((Object)jPanel, (String)"getComponentSize");
                    if (rectangle2D == null) {
                        rectangle2D = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(noSuchMethodException);
                }
                catch (Throwable throwable) {
                    if (AWTImageHandler.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "grabImage(Object,int,int,int,int)", 308).add("ex", (Object)throwable)).log();
                    }
                    cloneable = jPanel.getSize();
                    rectangle2D = new Rectangle2D.Double(0.0, 0.0, ((Dimension)cloneable).width, ((Dimension)cloneable).height);
                }
                for (container = jPanel.getParent(); container != null && !Util.isInstance(container, "de.qfs.apps.qfpdf.ui.ComponentPane"); container = container.getParent()) {
                }
                if (container == null) {
                    if (AWTImageHandler.a.level >= 3) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "grabImage(Object,int,int,int,int)", 319).add("Cannot find CompnentPane for ")).add((Object)jPanel)).log();
                    }
                    container = jPanel.getParent();
                }
                cloneable = jPanel.getLocationOnScreen();
                Point point = container.getLocationOnScreen();
                int n6 = (int)Math.round(((Point)cloneable).getX() - point.getX());
                int n7 = (int)Math.round(((Point)cloneable).getY() - point.getY());
                ImageRep imageRep = this.grabImage(container, n6, n7, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                imageRep.setName("");
                ImageRep imageRep2 = imageRep;
                return imageRep2;
            }
            if (!this.i.isBrokenGrabImage() && bl) {
                RepaintManager.currentManager(component).setDoubleBufferingEnabled(false);
            }
            BufferedImage bufferedImage = null;
            Graphics graphics = null;
            if (!Options.cached_OPT_AWT_IMAGE_USE_CLEARTYPE) {
                bufferedImage = new BufferedImage(n4, n5, 2);
                graphics = ((Image)bufferedImage).getGraphics();
                if (AWTImageHandler.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "grabImage(Object,int,int,int,int)", 347).add("g", (Object)graphics)).log();
                }
            } else {
                bufferedImage = component.getGraphicsConfiguration().createCompatibleImage(n4, n5);
                graphics = ((Image)bufferedImage).getGraphics();
                if (AWTImageHandler.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "grabImage(Object,int,int,int,int)", 354).add("g", (Object)graphics)).log();
                }
            }
            graphics.setClip(0, 0, n4, n5);
            if (component2 != object) {
                graphics.setColor(component.getBackground());
                graphics.fillRect(0, 0, n4, n5);
            }
            graphics.translate(-n2, -n3);
            component.paintAll(graphics);
            graphics.dispose();
            ImageRep imageRep = this.createImageRep(bufferedImage);
            return imageRep;
        }
        finally {
            if (!this.i.isBrokenGrabImage() && bl) {
                RepaintManager.currentManager(component).setDoubleBufferingEnabled(true);
            }
        }
    }

    public int getNumberOfScreens() {
        if (AWTImageHandler.a.level >= 7) {
            a.lvlBuild(7, "getNumberOfScreens()", 388).log();
        }
        try {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length;
        }
        catch (HeadlessException headlessException) {
            if (AWTImageHandler.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "getNumberOfScreens()", 393).add("ex", (Object)headlessException)).log();
            }
            return 0;
        }
    }

    @Override
    public int[] getBoundsOfScreen(int n2) {
        if (AWTImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getBoundsOfScreen(int)", 409).addDetail("screen", n2)).log();
        }
        if (this.n != null) {
            return this.n.getBoundsOfScreen(n2);
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            if (n2 < 0 || n2 >= graphicsDeviceArray.length) {
                throw new IllegalArgumentException("Invalid screen " + n2 + " not in [0:" + (graphicsDeviceArray.length - 1) + "]");
            }
            Rectangle rectangle = graphicsDeviceArray[n2].getDefaultConfiguration().getBounds();
            return new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        }
        catch (HeadlessException headlessException) {
            if (AWTImageHandler.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getBoundsOfScreen(int)", 423).add("ex", (Object)headlessException)).log();
            }
            throw new IllegalArgumentException("Invalid screen " + n2 + " for headless mode");
        }
    }

    @Override
    public int getScreenForComponent(Object object) {
        block14: {
            if (AWTImageHandler.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "getScreenForComponent(Object)", 439).addDetail("com", object)).log();
            }
            if (!(object instanceof Component)) {
                if (AWTImageHandler.a.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getScreenForComponent(Object)", 442).add("Not a component: ")).add(object)).log();
                }
                return -1;
            }
            try {
                Component component = (Component)object;
                if (component.isShowing()) {
                    Point point = component.getLocationOnScreen();
                    Dimension dimension = component.getSize();
                    if (AWTImageHandler.a.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getScreenForComponent(Object)", 451).add("screenLocation", (Object)point)).add("size", (Object)dimension)).log();
                    }
                    if (this.n != null) {
                        return this.n.getScreenForRegion(point.x, point.y, dimension.width, dimension.height);
                    }
                    GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = -1;
                    for (GraphicsDevice graphicsDevice : graphicsEnvironment.getScreenDevices()) {
                        int n5;
                        Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
                        if (AWTImageHandler.a.level >= 9) {
                            ((LevelAwareLogBuilder)a.lvlBuild(9, "getScreenForComponent(Object)", 463).add("bounds", (Object)rectangle)).log();
                        }
                        int n6 = Math.max(point.x, rectangle.x);
                        int n7 = Math.min(point.x + dimension.width, rectangle.x + rectangle.width);
                        int n8 = Math.max(point.y, rectangle.y);
                        int n9 = Math.min(point.y + dimension.height, rectangle.y + rectangle.height);
                        if (AWTImageHandler.a.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getScreenForComponent(Object)", 469).add("left", n6)).add("right", n7)).add("top", n8)).add("bottom", n9)).log();
                        }
                        int n10 = n7 - n6;
                        int n11 = n9 - n8;
                        if (AWTImageHandler.a.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getScreenForComponent(Object)", 473).add("w", n10)).add("h", n11)).log();
                        }
                        if (n10 > 0 && n11 > 0 && (n5 = n10 * n11) > n3) {
                            n3 = n5;
                            n4 = n2;
                            if (AWTImageHandler.a.level >= 9) {
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getScreenForComponent(Object)", 479).add("max", n3)).add("best", n4)).log();
                            }
                        }
                        ++n2;
                    }
                    return n4;
                }
            }
            catch (HeadlessException headlessException) {
                if (AWTImageHandler.a.level < 3) break block14;
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getScreenForComponent(Object)", 487).add("ex", (Object)headlessException)).log();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageRep grabImage(Object object, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (AWTImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "grabImage(Object,int,int,int,int,int,int)", 514).addDetail("com", object)).addDetail("x", n2)).addDetail("y", n3)).addDetail("width", n4)).addDetail("height", n5)).addDetail("pWidth", n6)).addDetail("pHeight", n7)).log();
        }
        Component component = (Component)object;
        Component component2 = this.i.isBrokenGrabImage() ? component : AWTImageHandler.a(component, new Point(0, 0));
        boolean bl = RepaintManager.currentManager(component).isDoubleBufferingEnabled();
        try {
            if (!this.i.isBrokenGrabImage() && bl) {
                RepaintManager.currentManager(component).setDoubleBufferingEnabled(false);
            }
            BufferedImage bufferedImage = new BufferedImage(n4, n5, 2);
            Graphics graphics = ((Image)bufferedImage).getGraphics();
            graphics.setClip(0, 0, n6, n7);
            if (component2 != object) {
                graphics.setColor(component.getBackground());
                graphics.fillRect(0, 0, n6, n7);
            }
            graphics.translate(-n2, -n3);
            component.paintAll(graphics);
            graphics.dispose();
            ImageRep imageRep = this.createImageRep(bufferedImage);
            return imageRep;
        }
        finally {
            if (!this.i.isBrokenGrabImage() && bl) {
                RepaintManager.currentManager(component).setDoubleBufferingEnabled(true);
            }
        }
    }

    public ImageRep grabImageOfComponent(Component component) {
        if (AWTImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "grabImageOfComponent(Component)", 566).addDetail("com", (Object)component)).log();
        }
        Dimension dimension = component.getSize();
        return this.grabImage(component, 0, 0, dimension.width, dimension.height);
    }

    public ImageRep grabWindowImage(Window window) {
        if (AWTImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "grabWindowImage(Window)", 582).addDetail("window", (Object)window)).log();
        }
        Container container = window;
        Point point = new Point(0, 0);
        if (window instanceof JWindow) {
            container = ((JWindow)window).getRootPane();
            point = container.getLocation();
        }
        if (window instanceof JDialog) {
            container = ((JDialog)window).getRootPane();
            point = container.getLocation();
        }
        if (window instanceof JFrame) {
            container = ((JFrame)window).getRootPane();
            point = container.getLocation();
        }
        if (AWTImageHandler.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "grabWindowImage(Window)", 598).add("cOffset", (Object)point)).log();
        }
        Dimension dimension = container.getSize();
        Window[] windowArray = window.getOwnedWindows();
        if (windowArray != null) {
            for (int i2 = 0; i2 < windowArray.length; ++i2) {
            }
        }
        return this.grabImage(container, 0, 0, dimension.width, dimension.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        block10: {
            if (AWTImageHandler.a.level >= 7) {
                a.lvlBuild(7, "updateRobot()", 621).log();
            }
            AWTImageHandler aWTImageHandler = this;
            synchronized (aWTImageHandler) {
                if (this.k != null && (this.m <= 0L || System.currentTimeMillis() - this.m <= 10000L)) {
                    this.m = System.currentTimeMillis();
                    return;
                }
            }
            try {
                this.k = new Robot();
                if (AWTImageHandler.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "updateRobot()", 634).add("robots", (Object)this.l)).log();
                }
                if (AWTImageHandler.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "updateRobot()", 635).add("robot", (Object)this.k)).log();
                }
            }
            catch (Exception exception) {
                if (AWTImageHandler.a.level >= 3) {
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "updateRobot()", 637).add("ex", (Object)exception)).log();
                }
                if (AWTImageHandler.a.level < 1) break block10;
                ((LevelAwareLogBuilder)a.lvlBuild(1, "updateRobot()", 638).add("No AWT Robot available - Creating screenshots won't work")).log();
            }
        }
        this.m = System.currentTimeMillis();
    }

    private void c() {
        if (AWTImageHandler.a.level >= 7) {
            a.lvlBuild(7, "updateNativeDelegate()", 646).log();
        }
        this.n = null;
        String string = Options.cached_OPT_DEFAULT_SCREENSHOT_TECHNOLOGY;
        if (AWTImageHandler.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "updateNativeDelegate()", 650).add("defaultTechnology", string)).log();
        }
        for (String string2 : string.split(",")) {
            NativeRobot nativeRobot;
            if ("native".equals(string2) && (nativeRobot = Native.instance().getNativeRobot()) != null) {
                this.n = new NativeImageHandler(nativeRobot);
                return;
            }
            if ("awt".equals(string2)) break;
        }
    }

    private static Component a(Component component, Point point) {
        if (AWTImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getOpaqueParent(Component,Point)", 676).addDetail("com", (Object)component)).addDetail("relPos", (Object)point)).log();
        }
        point.x = 0;
        point.y = 0;
        while (component instanceof JComponent && JComponent.isLightweightComponent(component) && !((JComponent)component).isOpaque()) {
            if (AWTImageHandler.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getOpaqueParent(Component,Point)", 689).add("Not opaque: ")).add((Object)component)).log();
            }
            Container container = component.getParent();
            if (AWTImageHandler.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getOpaqueParent(Component,Point)", 691).add("parent", (Object)container)).log();
            }
            if (container == null) break;
            Point point2 = component.getLocation();
            if (AWTImageHandler.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getOpaqueParent(Component,Point)", 696).add("pos", (Object)point2)).log();
            }
            component = container;
            point.x += point2.x;
            point.y += point2.y;
        }
        if (AWTImageHandler.a.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getOpaqueParent(Component,Point)", 701).add((Object)component)).add(", x: ")).add(point.x)).add(", y: ")).add(point.y)).log();
        }
        return component;
    }

    @Override
    public BaseImageHelper getHelper() {
        if (AWTImageHandler.a.level >= 7) {
            a.lvlBuild(7, "getHelper()", 714).log();
        }
        return this.i;
    }

    public Image getImage(ImageRep imageRep) {
        if (AWTImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getImage(ImageRep)", 729).addDetail("rep", (Object)imageRep)).log();
        }
        return this.getImage(imageRep, false);
    }

    public Image getImage(ImageRep imageRep, boolean bl) {
        if (AWTImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getImage(ImageRep,boolean)", 745).addDetail("rep", (Object)imageRep)).addDetail("overrideTransparency", bl)).log();
        }
        if (imageRep.getUserData() instanceof Image) {
            Image image = (Image)imageRep.getUserData();
            if (AWTImageHandler.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getImage(ImageRep,boolean)", 749).add("cached Image: ")).add("ret", (Object)image)).log();
            }
            return image;
        }
        int[] nArray = imageRep.getARGB();
        int n2 = imageRep.getWidth();
        int n3 = imageRep.getHeight();
        if (bl) {
            int n4 = n2 * n3 - 1;
            while (n4 >= 0) {
                int n5 = n4--;
                nArray[n5] = nArray[n5] | 0xFF000000;
            }
        }
        Image image = ((AWTImageHelper)this.getHelper()).createImage(nArray, n2, n3, true);
        imageRep.setUserData(image);
        if (AWTImageHandler.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getImage(ImageRep,boolean)", 762).add("image", (Object)image)).log();
        }
        return image;
    }

    public ImageRep createImageRep(Image image) {
        if (AWTImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "createImageRep(Image)", 776).addDetail("image", (Object)image)).log();
        }
        return this.createImageRep("", image);
    }

    public ImageRep createImageRep(String string, Image image) {
        if (AWTImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createImageRep(String,Image)", 792).addDetail("name", string)).addDetail("image", (Object)image)).log();
        }
        h h2 = new h(image);
        return new ImageRep(string, this.i.getARGB(image, false), ImageRep.CompressionMode.BINARY, h2.a(), h2.b());
    }

    public ImageRep highlightAreaInScreenshot(ImageRep imageRep, int n2, int n3, int n4, int n5, String string, int n6) {
        if (AWTImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "highlightAreaInScreenshot(ImageRep,int,int,int,int,String,int)", 808).addDetail("ir", (Object)imageRep)).addDetail("x", n2)).addDetail("y", n3)).addDetail("width", n4)).addDetail("height", n5)).addDetail("borderColor", string)).addDetail("borderThickness", n6)).log();
        }
        Color color = Color.getColor(string);
        BufferedImage bufferedImage = (BufferedImage)this.getImage(imageRep);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setStroke(new BasicStroke(n6));
        graphics2D.setColor(color);
        graphics2D.drawRect(n2, n3, n4, n5);
        graphics2D.dispose();
        imageRep.setPng(((AWTImageHelper)this.getHelper()).pngEncode(bufferedImage));
        return imageRep;
    }

    public int[] getScreensWithWindows() {
        Window[] windowArray;
        if (AWTImageHandler.a.level >= 7) {
            a.lvlBuild(7, "getScreensWithWindows()", 832).log();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Window[] objectArray = windowArray = Window.getWindows();
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Window window = objectArray[i2];
            if (AWTImageHandler.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getScreensWithWindows()", 837).add("win", (Object)window)).log();
            }
            if (!window.isShowing() || window.getWidth() <= 0 || window.getHeight() <= 0) continue;
            int n3 = this.getScreenForComponent(window);
            if (AWTImageHandler.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getScreensWithWindows()", 840).add("screen", n3)).log();
            }
            if (n3 < 0 || arrayList.contains(n3)) continue;
            arrayList.add(n3);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        Collections.sort(arrayList);
        int[] nArray = new int[arrayList.size()];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = (Integer)arrayList.get(n2);
        }
        return nArray;
    }

    private boolean a(Object object) {
        if (AWTImageHandler.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isPDFClientComponent(Object)", 868).addDetail("com", object)).log();
        }
        return Util.isInstance(object, "de.qfs.apps.qfpdf.ui.BaseComponent");
    }
}

