/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.image;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import de.qfs.apps.qftest.shared.ExternalClassWrapperHelper;
import de.qfs.apps.qftest.shared.image.BarcodeHelper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class BarcodeHelperImpl
extends ExternalClassWrapperHelper
implements BarcodeHelper {
    private static int c = 5;

    @Override
    public String readCodeFromImage(BufferedImage bufferedImage) throws Exception {
        Result result;
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth() + 2 * c, bufferedImage.getHeight() + 2 * c, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        graphics2D.drawImage((Image)bufferedImage, c, c, null);
        graphics2D.dispose();
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(bufferedImage2)));
        try {
            result = new MultiFormatReader().decode(binaryBitmap);
        }
        catch (ReaderException readerException) {
            throw new IOException(readerException.toString());
        }
        return result.getText();
    }

    @Override
    public BufferedImage writeCodeToImage(String string, int n2, int n3, String string2) throws Exception {
        BarcodeFormat barcodeFormat = this.a(string2);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(new String(string.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8), barcodeFormat, n2, n3);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
    }

    private BarcodeFormat a(String string) {
        string = string.toUpperCase().replaceAll("[^A-Z0-9]", "");
        BarcodeFormat barcodeFormat = null;
        for (BarcodeFormat barcodeFormat2 : BarcodeFormat.values()) {
            String string2 = barcodeFormat2.name().toUpperCase().replaceAll("[^A-Z0-9]", "");
            if (string2.equals(string)) {
                return barcodeFormat2;
            }
            if (barcodeFormat != null || !string2.contains(string)) continue;
            barcodeFormat = barcodeFormat2;
        }
        if (barcodeFormat != null) {
            return barcodeFormat;
        }
        return BarcodeFormat.CODE_128;
    }
}

