/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.io.app;

import de.qfs.apps.qftest.shared.system.mac.PListAccess;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.FileUtils;
import de.qfs.lib.util.ProcessManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class IOSAppAnalyzer {
    private static final QFLogger i = new QFLogger("de.qfs.apps.qftest.shared.io.app.IOSAppAnalyzer");
    public static final String a = "Payload/";
    public static final int b = "Payload/".length();
    static final Pattern c = Pattern.compile("[^/]+\\.ipa");
    static final Pattern d = Pattern.compile("Payload/([^/]+\\.app)/Info\\.plist");
    static final Pattern e = Pattern.compile("([^/]+\\.app)/Info\\.plist");
    static final Pattern f = Pattern.compile("(?m)executable (\\S+)\n|\\[([^\\]]+)\\]");
    private final File j;
    private a k = de.qfs.apps.qftest.shared.io.app.IOSAppAnalyzer$a.a;
    private final Map l;
    String g;
    String h;

    public IOSAppAnalyzer(File file) {
        if (IOSAppAnalyzer.i.level >= 7) {
            ((LevelAwareLogBuilder)i.lvlBuild(7, "IOSAppAnalyzer(File)", 98).addDetail("appFile", (Object)file)).log();
        }
        if (file == null) {
            throw new IllegalArgumentException("appFile is marked non-null but is null");
        }
        this.j = file;
        if (!file.exists()) {
            throw new IOSAnalyzerException("File does not exists: " + file);
        }
        File file2 = new File(file, "Info.plist");
        if (file2.exists()) {
            this.l = PListAccess.instance().getContent(file2);
            this.g = file.getName();
        } else {
            try {
                Map map = this.a(file);
                if (map == null) {
                    throw new IOSAnalyzerException("iOS package contains no Info");
                }
                this.l = map;
            }
            catch (Exception exception) {
                throw new IOSAnalyzerException("Error reading the iOS package", exception);
            }
        }
        if (this.l.isEmpty()) {
            throw new IOSAnalyzerException("File is not a valid app container: " + file);
        }
    }

    private Map a(File file) throws IOException {
        if (IOSAppAnalyzer.i.level >= 7) {
            ((LevelAwareLogBuilder)i.lvlBuild(7, "getInfoContentFromArchive(File)", 128).addDetail("file", (Object)file)).log();
        }
        if (file == null) {
            throw new IllegalArgumentException("file is marked non-null but is null");
        }
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry zipEntry;
            Iterator iterator = zipFile.stream().iterator();
            while ((zipEntry = iterator.hasNext() ? (ZipEntry)iterator.next() : null) != null) {
                Map map = this.a(zipEntry, zipFile.getInputStream(zipEntry));
                if (map == null) continue;
                Map map2 = map;
                return map2;
            }
        }
        return null;
    }

    private Map a(InputStream inputStream) throws IOException {
        if (IOSAppAnalyzer.i.level >= 7) {
            ((LevelAwareLogBuilder)i.lvlBuild(7, "getInfoContentFromArchive(InputStream)", 144).addDetail("archiveContent", (Object)inputStream)).log();
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("archiveContent is marked non-null but is null");
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                Map map = this.a(zipEntry, zipInputStream);
                if (map == null) continue;
                Map map2 = map;
                return map2;
            }
        }
        return null;
    }

    private Map a(ZipEntry zipEntry, InputStream inputStream) throws IOException {
        if (IOSAppAnalyzer.i.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)i.lvlBuild(7, "getInfoContentFromZipEntry(ZipEntry,InputStream)", 159).addDetail("entry", (Object)zipEntry)).addDetail("entryStream", (Object)inputStream)).log();
        }
        if (zipEntry == null) {
            throw new IllegalArgumentException("entry is marked non-null but is null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("entryStream is marked non-null but is null");
        }
        String string = zipEntry.getName();
        if (this.h == null && c.matcher(string).matches()) {
            this.h = string;
            return this.a(inputStream);
        }
        Matcher matcher = d.matcher(string);
        Matcher matcher2 = e.matcher(string);
        if (matcher.matches() || this.h == null && matcher2.matches()) {
            if (string.startsWith(a)) {
                this.k = this.h == null ? de.qfs.apps.qftest.shared.io.app.IOSAppAnalyzer$a.b : de.qfs.apps.qftest.shared.io.app.IOSAppAnalyzer$a.d;
                this.g = matcher.group(1);
            } else {
                this.k = de.qfs.apps.qftest.shared.io.app.IOSAppAnalyzer$a.c;
                this.g = matcher2.group(1);
            }
            return PListAccess.instance().getContent(inputStream);
        }
        return null;
    }

    public String a() {
        if (IOSAppAnalyzer.i.level >= 7) {
            i.lvlBuild(7, "getBundleId()", 187).log();
        }
        return Optional.of((String)this.l.get("CFBundleIdentifier")).orElseGet(null);
    }

    public List b() {
        if (IOSAppAnalyzer.i.level >= 7) {
            i.lvlBuild(7, "getSupportedPlatforms()", 194).log();
        }
        Object v2 = this.l.get("CFBundleSupportedPlatforms");
        LinkedList<String> linkedList = new LinkedList<String>();
        if (v2 instanceof String) {
            linkedList.add((String)v2);
        }
        if (v2 != null && v2.getClass().isArray()) {
            int n2 = Array.getLength(v2);
            for (int i2 = 0; i2 < n2; ++i2) {
                linkedList.add("" + Array.get(v2, i2));
            }
        }
        return linkedList;
    }

    public Set c() {
        if (IOSAppAnalyzer.i.level >= 7) {
            i.lvlBuild(7, "getSupportedArchitectures()", 212).log();
        }
        String string = (String)this.l.get("CFBundleExecutable");
        File file = null;
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            switch (this.k) {
                case b: 
                case c: 
                case d: {
                    bl = true;
                    file = File.createTempFile("ios", "binhead");
                    this.a(string, file);
                    break;
                }
                case a: {
                    file = new File(this.j, string);
                }
            }
            if (file == null) {
                throw new IOSAnalyzerException("Error determining executable of app file");
            }
            try {
                String string2 = ProcessManager.runProcess((String[])new String[]{"file", "-b", file.getAbsolutePath()}, (int)100);
                if (IOSAppAnalyzer.i.level >= 9) {
                    ((LevelAwareLogBuilder)i.lvlBuild(9, "getSupportedArchitectures()", 238).add("output", string2)).log();
                }
                Matcher matcher = f.matcher(string2);
                while (matcher.find()) {
                    if (matcher.group(2) != null) {
                        hashSet.add(matcher.group(2));
                        continue;
                    }
                    hashSet.add(matcher.group(1));
                }
            }
            catch (ProcessManager.RunProcessException runProcessException) {
                throw new IOSAnalyzerException("Error determining architectures of app file", runProcessException);
            }
        }
        catch (Exception exception) {
            throw new IOSAnalyzerException("Error determining architectures of app file", exception);
        }
        finally {
            if (bl) {
                file.delete();
            }
        }
        if (IOSAppAnalyzer.i.level >= 9) {
            ((LevelAwareLogBuilder)i.lvlBuild(9, "getSupportedArchitectures()", 259).add("result", hashSet)).log();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string, File file) throws IOException {
        if (IOSAppAnalyzer.i.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)i.lvlBuild(7, "extractFileHeadToTempFile(String,File)", 266).addDetail("executableName", string)).addDetail("tempFile", (Object)file)).log();
        }
        String string2 = this.i();
        Pattern pattern = Pattern.compile(string2 + "[^/]+\\.app/" + string);
        try (ZipFile zipFile = new ZipFile(this.j);
             InputStream inputStream = null;){
            Iterator iterator;
            Object object;
            if (this.h != null) {
                object = zipFile.stream().iterator();
                while ((iterator = (ZipEntry)object.next()) != null) {
                    if (!this.h.equals(((ZipEntry)((Object)iterator)).getName())) continue;
                    inputStream = zipFile.getInputStream((ZipEntry)((Object)iterator));
                    break;
                }
            }
            iterator = null;
            ZipInputStream zipInputStream = null;
            if (inputStream == null) {
                iterator = zipFile.stream().iterator();
                object = iterator.hasNext() ? (ZipEntry)iterator.next() : null;
            } else {
                zipInputStream = new ZipInputStream(inputStream);
                object = zipInputStream.getNextEntry();
            }
            try {
                while (object != null) {
                    block48: {
                        try {
                            if (!pattern.matcher(((ZipEntry)object).getName()).matches()) break block48;
                            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                                byte[] byArray = new byte[100];
                                ZipInputStream zipInputStream2 = zipInputStream == null ? zipFile.getInputStream((ZipEntry)object) : zipInputStream;
                                try {
                                    for (int i2 = 0; i2 < 100; i2 += 100) {
                                        int n2 = ((InputStream)zipInputStream2).read(byArray);
                                        fileOutputStream.write(byArray, 0, n2);
                                    }
                                    break;
                                }
                                finally {
                                    if (zipInputStream2 != null && zipInputStream2 != zipInputStream) {
                                        ((InputStream)zipInputStream2).close();
                                    }
                                }
                            }
                        }
                        finally {
                            if (zipInputStream != null) {
                                zipInputStream.closeEntry();
                            }
                        }
                    }
                    if (zipInputStream == null) {
                        object = iterator.hasNext() ? (ZipEntry)iterator.next() : null;
                        continue;
                    }
                    object = zipInputStream.getNextEntry();
                }
            }
            finally {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
        }
    }

    private String i() {
        if (IOSAppAnalyzer.i.level >= 7) {
            i.lvlBuild(7, "getContentPrefix()", 351).log();
        }
        switch (this.k) {
            case b: 
            case d: {
                return a;
            }
        }
        return "";
    }

    public void a(File file, boolean bl) throws IOException {
        if (IOSAppAnalyzer.i.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)i.lvlBuild(7, "extractAppTo(File,boolean)", 365).addDetail("destinationDir", (Object)file)).addDetail("extractIpa", bl)).log();
        }
        if (bl) {
            switch (this.k) {
                case b: 
                case c: 
                case d: {
                    IOSAppAnalyzer.a(this.j, file, this.i(), this.h, true);
                    break;
                }
                case a: {
                    FileUtils.copyDirectory((File)this.j, (File)new File(file, this.j.getName()));
                }
            }
        } else {
            switch (this.k) {
                case c: 
                case d: {
                    IOSAppAnalyzer.a(this.j, file, "", null, false);
                    break;
                }
                case b: {
                    FileUtils.copyFile((File)this.j, (File)new File(file, this.j.getName()));
                    break;
                }
                case a: {
                    FileUtils.copyDirectory((File)this.j, (File)new File(file, this.j.getName()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(File file, File file2, String string, String string2, boolean bl) throws IOException {
        if (IOSAppAnalyzer.i.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)i.lvlBuild(7, "extractCompressedPayloadToFolder(File,File,String,String,boolean)", 400).addDetail("file", (Object)file)).addDetail("destinationDir", (Object)file2)).addDetail("contentPrefix", string)).addDetail("innerContainerName", string2)).addDetail("filterApp", bl)).log();
        }
        int n2 = string.length();
        try (ZipFile zipFile = new ZipFile(file);
             InputStream inputStream = null;){
            ZipEntry zipEntry;
            Object object;
            if (string2 != null) {
                object = zipFile.stream().iterator();
                while ((zipEntry = (ZipEntry)object.next()) != null) {
                    if (!string2.equals(zipEntry.getName())) continue;
                    inputStream = zipFile.getInputStream(zipEntry);
                    break;
                }
            }
            object = new byte[10240];
            Iterator iterator = null;
            ZipInputStream zipInputStream = null;
            if (inputStream == null) {
                iterator = zipFile.stream().iterator();
                zipEntry = iterator.hasNext() ? (ZipEntry)iterator.next() : null;
            } else {
                zipInputStream = new ZipInputStream(inputStream);
                zipEntry = zipInputStream.getNextEntry();
            }
            try {
                if (IOSAppAnalyzer.i.level >= 9) {
                    ((LevelAwareLogBuilder)i.lvlBuild(9, "extractCompressedPayloadToFolder(File,File,String,String,boolean)", 439).add("zipEntry", (Object)zipEntry)).log();
                }
                while (zipEntry != null) {
                    block50: {
                        try {
                            String string3 = zipEntry.getName();
                            if (!string3.startsWith(string)) break block50;
                            string3 = string3.substring(n2);
                            if (bl && !string3.contains(".app")) break block50;
                            File file3 = new File(file2, string3);
                            if (IOSAppAnalyzer.i.level >= 9) {
                                ((LevelAwareLogBuilder)i.lvlBuild(9, "extractCompressedPayloadToFolder(File,File,String,String,boolean)", 447).add("fileToCreate", (Object)file3)).log();
                            }
                            new File(file3.getParent()).mkdirs();
                            if (zipEntry.isDirectory()) break block50;
                            try (FileOutputStream fileOutputStream = new FileOutputStream(file3);){
                                ZipInputStream zipInputStream2 = zipInputStream == null ? zipFile.getInputStream(zipEntry) : zipInputStream;
                                try {
                                    int n3;
                                    while ((n3 = ((InputStream)zipInputStream2).read((byte[])object)) > 0) {
                                        fileOutputStream.write((byte[])object, 0, n3);
                                    }
                                }
                                finally {
                                    if (zipInputStream2 != null && zipInputStream2 != zipInputStream) {
                                        ((InputStream)zipInputStream2).close();
                                    }
                                }
                            }
                        }
                        finally {
                            if (zipInputStream != null) {
                                zipInputStream.closeEntry();
                            }
                        }
                    }
                    if (zipInputStream == null) {
                        zipEntry = iterator.hasNext() ? (ZipEntry)iterator.next() : null;
                        continue;
                    }
                    zipEntry = zipInputStream.getNextEntry();
                }
            }
            finally {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
        }
    }

    public static void a(String[] stringArray) throws Exception {
        if (IOSAppAnalyzer.i.level >= 7) {
            ((LevelAwareLogBuilder)i.lvlBuild(7, "main(String[])", 505).addDetail("args", (Object)stringArray)).log();
        }
        IOSAppAnalyzer iOSAppAnalyzer = new IOSAppAnalyzer(new File("/Users/pascal/Documents/support/halde/SUP-9551/simulator/sup-9551-bitonerise_basicConfig_dev_07170s.zip"));
        System.out.println(iOSAppAnalyzer);
        System.out.println(iOSAppAnalyzer.c());
        iOSAppAnalyzer.a(new File("/tmp"), false);
    }

    public String toString() {
        if (IOSAppAnalyzer.i.level >= 7) {
            i.lvlBuild(7, "toString()", 56).log();
        }
        return "IOSAppAnalyzer(appFile=" + this.j + ", packageType=" + (Object)((Object)this.d()) + ", appName=" + this.f() + ", innerContainerName=" + this.g() + ")";
    }

    public a d() {
        if (IOSAppAnalyzer.i.level >= 7) {
            i.lvlBuild(7, "getPackageType()", 90).log();
        }
        return this.k;
    }

    public Map e() {
        if (IOSAppAnalyzer.i.level >= 7) {
            i.lvlBuild(7, "getInfoContent()", 91).log();
        }
        return this.l;
    }

    public String f() {
        if (IOSAppAnalyzer.i.level >= 7) {
            i.lvlBuild(7, "getAppName()", 92).log();
        }
        return this.g;
    }

    public String g() {
        if (IOSAppAnalyzer.i.level >= 7) {
            i.lvlBuild(7, "getInnerContainerName()", 93).log();
        }
        return this.h;
    }

    class IOSAnalyzerException
    extends RuntimeException {
        public IOSAnalyzerException(String string) {
            super(string);
            if (i.level >= 7) {
                ((LevelAwareLogBuilder)i.lvlBuild(7, "IOSAnalyzerException.IOSAnalyzerException(String)", 494).addDetail("msg", string)).log();
            }
        }

        public IOSAnalyzerException(String string, Throwable throwable) {
            super(string, throwable);
            if (i.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)i.lvlBuild(7, "IOSAnalyzerException.IOSAnalyzerException(String,Throwable)", 497).addDetail("msg", string)).addDetail("cause", (Object)throwable)).log();
            }
        }
    }

    public static enum a {
        a,
        b,
        c,
        d;


        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private a() {
            if (i.level >= 7) {
                i.lvlBuild(7, "PackageType.PackageType()", 61).log();
            }
        }
    }
}

