/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.ios;

import de.qfs.apps.qftest.shared.Geometry;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.lib.json.JsonSerializable;
import de.qfs.lib.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public interface IOSTarget
extends JsonSerializable {
    public String getName();

    public String getDisplayName();

    public IOSTarget setDisplayName(String var1);

    public String getUdid();

    public String getState();

    public Type getType();

    public VersionNumber getOsVersion();

    public String getArchitecture();

    public void overrideOsVersion(VersionNumber var1);

    default public boolean isConnected() {
        return this.isConnected(false);
    }

    public boolean isConnected(boolean var1);

    default public boolean isSimulator() {
        return this.getType() == Type.SIMULATOR;
    }

    default public String getOSName() {
        VersionNumber versionNumber = this.getOsVersion();
        if (versionNumber == null) {
            return "";
        }
        String string = versionNumber.getOriginalVersionString();
        if (string == null) {
            return "";
        }
        int n2 = string.indexOf(32);
        if (n2 < 0) {
            return "";
        }
        return string.substring(0, n2).trim();
    }

    default public boolean isWatchOS() {
        return "watchOS".equals(this.getOSName());
    }

    default public boolean isIOS() {
        return "iOS".equals(this.getOSName());
    }

    default public boolean isDevice() {
        return this.getType() == Type.DEVICE;
    }

    default public boolean isBooted() {
        return "Booted".equalsIgnoreCase(this.getState());
    }

    public void connect();

    public void disconnect();

    public void boot();

    public void focus();

    default public boolean canFocus() {
        return this.isSimulator();
    }

    public ImageRep grabScreenshot();

    public Geometry getScreenSize();

    public Collection listApps();

    public boolean isAppInstalled(String var1);

    public void installApp(boolean var1, File var2) throws IOException;

    public void uninstallApp(String var1) throws IOException;

    public void launchApp(String var1) throws IOException;

    public void stopApp(String var1) throws IOException;

    public static final class Type
    extends Enum {
        public static final /* enum */ Type SIMULATOR = new Type("SIMULATOR", 0);
        public static final /* enum */ Type DEVICE = new Type("DEVICE", 1);
        private static final /* synthetic */ Type[] a;

        public static Type[] values() {
            return (Type[])a.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Type() {
            void var2_-1;
            void var1_-1;
        }

        public String getName() {
            return this.toString().toLowerCase();
        }

        private static /* synthetic */ Type[] a() {
            return new Type[]{SIMULATOR, DEVICE};
        }

        static {
            a = Type.a();
        }
    }
}

