/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.ios.idb;

import de.qfs.apps.qftest.shared.Geometry;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.io.app.IOSAppAnalyzer;
import de.qfs.apps.qftest.shared.ios.IOSTarget;
import de.qfs.apps.qftest.shared.ios.IOSUtil;
import de.qfs.apps.qftest.shared.ios.idb.IdbClient;
import de.qfs.apps.qftest.shared.ios.idb.IdbCompanion;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.FileUtils;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.annotation.Nullable;

public class IdbTarget
implements IOSTarget {
    private static final QFLogger m = new QFLogger("de.qfs.apps.qftest.shared.ios.idb.IdbTarget");
    final IdbClient a;
    String b;
    String c;
    String d;
    String e;
    IOSTarget.Type f;
    VersionNumber g;
    VersionNumber h;
    String i;
    Geometry j;
    IdbCompanion k;
    JsonObject l;

    public void updateFromJson(JsonObject jsonObject) {
        block10: {
            if (IdbTarget.m.level >= 7) {
                ((LevelAwareLogBuilder)m.lvlBuild(7, "updateFromJson(JsonObject)", 79).addDetail("json", (Object)jsonObject)).log();
            }
            if (jsonObject == null) {
                return;
            }
            try {
                boolean bl = Misc.equalOrNull((Object)this.b, (Object)this.c);
                this.b = jsonObject.getString("name", this.b);
                if (bl) {
                    this.c = this.b;
                }
                this.d = jsonObject.getString("udid", this.d);
                this.e = jsonObject.getString("state", this.e);
                if (jsonObject.contains("type")) {
                    IOSTarget.Type type = this.f = jsonObject.getString("type", "").equalsIgnoreCase("device") ? IOSTarget.Type.DEVICE : IOSTarget.Type.SIMULATOR;
                }
                if (jsonObject.contains("os_version")) {
                    this.g = VersionNumber.fromString((String)jsonObject.getString("os_version", ""));
                }
                this.i = jsonObject.getString("architecture", this.i);
                this.j = Geometry.fromJson(jsonObject.get("screen_dimensions"));
                this.k = this.a(jsonObject);
                if (jsonObject.contains("extended")) {
                    this.l = jsonObject.getObject("extended").getObject("device");
                } else if (jsonObject.contains("device")) {
                    this.l = jsonObject.getObject("device");
                }
            }
            catch (Exception exception) {
                if (IdbTarget.m.level < 1) break block10;
                ((LevelAwareLogBuilder)m.lvlBuild(1, "updateFromJson(JsonObject)", 110).add("Error parsing target info", (Object)exception)).log();
            }
        }
    }

    @Override
    public void overrideOsVersion(VersionNumber versionNumber) {
        this.h = versionNumber;
    }

    @Override
    public VersionNumber getOsVersion() {
        if (this.h != null) {
            return this.h;
        }
        return this.g;
    }

    @Nullable
    private IdbCompanion a(JsonObject jsonObject) {
        block9: {
            if (IdbTarget.m.level >= 7) {
                ((LevelAwareLogBuilder)m.lvlBuild(7, "getCompanionFromJson(JsonObject)", 128).addDetail("json", (Object)jsonObject)).log();
            }
            try {
                if (jsonObject.contains("companion_info")) {
                    JsonObject jsonObject2 = jsonObject.getObject("companion_info");
                    IdbCompanion.IdbCompanionBuilder idbCompanionBuilder = IdbCompanion.builder().udid(jsonObject2.getString("udid", this.d)).local(jsonObject2.getBoolean("is_local", true));
                    JsonObject jsonObject3 = jsonObject2.getObject("address");
                    if (jsonObject3.contains("path")) {
                        idbCompanionBuilder.path(jsonObject3.getString("path", ""));
                    } else {
                        idbCompanionBuilder.host(jsonObject3.getString("host", ""));
                        idbCompanionBuilder.port(jsonObject3.getInt("port", 0));
                    }
                    return idbCompanionBuilder.build();
                }
                if (jsonObject.contains("companion")) {
                    IdbCompanion.IdbCompanionBuilder idbCompanionBuilder = IdbCompanion.builder().udid(this.d).local(jsonObject.getBoolean("is_local", true));
                    if (jsonObject.contains("path")) {
                        idbCompanionBuilder.path(jsonObject.getString("path", ""));
                    } else {
                        idbCompanionBuilder.host(jsonObject.getString("host", ""));
                        idbCompanionBuilder.port(jsonObject.getInt("port", 0));
                    }
                    return idbCompanionBuilder.build();
                }
            }
            catch (Exception exception) {
                if (IdbTarget.m.level < 1) break block9;
                ((LevelAwareLogBuilder)m.lvlBuild(1, "getCompanionFromJson(JsonObject)", 158).add("Error parsing companion info", (Object)exception)).log();
            }
        }
        return null;
    }

    @Override
    public boolean isConnected(boolean bl) {
        if (this.k == null) {
            return false;
        }
        if (!bl) {
            return true;
        }
        return this.a.verify(this);
    }

    @Override
    public void connect() {
        if (IdbTarget.m.level >= 7) {
            m.lvlBuild(7, "connect()", 172).log();
        }
        if (this.isConnected(true)) {
            this.disconnect();
        }
        if (this.a.connect(this)) {
            JsonObject jsonObject = this.a.describe(this);
            this.updateFromJson(jsonObject);
        } else {
            this.k = null;
        }
    }

    @Override
    public void disconnect() {
        if (IdbTarget.m.level >= 7) {
            m.lvlBuild(7, "disconnect()", 189).log();
        }
        this.a.disconnect(this);
        this.k = null;
    }

    @Override
    public void boot() {
        if (IdbTarget.m.level >= 7) {
            m.lvlBuild(7, "boot()", 199).log();
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if (this.isSimulator()) {
            this.a.boot(this);
        } else if (IdbTarget.m.level >= 5) {
            ((LevelAwareLogBuilder)m.lvlBuild(5, "boot()", 206).add("Boot on hardware not required")).log();
        }
    }

    @Override
    public void focus() {
        if (IdbTarget.m.level >= 7) {
            m.lvlBuild(7, "focus()", 215).log();
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if (this.isSimulator()) {
            this.a.focus(this);
        } else if (IdbTarget.m.level >= 5) {
            ((LevelAwareLogBuilder)m.lvlBuild(5, "focus()", 222).add("Bringt to front on hardware not required")).log();
        }
    }

    @Override
    public ImageRep grabScreenshot() {
        return this.a.grabScreenshot(this);
    }

    @Override
    public List listApps() {
        if (IdbTarget.m.level >= 7) {
            m.lvlBuild(7, "listApps()", 239).log();
        }
        return this.a.listApps(this);
    }

    @Override
    public boolean isAppInstalled(String string) {
        if (IdbTarget.m.level >= 7) {
            ((LevelAwareLogBuilder)m.lvlBuild(7, "isAppInstalled(String)", 248).addDetail("bundleId", string)).log();
        }
        List list = this.listApps();
        if (IdbTarget.m.level >= 9) {
            ((LevelAwareLogBuilder)m.lvlBuild(9, "isAppInstalled(String)", 250).add("installedApps", (Object)list)).log();
        }
        return list.stream().anyMatch(iOSApp -> iOSApp.getBundleId().equals(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void installApp(boolean bl, File file) throws IOException {
        Object object;
        Object object2;
        if (IdbTarget.m.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)m.lvlBuild(7, "installApp(boolean,File)", 259).addDetail("reinstall", bl)).addDetail("appPath", (Object)file)).log();
        }
        IOSAppAnalyzer iOSAppAnalyzer = new IOSAppAnalyzer(file);
        if (!bl && this.isAppInstalled((String)(object2 = iOSAppAnalyzer.a()))) {
            if (IdbTarget.m.level < 5) return;
            ((LevelAwareLogBuilder)m.lvlBuild(5, "installApp(boolean,File)", 265).add("Nothing to do, app already installed")).log();
            return;
        }
        object2 = iOSAppAnalyzer.b();
        if (IdbTarget.m.level >= 9) {
            ((LevelAwareLogBuilder)m.lvlBuild(9, "installApp(boolean,File)", 271).add("supportedPlatforms", object2)).log();
        }
        if (this.isSimulator()) {
            var5_5 = object2.stream().anyMatch(string -> string.toLowerCase().contains("simulator"));
            if (!var5_5) {
                throw new IOException(String.valueOf(file) + " does not support simulator, only " + String.valueOf(object2));
            }
            object = iOSAppAnalyzer.c();
            if (IdbTarget.m.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)m.lvlBuild(9, "installApp(boolean,File)", 279).add("supportedArchitectures", object)).add("AArch64 System", Misc.isMacOsAppleSilicon())).log();
            }
            if (!object.contains("x86_64") && !Misc.isMacOsAppleSilicon()) {
                throw new IOException(String.valueOf(file) + " does not support the current CPU architecture, only " + String.valueOf(object));
            }
        } else {
            var5_5 = object2.stream().anyMatch(string -> string.toLowerCase().contains("iphoneos"));
            if (!var5_5) {
                throw new IOException(String.valueOf(file) + " does not support deployment on devices, only " + String.valueOf(object2));
            }
        }
        File file2 = null;
        object = iOSAppAnalyzer.d();
        try {
            boolean bl2;
            boolean bl3 = bl2 = this.isSimulator() && Options.cached_OPT_IOS_ADHOC_SIGN_APP_FOR_SIMULATOR;
            if (object == IOSAppAnalyzer.a.c || object == IOSAppAnalyzer.a.d || bl2) {
                file2 = Files.createTempDirectory("ios-app-install", new FileAttribute[0]).toFile();
                iOSAppAnalyzer.a(file2, false);
                String string2 = iOSAppAnalyzer.g();
                file = string2 != null ? new File(file2, string2) : new File(file2, iOSAppAnalyzer.f());
                if (IdbTarget.m.level >= 9) {
                    ((LevelAwareLogBuilder)m.lvlBuild(9, "installApp(boolean,File)", 304).add("appPath", (Object)file)).log();
                }
                if (bl2) {
                    IOSUtil.adhocSignApp(file);
                }
            }
            this.a.install(this, file);
            if (file2 == null) return;
        }
        catch (Throwable throwable) {
            if (file2 == null) throw throwable;
            FileUtils.deleteRecursively(file2);
            throw throwable;
        }
        FileUtils.deleteRecursively((File)file2);
    }

    @Override
    public void uninstallApp(String string) throws IOException {
        if (IdbTarget.m.level >= 7) {
            ((LevelAwareLogBuilder)m.lvlBuild(7, "uninstallApp(String)", 324).addDetail("bundleId", string)).log();
        }
        this.a.uninstall(this, string);
    }

    @Override
    public void launchApp(String string) throws IOException {
        if (IdbTarget.m.level >= 7) {
            ((LevelAwareLogBuilder)m.lvlBuild(7, "launchApp(String)", 334).addDetail("bundleId", string)).log();
        }
        this.a.launch(this, string, null, null);
    }

    @Override
    public void stopApp(String string) throws IOException {
        if (IdbTarget.m.level >= 7) {
            ((LevelAwareLogBuilder)m.lvlBuild(7, "stopApp(String)", 344).addDetail("bundleId", string)).log();
        }
        this.a.terminate(this, string);
    }

    public static IdbTarget fromJsonObject(IdbClient idbClient, JsonObject jsonObject) {
        IdbTarget idbTarget = new IdbTarget(idbClient);
        idbTarget.updateFromJson(jsonObject);
        return idbTarget;
    }

    public JsonValue asJsonValue() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("name", this.b);
        jsonObject.add("udid", this.d);
        jsonObject.add("displayName", this.c);
        jsonObject.add("state", this.e);
        jsonObject.add("type", this.f.toString());
        jsonObject.add("osVersion", this.g.getOriginalVersionString());
        jsonObject.add("architecture", this.i);
        if (this.j != null) {
            jsonObject.add("screenSize", this.j.asJsonValue());
        }
        if (this.l != null) {
            jsonObject.add("deviceInfo", (JsonValue)this.l);
        }
        return jsonObject;
    }

    public IdbTarget(IdbClient idbClient) {
        this.a = idbClient;
    }

    public IdbClient getClient() {
        return this.a;
    }

    @Override
    public String getName() {
        return this.b;
    }

    @Override
    public String getDisplayName() {
        return this.c;
    }

    @Override
    public String getUdid() {
        return this.d;
    }

    @Override
    public String getState() {
        return this.e;
    }

    @Override
    public IOSTarget.Type getType() {
        return this.f;
    }

    public VersionNumber getOverrideOsVersion() {
        return this.h;
    }

    @Override
    public String getArchitecture() {
        return this.i;
    }

    @Override
    public Geometry getScreenSize() {
        return this.j;
    }

    public IdbCompanion getCompanion() {
        return this.k;
    }

    public JsonObject getDeviceInfo() {
        return this.l;
    }

    public IdbTarget setName(String string) {
        this.b = string;
        return this;
    }

    @Override
    public IdbTarget setDisplayName(String string) {
        this.c = string;
        return this;
    }

    public IdbTarget setUdid(String string) {
        this.d = string;
        return this;
    }

    public IdbTarget setState(String string) {
        this.e = string;
        return this;
    }

    public IdbTarget setType(IOSTarget.Type type) {
        this.f = type;
        return this;
    }

    public IdbTarget setOsVersion(VersionNumber versionNumber) {
        this.g = versionNumber;
        return this;
    }

    public IdbTarget setOverrideOsVersion(VersionNumber versionNumber) {
        this.h = versionNumber;
        return this;
    }

    public IdbTarget setArchitecture(String string) {
        this.i = string;
        return this;
    }

    public IdbTarget setScreenSize(Geometry geometry) {
        this.j = geometry;
        return this;
    }

    public IdbTarget setCompanion(IdbCompanion idbCompanion) {
        this.k = idbCompanion;
        return this;
    }

    public IdbTarget setDeviceInfo(JsonObject jsonObject) {
        this.l = jsonObject;
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IdbTarget)) {
            return false;
        }
        IdbTarget idbTarget = (IdbTarget)object;
        if (!idbTarget.canEqual(this)) {
            return false;
        }
        IdbClient idbClient = this.getClient();
        IdbClient idbClient2 = idbTarget.getClient();
        if (idbClient == null ? idbClient2 != null : !idbClient.equals(idbClient2)) {
            return false;
        }
        String string = this.getName();
        String string2 = idbTarget.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getDisplayName();
        String string4 = idbTarget.getDisplayName();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getUdid();
        String string6 = idbTarget.getUdid();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getState();
        String string8 = idbTarget.getState();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        IOSTarget.Type type = this.getType();
        IOSTarget.Type type2 = idbTarget.getType();
        if (type == null ? type2 != null : !((Object)((Object)type)).equals((Object)type2)) {
            return false;
        }
        VersionNumber versionNumber = this.getOsVersion();
        VersionNumber versionNumber2 = idbTarget.getOsVersion();
        if (versionNumber == null ? versionNumber2 != null : !versionNumber.equals(versionNumber2)) {
            return false;
        }
        VersionNumber versionNumber3 = this.getOverrideOsVersion();
        VersionNumber versionNumber4 = idbTarget.getOverrideOsVersion();
        if (versionNumber3 == null ? versionNumber4 != null : !versionNumber3.equals(versionNumber4)) {
            return false;
        }
        String string9 = this.getArchitecture();
        String string10 = idbTarget.getArchitecture();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        Geometry geometry = this.getScreenSize();
        Geometry geometry2 = idbTarget.getScreenSize();
        if (geometry == null ? geometry2 != null : !((Object)geometry).equals(geometry2)) {
            return false;
        }
        IdbCompanion idbCompanion = this.getCompanion();
        IdbCompanion idbCompanion2 = idbTarget.getCompanion();
        if (idbCompanion == null ? idbCompanion2 != null : !((Object)idbCompanion).equals(idbCompanion2)) {
            return false;
        }
        JsonObject jsonObject = this.getDeviceInfo();
        JsonObject jsonObject2 = idbTarget.getDeviceInfo();
        return !(jsonObject == null ? jsonObject2 != null : !jsonObject.equals(jsonObject2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof IdbTarget;
    }

    public int hashCode() {
        int n2 = 1;
        IdbClient idbClient = this.getClient();
        n2 = n2 * 59 + (idbClient == null ? 43 : idbClient.hashCode());
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getDisplayName();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getUdid();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getState();
        n2 = n2 * 59 + (string4 == null ? 43 : string4.hashCode());
        IOSTarget.Type type = this.getType();
        n2 = n2 * 59 + (type == null ? 43 : ((Object)((Object)type)).hashCode());
        VersionNumber versionNumber = this.getOsVersion();
        n2 = n2 * 59 + (versionNumber == null ? 43 : versionNumber.hashCode());
        VersionNumber versionNumber2 = this.getOverrideOsVersion();
        n2 = n2 * 59 + (versionNumber2 == null ? 43 : versionNumber2.hashCode());
        String string5 = this.getArchitecture();
        n2 = n2 * 59 + (string5 == null ? 43 : string5.hashCode());
        Geometry geometry = this.getScreenSize();
        n2 = n2 * 59 + (geometry == null ? 43 : ((Object)geometry).hashCode());
        IdbCompanion idbCompanion = this.getCompanion();
        n2 = n2 * 59 + (idbCompanion == null ? 43 : ((Object)idbCompanion).hashCode());
        JsonObject jsonObject = this.getDeviceInfo();
        n2 = n2 * 59 + (jsonObject == null ? 43 : jsonObject.hashCode());
        return n2;
    }

    public String toString() {
        return "IdbTarget(client=" + String.valueOf(this.getClient()) + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", udid=" + this.getUdid() + ", state=" + this.getState() + ", type=" + String.valueOf((Object)this.getType()) + ", osVersion=" + String.valueOf(this.getOsVersion()) + ", overrideOsVersion=" + String.valueOf(this.getOverrideOsVersion()) + ", architecture=" + this.getArchitecture() + ", screenSize=" + String.valueOf(this.getScreenSize()) + ", companion=" + String.valueOf(this.getCompanion()) + ", deviceInfo=" + String.valueOf(this.getDeviceInfo()) + ")";
    }
}

