/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.script.dataformats;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.qfs.apps.qftest.shared.ExternalClassWrapperHelper;
import de.qfs.apps.qftest.shared.data.ChildInfo;
import de.qfs.apps.qftest.shared.data.ClientData;
import de.qfs.apps.qftest.shared.data.ElementInfo;
import de.qfs.apps.qftest.shared.data.ExtraFeature;
import de.qfs.apps.qftest.shared.data.ExtraFeatureSet;
import de.qfs.apps.qftest.shared.data.SmartInfo;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.data.ToplevelInfo;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.event.EventData;
import de.qfs.apps.qftest.shared.data.event.KeyEventData;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.script.DataFormatException;
import de.qfs.apps.qftest.shared.script.dataformats.b;
import de.qfs.lib.gui.EventNames;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class JacksonJsonHelperImpl
extends ExternalClassWrapperHelper
implements b {
    private final ObjectWriter c;
    private final ObjectMapper d = new ObjectMapper();

    public JacksonJsonHelperImpl() {
        this.d.enable(SerializationFeature.INDENT_OUTPUT);
        this.d.enable(new MapperFeature[]{MapperFeature.PROPAGATE_TRANSIENT_MARKER});
        this.d.addMixIn(ElementInfo.class, ElementInfoMixIn.class);
        this.d.addMixIn(ChildInfo.class, ElementInfoMixIn.class);
        this.d.addMixIn(ToplevelInfo.class, ElementInfoMixIn.class);
        this.d.addMixIn(SmartInfo.class, ElementInfoMixIn.class);
        this.d.addMixIn(ClientData.class, ClientDataMixIn.class);
        this.d.addMixIn(ExtraFeature.class, ExtraFeatureMixin.class);
        this.d.addMixIn(ExtraFeatureSet.class, ExtraFeatureSetMixin.class);
        this.d.addMixIn(CheckData.class, CheckDataMixin.class);
        this.d.addMixIn(EventData.class, EventDataMixin.class);
        this.d.addMixIn(KeyEventData.class, KeyEventDataMixin.class);
        this.d.addMixIn(ImageRep.class, ImageRepMixin.class);
        this.d.addMixIn(SubItemIndex.class, SubItemIndexMixin.class);
        DefaultPrettyPrinter defaultPrettyPrinter = new DefaultPrettyPrinter();
        defaultPrettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        this.c = this.d.writer((PrettyPrinter)defaultPrettyPrinter);
    }

    @Override
    public Map a(String string) throws DataFormatException {
        if (string == null) {
            throw new IllegalArgumentException("code is marked non-null but is null");
        }
        try {
            return (Map)this.d.readValue(string, LinkedHashMap.class);
        }
        catch (Exception exception) {
            throw new DataFormatException(exception.getLocalizedMessage());
        }
    }

    @Override
    public String a(Map map) throws DataFormatException {
        try {
            return this.c.writeValueAsString((Object)map);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new DataFormatException(jsonProcessingException.getLocalizedMessage());
        }
    }

    @Override
    public Object a(String string, Class clazz) throws DataFormatException {
        try {
            return this.d.readValue(string, clazz);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new DataFormatException(jsonProcessingException.getLocalizedMessage());
        }
    }

    @Override
    public String a(Object object, Class clazz) throws DataFormatException {
        try {
            return this.c.writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new DataFormatException(jsonProcessingException.getLocalizedMessage());
        }
    }

    public static class CharAsIntDeserializer
    extends StdDeserializer {
        protected CharAsIntDeserializer() {
            super(Character.class);
        }

        public Character deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            int n2 = jsonParser.getIntValue();
            return Character.valueOf((char)n2);
        }
    }

    public static class CharAsIntSerializer
    extends StdSerializer {
        protected CharAsIntSerializer() {
            super(Character.class);
        }

        public void serialize(Character c2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (c2 == null) {
                jsonGenerator.writeNull();
            } else {
                jsonGenerator.writeNumber((int)c2.charValue());
            }
        }
    }

    public static class EventNameDeserializer
    extends StdDeserializer {
        public EventNameDeserializer() {
            super(Integer.class);
        }

        public Integer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return EventNames.getId((String)jsonParser.getText());
        }
    }

    public static class EventNameSerializer
    extends StdSerializer {
        public EventNameSerializer() {
            super(Integer.class);
        }

        public void serialize(Integer n2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(EventNames.getName((int)n2));
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static abstract class ImageRepMixin {
        @JsonIgnore
        public abstract byte[] getPng();

        @JsonIgnore
        public abstract byte[] setPng();

        @JsonIgnore
        public abstract int[] getARGB();

        @JsonIgnore
        public abstract void setARGB(int[] var1);

        @JsonIgnore
        public abstract byte[] getDeflated();

        @JsonIgnore
        public abstract void setDeflated(byte[] var1, ImageRep.CompressionMode var2);

        @JsonIgnore
        public abstract boolean isPng();

        @JsonIgnore
        public abstract void setPng(boolean var1);

        @JsonIgnore
        public abstract int getHashCode();

        @JsonIgnore
        public abstract void setBufferedImage(BufferedImage var1);

        @JsonIgnore
        public abstract BufferedImage asBufferedImage();

        @JsonIgnore
        public abstract ImageRep.CompressionMode getCompressionMode();

        @JsonIgnore
        public abstract void setCompressionMode(ImageRep.CompressionMode var1);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"@class", "identifier", "client", "when", "text", "keyCode", "keyChar", "modifiers", "relative", "empty", "converted", "sameHeavyweight", "supportsSetValue", "source"})
    public static abstract class KeyEventDataMixin {
        @JsonSerialize(using=EventNameSerializer.class)
        @JsonDeserialize(using=EventNameDeserializer.class)
        public int id;
        @JsonSerialize(using=CharAsIntSerializer.class)
        @JsonDeserialize(using=CharAsIntDeserializer.class)
        public char keyChar;
    }

    public static abstract class EventDataMixin {
        @JsonSerialize(using=EventNameSerializer.class)
        @JsonDeserialize(using=EventNameDeserializer.class)
        public int id;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"@class", "identifier", "client", "value", "regexp", "notCheck", "defaultTimeout", "source"})
    public static abstract class CheckDataMixin {
        @JsonProperty(value="identifier")
        @JsonAlias(value={"checkTypeIdentifier"})
        public abstract String getCheckTypeIdentifier();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static abstract class ExtraFeatureSetMixin {
        @JsonIgnore
        public abstract ExtraFeature getShouldMatchLabel();
    }

    public static abstract class SubItemIndexMixin {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnore
        public abstract boolean isElementSyntax();

        @JsonCreator
        public SubItemIndexMixin(@JsonProperty(value="index") String string) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static abstract class ExtraFeatureMixin {
        @JsonIgnore
        public abstract boolean isLabelVariant();

        @JsonCreator
        public ExtraFeatureMixin(@JsonProperty(value="state") int n2, @JsonProperty(value="name") String string, @JsonProperty(value="value") String string2) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static abstract class SkipNullMixIn {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
    @JsonPropertyOrder(value={"@class", "engine", "name", "suggestedName", "class", "classIndex", "classCount", "feature", "regexp", "x", "y", "width", "height", "superclasses", "container", "menu", "modal", "currentEnabledState", "currentSelectedState", "currentCheckedState", "currentEditableState", "currentVisibility", "createProcedures", "interestingForProcbuilder", "extraFeatures", "itemIndexes", "parentInfo"})
    public static abstract class ElementInfoMixIn {
        @JsonProperty(value="class")
        @JsonAlias(value={"clazz"})
        public String clazz;
        @JsonProperty(value="extraFeatures")
        @JsonAlias(value={"parameters"})
        public ExtraFeatureSet parameters;

        @JsonIgnore
        public abstract ToplevelInfo getRoot();

        @JsonIgnore
        public abstract Map getCache();

        @JsonIgnore
        public abstract void setItemResolved(boolean var1);

        @JsonIgnore
        public abstract int getItemIndexCount();

        @JsonIgnore
        public abstract String getFullId();

        @JsonIgnore
        public abstract String[] getClassNames();

        @JsonIgnore
        public abstract SubItemIndex[] getUnresolvedItemIndexes();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
    @JsonPropertyOrder(value={"@class", "id", "client", "when", "x", "y", "screenX", "screenY", "clickCount", "modifiers", "hardEvent", "semihardEvent", "popupTrigger", "sameHeavyweight"})
    public static abstract class ClientDataMixIn {
        @JsonIgnore
        public abstract String getEventName();
    }
}

