/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.script.dataformats;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.util.StringQuotingChecker;
import de.qfs.apps.qftest.shared.ExternalClassWrapperHelper;
import de.qfs.apps.qftest.shared.script.DataFormatException;
import de.qfs.apps.qftest.shared.script.dataformats.b;
import de.qfs.lib.gui.Message;
import de.qfs.lib.util.Misc;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.DumperOptions;

public class JacksonYamlHelperImpl
extends ExternalClassWrapperHelper
implements b {
    private static final Pattern c = Pattern.compile("^Duplicate field '(?<key>[a-zA-Z]+)'.*at \\[Source:.+line: (?<line>[0-9]+), column: (?<column>[0-9]+)\\]$", 32);
    private static final Pattern d = Pattern.compile("^Expected a field name.*at \\[Source:.+line: (?<line>[0-9]+), column: (?<column>[0-9]+)\\]$", 32);
    private static final Pattern e = Pattern.compile("^mapping values are not allowed here.*at \\[Source:.+line: (?<line>[0-9]+), column: (?<column>[0-9]+)\\]$", 32);
    private static final Pattern f = Pattern.compile("^while scanning a quoted scalar.*at \\[Source:.+line: (?<line>[0-9]+), column: (?<column>[0-9]+)\\]$", 32);
    private final ObjectMapper g;

    public JacksonYamlHelperImpl() {
        CustomYamlFactory customYamlFactory = new CustomYamlFactory();
        customYamlFactory.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
        customYamlFactory.disable(YAMLGenerator.Feature.SPLIT_LINES);
        customYamlFactory.disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER);
        customYamlFactory.disable(YAMLGenerator.Feature.SPLIT_LINES);
        this.g = new ObjectMapper((JsonFactory)customYamlFactory);
        this.g.enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
    }

    @Override
    public Map a(String string2) throws DataFormatException {
        if (string2 == null) {
            throw new IllegalArgumentException("code is marked non-null but is null");
        }
        if (string2.trim().isEmpty()) {
            return new LinkedHashMap();
        }
        boolean bl = Arrays.stream(Misc.splitLines((String)string2)).noneMatch(string -> !string.trim().startsWith("#") && !string.trim().isEmpty());
        if (bl) {
            return new LinkedHashMap();
        }
        try {
            JsonNode jsonNode = this.g.readTree(string2);
            return (Map)this.g.treeToValue((TreeNode)jsonNode, LinkedHashMap.class);
        }
        catch (Exception exception) {
            Matcher matcher = c.matcher(exception.getMessage());
            if (matcher.find()) {
                String string3 = matcher.group("key");
                throw new DataFormatException(Message.format((String)"cwrduplicatekey.message", (Object[])new String[]{string3}));
            }
            matcher = d.matcher(exception.getMessage());
            if (matcher.find()) {
                String string4 = matcher.group("line");
                String string5 = matcher.group("column");
                throw new DataFormatException(Message.format((String)"cwrinvalidsyntaxat.message", (Object[])new String[]{string4, string5}));
            }
            matcher = e.matcher(exception.getMessage());
            if (matcher.find()) {
                String string6 = matcher.group("line");
                String string7 = matcher.group("column");
                throw new DataFormatException(Message.format((String)"cwrinvalidsyntaxat.message", (Object[])new String[]{string6, string7}));
            }
            matcher = f.matcher(exception.getMessage());
            if (matcher.find()) {
                String string8 = matcher.group("line");
                String string9 = matcher.group("column");
                throw new DataFormatException(Message.format((String)"cwrunmatchedquote.message", (Object[])new String[]{string8, string9}));
            }
            throw new DataFormatException(exception.getLocalizedMessage());
        }
    }

    @Override
    public String a(Map map) throws DataFormatException {
        if (map == null || map.isEmpty()) {
            return "";
        }
        try {
            return this.g.writeValueAsString((Object)map);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new DataFormatException(jsonProcessingException.getLocalizedMessage());
        }
    }

    @Override
    public Object a(String string, Class clazz) throws DataFormatException {
        try {
            return this.g.readValue(string, clazz);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new DataFormatException(jsonProcessingException.getLocalizedMessage());
        }
    }

    @Override
    public String a(Object object, Class clazz) throws DataFormatException {
        try {
            return this.g.writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new DataFormatException(jsonProcessingException.getLocalizedMessage());
        }
    }

    public static class CustomYamlGenerator
    extends YAMLGenerator {
        public CustomYamlGenerator(IOContext iOContext, int n2, int n3, StringQuotingChecker stringQuotingChecker, ObjectCodec objectCodec, Writer writer, DumperOptions.Version version) throws IOException {
            super(iOContext, n2, n3, stringQuotingChecker, objectCodec, writer, version);
        }

        public void writeNull() throws IOException {
            this._verifyValueWrite("write null value");
            this._writeScalar("", "object", DumperOptions.ScalarStyle.PLAIN);
        }
    }

    public static class CustomYamlFactory
    extends YAMLFactory {
        protected YAMLGenerator _createGenerator(Writer writer, IOContext iOContext) throws IOException {
            return new CustomYamlGenerator(iOContext, this._generatorFeatures, this._yamlGeneratorFeatures, this._quotingChecker, this._objectCodec, writer, this._version);
        }
    }
}

